/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginXdocGenerator
implements Generator {
    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        Iterator it = pluginDescriptor.getMojos().iterator();
        while (it.hasNext()) {
            MojoDescriptor descriptor = (MojoDescriptor)it.next();
            this.processMojoDescriptor(descriptor, destinationDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, File destinationDirectory) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(destinationDirectory, this.getMojoFilename(mojoDescriptor, "xml")));
            this.writeBody(writer, mojoDescriptor);
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    private String getMojoFilename(MojoDescriptor mojo, String ext) {
        return mojo.getGoal() + "-mojo." + ext;
    }

    private void writeBody(FileWriter writer, MojoDescriptor mojoDescriptor) {
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter(writer);
        w.startElement("document");
        w.startElement("properties");
        w.startElement("title");
        w.writeText(mojoDescriptor.getPluginDescriptor().getArtifactId() + " - " + mojoDescriptor.getFullGoalName());
        w.endElement();
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", mojoDescriptor.getFullGoalName());
        w.startElement("p");
        if (mojoDescriptor.getDescription() != null) {
            w.writeMarkup(mojoDescriptor.getDescription());
        } else {
            w.writeText("No description.");
        }
        w.endElement();
        this.writeGoalAttributes(mojoDescriptor, (XMLWriter)w);
        this.writeGoalParameterTable(mojoDescriptor, (XMLWriter)w);
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeGoalAttributes(MojoDescriptor mojoDescriptor, XMLWriter w) {
        w.startElement("p");
        w.writeMarkup("<b>Mojo Attributes</b>:");
        w.startElement("ul");
        String value = mojoDescriptor.getDeprecated();
        if (StringUtils.isNotEmpty((String)value)) {
            w.startElement("li");
            w.writeMarkup("This plugin goal has been deprecated: " + value + "");
            w.endElement();
        }
        if (mojoDescriptor.isProjectRequired()) {
            w.startElement("li");
            w.writeMarkup("Requires a Maven 2.0 project to execute.");
            w.endElement();
        }
        if (mojoDescriptor.isAggregator()) {
            w.startElement("li");
            w.writeMarkup("Executes as an aggregator plugin.");
            w.endElement();
        }
        if (mojoDescriptor.isDirectInvocationOnly()) {
            w.startElement("li");
            w.writeMarkup("Executes by direct invocation only.");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.isDependencyResolutionRequired()))) {
            w.startElement("li");
            w.writeMarkup("Requires dependency resolution of artifacts in scope: <code>" + value + "</code>");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getSince()))) {
            w.startElement("li");
            w.writeMarkup("Since version: <code>" + value + "</code>");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getPhase()))) {
            w.startElement("li");
            w.writeMarkup("Automatically executes within the lifecycle phase: <code>" + value + "</code>");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecutePhase()))) {
            w.startElement("li");
            w.writeMarkup("Invokes the execution of the lifecycle phase <code>" + value + "</code> prior to executing itself.");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteGoal()))) {
            w.startElement("li");
            w.writeMarkup("Invokes the execution of this plugin's goal <code>" + value + "</code> prior to executing itself.");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteLifecycle()))) {
            w.startElement("li");
            w.writeMarkup("Executes in its own lifecycle: <code>" + value + "</code>");
            w.endElement();
        }
        if (mojoDescriptor.isOnlineRequired()) {
            w.startElement("li");
            w.writeMarkup("Requires that mvn runs in online mode.");
            w.endElement();
        }
        if (!mojoDescriptor.isInheritedByDefault()) {
            w.startElement("li");
            w.writeMarkup("Is NOT inherited by default in multi-project builds.");
            w.endElement();
        }
        w.endElement();
        w.endElement();
    }

    private void writeGoalParameterTable(MojoDescriptor mojoDescriptor, XMLWriter w) {
        List parameterList = mojoDescriptor.getParameters();
        List list = this.filterParameters(parameterList);
        if (list != null && list.size() > 0) {
            this.writeParameterSummary(list, w);
            this.writeParameterDetails(list, w);
        }
    }

    private List filterParameters(List parameterList) {
        ArrayList<Parameter> filtered = new ArrayList<Parameter>();
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            String expression;
            Parameter parameter = (Parameter)parameters.next();
            if (!parameter.isEditable() || (expression = parameter.getExpression()) != null && expression.startsWith("${component.")) continue;
            filtered.add(parameter);
        }
        return filtered;
    }

    private void writeParameterDetails(List parameterList, XMLWriter w) {
        w.startElement("subsection");
        w.addAttribute("name", "Parameter Details");
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            w.startElement("p");
            w.writeMarkup("<b><a name=\"" + parameter.getName() + "\">" + parameter.getName() + "</a></b>");
            w.endElement();
            String description = parameter.getDescription();
            if (StringUtils.isEmpty((String)description)) {
                description = "No Description.";
            }
            w.startElement("p");
            w.writeMarkup(description);
            w.endElement();
            w.startElement("ul");
            this.writeDetail("Type", parameter.getType(), w);
            this.writeDetail("Since", parameter.getSince(), w);
            if (parameter.isRequired()) {
                this.writeDetail("Required", "Yes", w);
            } else {
                this.writeDetail("Required", "No", w);
            }
            this.writeDetail("Expression", parameter.getExpression(), w);
            this.writeDetail("Default", parameter.getDefaultValue(), w);
            w.endElement();
            if (!parameters.hasNext()) continue;
            w.writeMarkup("<hr/>");
        }
        w.endElement();
    }

    private void writeDetail(String param, String value, XMLWriter w) {
        if (StringUtils.isNotEmpty((String)value)) {
            w.startElement("li");
            w.writeMarkup("<b>" + param + "</b>: <code>");
            w.writeText(value);
            w.writeMarkup("</code>");
            w.endElement();
        }
    }

    private void writeParameterSummary(List parameterList, XMLWriter w) {
        List optionalParams;
        List requiredParams = this.getParametersByRequired(true, parameterList);
        if (requiredParams.size() > 0) {
            this.writeParameterList("Required Parameters", requiredParams, w);
        }
        if ((optionalParams = this.getParametersByRequired(false, parameterList)).size() > 0) {
            this.writeParameterList("Optional Parameters", optionalParams, w);
        }
    }

    private void writeParameterList(String title, List parameterList, XMLWriter w) {
        w.startElement("subsection");
        w.addAttribute("name", title);
        w.startElement("table");
        w.startElement("tr");
        w.startElement("th");
        w.writeText("Name");
        w.endElement();
        w.startElement("th");
        w.writeText("Type");
        w.endElement();
        w.startElement("th");
        w.writeText("Description");
        w.endElement();
        w.endElement();
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            w.startElement("tr");
            w.startElement("td");
            w.writeMarkup("<b><a href=\"#" + parameter.getName() + "\">" + parameter.getName() + "</a></b>");
            w.endElement();
            w.startElement("td");
            int index = parameter.getType().lastIndexOf(".");
            w.writeMarkup("<code>" + parameter.getType().substring(index + 1) + "</code>");
            w.endElement();
            w.startElement("td");
            String description = parameter.getDescription();
            if (StringUtils.isEmpty((String)description)) {
                description = "No description.";
            }
            w.writeMarkup(description);
            if (StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.writeMarkup(" Default value is <code>");
                w.writeText(parameter.getDefaultValue());
                w.writeMarkup("</code>.");
            }
            w.endElement();
            w.endElement();
        }
        w.endElement();
        w.endElement();
    }

    private List getParametersByRequired(boolean required, List parameterList) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            if (parameter.isRequired() != required) continue;
            list.add(parameter);
        }
        return list;
    }
}

