/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuildingEvent;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.DefaultModelBuildingResult;
import org.apache.maven.model.building.DefaultModelProblemCollector;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingEventCatapult;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingListener;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.building.ModelCacheTag;
import org.apache.maven.model.building.ModelData;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.composition.DependencyManagementImporter;
import org.apache.maven.model.inheritance.InheritanceAssembler;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.management.DependencyManagementInjector;
import org.apache.maven.model.management.PluginManagementInjector;
import org.apache.maven.model.normalization.ModelNormalizer;
import org.apache.maven.model.path.ModelPathTranslator;
import org.apache.maven.model.plugin.LifecycleBindingsInjector;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.apache.maven.model.plugin.ReportingConverter;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelBuilder.class)
public class DefaultModelBuilder
implements ModelBuilder {
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private ModelValidator modelValidator;
    @Requirement
    private ModelNormalizer modelNormalizer;
    @Requirement
    private ModelInterpolator modelInterpolator;
    @Requirement
    private ModelPathTranslator modelPathTranslator;
    @Requirement
    private SuperPomProvider superPomProvider;
    @Requirement
    private InheritanceAssembler inheritanceAssembler;
    @Requirement
    private ProfileSelector profileSelector;
    @Requirement
    private ProfileInjector profileInjector;
    @Requirement
    private PluginManagementInjector pluginManagementInjector;
    @Requirement
    private DependencyManagementInjector dependencyManagementInjector;
    @Requirement
    private DependencyManagementImporter dependencyManagementImporter;
    @Requirement(optional=true)
    private LifecycleBindingsInjector lifecycleBindingsInjector;
    @Requirement
    private PluginConfigurationExpander pluginConfigurationExpander;
    @Requirement
    private ReportingConverter reportingConverter;

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request) throws ModelBuildingException {
        return this.build(request, new LinkedHashSet<String>());
    }

    private ModelBuildingResult build(ModelBuildingRequest request, Collection<String> imports) throws ModelBuildingException {
        DefaultModelBuildingResult result = new DefaultModelBuildingResult();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(null);
        ProfileActivationContext profileActivationContext = this.getProfileActivationContext(request);
        problems.setSource("(external profiles)");
        List<Profile> activeExternalProfiles = this.profileSelector.getActiveProfiles(request.getProfiles(), profileActivationContext, problems);
        Model inputModel = this.readModel(request.getModelSource(), request.getPomFile(), request, problems);
        problems.setRootModel(inputModel);
        ModelData resultData = new ModelData(inputModel);
        ModelData superData = new ModelData(this.getSuperModel());
        ArrayList<ModelData> lineage = new ArrayList<ModelData>();
        ModelData currentData = resultData;
        while (currentData != null) {
            lineage.add(currentData);
            Model tmpModel = currentData.getModel();
            Model rawModel = tmpModel.clone();
            currentData.setRawModel(rawModel);
            problems.setSource(tmpModel);
            this.modelNormalizer.mergeDuplicates(tmpModel, request, problems);
            List<Profile> activePomProfiles = this.profileSelector.getActiveProfiles(rawModel.getProfiles(), profileActivationContext, problems);
            currentData.setActiveProfiles(activePomProfiles);
            for (Profile activeProfile : activePomProfiles) {
                this.profileInjector.injectProfile(tmpModel, activeProfile, request, problems);
            }
            if (currentData == resultData) {
                for (Profile activeProfile : activeExternalProfiles) {
                    this.profileInjector.injectProfile(tmpModel, activeProfile, request, problems);
                }
            }
            if (currentData == superData) break;
            this.configureResolver(request.getModelResolver(), tmpModel, problems);
            currentData = this.readParent(tmpModel, request, problems);
            if (currentData != null) continue;
            currentData = superData;
        }
        this.assembleInheritance(lineage, request, problems);
        Model resultModel = resultData.getModel();
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        resultModel = this.interpolateModel(resultModel, request, problems);
        resultData.setModel(resultModel);
        resultData.setGroupId(resultModel.getGroupId());
        resultData.setArtifactId(resultModel.getArtifactId());
        resultData.setVersion(resultModel.getVersion());
        result.setProblems(problems.getProblems());
        result.setEffectiveModel(resultModel);
        result.setActiveExternalProfiles(activeExternalProfiles);
        for (ModelData currentData2 : lineage) {
            String modelId = currentData2 != superData ? currentData2.getId() : "";
            result.addModelId(modelId);
            result.setActivePomProfiles(modelId, currentData2.getActiveProfiles());
            result.setRawModel(modelId, currentData2.getRawModel());
        }
        if (!request.isTwoPhaseBuilding()) {
            this.build(request, result);
        }
        return result;
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        return this.build(request, result, new LinkedHashSet<String>());
    }

    private ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result, Collection<String> imports) throws ModelBuildingException {
        Model resultModel = result.getEffectiveModel();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result.getProblems());
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        this.modelPathTranslator.alignToBaseDirectory(resultModel, resultModel.getProjectDirectory(), request);
        this.pluginManagementInjector.injectManagement(resultModel, request, problems);
        this.fireEvent(resultModel, request, problems, ModelBuildingEventCatapult.BUILD_EXTENSIONS_ASSEMBLED);
        if (request.isProcessPlugins()) {
            if (this.lifecycleBindingsInjector == null) {
                throw new IllegalStateException("lifecycle bindings injector is missing");
            }
            this.lifecycleBindingsInjector.injectLifecycleBindings(resultModel, request, problems);
        }
        this.importDependencyManagement(resultModel, request, problems, imports);
        this.dependencyManagementInjector.injectManagement(resultModel, request, problems);
        this.modelNormalizer.injectDefaultValues(resultModel, request, problems);
        if (request.isProcessPlugins()) {
            this.pluginConfigurationExpander.expandPluginConfiguration(resultModel, request, problems);
            this.reportingConverter.convertReporting(resultModel, request, problems);
        }
        this.modelValidator.validateEffectiveModel(resultModel, request, problems);
        if (this.hasErrors(problems.getProblems())) {
            throw new ModelBuildingException(problems.getRootModelId(), problems.getProblems());
        }
        return result;
    }

    private Model readModel(ModelSource modelSource, File pomFile, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model model;
        block10: {
            if (modelSource == null) {
                if (pomFile != null) {
                    modelSource = new FileModelSource(pomFile);
                } else {
                    throw new IllegalArgumentException("neither model source nor input file are specified");
                }
            }
            problems.setSource(modelSource.getLocation());
            try {
                boolean strict = request.getValidationLevel() >= 20;
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("org.apache.maven.model.io.isStrict", strict);
                options.put("org.apache.maven.model.building.location", modelSource.getLocation());
                options.put("org.apache.maven.model.building.source", modelSource);
                try {
                    model = this.modelProcessor.read(modelSource.getInputStream(), options);
                }
                catch (ModelParseException e) {
                    if (!strict) {
                        throw e;
                    }
                    options.put("org.apache.maven.model.io.isStrict", Boolean.FALSE);
                    model = this.modelProcessor.read(modelSource.getInputStream(), options);
                    if (pomFile != null) {
                        problems.addError("Malformed POM " + modelSource.getLocation() + ": " + e.getMessage(), e);
                        break block10;
                    }
                    problems.addWarning("Malformed POM " + modelSource.getLocation() + ": " + e.getMessage(), e);
                }
            }
            catch (ModelParseException e) {
                problems.addFatalError("Non-parseable POM " + modelSource.getLocation() + ": " + e.getMessage(), e);
                throw new ModelBuildingException(problems.getRootModelId(), problems.getProblems());
            }
            catch (IOException e) {
                problems.addFatalError("Non-readable POM " + modelSource.getLocation() + ": " + e.getMessage(), e);
                throw new ModelBuildingException(problems.getRootModelId(), problems.getProblems());
            }
        }
        model.setPomFile(pomFile);
        problems.setSource(model);
        this.modelValidator.validateRawModel(model, request, problems);
        return model;
    }

    private boolean hasErrors(List<ModelProblem> problems) {
        if (problems != null) {
            for (ModelProblem problem : problems) {
                if (ModelProblem.Severity.ERROR.compareTo(problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private ProfileActivationContext getProfileActivationContext(ModelBuildingRequest request) {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(request.getActiveProfileIds());
        context.setInactiveProfileIds(request.getInactiveProfileIds());
        context.setSystemProperties(request.getSystemProperties());
        context.setUserProperties(request.getUserProperties());
        context.setProjectDirectory(request.getPomFile() != null ? request.getPomFile().getParentFile() : null);
        return context;
    }

    private void configureResolver(ModelResolver modelResolver, Model model, DefaultModelProblemCollector problems) {
        if (modelResolver == null) {
            return;
        }
        problems.setSource(model);
        List repositories = model.getRepositories();
        for (Repository repository : repositories) {
            try {
                modelResolver.addRepository(repository);
            }
            catch (InvalidRepositoryException e) {
                problems.addError("Invalid repository " + repository.getId() + ": " + e.getMessage(), e);
            }
        }
    }

    private void assembleInheritance(List<ModelData> lineage, ModelBuildingRequest request, ModelProblemCollector problems) {
        for (int i = lineage.size() - 2; i >= 0; --i) {
            Model parent = lineage.get(i + 1).getModel();
            Model child = lineage.get(i).getModel();
            this.inheritanceAssembler.assembleModelInheritance(child, parent, request, problems);
        }
    }

    private Model interpolateModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Model result = this.modelInterpolator.interpolateModel(model, model.getProjectDirectory(), request, problems);
        result.setPomFile(model.getPomFile());
        return result;
    }

    private ModelData readParent(Model childModel, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelData parentData;
        Parent parent = childModel.getParent();
        if (parent != null) {
            String groupId = parent.getGroupId();
            String artifactId = parent.getArtifactId();
            String version = parent.getVersion();
            parentData = this.getCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.RAW);
            if (parentData == null) {
                parentData = this.readParentLocally(childModel, request, problems);
                if (parentData == null) {
                    parentData = this.readParentExternally(childModel, request, problems);
                }
                this.putCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.RAW, parentData);
            } else {
                File expectedParentFile;
                File pomFile = parentData.getModel().getPomFile();
                if (pomFile != null && !pomFile.equals(expectedParentFile = this.getParentPomFile(childModel))) {
                    parentData = this.readParentExternally(childModel, request, problems);
                }
            }
            Model parentModel = parentData.getModel();
            if (!"pom".equals(parentModel.getPackaging())) {
                problems.addError("Invalid packaging for parent POM " + ModelProblemUtils.toSourceHint(parentModel) + ", must be \"pom\" but is \"" + parentModel.getPackaging() + "\"");
            }
        } else {
            parentData = null;
        }
        return parentData;
    }

    private ModelData readParentLocally(Model childModel, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        File pomFile = this.getParentPomFile(childModel);
        if (pomFile == null || !pomFile.isFile()) {
            return null;
        }
        Model candidateModel = this.readModel(null, pomFile, request, problems);
        String groupId = candidateModel.getGroupId();
        if (groupId == null && candidateModel.getParent() != null) {
            groupId = candidateModel.getParent().getGroupId();
        }
        String artifactId = candidateModel.getArtifactId();
        String version = candidateModel.getVersion();
        if (version == null && candidateModel.getParent() != null) {
            version = candidateModel.getParent().getVersion();
        }
        Parent parent = childModel.getParent();
        if (groupId == null || !groupId.equals(parent.getGroupId())) {
            return null;
        }
        if (artifactId == null || !artifactId.equals(parent.getArtifactId())) {
            return null;
        }
        if (version == null || !version.equals(parent.getVersion())) {
            return null;
        }
        ModelData parentData = new ModelData(candidateModel, groupId, artifactId, version);
        return parentData;
    }

    private File getParentPomFile(Model childModel) {
        File projectDirectory = childModel.getProjectDirectory();
        if (projectDirectory == null) {
            return null;
        }
        String parentPath = childModel.getParent().getRelativePath();
        File pomFile = new File(new File(projectDirectory, parentPath).toURI().normalize());
        if (pomFile.isDirectory()) {
            pomFile = this.modelProcessor.locatePom(pomFile);
        }
        return pomFile;
    }

    private ModelData readParentExternally(Model childModel, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelSource modelSource;
        problems.setSource(childModel);
        Parent parent = childModel.getParent();
        String groupId = parent.getGroupId();
        String artifactId = parent.getArtifactId();
        String version = parent.getVersion();
        ModelResolver modelResolver = request.getModelResolver();
        if (modelResolver == null) {
            throw new IllegalArgumentException("no model resolver provided, cannot resolve parent POM " + ModelProblemUtils.toId(groupId, artifactId, version) + " for POM " + ModelProblemUtils.toSourceHint(childModel));
        }
        try {
            modelSource = modelResolver.resolveModel(groupId, artifactId, version);
        }
        catch (UnresolvableModelException e) {
            problems.addFatalError("Non-resolvable parent POM " + ModelProblemUtils.toId(groupId, artifactId, version) + " for " + ModelProblemUtils.toId(childModel) + ": " + e.getMessage(), e);
            throw new ModelBuildingException(problems.getRootModelId(), problems.getProblems());
        }
        Model parentModel = this.readModel(modelSource, null, request, problems);
        ModelData parentData = new ModelData(parentModel, parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        return parentData;
    }

    private Model getSuperModel() {
        return this.superPomProvider.getSuperModel("4.0.0").clone();
    }

    private void importDependencyManagement(Model model, ModelBuildingRequest request, DefaultModelProblemCollector problems, Collection<String> imports) {
        DependencyManagement depMngt = model.getDependencyManagement();
        if (depMngt == null) {
            return;
        }
        String importing = model.getGroupId() + ':' + model.getArtifactId() + ':' + model.getVersion();
        imports.add(importing);
        ModelResolver modelResolver = request.getModelResolver();
        ModelBuildingRequest importRequest = null;
        ArrayList<DependencyManagement> importMngts = null;
        Iterator it = depMngt.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            if (!"pom".equals(dependency.getType()) || !"import".equals(dependency.getScope())) continue;
            it.remove();
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String version = dependency.getVersion();
            String imported = groupId + ':' + artifactId + ':' + version;
            if (imports.contains(imported)) {
                String message = "The dependencies of type=pom and with scope=import form a cycle: ";
                for (String modelId : imports) {
                    message = message + modelId + " -> ";
                }
                message = message + imported;
                problems.addError(message);
                continue;
            }
            DependencyManagement importMngt = this.getCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.IMPORT);
            if (importMngt == null) {
                ModelBuildingResult importResult;
                ModelSource importSource;
                if (modelResolver == null) {
                    throw new IllegalArgumentException("no model resolver provided, cannot resolve import POM " + ModelProblemUtils.toId(groupId, artifactId, version) + " for POM " + ModelProblemUtils.toSourceHint(model));
                }
                try {
                    importSource = modelResolver.resolveModel(groupId, artifactId, version);
                }
                catch (UnresolvableModelException e) {
                    problems.addError("Non-resolvable import POM " + ModelProblemUtils.toId(groupId, artifactId, version) + ": " + e.getMessage(), e);
                    continue;
                }
                if (importRequest == null) {
                    importRequest = new DefaultModelBuildingRequest();
                    importRequest.setValidationLevel(0);
                }
                importRequest.setModelSource(importSource);
                importRequest.setModelResolver(modelResolver.newCopy());
                try {
                    importResult = this.build(importRequest, imports);
                }
                catch (ModelBuildingException e) {
                    problems.addAll(e.getProblems());
                    continue;
                }
                problems.addAll(importResult.getProblems());
                Model importModel = importResult.getEffectiveModel();
                importMngt = importModel.getDependencyManagement();
                if (importMngt == null) {
                    importMngt = new DependencyManagement();
                }
                this.putCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.IMPORT, importMngt);
            }
            if (importMngts == null) {
                importMngts = new ArrayList<DependencyManagement>();
            }
            importMngts.add(importMngt);
        }
        imports.remove(importing);
        this.dependencyManagementImporter.importManagement(model, importMngts, request, problems);
    }

    private <T> void putCache(ModelCache modelCache, String groupId, String artifactId, String version, ModelCacheTag<T> tag, T data) {
        if (modelCache != null) {
            modelCache.put(groupId, artifactId, version, tag.getName(), tag.intoCache(data));
        }
    }

    private <T> T getCache(ModelCache modelCache, String groupId, String artifactId, String version, ModelCacheTag<T> tag) {
        Object data;
        if (modelCache != null && (data = modelCache.get(groupId, artifactId, version, tag.getName())) != null) {
            return tag.fromCache(tag.getType().cast(data));
        }
        return null;
    }

    private void fireEvent(Model model, ModelBuildingRequest request, ModelProblemCollector problems, ModelBuildingEventCatapult catapult) throws ModelBuildingException {
        ModelBuildingListener listener = request.getModelBuildingListener();
        if (listener != null) {
            DefaultModelBuildingEvent event = new DefaultModelBuildingEvent(model, request, problems);
            catapult.fire(listener, event);
        }
    }
}

