/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser.table;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BlockParser;
import org.apache.maven.doxia.module.confluence.parser.BoldBlock;
import org.apache.maven.doxia.module.confluence.parser.FigureBlockParser;
import org.apache.maven.doxia.module.confluence.parser.ParagraphBlockParser;
import org.apache.maven.doxia.module.confluence.parser.SectionBlockParser;
import org.apache.maven.doxia.module.confluence.parser.table.TableBlock;
import org.apache.maven.doxia.module.confluence.parser.table.TableCellBlock;
import org.apache.maven.doxia.module.confluence.parser.table.TableCellHeaderBlock;
import org.apache.maven.doxia.module.confluence.parser.table.TableRowBlock;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineReaderSource;
import org.apache.maven.doxia.util.ByLineSource;
import org.codehaus.plexus.util.StringUtils;

public class TableBlockParser
implements BlockParser {
    private static final String EMPTY_STRING = "";
    private static final String ANY_CHARACTER = ".*";
    private static final String ESCAPE_CHARACTER = "\\";

    public boolean accept(String line, ByLineSource source) {
        return line.startsWith("|");
    }

    public Block visit(String line, ByLineSource source) throws ParseException {
        if (!this.accept(line, source)) {
            throw new IllegalAccessError("call accept before this ;)");
        }
        ArrayList<Block> rows = new ArrayList<Block>();
        String l = line;
        do {
            l = l.substring(0, l.lastIndexOf("|"));
            ArrayList<Block> cells = new ArrayList<Block>();
            SectionBlockParser headingParser = new SectionBlockParser();
            FigureBlockParser figureParser = new FigureBlockParser();
            BlockParser[] subparsers = new BlockParser[]{headingParser, figureParser};
            ParagraphBlockParser paragraphParser = new ParagraphBlockParser(subparsers);
            if (l.startsWith("||")) {
                String[] text = StringUtils.split((String)l, (String)"||");
                for (int i = 0; i < text.length; ++i) {
                    ArrayList<Block> textBlocks = new ArrayList<Block>();
                    textBlocks.add(paragraphParser.visit(text[i], (ByLineSource)new ByLineReaderSource((Reader)new StringReader(EMPTY_STRING)), false));
                    ArrayList<Block> blocks = new ArrayList<Block>();
                    blocks.add(new BoldBlock(textBlocks));
                    cells.add(new TableCellHeaderBlock(blocks));
                }
            } else {
                int it = 0;
                String[] text = StringUtils.split((String)l, (String)"|");
                LinkedList<String> texts = new LinkedList<String>();
                while (it < text.length) {
                    if (text[it].matches(".*\\[.*") && !text[it].matches(".*\\].*")) {
                        texts.add(text[it] + "|" + text[it + 1]);
                        it += 2;
                        continue;
                    }
                    texts.add(text[it]);
                    ++it;
                }
                Object[] pText = texts.toArray();
                for (int i = 0; i < pText.length; ++i) {
                    ArrayList<Block> blocks = new ArrayList<Block>();
                    blocks.add(paragraphParser.visit((String)pText[i], (ByLineSource)new ByLineReaderSource((Reader)new StringReader(EMPTY_STRING)), false));
                    cells.add(new TableCellBlock(blocks));
                }
            }
            rows.add(new TableRowBlock(cells));
        } while ((l = source.getNextLine()) != null && this.accept(l, source));
        assert (rows.size() >= 1);
        return new TableBlock(rows);
    }
}

