/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer.pdf.fo;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.AbstractPdfRenderer;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.fo.FoAggregateSink;
import org.apache.maven.doxia.module.fo.FoUtils;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.xml.sax.SAXParseException;

public class FoPdfRenderer
extends AbstractPdfRenderer {
    public void generatePdf(File foFile, File pdfFile) throws DocumentRendererException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Generating: " + pdfFile);
        }
        try {
            FoUtils.convertFO2PDF((File)foFile, (File)pdfFile, null);
        }
        catch (TransformerException e) {
            if (e.getCause() != null && e.getCause() instanceof SAXParseException) {
                SAXParseException sax = (SAXParseException)e.getCause();
                StringBuffer sb = new StringBuffer();
                sb.append("Error creating PDF from ").append(foFile.getAbsolutePath()).append(":").append(sax.getLineNumber()).append(":").append(sax.getColumnNumber()).append("\n");
                sb.append(e.getMessage());
                throw new DocumentRendererException(sb.toString());
            }
            throw new DocumentRendererException("Error creating PDF from " + foFile + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map filesToProcess, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        File pdfOutputFile;
        String outputName = documentModel.getOutputName();
        if (outputName == null) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("No outputName is defined in the document descriptor. Using 'target.pdf'");
            }
            documentModel.setOutputName("target");
        } else if (outputName.lastIndexOf(".") != -1) {
            documentModel.setOutputName(outputName.substring(0, outputName.lastIndexOf(".")));
        }
        outputName = documentModel.getOutputName();
        File outputFOFile = new File(outputDirectory, outputName + ".fo");
        if (!outputFOFile.getParentFile().exists()) {
            outputFOFile.getParentFile().mkdirs();
        }
        if (!(pdfOutputFile = new File(outputDirectory, outputName + ".pdf")).getParentFile().exists()) {
            pdfOutputFile.getParentFile().mkdirs();
        }
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)outputFOFile);
            FoAggregateSink sink = new FoAggregateSink((Writer)writer);
            sink.setDocumentModel(documentModel);
            sink.beginDocument();
            sink.coverPage();
            sink.toc();
            if (documentModel.getToc() == null || documentModel.getToc().getItems() == null) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("No TOC is defined in the document descriptor. Merging all documents.");
                }
                Iterator j = filesToProcess.keySet().iterator();
                while (j.hasNext()) {
                    String key = (String)j.next();
                    SiteModule module = (SiteModule)filesToProcess.get(key);
                    sink.setDocumentName(key);
                    String fullDocPath = this.getBaseDir() + File.separator + module.getSourceDirectory() + File.separator + key;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Parsing file " + fullDocPath);
                    }
                    this.parse(fullDocPath, module.getParserId(), (Sink)sink);
                }
            } else {
                Iterator k = documentModel.getToc().getItems().iterator();
                while (k.hasNext()) {
                    DocumentTOCItem tocItem = (DocumentTOCItem)k.next();
                    if (tocItem.getRef() == null) {
                        if (!this.getLogger().isInfoEnabled()) continue;
                        this.getLogger().info("No ref defined for tocItem " + tocItem.getName());
                        continue;
                    }
                    String href = StringUtils.replace((String)tocItem.getRef(), (String)"\\", (String)"/");
                    if (href.lastIndexOf(".") != -1) {
                        href = href.substring(0, href.lastIndexOf("."));
                    }
                    Iterator i = this.siteModuleManager.getSiteModules().iterator();
                    while (i.hasNext()) {
                        String doc;
                        File source;
                        SiteModule module = (SiteModule)i.next();
                        File moduleBasedir = new File(this.getBaseDir(), module.getSourceDirectory());
                        if (!moduleBasedir.exists() || !(source = new File(moduleBasedir, doc = href + "." + module.getExtension())).exists()) continue;
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Parsing file " + source);
                        }
                        sink.setDocumentName(doc);
                        sink.setDocumentTitle(tocItem.getName());
                        this.parse(source.getPath(), module.getParserId(), (Sink)sink);
                    }
                }
            }
            sink.endDocument();
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        this.copyResources(outputDirectory);
        this.generatePdf(outputFOFile, pdfOutputFile);
    }
}

