/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morfologik;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import morfologik.stemming.PolishStemmer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.morfologik.MorfologikFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class MorfologikFilterFactory
extends TokenFilterFactory {
    private PolishStemmer.DICTIONARY dictionary = PolishStemmer.DICTIONARY.MORFOLOGIK;
    public static final String DICTIONARY_SCHEMA_ATTRIBUTE = "dictionary";

    public TokenStream create(TokenStream ts) {
        return new MorfologikFilter(ts, this.dictionary, this.luceneMatchVersion);
    }

    public void init(Map<String, String> args) {
        super.init(args);
        String dictionaryName = args.get(DICTIONARY_SCHEMA_ATTRIBUTE);
        if (dictionaryName != null && !dictionaryName.isEmpty()) {
            try {
                PolishStemmer.DICTIONARY dictionary = PolishStemmer.DICTIONARY.valueOf((String)dictionaryName.toUpperCase(Locale.ROOT));
                assert (dictionary != null);
                this.dictionary = dictionary;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The dictionary attribute accepts the following constants: " + Arrays.toString(PolishStemmer.DICTIONARY.values()) + ", this value is invalid: " + dictionaryName);
            }
        }
    }
}

