/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.server.common.CheckpointFile;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.log.EpochEntry;

public class InMemoryLeaderEpochCheckpoint
implements LeaderEpochCheckpoint {
    private List<EpochEntry> epochs = Collections.emptyList();

    @Override
    public void write(Collection<EpochEntry> epochs) {
        this.epochs = new ArrayList<EpochEntry>(epochs);
    }

    @Override
    public List<EpochEntry> read() {
        return Collections.unmodifiableList(this.epochs);
    }

    public ByteBuffer readAsByteBuffer() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
            CheckpointFile.CheckpointWriteBuffer writeBuffer = new CheckpointFile.CheckpointWriteBuffer(writer, 0, (CheckpointFile.EntryFormatter)LeaderEpochCheckpointFile.FORMATTER);
            writeBuffer.write(this.epochs);
            writer.flush();
        }
        return ByteBuffer.wrap(stream.toByteArray());
    }
}

