/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogLeaderEpochState;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogMetadataCache {
    private static final Logger log = LoggerFactory.getLogger(RemoteLogMetadataCache.class);
    private final ConcurrentMap<RemoteLogSegmentId, RemoteLogSegmentMetadata> idToSegmentMetadata = new ConcurrentHashMap<RemoteLogSegmentId, RemoteLogSegmentMetadata>();
    private final ConcurrentMap<Integer, RemoteLogLeaderEpochState> leaderEpochEntries = new ConcurrentHashMap<Integer, RemoteLogLeaderEpochState>();

    public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(int leaderEpoch, long offset) {
        RemoteLogLeaderEpochState remoteLogLeaderEpochState = (RemoteLogLeaderEpochState)this.leaderEpochEntries.get(leaderEpoch);
        if (remoteLogLeaderEpochState == null) {
            return Optional.empty();
        }
        RemoteLogSegmentId remoteLogSegmentId = remoteLogLeaderEpochState.floorEntry(offset);
        if (remoteLogSegmentId == null) {
            return Optional.empty();
        }
        RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)this.idToSegmentMetadata.get(remoteLogSegmentId);
        Map.Entry nextEntry = metadata.segmentLeaderEpochs().higherEntry(leaderEpoch);
        long epochEndOffset = nextEntry != null ? (Long)nextEntry.getValue() - 1L : metadata.endOffset();
        return offset > epochEndOffset ? Optional.empty() : Optional.of(metadata);
    }

    public void updateRemoteLogSegmentMetadata(RemoteLogSegmentMetadataUpdate metadataUpdate) throws RemoteResourceNotFoundException {
        log.debug("Updating remote log segment metadata: [{}]", (Object)metadataUpdate);
        Objects.requireNonNull(metadataUpdate, "metadataUpdate can not be null");
        RemoteLogSegmentState targetState = metadataUpdate.state();
        RemoteLogSegmentId remoteLogSegmentId = metadataUpdate.remoteLogSegmentId();
        RemoteLogSegmentMetadata existingMetadata = (RemoteLogSegmentMetadata)this.idToSegmentMetadata.get(remoteLogSegmentId);
        if (existingMetadata == null) {
            throw new RemoteResourceNotFoundException("No remote log segment metadata found for :" + remoteLogSegmentId);
        }
        this.checkStateTransition(existingMetadata.state(), targetState);
        switch (targetState) {
            case COPY_SEGMENT_STARTED: {
                throw new IllegalArgumentException("metadataUpdate: " + metadataUpdate + " with state " + RemoteLogSegmentState.COPY_SEGMENT_STARTED + " can not be updated");
            }
            case COPY_SEGMENT_FINISHED: {
                this.handleSegmentWithCopySegmentFinishedState(metadataUpdate, existingMetadata);
                break;
            }
            case DELETE_SEGMENT_STARTED: {
                this.handleSegmentWithDeleteSegmentStartedState(metadataUpdate, existingMetadata);
                break;
            }
            case DELETE_SEGMENT_FINISHED: {
                this.handleSegmentWithDeleteSegmentFinishedState(metadataUpdate, existingMetadata);
                break;
            }
            default: {
                throw new IllegalArgumentException("Metadata with the state " + targetState + " is not supported");
            }
        }
    }

    private void handleSegmentWithCopySegmentFinishedState(RemoteLogSegmentMetadataUpdate metadataUpdate, RemoteLogSegmentMetadata existingMetadata) {
        log.debug("Adding remote log segment metadata to leader epoch mappings with update: [{}]", (Object)metadataUpdate);
        this.doHandleSegmentStateTransitionForLeaderEpochs(existingMetadata, RemoteLogLeaderEpochState::handleSegmentWithCopySegmentFinishedState);
        this.idToSegmentMetadata.put(existingMetadata.remoteLogSegmentId(), existingMetadata.createWithUpdates(metadataUpdate));
    }

    private void handleSegmentWithDeleteSegmentStartedState(RemoteLogSegmentMetadataUpdate metadataUpdate, RemoteLogSegmentMetadata existingMetadata) {
        log.debug("Cleaning up the state for : [{}]", (Object)metadataUpdate);
        this.doHandleSegmentStateTransitionForLeaderEpochs(existingMetadata, RemoteLogLeaderEpochState::handleSegmentWithDeleteSegmentStartedState);
        this.idToSegmentMetadata.put(existingMetadata.remoteLogSegmentId(), existingMetadata.createWithUpdates(metadataUpdate));
    }

    private void handleSegmentWithDeleteSegmentFinishedState(RemoteLogSegmentMetadataUpdate metadataUpdate, RemoteLogSegmentMetadata existingMetadata) {
        log.debug("Removing the entry as it reached the terminal state: [{}]", (Object)metadataUpdate);
        this.doHandleSegmentStateTransitionForLeaderEpochs(existingMetadata, RemoteLogLeaderEpochState::handleSegmentWithDeleteSegmentFinishedState);
        this.idToSegmentMetadata.remove(existingMetadata.remoteLogSegmentId());
    }

    private void doHandleSegmentStateTransitionForLeaderEpochs(RemoteLogSegmentMetadata existingMetadata, RemoteLogLeaderEpochState.Action action) {
        RemoteLogSegmentId remoteLogSegmentId = existingMetadata.remoteLogSegmentId();
        NavigableMap leaderEpochToOffset = existingMetadata.segmentLeaderEpochs();
        for (Map.Entry entry : leaderEpochToOffset.entrySet()) {
            Integer leaderEpoch = (Integer)entry.getKey();
            Long startOffset = (Long)entry.getValue();
            RemoteLogLeaderEpochState remoteLogLeaderEpochState = (RemoteLogLeaderEpochState)this.leaderEpochEntries.get(leaderEpoch);
            if (remoteLogLeaderEpochState == null) {
                throw new IllegalStateException("RemoteLogLeaderEpochState does not exist for the leader epoch: " + leaderEpoch);
            }
            long leaderEpochEndOffset = this.highestOffsetForEpoch(leaderEpoch, existingMetadata);
            action.accept(remoteLogLeaderEpochState, startOffset, remoteLogSegmentId, leaderEpochEndOffset);
        }
    }

    private long highestOffsetForEpoch(Integer leaderEpoch, RemoteLogSegmentMetadata segmentMetadata) {
        NavigableMap epochToOffset = segmentMetadata.segmentLeaderEpochs();
        Map.Entry nextEntry = epochToOffset.higherEntry(leaderEpoch);
        return nextEntry != null ? (Long)nextEntry.getValue() - 1L : segmentMetadata.endOffset();
    }

    public Iterator<RemoteLogSegmentMetadata> listAllRemoteLogSegments() {
        return Collections.unmodifiableCollection(this.idToSegmentMetadata.values()).iterator();
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(int leaderEpoch) throws RemoteResourceNotFoundException {
        RemoteLogLeaderEpochState remoteLogLeaderEpochState = (RemoteLogLeaderEpochState)this.leaderEpochEntries.get(leaderEpoch);
        if (remoteLogLeaderEpochState == null) {
            return Collections.emptyIterator();
        }
        return remoteLogLeaderEpochState.listAllRemoteLogSegments(this.idToSegmentMetadata);
    }

    public Optional<Long> highestOffsetForEpoch(int leaderEpoch) {
        RemoteLogLeaderEpochState entry = (RemoteLogLeaderEpochState)this.leaderEpochEntries.get(leaderEpoch);
        return entry != null ? Optional.ofNullable(entry.highestLogOffset()) : Optional.empty();
    }

    public void addCopyInProgressSegment(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        log.debug("Adding to in-progress state: [{}]", (Object)remoteLogSegmentMetadata);
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        if (remoteLogSegmentMetadata.state() != RemoteLogSegmentState.COPY_SEGMENT_STARTED) {
            throw new IllegalArgumentException("Given remoteLogSegmentMetadata:" + remoteLogSegmentMetadata + " should have state as " + RemoteLogSegmentState.COPY_SEGMENT_STARTED + " but it contains state as: " + remoteLogSegmentMetadata.state());
        }
        RemoteLogSegmentId remoteLogSegmentId = remoteLogSegmentMetadata.remoteLogSegmentId();
        RemoteLogSegmentMetadata existingMetadata = (RemoteLogSegmentMetadata)this.idToSegmentMetadata.get(remoteLogSegmentId);
        this.checkStateTransition(existingMetadata != null ? existingMetadata.state() : null, remoteLogSegmentMetadata.state());
        for (Integer epoch : remoteLogSegmentMetadata.segmentLeaderEpochs().keySet()) {
            this.leaderEpochEntries.computeIfAbsent(epoch, leaderEpoch -> new RemoteLogLeaderEpochState()).handleSegmentWithCopySegmentStartedState(remoteLogSegmentId);
        }
        this.idToSegmentMetadata.put(remoteLogSegmentId, remoteLogSegmentMetadata);
    }

    private void checkStateTransition(RemoteLogSegmentState existingState, RemoteLogSegmentState targetState) {
        if (!RemoteLogSegmentState.isValidTransition((RemoteLogSegmentState)existingState, (RemoteLogSegmentState)targetState)) {
            throw new IllegalStateException("Current state: " + existingState + " can not be transitioned to target state: " + targetState);
        }
    }
}

