/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.ProtocolExec;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestProtocolExec {
    @Mock
    private ClientExecChain requestExecutor;
    @Mock
    private HttpProcessor httpProcessor;
    @Mock
    private HttpExecutionAware execAware;
    private ProtocolExec protocolExec;
    private HttpHost target;
    private HttpHost proxy;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.protocolExec = new ProtocolExec(this.requestExecutor, this.httpProcessor);
        this.target = new HttpHost("foo", 80);
        this.proxy = new HttpHost("bar", 8888);
    }

    @Test
    public void testFundamentals() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("/test"));
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response);
        this.protocolExec.execute(route, request, context, this.execAware);
        ((HttpProcessor)Mockito.verify((Object)this.httpProcessor)).process((HttpRequest)request, (HttpContext)context);
        ((ClientExecChain)Mockito.verify((Object)this.requestExecutor)).execute(route, request, context, this.execAware);
        ((HttpProcessor)Mockito.verify((Object)this.httpProcessor)).process((HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)new HttpHost("foo", 80), (Object)context.getTargetHost());
        Assert.assertEquals((Object)this.target, (Object)context.getTargetHost());
        Assert.assertEquals((Object)route, (Object)context.getHttpRoute());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
    }

    @Test
    public void testRewriteAbsoluteRequestURI() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://foo/test"));
        this.protocolExec.rewriteRequestURI(request, route);
        Assert.assertEquals((Object)new URI("/test"), (Object)request.getURI());
    }

    @Test
    public void testRewriteEmptyRequestURI() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet(""));
        this.protocolExec.rewriteRequestURI(request, route);
        Assert.assertEquals((Object)new URI("/"), (Object)request.getURI());
    }

    @Test
    public void testRewriteAbsoluteRequestURIViaPRoxy() throws Exception {
        HttpRoute route = new HttpRoute(this.target, this.proxy);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://foo/test"));
        this.protocolExec.rewriteRequestURI(request, route);
        Assert.assertEquals((Object)new URI("http://foo/test"), (Object)request.getURI());
    }

    @Test
    public void testRewriteRelativeRequestURIViaPRoxy() throws Exception {
        HttpRoute route = new HttpRoute(this.target, this.proxy);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("/test"));
        this.protocolExec.rewriteRequestURI(request, route);
        Assert.assertEquals((Object)new URI("http://foo:80/test"), (Object)request.getURI());
    }

    @Test
    public void testHostHeaderUriRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        HttpClientContext context = HttpClientContext.create();
        this.protocolExec.execute(route, request, context, this.execAware);
        Assert.assertEquals((Object)new HttpHost("bar", -1, "http"), (Object)context.getTargetHost());
    }

    @Test
    public void testHostHeaderWhenNonUriRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new BasicHttpRequest("GET", "http://bar/test"));
        HttpClientContext context = HttpClientContext.create();
        this.protocolExec.execute(route, request, context, this.execAware);
        Assert.assertEquals((Object)new HttpHost("bar", -1, "http"), (Object)context.getTargetHost());
    }

    @Test
    public void testHostHeaderWhenNonUriRequestAndInvalidUri() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new BasicHttpRequest("GET", "http://bar/test|"));
        HttpClientContext context = HttpClientContext.create();
        this.protocolExec.execute(route, request, context, this.execAware);
        Assert.assertEquals((Object)new HttpHost("foo", 80, "http"), (Object)context.getTargetHost());
    }

    @Test
    public void testHostHeaderImplicitHost() throws Exception {
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 8080));
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("/test"));
        HttpClientContext context = HttpClientContext.create();
        this.protocolExec.execute(route, request, context, this.execAware);
        Assert.assertEquals((Object)new HttpHost("somehost", 8080), (Object)context.getTargetHost());
    }

    @Test
    public void testUserInfoInRequestURI() throws Exception {
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 8080));
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://somefella:secret@bar/test"));
        HttpClientContext context = HttpClientContext.create();
        this.protocolExec.execute(route, request, context, this.execAware);
        Assert.assertEquals((Object)new URI("/test"), (Object)request.getURI());
        Assert.assertEquals((Object)new HttpHost("bar", -1), (Object)context.getTargetHost());
        CredentialsProvider credentialsProvider = context.getCredentialsProvider();
        Assert.assertNotNull((Object)credentialsProvider);
        Credentials creds = credentialsProvider.getCredentials(new AuthScope("bar", -1, null));
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"somefella", (Object)creds.getUserPrincipal().getName());
    }

    @Test(expected=HttpException.class)
    public void testPostProcessHttpException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("/test"));
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response);
        ((HttpProcessor)Mockito.doThrow((Throwable)new HttpException("Ooopsie")).when((Object)this.httpProcessor)).process((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any());
        try {
            this.protocolExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((CloseableHttpResponse)Mockito.verify((Object)response)).close();
            throw ex;
        }
    }

    @Test(expected=IOException.class)
    public void testPostProcessIOException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("/test"));
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response);
        ((HttpProcessor)Mockito.doThrow((Throwable)new IOException("Ooopsie")).when((Object)this.httpProcessor)).process((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any());
        try {
            this.protocolExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((CloseableHttpResponse)Mockito.verify((Object)response)).close();
            throw ex;
        }
    }

    @Test(expected=RuntimeException.class)
    public void testPostProcessRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("/test"));
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response);
        ((HttpProcessor)Mockito.doThrow((Throwable)new RuntimeException("Ooopsie")).when((Object)this.httpProcessor)).process((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any());
        try {
            this.protocolExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((CloseableHttpResponse)Mockito.verify((Object)response)).close();
            throw ex;
        }
    }
}

