/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.impl.execchain.HttpResponseProxy;
import org.apache.http.impl.execchain.MainClientExec;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.apache.http.impl.execchain.TunnelRefusedException;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.util.EntityUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestMainClientExec {
    @Mock
    private HttpRequestExecutor requestExecutor;
    @Mock
    private HttpClientConnectionManager connManager;
    @Mock
    private ConnectionReuseStrategy reuseStrategy;
    @Mock
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    @Mock
    private AuthenticationStrategy targetAuthStrategy;
    @Mock
    private AuthenticationStrategy proxyAuthStrategy;
    @Mock
    private UserTokenHandler userTokenHandler;
    @Mock
    private HttpExecutionAware execAware;
    @Mock
    private ConnectionRequest connRequest;
    @Mock
    private HttpClientConnection managedConn;
    private MainClientExec mainClientExec;
    private HttpHost target;
    private HttpHost proxy;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mainClientExec = new MainClientExec(this.requestExecutor, this.connManager, this.reuseStrategy, this.keepAliveStrategy, this.targetAuthStrategy, this.proxyAuthStrategy, this.userTokenHandler);
        this.target = new HttpHost("foo", 80);
        this.proxy = new HttpHost("bar", 8888);
        Mockito.when((Object)this.connManager.requestConnection((HttpRoute)Mockito.any(), Mockito.any())).thenReturn((Object)this.connRequest);
        Mockito.when((Object)this.connRequest.get(Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()))).thenReturn((Object)this.managedConn);
        HashMap<String, BasicHeader> challenges = new HashMap<String, BasicHeader>();
        challenges.put("basic", new BasicHeader("WWW-Authenticate", "Basic realm=test"));
        AuthOption authOption = new AuthOption((AuthScheme)new BasicScheme(), (Credentials)new UsernamePasswordCredentials("user:pass"));
        Mockito.when((Object)this.targetAuthStrategy.getChallenges((HttpHost)Mockito.eq((Object)this.target), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(challenges);
        Mockito.when((Object)this.targetAuthStrategy.getChallenges((HttpHost)Mockito.eq((Object)this.target), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(challenges);
        Mockito.when((Object)this.targetAuthStrategy.select((Map)Mockito.same(challenges), (HttpHost)Mockito.eq((Object)this.target), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(new LinkedList<AuthOption>(Arrays.asList(authOption)));
        Mockito.when((Object)this.proxyAuthStrategy.getChallenges((HttpHost)Mockito.eq((Object)this.proxy), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(challenges);
        Mockito.when((Object)this.proxyAuthStrategy.getChallenges((HttpHost)Mockito.eq((Object)this.proxy), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(challenges);
        Mockito.when((Object)this.proxyAuthStrategy.select((Map)Mockito.same(challenges), (HttpHost)Mockito.eq((Object)this.proxy), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(new LinkedList<AuthOption>(Arrays.asList(authOption)));
    }

    @Test
    public void testExecRequestNonPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(123).setSocketTimeout(234).setConnectionRequestTimeout(345).build();
        context.setRequestConfig(config);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        CloseableHttpResponse finalResponse = this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).requestConnection(route, null);
        ((ConnectionRequest)Mockito.verify((Object)this.connRequest)).get(345L, TimeUnit.MILLISECONDS);
        ((HttpExecutionAware)Mockito.verify((Object)this.execAware, (VerificationMode)Mockito.times((int)1))).setCancellable((Cancellable)this.connRequest);
        ((HttpExecutionAware)Mockito.verify((Object)this.execAware, (VerificationMode)Mockito.times((int)2))).setCancellable((Cancellable)Mockito.any());
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).connect(this.managedConn, route, 123, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).routeComplete(this.managedConn, route, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn)).setSocketTimeout(234);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.times((int)1))).close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)context.getTargetAuthState());
        Assert.assertNotNull((Object)context.getProxyAuthState());
        Assert.assertSame((Object)this.managedConn, (Object)context.getConnection());
        Assert.assertNull((Object)context.getUserToken());
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof HttpResponseProxy));
    }

    @Test
    public void testExecRequestPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.keepAliveStrategy.getKeepAliveDuration((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)678L);
        CloseableHttpResponse finalResponse = this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).requestConnection(route, null);
        ((ConnectionRequest)Mockito.verify((Object)this.connRequest)).get(0L, TimeUnit.MILLISECONDS);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 678L, TimeUnit.MILLISECONDS);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.never())).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof HttpResponseProxy));
    }

    @Test
    public void testExecRequestPersistentStatefulConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.userTokenHandler.getUserToken((HttpContext)Mockito.any())).thenReturn((Object)"this and that");
        this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).requestConnection(route, null);
        ((ConnectionRequest)Mockito.verify((Object)this.connRequest)).get(0L, TimeUnit.MILLISECONDS);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, (Object)"this and that", 0L, TimeUnit.MILLISECONDS);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.never())).close();
        Assert.assertEquals((Object)"this and that", (Object)context.getUserToken());
    }

    @Test
    public void testExecRequestConnectionRelease() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.FALSE);
        CloseableHttpResponse finalResponse = this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).requestConnection(route, null);
        ((ConnectionRequest)Mockito.verify((Object)this.connRequest)).get(0L, TimeUnit.MILLISECONDS);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager, (VerificationMode)Mockito.never())).releaseConnection((HttpClientConnection)Mockito.same((Object)this.managedConn), Mockito.any(), (long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any()));
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.never())).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof HttpResponseProxy));
        finalResponse.close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager, (VerificationMode)Mockito.times((int)1))).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void testExecRequestStaleConnectionCheck() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        RequestConfig config = RequestConfig.custom().setStaleConnectionCheckEnabled(true).build();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        context.setRequestConfig(config);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        CloseableHttpResponse finalResponse = this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof HttpResponseProxy));
    }

    @Test
    public void testSocketTimeoutExistingConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        RequestConfig config = RequestConfig.custom().setSocketTimeout(3000).build();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        context.setRequestConfig(config);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn)).setSocketTimeout(3000);
    }

    @Test
    public void testSocketTimeoutReset() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.never())).setSocketTimeout(Mockito.anyInt());
    }

    @Test(expected=RequestAbortedException.class)
    public void testExecAbortedPriorToConnectionLease() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.execAware.isAborted()).thenReturn((Object)Boolean.TRUE);
        try {
            this.mainClientExec.execute(route, request, context, this.execAware);
        }
        catch (IOException ex) {
            ((ConnectionRequest)Mockito.verify((Object)this.connRequest, (VerificationMode)Mockito.times((int)1))).cancel();
            throw ex;
        }
    }

    @Test(expected=RequestAbortedException.class)
    public void testExecAbortedPriorToConnectionSetup() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.execAware.isAborted()).thenReturn((Object)Boolean.FALSE, (Object[])new Boolean[]{Boolean.TRUE});
        try {
            this.mainClientExec.execute(route, request, context, this.execAware);
        }
        catch (IOException ex) {
            ((ConnectionRequest)Mockito.verify((Object)this.connRequest, (VerificationMode)Mockito.times((int)1))).get(0L, TimeUnit.MILLISECONDS);
            ((HttpExecutionAware)Mockito.verify((Object)this.execAware, (VerificationMode)Mockito.times((int)2))).setCancellable((Cancellable)Mockito.any());
            ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager, (VerificationMode)Mockito.never())).connect((HttpClientConnection)Mockito.same((Object)this.managedConn), (HttpRoute)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any());
            throw ex;
        }
    }

    @Test(expected=RequestAbortedException.class)
    public void testExecAbortedPriorToRequestExecution() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.execAware.isAborted()).thenReturn((Object)Boolean.FALSE, (Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        try {
            this.mainClientExec.execute(route, request, context, this.execAware);
        }
        catch (IOException ex) {
            ((ConnectionRequest)Mockito.verify((Object)this.connRequest, (VerificationMode)Mockito.times((int)1))).get(0L, TimeUnit.MILLISECONDS);
            ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager, (VerificationMode)Mockito.times((int)1))).connect(this.managedConn, route, 0, (HttpContext)context);
            ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.never())).execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any());
            throw ex;
        }
    }

    @Test(expected=RequestAbortedException.class)
    public void testExecConnectionRequestFailed() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.connRequest.get((long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any()))).thenThrow(new Throwable[]{new ExecutionException("Opppsie", null)});
        this.mainClientExec.execute(route, request, context, this.execAware);
    }

    @Test
    public void testExecRequestRetryOnAuthChallenge() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "Huh?");
        InputStream instream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(instream1).build());
        BasicHttpResponse response2 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        InputStream instream2 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{2, 3, 4}));
        response2.setEntity(EntityBuilder.create().setStream(instream2).build());
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response1, (Object[])new HttpResponse[]{response2});
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.targetAuthStrategy.isAuthenticationRequested((HttpHost)Mockito.eq((Object)this.target), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        CloseableHttpResponse finalResponse = this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)2))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((InputStream)Mockito.verify((Object)instream1)).close();
        ((InputStream)Mockito.verify((Object)instream2, (VerificationMode)Mockito.never())).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertEquals((int)200, (int)finalResponse.getStatusLine().getStatusCode());
    }

    @Test
    public void testExecEntityEnclosingRequestRetryOnAuthChallenge() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "Huh?");
        InputStream instream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(instream1).build());
        BasicHttpResponse response2 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        InputStream instream2 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{2, 3, 4}));
        response2.setEntity(EntityBuilder.create().setStream(instream2).build());
        AuthState proxyAuthState = new AuthState();
        proxyAuthState.setState(AuthProtocolState.SUCCESS);
        proxyAuthState.update((AuthScheme)new NTLMScheme(), (Credentials)new NTCredentials("user:pass"));
        HttpClientContext context = new HttpClientContext();
        context.setAttribute("http.auth.proxy-scope", (Object)proxyAuthState);
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response1, (Object[])new HttpResponse[]{response2});
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.targetAuthStrategy.isAuthenticationRequested((HttpHost)Mockito.eq((Object)this.target), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        CloseableHttpResponse finalResponse = this.mainClientExec.execute(route, request, context, this.execAware);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)2))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn)).close();
        ((InputStream)Mockito.verify((Object)instream2, (VerificationMode)Mockito.never())).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertEquals((int)200, (int)finalResponse.getStatusLine().getStatusCode());
        Assert.assertNull((Object)proxyAuthState.getAuthScheme());
        Assert.assertNull((Object)proxyAuthState.getCredentials());
    }

    @Test(expected=NonRepeatableRequestException.class)
    public void testExecEntityEnclosingRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpPost post = new HttpPost("http://bar/test");
        ByteArrayInputStream instream0 = new ByteArrayInputStream(new byte[]{1, 2, 3});
        post.setEntity(EntityBuilder.create().setStream((InputStream)instream0).build());
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)post);
        BasicHttpResponse response1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "Huh?");
        ByteArrayInputStream instream1 = new ByteArrayInputStream(new byte[]{1, 2, 3});
        response1.setEntity(EntityBuilder.create().setStream((InputStream)instream1).build());
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenAnswer((Answer)new Answer<HttpResponse>((HttpResponse)response1){
            final /* synthetic */ HttpResponse val$response1;
            {
                this.val$response1 = httpResponse;
            }

            public HttpResponse answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)args[0];
                request.getEntity().writeTo((OutputStream)new ByteArrayOutputStream());
                return this.val$response1;
            }
        });
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.targetAuthStrategy.isAuthenticationRequested((HttpHost)Mockito.eq((Object)this.target), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        this.mainClientExec.execute(route, request, context, this.execAware);
    }

    @Test(expected=InterruptedIOException.class)
    public void testExecConnectionShutDown() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new ConnectionShutdownException()});
        this.mainClientExec.execute(route, request, context, this.execAware);
    }

    @Test(expected=RuntimeException.class)
    public void testExecRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Ka-boom")});
        try {
            this.mainClientExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
            throw ex;
        }
    }

    @Test(expected=HttpException.class)
    public void testExecHttpException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new HttpException("Ka-boom")});
        try {
            this.mainClientExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
            throw ex;
        }
    }

    @Test(expected=IOException.class)
    public void testExecIOException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new IOException("Ka-boom")});
        try {
            this.mainClientExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
            throw ex;
        }
    }

    @Test
    public void testEstablishDirectRoute() throws Exception {
        AuthState authState = new AuthState();
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mainClientExec.establishRoute(authState, this.managedConn, route, (HttpRequest)request, context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).connect(this.managedConn, route, 0, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).routeComplete(this.managedConn, route, (HttpContext)context);
    }

    @Test
    public void testEstablishRouteDirectProxy() throws Exception {
        AuthState authState = new AuthState();
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, false);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mainClientExec.establishRoute(authState, this.managedConn, route, (HttpRequest)request, context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).connect(this.managedConn, route, 0, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).routeComplete(this.managedConn, route, (HttpContext)context);
    }

    @Test
    public void testEstablishRouteViaProxyTunnel() throws Exception {
        AuthState authState = new AuthState();
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(321).build();
        context.setRequestConfig(config);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        this.mainClientExec.establishRoute(authState, this.managedConn, route, (HttpRequest)request, context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).connect(this.managedConn, route, 321, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).routeComplete(this.managedConn, route, (HttpContext)context);
        ArgumentCaptor reqCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor)).execute((HttpRequest)reqCaptor.capture(), (HttpClientConnection)Mockito.same((Object)this.managedConn), (HttpContext)Mockito.same((Object)context));
        HttpRequest connect = (HttpRequest)reqCaptor.getValue();
        Assert.assertNotNull((Object)connect);
        Assert.assertEquals((String)"CONNECT", (String)connect.getRequestLine().getMethod());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)connect.getRequestLine().getProtocolVersion());
        Assert.assertEquals((String)"foo:80", (String)connect.getRequestLine().getUri());
    }

    @Test(expected=HttpException.class)
    public void testEstablishRouteViaProxyTunnelUnexpectedResponse() throws Exception {
        AuthState authState = new AuthState();
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 101, "Lost");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        this.mainClientExec.establishRoute(authState, this.managedConn, route, (HttpRequest)request, context);
    }

    @Test(expected=HttpException.class)
    public void testEstablishRouteViaProxyTunnelFailure() throws Exception {
        AuthState authState = new AuthState();
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 500, "Boom");
        response.setEntity((HttpEntity)new StringEntity("Ka-boom"));
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        try {
            this.mainClientExec.establishRoute(authState, this.managedConn, route, (HttpRequest)request, context);
        }
        catch (TunnelRefusedException ex) {
            HttpResponse r = ex.getResponse();
            Assert.assertEquals((String)"Ka-boom", (String)EntityUtils.toString((HttpEntity)r.getEntity()));
            ((HttpClientConnection)Mockito.verify((Object)this.managedConn)).close();
            throw ex;
        }
    }

    @Test
    public void testEstablishRouteViaProxyTunnelRetryOnAuthChallengePersistentConnection() throws Exception {
        AuthState authState = new AuthState();
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "Huh?");
        InputStream instream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(instream1).build());
        BasicHttpResponse response2 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.proxyAuthStrategy.isAuthenticationRequested((HttpHost)Mockito.eq((Object)this.proxy), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response1, (Object[])new HttpResponse[]{response2});
        this.mainClientExec.establishRoute(authState, this.managedConn, route, (HttpRequest)request, context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).connect(this.managedConn, route, 0, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).routeComplete(this.managedConn, route, (HttpContext)context);
        ((InputStream)Mockito.verify((Object)instream1)).close();
    }

    @Test
    public void testEstablishRouteViaProxyTunnelRetryOnAuthChallengeNonPersistentConnection() throws Exception {
        AuthState authState = new AuthState();
        HttpRoute route = new HttpRoute(this.target, null, this.proxy, true);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "Huh?");
        InputStream instream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(instream1).build());
        BasicHttpResponse response2 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.proxyAuthStrategy.isAuthenticationRequested((HttpHost)Mockito.eq((Object)this.proxy), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response1, (Object[])new HttpResponse[]{response2});
        this.mainClientExec.establishRoute(authState, this.managedConn, route, (HttpRequest)request, context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).connect(this.managedConn, route, 0, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).routeComplete(this.managedConn, route, (HttpContext)context);
        ((InputStream)Mockito.verify((Object)instream1, (VerificationMode)Mockito.never())).close();
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn)).close();
    }

    @Test(expected=HttpException.class)
    public void testEstablishRouteViaProxyTunnelMultipleHops() throws Exception {
        AuthState authState = new AuthState();
        HttpHost proxy1 = new HttpHost("this", 8888);
        HttpHost proxy2 = new HttpHost("that", 8888);
        HttpRoute route = new HttpRoute(this.target, null, new HttpHost[]{proxy1, proxy2}, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mainClientExec.establishRoute(authState, this.managedConn, route, (HttpRequest)request, context);
    }
}

