/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConnectionManagement
extends LocalServerTestBase {
    @Before
    public void setup() throws Exception {
        this.startServer();
    }

    private static HttpClientConnection getConnection(HttpClientConnectionManager mgr, HttpRoute route, long timeout, TimeUnit unit) throws ConnectionPoolTimeoutException, ExecutionException, InterruptedException {
        ConnectionRequest connRequest = mgr.requestConnection(route, null);
        return connRequest.get(timeout, unit);
    }

    private static HttpClientConnection getConnection(HttpClientConnectionManager mgr, HttpRoute route) throws ConnectionPoolTimeoutException, ExecutionException, InterruptedException {
        ConnectionRequest connRequest = mgr.requestConnection(route, null);
        return connRequest.get(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testReleaseConnection() throws Exception {
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager();
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        int rsplen = 8;
        String uri = "/random/8";
        BasicHttpRequest request = new BasicHttpRequest("GET", "/random/8", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpContext context = new BasicHttpContext();
        HttpClientConnection conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        mgr.connect(conn, route, 0, (HttpContext)context);
        mgr.routeComplete(conn, route, (HttpContext)context);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.target_host", (Object)target);
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestConnControl()});
        HttpRequestExecutor exec = new HttpRequestExecutor();
        exec.preProcess((HttpRequest)request, (HttpProcessor)httpProcessor, (HttpContext)context);
        HttpResponse response = exec.execute((HttpRequest)request, conn, (HttpContext)context);
        Assert.assertEquals((String)"wrong status in first response", (long)200L, (long)response.getStatusLine().getStatusCode());
        byte[] data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of first response entity", (long)8L, (long)data.length);
        try {
            TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        conn.close();
        mgr.releaseConnection(conn, null, -1L, null);
        conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn.isOpen());
        mgr.connect(conn, route, 0, (HttpContext)context);
        mgr.routeComplete(conn, route, (HttpContext)context);
        context.setAttribute("http.connection", (Object)conn);
        response = exec.execute((HttpRequest)request, conn, (HttpContext)context);
        Assert.assertEquals((String)"wrong status in second response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of second response entity", (long)8L, (long)data.length);
        mgr.releaseConnection(conn, null, -1L, null);
        conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        Assert.assertTrue((String)"connection should have been open", (boolean)conn.isOpen());
        context.setAttribute("http.connection", (Object)conn);
        response = exec.execute((HttpRequest)request, conn, (HttpContext)context);
        Assert.assertEquals((String)"wrong status in third response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of third response entity", (long)8L, (long)data.length);
        mgr.releaseConnection(conn, null, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testReleaseConnectionWithTimeLimits() throws Exception {
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager();
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        int rsplen = 8;
        String uri = "/random/8";
        BasicHttpRequest request = new BasicHttpRequest("GET", "/random/8", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpContext context = new BasicHttpContext();
        HttpClientConnection conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        mgr.connect(conn, route, 0, (HttpContext)context);
        mgr.routeComplete(conn, route, (HttpContext)context);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.target_host", (Object)target);
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestConnControl()});
        HttpRequestExecutor exec = new HttpRequestExecutor();
        exec.preProcess((HttpRequest)request, (HttpProcessor)httpProcessor, (HttpContext)context);
        HttpResponse response = exec.execute((HttpRequest)request, conn, (HttpContext)context);
        Assert.assertEquals((String)"wrong status in first response", (long)200L, (long)response.getStatusLine().getStatusCode());
        byte[] data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of first response entity", (long)8L, (long)data.length);
        try {
            TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        conn.close();
        mgr.releaseConnection(conn, null, 100L, TimeUnit.MILLISECONDS);
        conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn.isOpen());
        mgr.connect(conn, route, 0, (HttpContext)context);
        mgr.routeComplete(conn, route, (HttpContext)context);
        context.setAttribute("http.connection", (Object)conn);
        response = exec.execute((HttpRequest)request, conn, (HttpContext)context);
        Assert.assertEquals((String)"wrong status in second response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of second response entity", (long)8L, (long)data.length);
        mgr.releaseConnection(conn, null, 100L, TimeUnit.MILLISECONDS);
        conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        Assert.assertTrue((String)"connection should have been open", (boolean)conn.isOpen());
        context.setAttribute("http.connection", (Object)conn);
        response = exec.execute((HttpRequest)request, conn, (HttpContext)context);
        Assert.assertEquals((String)"wrong status in third response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of third response entity", (long)8L, (long)data.length);
        mgr.releaseConnection(conn, null, 100L, TimeUnit.MILLISECONDS);
        Thread.sleep(150L);
        conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        Assert.assertTrue((String)"connection should have been closed", (!conn.isOpen() ? 1 : 0) != 0);
        mgr.connect(conn, route, 0, (HttpContext)context);
        mgr.routeComplete(conn, route, (HttpContext)context);
        context.setAttribute("http.connection", (Object)conn);
        response = exec.execute((HttpRequest)request, conn, (HttpContext)context);
        Assert.assertEquals((String)"wrong status in third response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of fourth response entity", (long)8L, (long)data.length);
        mgr.shutdown();
    }

    @Test
    public void testCloseExpiredIdleConnections() throws Exception {
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager();
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        BasicHttpContext context = new BasicHttpContext();
        HttpClientConnection conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        mgr.connect(conn, route, 0, (HttpContext)context);
        mgr.routeComplete(conn, route, (HttpContext)context);
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getLeased());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getLeased());
        mgr.releaseConnection(conn, null, 100L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getAvailable());
        mgr.closeExpiredConnections();
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getAvailable());
        Thread.sleep(150L);
        mgr.closeExpiredConnections();
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)0L, (long)mgr.getStats(route).getAvailable());
        mgr.shutdown();
    }

    @Test
    public void testCloseExpiredTTLConnections() throws Exception {
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager(100L, TimeUnit.MILLISECONDS);
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        BasicHttpContext context = new BasicHttpContext();
        HttpClientConnection conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        mgr.connect(conn, route, 0, (HttpContext)context);
        mgr.routeComplete(conn, route, (HttpContext)context);
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getLeased());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getLeased());
        mgr.releaseConnection(conn, null, -1L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getAvailable());
        mgr.closeExpiredConnections();
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getAvailable());
        Thread.sleep(150L);
        mgr.closeExpiredConnections();
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)0L, (long)mgr.getStats(route).getAvailable());
        mgr.shutdown();
    }

    @Test
    public void testReleaseConnectionOnAbort() throws Exception {
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager();
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        int rsplen = 8;
        String uri = "/random/8";
        BasicHttpContext context = new BasicHttpContext();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/random/8", (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpClientConnection conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        mgr.connect(conn, route, 0, (HttpContext)context);
        mgr.routeComplete(conn, route, (HttpContext)context);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.target_host", (Object)target);
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestConnControl()});
        HttpRequestExecutor exec = new HttpRequestExecutor();
        exec.preProcess((HttpRequest)request, (HttpProcessor)httpProcessor, (HttpContext)context);
        HttpResponse response = exec.execute((HttpRequest)request, conn, (HttpContext)context);
        Assert.assertEquals((String)"wrong status in first response", (long)200L, (long)response.getStatusLine().getStatusCode());
        try {
            TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route, 100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)(conn instanceof HttpClientConnection));
        conn.shutdown();
        mgr.releaseConnection(conn, null, -1L, null);
        conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn.isOpen());
        mgr.releaseConnection(conn, null, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testAbortDuringConnecting() throws Exception {
        final CountDownLatch connectLatch = new CountDownLatch(1);
        final StallingSocketFactory stallingSocketFactory = new StallingSocketFactory(connectLatch, WaitPolicy.BEFORE_CONNECT, (ConnectionSocketFactory)PlainConnectionSocketFactory.getSocketFactory());
        Registry registry = RegistryBuilder.create().register("http", (Object)stallingSocketFactory).build();
        final PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager(registry);
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        BasicHttpContext context = new BasicHttpContext();
        final HttpClientConnection conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        final AtomicReference throwRef = new AtomicReference();
        Thread abortingThread = new Thread(new Runnable(){

            public void run() {
                try {
                    stallingSocketFactory.waitForState();
                    conn.shutdown();
                    mgr.releaseConnection(conn, null, -1L, null);
                    connectLatch.countDown();
                }
                catch (Throwable e) {
                    throwRef.set(e);
                }
            }
        });
        abortingThread.start();
        try {
            mgr.connect(conn, route, 0, (HttpContext)context);
            mgr.routeComplete(conn, route, (HttpContext)context);
            Assert.fail((String)"expected SocketException");
        }
        catch (SocketException expected) {
            // empty catch block
        }
        abortingThread.join(5000L);
        if (throwRef.get() != null) {
            throw new RuntimeException((Throwable)throwRef.get());
        }
        Assert.assertFalse((boolean)conn.isOpen());
        Assert.assertEquals((long)0L, (long)this.localServer.getAcceptedConnectionCount());
        HttpClientConnection conn2 = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn2.isOpen());
        mgr.releaseConnection(conn2, null, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testAbortBeforeSocketCreate() throws Exception {
        final CountDownLatch connectLatch = new CountDownLatch(1);
        final StallingSocketFactory stallingSocketFactory = new StallingSocketFactory(connectLatch, WaitPolicy.BEFORE_CREATE, (ConnectionSocketFactory)PlainConnectionSocketFactory.getSocketFactory());
        Registry registry = RegistryBuilder.create().register("http", (Object)stallingSocketFactory).build();
        final PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager(registry);
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        BasicHttpContext context = new BasicHttpContext();
        final HttpClientConnection conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        final AtomicReference throwRef = new AtomicReference();
        Thread abortingThread = new Thread(new Runnable(){

            public void run() {
                try {
                    stallingSocketFactory.waitForState();
                    conn.shutdown();
                    mgr.releaseConnection(conn, null, -1L, null);
                    connectLatch.countDown();
                }
                catch (Throwable e) {
                    throwRef.set(e);
                }
            }
        });
        abortingThread.start();
        try {
            mgr.connect(conn, route, 0, (HttpContext)context);
            mgr.routeComplete(conn, route, (HttpContext)context);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException expected) {
            // empty catch block
        }
        abortingThread.join(5000L);
        if (throwRef.get() != null) {
            throw new RuntimeException((Throwable)throwRef.get());
        }
        Assert.assertFalse((boolean)conn.isOpen());
        Assert.assertEquals((long)0L, (long)this.localServer.getAcceptedConnectionCount());
        HttpClientConnection conn2 = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn2.isOpen());
        mgr.releaseConnection(conn2, null, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testAbortAfterSocketConnect() throws Exception {
        final CountDownLatch connectLatch = new CountDownLatch(1);
        final StallingSocketFactory stallingSocketFactory = new StallingSocketFactory(connectLatch, WaitPolicy.AFTER_CONNECT, (ConnectionSocketFactory)PlainConnectionSocketFactory.getSocketFactory());
        Registry registry = RegistryBuilder.create().register("http", (Object)stallingSocketFactory).build();
        final PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager(registry);
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        BasicHttpContext context = new BasicHttpContext();
        final HttpClientConnection conn = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route);
        final AtomicReference throwRef = new AtomicReference();
        Thread abortingThread = new Thread(new Runnable(){

            public void run() {
                try {
                    stallingSocketFactory.waitForState();
                    conn.shutdown();
                    mgr.releaseConnection(conn, null, -1L, null);
                    connectLatch.countDown();
                }
                catch (Throwable e) {
                    throwRef.set(e);
                }
            }
        });
        abortingThread.start();
        try {
            mgr.connect(conn, route, 0, (HttpContext)context);
            mgr.routeComplete(conn, route, (HttpContext)context);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException expected) {
            // empty catch block
        }
        abortingThread.join(5000L);
        if (throwRef.get() != null) {
            throw new RuntimeException((Throwable)throwRef.get());
        }
        Assert.assertFalse((boolean)conn.isOpen());
        for (int i = 0; i < 10 && this.localServer.getAcceptedConnectionCount() != 1; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)this.localServer.getAcceptedConnectionCount());
        HttpClientConnection conn2 = TestConnectionManagement.getConnection((HttpClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn2.isOpen());
        mgr.releaseConnection(conn2, null, -1L, null);
        mgr.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WaitPolicy {
        BEFORE_CREATE,
        BEFORE_CONNECT,
        AFTER_CONNECT,
        AFTER_OPEN;

    }

    private static class StallingSocketFactory
    extends LatchSupport
    implements ConnectionSocketFactory {
        private final ConnectionSocketFactory delegate;

        public StallingSocketFactory(CountDownLatch continueLatch, WaitPolicy waitPolicy, ConnectionSocketFactory delegate) {
            super(continueLatch, waitPolicy);
            this.delegate = delegate;
        }

        public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException, ConnectTimeoutException {
            if (this.waitPolicy == WaitPolicy.BEFORE_CONNECT) {
                this.latch();
            }
            Socket socket = this.delegate.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
            if (this.waitPolicy == WaitPolicy.AFTER_CONNECT) {
                this.latch();
            }
            return socket;
        }

        public Socket createSocket(HttpContext context) throws IOException {
            if (this.waitPolicy == WaitPolicy.BEFORE_CREATE) {
                this.latch();
            }
            return this.delegate.createSocket(context);
        }
    }

    static class LatchSupport {
        private final CountDownLatch continueLatch;
        private final CountDownLatch waitLatch = new CountDownLatch(1);
        protected final WaitPolicy waitPolicy;

        LatchSupport(CountDownLatch continueLatch, WaitPolicy waitPolicy) {
            this.continueLatch = continueLatch;
            this.waitPolicy = waitPolicy;
        }

        void waitForState() throws InterruptedException {
            if (!this.waitLatch.await(1L, TimeUnit.SECONDS)) {
                throw new RuntimeException("waited too long");
            }
        }

        void latch() {
            this.waitLatch.countDown();
            try {
                if (!this.continueLatch.await(60L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("waited too long!");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

