/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.InternalHttpClient;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestInternalHttpClient {
    private ClientExecChain execChain;
    private HttpClientConnectionManager connManager;
    private HttpRoutePlanner routePlanner;
    private Lookup<CookieSpecProvider> cookieSpecRegistry;
    private Lookup<AuthSchemeProvider> authSchemeRegistry;
    private CookieStore cookieStore;
    private CredentialsProvider credentialsProvider;
    private RequestConfig defaultConfig;
    private Closeable closeable1;
    private Closeable closeable2;
    private InternalHttpClient client;

    @Before
    public void setup() throws Exception {
        this.execChain = (ClientExecChain)Mockito.mock(ClientExecChain.class);
        this.connManager = (HttpClientConnectionManager)Mockito.mock(HttpClientConnectionManager.class);
        this.routePlanner = (HttpRoutePlanner)Mockito.mock(HttpRoutePlanner.class);
        this.cookieSpecRegistry = (Lookup)Mockito.mock(Lookup.class);
        this.authSchemeRegistry = (Lookup)Mockito.mock(Lookup.class);
        this.cookieStore = (CookieStore)Mockito.mock(CookieStore.class);
        this.credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        this.defaultConfig = RequestConfig.custom().build();
        this.closeable1 = (Closeable)Mockito.mock(Closeable.class);
        this.closeable2 = (Closeable)Mockito.mock(Closeable.class);
        this.client = new InternalHttpClient(this.execChain, this.connManager, this.routePlanner, this.cookieSpecRegistry, this.authSchemeRegistry, this.cookieStore, this.credentialsProvider, this.defaultConfig, Arrays.asList(this.closeable1, this.closeable2));
    }

    @Test
    public void testExecute() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpRoute route = new HttpRoute(new HttpHost("somehost"));
        ArgumentCaptor argcap = ArgumentCaptor.forClass(HttpRequestWrapper.class);
        Mockito.when((Object)this.routePlanner.determineRoute((HttpHost)Mockito.eq((Object)new HttpHost("somehost")), (HttpRequest)argcap.capture(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        this.client.execute((HttpUriRequest)httpget);
        Assert.assertNotNull((Object)argcap.getValue());
        Assert.assertSame((Object)httpget, (Object)((HttpRequestWrapper)argcap.getValue()).getOriginal());
        ((ClientExecChain)Mockito.verify((Object)this.execChain)).execute((HttpRoute)Mockito.same((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.same((Object)httpget));
    }

    @Test(expected=ClientProtocolException.class)
    public void testExecuteHttpException() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpRoute route = new HttpRoute(new HttpHost("somehost"));
        Mockito.when((Object)this.routePlanner.determineRoute((HttpHost)Mockito.eq((Object)new HttpHost("somehost")), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        Mockito.when((Object)this.execChain.execute((HttpRoute)Mockito.same((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.same((Object)httpget))).thenThrow(new Throwable[]{new HttpException()});
        this.client.execute((HttpUriRequest)httpget);
    }

    @Test
    public void testExecuteDefaultContext() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpClientContext context = HttpClientContext.create();
        this.client.execute((HttpUriRequest)httpget, (HttpContext)context);
        Assert.assertSame(this.cookieSpecRegistry, (Object)context.getCookieSpecRegistry());
        Assert.assertSame(this.authSchemeRegistry, (Object)context.getAuthSchemeRegistry());
        Assert.assertSame((Object)this.cookieStore, (Object)context.getCookieStore());
        Assert.assertSame((Object)this.credentialsProvider, (Object)context.getCredentialsProvider());
        Assert.assertSame((Object)this.defaultConfig, (Object)context.getRequestConfig());
    }

    @Test
    public void testExecuteRequestConfig() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        RequestConfig config = RequestConfig.custom().build();
        httpget.setConfig(config);
        HttpClientContext context = HttpClientContext.create();
        this.client.execute((HttpUriRequest)httpget, (HttpContext)context);
        Assert.assertSame((Object)config, (Object)context.getRequestConfig());
    }

    @Test
    public void testExecuteLocalContext() throws Exception {
        HttpGet httpget = new HttpGet("http://somehost/stuff");
        HttpClientContext context = HttpClientContext.create();
        Lookup localCookieSpecRegistry = (Lookup)Mockito.mock(Lookup.class);
        Lookup localAuthSchemeRegistry = (Lookup)Mockito.mock(Lookup.class);
        CookieStore localCookieStore = (CookieStore)Mockito.mock(CookieStore.class);
        CredentialsProvider localCredentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        RequestConfig localConfig = RequestConfig.custom().build();
        context.setCookieSpecRegistry(localCookieSpecRegistry);
        context.setAuthSchemeRegistry(localAuthSchemeRegistry);
        context.setCookieStore(localCookieStore);
        context.setCredentialsProvider(localCredentialsProvider);
        context.setRequestConfig(localConfig);
        this.client.execute((HttpUriRequest)httpget, (HttpContext)context);
        Assert.assertSame((Object)localCookieSpecRegistry, (Object)context.getCookieSpecRegistry());
        Assert.assertSame((Object)localAuthSchemeRegistry, (Object)context.getAuthSchemeRegistry());
        Assert.assertSame((Object)localCookieStore, (Object)context.getCookieStore());
        Assert.assertSame((Object)localCredentialsProvider, (Object)context.getCredentialsProvider());
        Assert.assertSame((Object)localConfig, (Object)context.getRequestConfig());
    }

    @Test
    public void testClientClose() throws Exception {
        this.client.close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).shutdown();
        ((Closeable)Mockito.verify((Object)this.closeable1)).close();
        ((Closeable)Mockito.verify((Object)this.closeable2)).close();
    }

    @Test
    public void testClientCloseIOException() throws Exception {
        ((Closeable)Mockito.doThrow((Throwable)new IOException()).when((Object)this.closeable1)).close();
        this.client.close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).shutdown();
        ((Closeable)Mockito.verify((Object)this.closeable1)).close();
        ((Closeable)Mockito.verify((Object)this.closeable2)).close();
    }
}

