// $ANTLR 3.4 org/apache/hadoop/hive/ql/parse/HiveParser.g 2014-06-02 12:29:26

package org.apache.hadoop.hive.ql.parse;

import java.util.Collection;
import java.util.HashMap;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/**
   Licensed to the Apache Software Foundation (ASF) under one or more 
   contributor license agreements.  See the NOTICE file distributed with 
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with 
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
@SuppressWarnings({"all", "warnings", "unchecked"})
public class HiveParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "AMPERSAND", "BITWISEOR", "BITWISEXOR", "BigintLiteral", "ByteLengthLiteral", "COLON", "COMMA", "COMMENT", "CharSetLiteral", "CharSetName", "DIV", "DIVIDE", "DOLLAR", "DOT", "DecimalLiteral", "Digit", "EQUAL", "EQUAL_NS", "Exponent", "GREATERTHAN", "GREATERTHANOREQUALTO", "HexDigit", "Identifier", "KW_ADD", "KW_ADMIN", "KW_AFTER", "KW_ALL", "KW_ALTER", "KW_ANALYZE", "KW_AND", "KW_ARCHIVE", "KW_ARRAY", "KW_AS", "KW_ASC", "KW_BEFORE", "KW_BETWEEN", "KW_BIGINT", "KW_BINARY", "KW_BOOLEAN", "KW_BOTH", "KW_BUCKET", "KW_BUCKETS", "KW_BY", "KW_CASCADE", "KW_CASE", "KW_CAST", "KW_CHANGE", "KW_CHAR", "KW_CLUSTER", "KW_CLUSTERED", "KW_CLUSTERSTATUS", "KW_COLLECTION", "KW_COLUMN", "KW_COLUMNS", "KW_COMMENT", "KW_COMPACT", "KW_COMPACTIONS", "KW_COMPUTE", "KW_CONCATENATE", "KW_CONTINUE", "KW_CREATE", "KW_CROSS", "KW_CUBE", "KW_CURRENT", "KW_CURSOR", "KW_DATA", "KW_DATABASE", "KW_DATABASES", "KW_DATE", "KW_DATETIME", "KW_DBPROPERTIES", "KW_DECIMAL", "KW_DEFAULT", "KW_DEFERRED", "KW_DEFINED", "KW_DELETE", "KW_DELIMITED", "KW_DEPENDENCY", "KW_DESC", "KW_DESCRIBE", "KW_DIRECTORIES", "KW_DIRECTORY", "KW_DISABLE", "KW_DISTINCT", "KW_DISTRIBUTE", "KW_DOUBLE", "KW_DROP", "KW_ELEM_TYPE", "KW_ELSE", "KW_ENABLE", "KW_END", "KW_ESCAPED", "KW_EXCHANGE", "KW_EXCLUSIVE", "KW_EXISTS", "KW_EXPLAIN", "KW_EXPORT", "KW_EXTENDED", "KW_EXTERNAL", "KW_FALSE", "KW_FETCH", "KW_FIELDS", "KW_FILE", "KW_FILEFORMAT", "KW_FIRST", "KW_FLOAT", "KW_FOLLOWING", "KW_FOR", "KW_FORMAT", "KW_FORMATTED", "KW_FROM", "KW_FULL", "KW_FUNCTION", "KW_FUNCTIONS", "KW_GRANT", "KW_GROUP", "KW_GROUPING", "KW_HAVING", "KW_HOLD_DDLTIME", "KW_IDXPROPERTIES", "KW_IF", "KW_IGNORE", "KW_IMPORT", "KW_IN", "KW_INDEX", "KW_INDEXES", "KW_INNER", "KW_INPATH", "KW_INPUTDRIVER", "KW_INPUTFORMAT", "KW_INSERT", "KW_INT", "KW_INTERSECT", "KW_INTO", "KW_IS", "KW_ITEMS", "KW_JAR", "KW_JOIN", "KW_KEYS", "KW_KEY_TYPE", "KW_LATERAL", "KW_LEFT", "KW_LESS", "KW_LIKE", "KW_LIMIT", "KW_LINES", "KW_LOAD", "KW_LOCAL", "KW_LOCATION", "KW_LOCK", "KW_LOCKS", "KW_LOGICAL", "KW_LONG", "KW_MACRO", "KW_MAP", "KW_MAPJOIN", "KW_MATERIALIZED", "KW_MINUS", "KW_MORE", "KW_MSCK", "KW_NONE", "KW_NOSCAN", "KW_NOT", "KW_NO_DROP", "KW_NULL", "KW_OF", "KW_OFFLINE", "KW_ON", "KW_OPTION", "KW_OR", "KW_ORCFILE", "KW_ORDER", "KW_OUT", "KW_OUTER", "KW_OUTPUTDRIVER", "KW_OUTPUTFORMAT", "KW_OVER", "KW_OVERWRITE", "KW_OWNER", "KW_PARQUETFILE", "KW_PARTIALSCAN", "KW_PARTITION", "KW_PARTITIONED", "KW_PARTITIONS", "KW_PERCENT", "KW_PLUS", "KW_PRECEDING", "KW_PRESERVE", "KW_PRETTY", "KW_PRINCIPALS", "KW_PROCEDURE", "KW_PROTECTION", "KW_PURGE", "KW_RANGE", "KW_RCFILE", "KW_READ", "KW_READONLY", "KW_READS", "KW_REBUILD", "KW_RECORDREADER", "KW_RECORDWRITER", "KW_REDUCE", "KW_REGEXP", "KW_RENAME", "KW_REPAIR", "KW_REPLACE", "KW_RESTRICT", "KW_REVOKE", "KW_RIGHT", "KW_RLIKE", "KW_ROLE", "KW_ROLES", "KW_ROLLUP", "KW_ROW", "KW_ROWS", "KW_SCHEMA", "KW_SCHEMAS", "KW_SELECT", "KW_SEMI", "KW_SEQUENCEFILE", "KW_SERDE", "KW_SERDEPROPERTIES", "KW_SET", "KW_SETS", "KW_SHARED", "KW_SHOW", "KW_SHOW_DATABASE", "KW_SKEWED", "KW_SMALLINT", "KW_SORT", "KW_SORTED", "KW_SSL", "KW_STATISTICS", "KW_STORED", "KW_STREAMTABLE", "KW_STRING", "KW_STRUCT", "KW_TABLE", "KW_TABLES", "KW_TABLESAMPLE", "KW_TBLPROPERTIES", "KW_TEMPORARY", "KW_TERMINATED", "KW_TEXTFILE", "KW_THEN", "KW_TIMESTAMP", "KW_TINYINT", "KW_TO", "KW_TOUCH", "KW_TRANSACTIONS", "KW_TRANSFORM", "KW_TRIGGER", "KW_TRUE", "KW_TRUNCATE", "KW_UNARCHIVE", "KW_UNBOUNDED", "KW_UNDO", "KW_UNION", "KW_UNIONTYPE", "KW_UNIQUEJOIN", "KW_UNLOCK", "KW_UNSET", "KW_UNSIGNED", "KW_UPDATE", "KW_USE", "KW_USER", "KW_USING", "KW_UTC", "KW_UTCTIMESTAMP", "KW_VALUE_TYPE", "KW_VARCHAR", "KW_VIEW", "KW_WHEN", "KW_WHERE", "KW_WHILE", "KW_WINDOW", "KW_WITH", "LCURLY", "LESSTHAN", "LESSTHANOREQUALTO", "LPAREN", "LSQUARE", "Letter", "MINUS", "MOD", "NOTEQUAL", "Number", "PLUS", "QUESTION", "QuotedIdentifier", "RCURLY", "RPAREN", "RSQUARE", "RegexComponent", "SEMICOLON", "STAR", "SmallintLiteral", "StringLiteral", "TILDE", "TinyintLiteral", "WS", "TOK_ALIASLIST", "TOK_ALLCOLREF", "TOK_ALTERDATABASE_OWNER", "TOK_ALTERDATABASE_PROPERTIES", "TOK_ALTERINDEX_PROPERTIES", "TOK_ALTERINDEX_REBUILD", "TOK_ALTERTABLE_ADDCOLS", "TOK_ALTERTABLE_ADDPARTS", "TOK_ALTERTABLE_ARCHIVE", "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION", "TOK_ALTERTABLE_CLUSTER_SORT", "TOK_ALTERTABLE_DROPPARTS", "TOK_ALTERTABLE_FILEFORMAT", "TOK_ALTERTABLE_LOCATION", "TOK_ALTERTABLE_MERGEFILES", "TOK_ALTERTABLE_PARTCOLTYPE", "TOK_ALTERTABLE_PARTITION", "TOK_ALTERTABLE_PROPERTIES", "TOK_ALTERTABLE_PROTECTMODE", "TOK_ALTERTABLE_RENAME", "TOK_ALTERTABLE_RENAMECOL", "TOK_ALTERTABLE_RENAMEPART", "TOK_ALTERTABLE_REPLACECOLS", "TOK_ALTERTABLE_SERDEPROPERTIES", "TOK_ALTERTABLE_SERIALIZER", "TOK_ALTERTABLE_SKEWED", "TOK_ALTERTABLE_TOUCH", "TOK_ALTERTABLE_UNARCHIVE", "TOK_ALTERTBLPART_SKEWED_LOCATION", "TOK_ALTERVIEW_ADDPARTS", "TOK_ALTERVIEW_AS", "TOK_ALTERVIEW_DROPPARTS", "TOK_ALTERVIEW_PROPERTIES", "TOK_ALTERVIEW_RENAME", "TOK_ANALYZE", "TOK_ARCHIVE", "TOK_BIGINT", "TOK_BINARY", "TOK_BOOLEAN", "TOK_CASCADE", "TOK_CHAR", "TOK_CHARSETLITERAL", "TOK_CLUSTERBY", "TOK_COLTYPELIST", "TOK_COMPACT", "TOK_CREATEDATABASE", "TOK_CREATEFUNCTION", "TOK_CREATEINDEX", "TOK_CREATEINDEX_INDEXTBLNAME", "TOK_CREATEMACRO", "TOK_CREATEROLE", "TOK_CREATETABLE", "TOK_CREATEVIEW", "TOK_CROSSJOIN", "TOK_CTE", "TOK_CUBE_GROUPBY", "TOK_DATABASECOMMENT", "TOK_DATABASELOCATION", "TOK_DATABASEPROPERTIES", "TOK_DATE", "TOK_DATELITERAL", "TOK_DATETIME", "TOK_DBPROPLIST", "TOK_DB_TYPE", "TOK_DECIMAL", "TOK_DEFERRED_REBUILDINDEX", "TOK_DESCDATABASE", "TOK_DESCFUNCTION", "TOK_DESCTABLE", "TOK_DESTINATION", "TOK_DIR", "TOK_DISABLE", "TOK_DISTRIBUTEBY", "TOK_DOUBLE", "TOK_DROPDATABASE", "TOK_DROPFUNCTION", "TOK_DROPINDEX", "TOK_DROPMACRO", "TOK_DROPROLE", "TOK_DROPTABLE", "TOK_DROPTABLE_PROPERTIES", "TOK_DROPVIEW", "TOK_DROPVIEW_PROPERTIES", "TOK_ENABLE", "TOK_EXCHANGEPARTITION", "TOK_EXPLAIN", "TOK_EXPLIST", "TOK_EXPORT", "TOK_FALSE", "TOK_FILE", "TOK_FILEFORMAT_GENERIC", "TOK_FLOAT", "TOK_FROM", "TOK_FULLOUTERJOIN", "TOK_FUNCTION", "TOK_FUNCTIONDI", "TOK_FUNCTIONSTAR", "TOK_GRANT", "TOK_GRANT_ROLE", "TOK_GRANT_WITH_ADMIN_OPTION", "TOK_GRANT_WITH_OPTION", "TOK_GROUP", "TOK_GROUPBY", "TOK_GROUPING_SETS", "TOK_GROUPING_SETS_EXPRESSION", "TOK_HAVING", "TOK_HINT", "TOK_HINTARGLIST", "TOK_HINTLIST", "TOK_HOLD_DDLTIME", "TOK_IFEXISTS", "TOK_IFNOTEXISTS", "TOK_IGNOREPROTECTION", "TOK_IMPORT", "TOK_INDEXCOMMENT", "TOK_INDEXPROPERTIES", "TOK_INDEXPROPLIST", "TOK_INSERT", "TOK_INSERT_INTO", "TOK_INT", "TOK_ISNOTNULL", "TOK_ISNULL", "TOK_JAR", "TOK_JOIN", "TOK_LATERAL_VIEW", "TOK_LATERAL_VIEW_OUTER", "TOK_LEFTOUTERJOIN", "TOK_LEFTSEMIJOIN", "TOK_LENGTH", "TOK_LIKETABLE", "TOK_LIMIT", "TOK_LIST", "TOK_LOAD", "TOK_LOCAL_DIR", "TOK_LOCKDB", "TOK_LOCKTABLE", "TOK_MAP", "TOK_MAPJOIN", "TOK_MSCK", "TOK_NOT_CLUSTERED", "TOK_NOT_SORTED", "TOK_NO_DROP", "TOK_NULL", "TOK_OFFLINE", "TOK_OP_ADD", "TOK_OP_AND", "TOK_OP_BITAND", "TOK_OP_BITNOT", "TOK_OP_BITOR", "TOK_OP_BITXOR", "TOK_OP_DIV", "TOK_OP_EQ", "TOK_OP_GE", "TOK_OP_GT", "TOK_OP_LE", "TOK_OP_LIKE", "TOK_OP_LT", "TOK_OP_MOD", "TOK_OP_MUL", "TOK_OP_NE", "TOK_OP_NOT", "TOK_OP_OR", "TOK_OP_SUB", "TOK_ORDERBY", "TOK_ORREPLACE", "TOK_PARTITIONINGSPEC", "TOK_PARTITIONLOCATION", "TOK_PARTSPEC", "TOK_PARTVAL", "TOK_PERCENT", "TOK_PRINCIPAL_NAME", "TOK_PRIVILEGE", "TOK_PRIVILEGE_LIST", "TOK_PRIV_ALL", "TOK_PRIV_ALTER_DATA", "TOK_PRIV_ALTER_METADATA", "TOK_PRIV_CREATE", "TOK_PRIV_DELETE", "TOK_PRIV_DROP", "TOK_PRIV_INDEX", "TOK_PRIV_INSERT", "TOK_PRIV_LOCK", "TOK_PRIV_OBJECT", "TOK_PRIV_OBJECT_COL", "TOK_PRIV_SELECT", "TOK_PRIV_SHOW_DATABASE", "TOK_PTBLFUNCTION", "TOK_QUERY", "TOK_READONLY", "TOK_RECORDREADER", "TOK_RECORDWRITER", "TOK_RESOURCE_ALL", "TOK_RESOURCE_LIST", "TOK_RESOURCE_URI", "TOK_RESTRICT", "TOK_REVOKE", "TOK_REVOKE_ROLE", "TOK_RIGHTOUTERJOIN", "TOK_ROLE", "TOK_ROLLUP_GROUPBY", "TOK_ROWCOUNT", "TOK_SELECT", "TOK_SELECTDI", "TOK_SELEXPR", "TOK_SERDE", "TOK_SERDENAME", "TOK_SERDEPROPS", "TOK_SHOWCOLUMNS", "TOK_SHOWDATABASES", "TOK_SHOWDBLOCKS", "TOK_SHOWFUNCTIONS", "TOK_SHOWINDEXES", "TOK_SHOWLOCKS", "TOK_SHOWPARTITIONS", "TOK_SHOWTABLES", "TOK_SHOW_COMPACTIONS", "TOK_SHOW_CREATETABLE", "TOK_SHOW_GRANT", "TOK_SHOW_ROLES", "TOK_SHOW_ROLE_GRANT", "TOK_SHOW_ROLE_PRINCIPALS", "TOK_SHOW_SET_ROLE", "TOK_SHOW_TABLESTATUS", "TOK_SHOW_TBLPROPERTIES", "TOK_SHOW_TRANSACTIONS", "TOK_SKEWED_LOCATIONS", "TOK_SKEWED_LOCATION_LIST", "TOK_SKEWED_LOCATION_MAP", "TOK_SMALLINT", "TOK_SORTBY", "TOK_STORAGEHANDLER", "TOK_STOREDASDIRS", "TOK_STREAMTABLE", "TOK_STRING", "TOK_STRINGLITERALSEQUENCE", "TOK_STRUCT", "TOK_SUBQUERY", "TOK_SUBQUERY_EXPR", "TOK_SUBQUERY_OP", "TOK_SUBQUERY_OP_NOTEXISTS", "TOK_SUBQUERY_OP_NOTIN", "TOK_SWITCHDATABASE", "TOK_TAB", "TOK_TABALIAS", "TOK_TABCOL", "TOK_TABCOLLIST", "TOK_TABCOLNAME", "TOK_TABCOLVALUE", "TOK_TABCOLVALUES", "TOK_TABCOLVALUE_PAIR", "TOK_TABLEBUCKETS", "TOK_TABLEBUCKETSAMPLE", "TOK_TABLECOMMENT", "TOK_TABLEFILEFORMAT", "TOK_TABLELOCATION", "TOK_TABLEPARTCOLS", "TOK_TABLEPROPERTIES", "TOK_TABLEPROPERTY", "TOK_TABLEPROPLIST", "TOK_TABLEROWFORMAT", "TOK_TABLEROWFORMATCOLLITEMS", "TOK_TABLEROWFORMATFIELD", "TOK_TABLEROWFORMATLINES", "TOK_TABLEROWFORMATMAPKEYS", "TOK_TABLEROWFORMATNULL", "TOK_TABLESERIALIZER", "TOK_TABLESKEWED", "TOK_TABLESPLITSAMPLE", "TOK_TABLE_OR_COL", "TOK_TABLE_PARTITION", "TOK_TABLE_TYPE", "TOK_TABNAME", "TOK_TABREF", "TOK_TABSORTCOLNAMEASC", "TOK_TABSORTCOLNAMEDESC", "TOK_TABSRC", "TOK_TABTYPE", "TOK_TBLORCFILE", "TOK_TBLPARQUETFILE", "TOK_TBLRCFILE", "TOK_TBLSEQUENCEFILE", "TOK_TBLTEXTFILE", "TOK_TEMPORARY", "TOK_TIMESTAMP", "TOK_TINYINT", "TOK_TMP_FILE", "TOK_TRANSFORM", "TOK_TRUE", "TOK_TRUNCATETABLE", "TOK_UNION", "TOK_UNIONTYPE", "TOK_UNIQUEJOIN", "TOK_UNLOCKDB", "TOK_UNLOCKTABLE", "TOK_USER", "TOK_USERSCRIPTCOLNAMES", "TOK_USERSCRIPTCOLSCHEMA", "TOK_VARCHAR", "TOK_VIEWPARTCOLS", "TOK_WHERE", "TOK_WINDOWDEF", "TOK_WINDOWRANGE", "TOK_WINDOWSPEC", "TOK_WINDOWVALUES", "884"
    };

    public static final int EOF=-1;
    public static final int AMPERSAND=4;
    public static final int BITWISEOR=5;
    public static final int BITWISEXOR=6;
    public static final int BigintLiteral=7;
    public static final int ByteLengthLiteral=8;
    public static final int COLON=9;
    public static final int COMMA=10;
    public static final int COMMENT=11;
    public static final int CharSetLiteral=12;
    public static final int CharSetName=13;
    public static final int DIV=14;
    public static final int DIVIDE=15;
    public static final int DOLLAR=16;
    public static final int DOT=17;
    public static final int DecimalLiteral=18;
    public static final int Digit=19;
    public static final int EQUAL=20;
    public static final int EQUAL_NS=21;
    public static final int Exponent=22;
    public static final int GREATERTHAN=23;
    public static final int GREATERTHANOREQUALTO=24;
    public static final int HexDigit=25;
    public static final int Identifier=26;
    public static final int KW_ADD=27;
    public static final int KW_ADMIN=28;
    public static final int KW_AFTER=29;
    public static final int KW_ALL=30;
    public static final int KW_ALTER=31;
    public static final int KW_ANALYZE=32;
    public static final int KW_AND=33;
    public static final int KW_ARCHIVE=34;
    public static final int KW_ARRAY=35;
    public static final int KW_AS=36;
    public static final int KW_ASC=37;
    public static final int KW_BEFORE=38;
    public static final int KW_BETWEEN=39;
    public static final int KW_BIGINT=40;
    public static final int KW_BINARY=41;
    public static final int KW_BOOLEAN=42;
    public static final int KW_BOTH=43;
    public static final int KW_BUCKET=44;
    public static final int KW_BUCKETS=45;
    public static final int KW_BY=46;
    public static final int KW_CASCADE=47;
    public static final int KW_CASE=48;
    public static final int KW_CAST=49;
    public static final int KW_CHANGE=50;
    public static final int KW_CHAR=51;
    public static final int KW_CLUSTER=52;
    public static final int KW_CLUSTERED=53;
    public static final int KW_CLUSTERSTATUS=54;
    public static final int KW_COLLECTION=55;
    public static final int KW_COLUMN=56;
    public static final int KW_COLUMNS=57;
    public static final int KW_COMMENT=58;
    public static final int KW_COMPACT=59;
    public static final int KW_COMPACTIONS=60;
    public static final int KW_COMPUTE=61;
    public static final int KW_CONCATENATE=62;
    public static final int KW_CONTINUE=63;
    public static final int KW_CREATE=64;
    public static final int KW_CROSS=65;
    public static final int KW_CUBE=66;
    public static final int KW_CURRENT=67;
    public static final int KW_CURSOR=68;
    public static final int KW_DATA=69;
    public static final int KW_DATABASE=70;
    public static final int KW_DATABASES=71;
    public static final int KW_DATE=72;
    public static final int KW_DATETIME=73;
    public static final int KW_DBPROPERTIES=74;
    public static final int KW_DECIMAL=75;
    public static final int KW_DEFAULT=76;
    public static final int KW_DEFERRED=77;
    public static final int KW_DEFINED=78;
    public static final int KW_DELETE=79;
    public static final int KW_DELIMITED=80;
    public static final int KW_DEPENDENCY=81;
    public static final int KW_DESC=82;
    public static final int KW_DESCRIBE=83;
    public static final int KW_DIRECTORIES=84;
    public static final int KW_DIRECTORY=85;
    public static final int KW_DISABLE=86;
    public static final int KW_DISTINCT=87;
    public static final int KW_DISTRIBUTE=88;
    public static final int KW_DOUBLE=89;
    public static final int KW_DROP=90;
    public static final int KW_ELEM_TYPE=91;
    public static final int KW_ELSE=92;
    public static final int KW_ENABLE=93;
    public static final int KW_END=94;
    public static final int KW_ESCAPED=95;
    public static final int KW_EXCHANGE=96;
    public static final int KW_EXCLUSIVE=97;
    public static final int KW_EXISTS=98;
    public static final int KW_EXPLAIN=99;
    public static final int KW_EXPORT=100;
    public static final int KW_EXTENDED=101;
    public static final int KW_EXTERNAL=102;
    public static final int KW_FALSE=103;
    public static final int KW_FETCH=104;
    public static final int KW_FIELDS=105;
    public static final int KW_FILE=106;
    public static final int KW_FILEFORMAT=107;
    public static final int KW_FIRST=108;
    public static final int KW_FLOAT=109;
    public static final int KW_FOLLOWING=110;
    public static final int KW_FOR=111;
    public static final int KW_FORMAT=112;
    public static final int KW_FORMATTED=113;
    public static final int KW_FROM=114;
    public static final int KW_FULL=115;
    public static final int KW_FUNCTION=116;
    public static final int KW_FUNCTIONS=117;
    public static final int KW_GRANT=118;
    public static final int KW_GROUP=119;
    public static final int KW_GROUPING=120;
    public static final int KW_HAVING=121;
    public static final int KW_HOLD_DDLTIME=122;
    public static final int KW_IDXPROPERTIES=123;
    public static final int KW_IF=124;
    public static final int KW_IGNORE=125;
    public static final int KW_IMPORT=126;
    public static final int KW_IN=127;
    public static final int KW_INDEX=128;
    public static final int KW_INDEXES=129;
    public static final int KW_INNER=130;
    public static final int KW_INPATH=131;
    public static final int KW_INPUTDRIVER=132;
    public static final int KW_INPUTFORMAT=133;
    public static final int KW_INSERT=134;
    public static final int KW_INT=135;
    public static final int KW_INTERSECT=136;
    public static final int KW_INTO=137;
    public static final int KW_IS=138;
    public static final int KW_ITEMS=139;
    public static final int KW_JAR=140;
    public static final int KW_JOIN=141;
    public static final int KW_KEYS=142;
    public static final int KW_KEY_TYPE=143;
    public static final int KW_LATERAL=144;
    public static final int KW_LEFT=145;
    public static final int KW_LESS=146;
    public static final int KW_LIKE=147;
    public static final int KW_LIMIT=148;
    public static final int KW_LINES=149;
    public static final int KW_LOAD=150;
    public static final int KW_LOCAL=151;
    public static final int KW_LOCATION=152;
    public static final int KW_LOCK=153;
    public static final int KW_LOCKS=154;
    public static final int KW_LOGICAL=155;
    public static final int KW_LONG=156;
    public static final int KW_MACRO=157;
    public static final int KW_MAP=158;
    public static final int KW_MAPJOIN=159;
    public static final int KW_MATERIALIZED=160;
    public static final int KW_MINUS=161;
    public static final int KW_MORE=162;
    public static final int KW_MSCK=163;
    public static final int KW_NONE=164;
    public static final int KW_NOSCAN=165;
    public static final int KW_NOT=166;
    public static final int KW_NO_DROP=167;
    public static final int KW_NULL=168;
    public static final int KW_OF=169;
    public static final int KW_OFFLINE=170;
    public static final int KW_ON=171;
    public static final int KW_OPTION=172;
    public static final int KW_OR=173;
    public static final int KW_ORCFILE=174;
    public static final int KW_ORDER=175;
    public static final int KW_OUT=176;
    public static final int KW_OUTER=177;
    public static final int KW_OUTPUTDRIVER=178;
    public static final int KW_OUTPUTFORMAT=179;
    public static final int KW_OVER=180;
    public static final int KW_OVERWRITE=181;
    public static final int KW_OWNER=182;
    public static final int KW_PARQUETFILE=183;
    public static final int KW_PARTIALSCAN=184;
    public static final int KW_PARTITION=185;
    public static final int KW_PARTITIONED=186;
    public static final int KW_PARTITIONS=187;
    public static final int KW_PERCENT=188;
    public static final int KW_PLUS=189;
    public static final int KW_PRECEDING=190;
    public static final int KW_PRESERVE=191;
    public static final int KW_PRETTY=192;
    public static final int KW_PRINCIPALS=193;
    public static final int KW_PROCEDURE=194;
    public static final int KW_PROTECTION=195;
    public static final int KW_PURGE=196;
    public static final int KW_RANGE=197;
    public static final int KW_RCFILE=198;
    public static final int KW_READ=199;
    public static final int KW_READONLY=200;
    public static final int KW_READS=201;
    public static final int KW_REBUILD=202;
    public static final int KW_RECORDREADER=203;
    public static final int KW_RECORDWRITER=204;
    public static final int KW_REDUCE=205;
    public static final int KW_REGEXP=206;
    public static final int KW_RENAME=207;
    public static final int KW_REPAIR=208;
    public static final int KW_REPLACE=209;
    public static final int KW_RESTRICT=210;
    public static final int KW_REVOKE=211;
    public static final int KW_RIGHT=212;
    public static final int KW_RLIKE=213;
    public static final int KW_ROLE=214;
    public static final int KW_ROLES=215;
    public static final int KW_ROLLUP=216;
    public static final int KW_ROW=217;
    public static final int KW_ROWS=218;
    public static final int KW_SCHEMA=219;
    public static final int KW_SCHEMAS=220;
    public static final int KW_SELECT=221;
    public static final int KW_SEMI=222;
    public static final int KW_SEQUENCEFILE=223;
    public static final int KW_SERDE=224;
    public static final int KW_SERDEPROPERTIES=225;
    public static final int KW_SET=226;
    public static final int KW_SETS=227;
    public static final int KW_SHARED=228;
    public static final int KW_SHOW=229;
    public static final int KW_SHOW_DATABASE=230;
    public static final int KW_SKEWED=231;
    public static final int KW_SMALLINT=232;
    public static final int KW_SORT=233;
    public static final int KW_SORTED=234;
    public static final int KW_SSL=235;
    public static final int KW_STATISTICS=236;
    public static final int KW_STORED=237;
    public static final int KW_STREAMTABLE=238;
    public static final int KW_STRING=239;
    public static final int KW_STRUCT=240;
    public static final int KW_TABLE=241;
    public static final int KW_TABLES=242;
    public static final int KW_TABLESAMPLE=243;
    public static final int KW_TBLPROPERTIES=244;
    public static final int KW_TEMPORARY=245;
    public static final int KW_TERMINATED=246;
    public static final int KW_TEXTFILE=247;
    public static final int KW_THEN=248;
    public static final int KW_TIMESTAMP=249;
    public static final int KW_TINYINT=250;
    public static final int KW_TO=251;
    public static final int KW_TOUCH=252;
    public static final int KW_TRANSACTIONS=253;
    public static final int KW_TRANSFORM=254;
    public static final int KW_TRIGGER=255;
    public static final int KW_TRUE=256;
    public static final int KW_TRUNCATE=257;
    public static final int KW_UNARCHIVE=258;
    public static final int KW_UNBOUNDED=259;
    public static final int KW_UNDO=260;
    public static final int KW_UNION=261;
    public static final int KW_UNIONTYPE=262;
    public static final int KW_UNIQUEJOIN=263;
    public static final int KW_UNLOCK=264;
    public static final int KW_UNSET=265;
    public static final int KW_UNSIGNED=266;
    public static final int KW_UPDATE=267;
    public static final int KW_USE=268;
    public static final int KW_USER=269;
    public static final int KW_USING=270;
    public static final int KW_UTC=271;
    public static final int KW_UTCTIMESTAMP=272;
    public static final int KW_VALUE_TYPE=273;
    public static final int KW_VARCHAR=274;
    public static final int KW_VIEW=275;
    public static final int KW_WHEN=276;
    public static final int KW_WHERE=277;
    public static final int KW_WHILE=278;
    public static final int KW_WINDOW=279;
    public static final int KW_WITH=280;
    public static final int LCURLY=281;
    public static final int LESSTHAN=282;
    public static final int LESSTHANOREQUALTO=283;
    public static final int LPAREN=284;
    public static final int LSQUARE=285;
    public static final int Letter=286;
    public static final int MINUS=287;
    public static final int MOD=288;
    public static final int NOTEQUAL=289;
    public static final int Number=290;
    public static final int PLUS=291;
    public static final int QUESTION=292;
    public static final int QuotedIdentifier=293;
    public static final int RCURLY=294;
    public static final int RPAREN=295;
    public static final int RSQUARE=296;
    public static final int RegexComponent=297;
    public static final int SEMICOLON=298;
    public static final int STAR=299;
    public static final int SmallintLiteral=300;
    public static final int StringLiteral=301;
    public static final int TILDE=302;
    public static final int TinyintLiteral=303;
    public static final int WS=304;
    public static final int TOK_ALIASLIST=580;
    public static final int TOK_ALLCOLREF=581;
    public static final int TOK_ALTERDATABASE_OWNER=582;
    public static final int TOK_ALTERDATABASE_PROPERTIES=583;
    public static final int TOK_ALTERINDEX_PROPERTIES=584;
    public static final int TOK_ALTERINDEX_REBUILD=585;
    public static final int TOK_ALTERTABLE_ADDCOLS=586;
    public static final int TOK_ALTERTABLE_ADDPARTS=587;
    public static final int TOK_ALTERTABLE_ARCHIVE=588;
    public static final int TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION=589;
    public static final int TOK_ALTERTABLE_CLUSTER_SORT=590;
    public static final int TOK_ALTERTABLE_DROPPARTS=591;
    public static final int TOK_ALTERTABLE_FILEFORMAT=592;
    public static final int TOK_ALTERTABLE_LOCATION=593;
    public static final int TOK_ALTERTABLE_MERGEFILES=594;
    public static final int TOK_ALTERTABLE_PARTCOLTYPE=595;
    public static final int TOK_ALTERTABLE_PARTITION=596;
    public static final int TOK_ALTERTABLE_PROPERTIES=597;
    public static final int TOK_ALTERTABLE_PROTECTMODE=598;
    public static final int TOK_ALTERTABLE_RENAME=599;
    public static final int TOK_ALTERTABLE_RENAMECOL=600;
    public static final int TOK_ALTERTABLE_RENAMEPART=601;
    public static final int TOK_ALTERTABLE_REPLACECOLS=602;
    public static final int TOK_ALTERTABLE_SERDEPROPERTIES=603;
    public static final int TOK_ALTERTABLE_SERIALIZER=604;
    public static final int TOK_ALTERTABLE_SKEWED=605;
    public static final int TOK_ALTERTABLE_TOUCH=606;
    public static final int TOK_ALTERTABLE_UNARCHIVE=607;
    public static final int TOK_ALTERTBLPART_SKEWED_LOCATION=608;
    public static final int TOK_ALTERVIEW_ADDPARTS=609;
    public static final int TOK_ALTERVIEW_AS=610;
    public static final int TOK_ALTERVIEW_DROPPARTS=611;
    public static final int TOK_ALTERVIEW_PROPERTIES=612;
    public static final int TOK_ALTERVIEW_RENAME=613;
    public static final int TOK_ANALYZE=614;
    public static final int TOK_ARCHIVE=615;
    public static final int TOK_BIGINT=616;
    public static final int TOK_BINARY=617;
    public static final int TOK_BOOLEAN=618;
    public static final int TOK_CASCADE=619;
    public static final int TOK_CHAR=620;
    public static final int TOK_CHARSETLITERAL=621;
    public static final int TOK_CLUSTERBY=622;
    public static final int TOK_COLTYPELIST=623;
    public static final int TOK_COMPACT=624;
    public static final int TOK_CREATEDATABASE=625;
    public static final int TOK_CREATEFUNCTION=626;
    public static final int TOK_CREATEINDEX=627;
    public static final int TOK_CREATEINDEX_INDEXTBLNAME=628;
    public static final int TOK_CREATEMACRO=629;
    public static final int TOK_CREATEROLE=630;
    public static final int TOK_CREATETABLE=631;
    public static final int TOK_CREATEVIEW=632;
    public static final int TOK_CROSSJOIN=633;
    public static final int TOK_CTE=634;
    public static final int TOK_CUBE_GROUPBY=635;
    public static final int TOK_DATABASECOMMENT=636;
    public static final int TOK_DATABASELOCATION=637;
    public static final int TOK_DATABASEPROPERTIES=638;
    public static final int TOK_DATE=639;
    public static final int TOK_DATELITERAL=640;
    public static final int TOK_DATETIME=641;
    public static final int TOK_DBPROPLIST=642;
    public static final int TOK_DB_TYPE=643;
    public static final int TOK_DECIMAL=644;
    public static final int TOK_DEFERRED_REBUILDINDEX=645;
    public static final int TOK_DESCDATABASE=646;
    public static final int TOK_DESCFUNCTION=647;
    public static final int TOK_DESCTABLE=648;
    public static final int TOK_DESTINATION=649;
    public static final int TOK_DIR=650;
    public static final int TOK_DISABLE=651;
    public static final int TOK_DISTRIBUTEBY=652;
    public static final int TOK_DOUBLE=653;
    public static final int TOK_DROPDATABASE=654;
    public static final int TOK_DROPFUNCTION=655;
    public static final int TOK_DROPINDEX=656;
    public static final int TOK_DROPMACRO=657;
    public static final int TOK_DROPROLE=658;
    public static final int TOK_DROPTABLE=659;
    public static final int TOK_DROPTABLE_PROPERTIES=660;
    public static final int TOK_DROPVIEW=661;
    public static final int TOK_DROPVIEW_PROPERTIES=662;
    public static final int TOK_ENABLE=663;
    public static final int TOK_EXCHANGEPARTITION=664;
    public static final int TOK_EXPLAIN=665;
    public static final int TOK_EXPLIST=666;
    public static final int TOK_EXPORT=667;
    public static final int TOK_FALSE=668;
    public static final int TOK_FILE=669;
    public static final int TOK_FILEFORMAT_GENERIC=670;
    public static final int TOK_FLOAT=671;
    public static final int TOK_FROM=672;
    public static final int TOK_FULLOUTERJOIN=673;
    public static final int TOK_FUNCTION=674;
    public static final int TOK_FUNCTIONDI=675;
    public static final int TOK_FUNCTIONSTAR=676;
    public static final int TOK_GRANT=677;
    public static final int TOK_GRANT_ROLE=678;
    public static final int TOK_GRANT_WITH_ADMIN_OPTION=679;
    public static final int TOK_GRANT_WITH_OPTION=680;
    public static final int TOK_GROUP=681;
    public static final int TOK_GROUPBY=682;
    public static final int TOK_GROUPING_SETS=683;
    public static final int TOK_GROUPING_SETS_EXPRESSION=684;
    public static final int TOK_HAVING=685;
    public static final int TOK_HINT=686;
    public static final int TOK_HINTARGLIST=687;
    public static final int TOK_HINTLIST=688;
    public static final int TOK_HOLD_DDLTIME=689;
    public static final int TOK_IFEXISTS=690;
    public static final int TOK_IFNOTEXISTS=691;
    public static final int TOK_IGNOREPROTECTION=692;
    public static final int TOK_IMPORT=693;
    public static final int TOK_INDEXCOMMENT=694;
    public static final int TOK_INDEXPROPERTIES=695;
    public static final int TOK_INDEXPROPLIST=696;
    public static final int TOK_INSERT=697;
    public static final int TOK_INSERT_INTO=698;
    public static final int TOK_INT=699;
    public static final int TOK_ISNOTNULL=700;
    public static final int TOK_ISNULL=701;
    public static final int TOK_JAR=702;
    public static final int TOK_JOIN=703;
    public static final int TOK_LATERAL_VIEW=704;
    public static final int TOK_LATERAL_VIEW_OUTER=705;
    public static final int TOK_LEFTOUTERJOIN=706;
    public static final int TOK_LEFTSEMIJOIN=707;
    public static final int TOK_LENGTH=708;
    public static final int TOK_LIKETABLE=709;
    public static final int TOK_LIMIT=710;
    public static final int TOK_LIST=711;
    public static final int TOK_LOAD=712;
    public static final int TOK_LOCAL_DIR=713;
    public static final int TOK_LOCKDB=714;
    public static final int TOK_LOCKTABLE=715;
    public static final int TOK_MAP=716;
    public static final int TOK_MAPJOIN=717;
    public static final int TOK_MSCK=718;
    public static final int TOK_NOT_CLUSTERED=719;
    public static final int TOK_NOT_SORTED=720;
    public static final int TOK_NO_DROP=721;
    public static final int TOK_NULL=722;
    public static final int TOK_OFFLINE=723;
    public static final int TOK_OP_ADD=724;
    public static final int TOK_OP_AND=725;
    public static final int TOK_OP_BITAND=726;
    public static final int TOK_OP_BITNOT=727;
    public static final int TOK_OP_BITOR=728;
    public static final int TOK_OP_BITXOR=729;
    public static final int TOK_OP_DIV=730;
    public static final int TOK_OP_EQ=731;
    public static final int TOK_OP_GE=732;
    public static final int TOK_OP_GT=733;
    public static final int TOK_OP_LE=734;
    public static final int TOK_OP_LIKE=735;
    public static final int TOK_OP_LT=736;
    public static final int TOK_OP_MOD=737;
    public static final int TOK_OP_MUL=738;
    public static final int TOK_OP_NE=739;
    public static final int TOK_OP_NOT=740;
    public static final int TOK_OP_OR=741;
    public static final int TOK_OP_SUB=742;
    public static final int TOK_ORDERBY=743;
    public static final int TOK_ORREPLACE=744;
    public static final int TOK_PARTITIONINGSPEC=745;
    public static final int TOK_PARTITIONLOCATION=746;
    public static final int TOK_PARTSPEC=747;
    public static final int TOK_PARTVAL=748;
    public static final int TOK_PERCENT=749;
    public static final int TOK_PRINCIPAL_NAME=750;
    public static final int TOK_PRIVILEGE=751;
    public static final int TOK_PRIVILEGE_LIST=752;
    public static final int TOK_PRIV_ALL=753;
    public static final int TOK_PRIV_ALTER_DATA=754;
    public static final int TOK_PRIV_ALTER_METADATA=755;
    public static final int TOK_PRIV_CREATE=756;
    public static final int TOK_PRIV_DELETE=757;
    public static final int TOK_PRIV_DROP=758;
    public static final int TOK_PRIV_INDEX=759;
    public static final int TOK_PRIV_INSERT=760;
    public static final int TOK_PRIV_LOCK=761;
    public static final int TOK_PRIV_OBJECT=762;
    public static final int TOK_PRIV_OBJECT_COL=763;
    public static final int TOK_PRIV_SELECT=764;
    public static final int TOK_PRIV_SHOW_DATABASE=765;
    public static final int TOK_PTBLFUNCTION=766;
    public static final int TOK_QUERY=767;
    public static final int TOK_READONLY=768;
    public static final int TOK_RECORDREADER=769;
    public static final int TOK_RECORDWRITER=770;
    public static final int TOK_RESOURCE_ALL=771;
    public static final int TOK_RESOURCE_LIST=772;
    public static final int TOK_RESOURCE_URI=773;
    public static final int TOK_RESTRICT=774;
    public static final int TOK_REVOKE=775;
    public static final int TOK_REVOKE_ROLE=776;
    public static final int TOK_RIGHTOUTERJOIN=777;
    public static final int TOK_ROLE=778;
    public static final int TOK_ROLLUP_GROUPBY=779;
    public static final int TOK_ROWCOUNT=780;
    public static final int TOK_SELECT=781;
    public static final int TOK_SELECTDI=782;
    public static final int TOK_SELEXPR=783;
    public static final int TOK_SERDE=784;
    public static final int TOK_SERDENAME=785;
    public static final int TOK_SERDEPROPS=786;
    public static final int TOK_SHOWCOLUMNS=787;
    public static final int TOK_SHOWDATABASES=788;
    public static final int TOK_SHOWDBLOCKS=789;
    public static final int TOK_SHOWFUNCTIONS=790;
    public static final int TOK_SHOWINDEXES=791;
    public static final int TOK_SHOWLOCKS=792;
    public static final int TOK_SHOWPARTITIONS=793;
    public static final int TOK_SHOWTABLES=794;
    public static final int TOK_SHOW_COMPACTIONS=795;
    public static final int TOK_SHOW_CREATETABLE=796;
    public static final int TOK_SHOW_GRANT=797;
    public static final int TOK_SHOW_ROLES=798;
    public static final int TOK_SHOW_ROLE_GRANT=799;
    public static final int TOK_SHOW_ROLE_PRINCIPALS=800;
    public static final int TOK_SHOW_SET_ROLE=801;
    public static final int TOK_SHOW_TABLESTATUS=802;
    public static final int TOK_SHOW_TBLPROPERTIES=803;
    public static final int TOK_SHOW_TRANSACTIONS=804;
    public static final int TOK_SKEWED_LOCATIONS=805;
    public static final int TOK_SKEWED_LOCATION_LIST=806;
    public static final int TOK_SKEWED_LOCATION_MAP=807;
    public static final int TOK_SMALLINT=808;
    public static final int TOK_SORTBY=809;
    public static final int TOK_STORAGEHANDLER=810;
    public static final int TOK_STOREDASDIRS=811;
    public static final int TOK_STREAMTABLE=812;
    public static final int TOK_STRING=813;
    public static final int TOK_STRINGLITERALSEQUENCE=814;
    public static final int TOK_STRUCT=815;
    public static final int TOK_SUBQUERY=816;
    public static final int TOK_SUBQUERY_EXPR=817;
    public static final int TOK_SUBQUERY_OP=818;
    public static final int TOK_SUBQUERY_OP_NOTEXISTS=819;
    public static final int TOK_SUBQUERY_OP_NOTIN=820;
    public static final int TOK_SWITCHDATABASE=821;
    public static final int TOK_TAB=822;
    public static final int TOK_TABALIAS=823;
    public static final int TOK_TABCOL=824;
    public static final int TOK_TABCOLLIST=825;
    public static final int TOK_TABCOLNAME=826;
    public static final int TOK_TABCOLVALUE=827;
    public static final int TOK_TABCOLVALUES=828;
    public static final int TOK_TABCOLVALUE_PAIR=829;
    public static final int TOK_TABLEBUCKETS=830;
    public static final int TOK_TABLEBUCKETSAMPLE=831;
    public static final int TOK_TABLECOMMENT=832;
    public static final int TOK_TABLEFILEFORMAT=833;
    public static final int TOK_TABLELOCATION=834;
    public static final int TOK_TABLEPARTCOLS=835;
    public static final int TOK_TABLEPROPERTIES=836;
    public static final int TOK_TABLEPROPERTY=837;
    public static final int TOK_TABLEPROPLIST=838;
    public static final int TOK_TABLEROWFORMAT=839;
    public static final int TOK_TABLEROWFORMATCOLLITEMS=840;
    public static final int TOK_TABLEROWFORMATFIELD=841;
    public static final int TOK_TABLEROWFORMATLINES=842;
    public static final int TOK_TABLEROWFORMATMAPKEYS=843;
    public static final int TOK_TABLEROWFORMATNULL=844;
    public static final int TOK_TABLESERIALIZER=845;
    public static final int TOK_TABLESKEWED=846;
    public static final int TOK_TABLESPLITSAMPLE=847;
    public static final int TOK_TABLE_OR_COL=848;
    public static final int TOK_TABLE_PARTITION=849;
    public static final int TOK_TABLE_TYPE=850;
    public static final int TOK_TABNAME=851;
    public static final int TOK_TABREF=852;
    public static final int TOK_TABSORTCOLNAMEASC=853;
    public static final int TOK_TABSORTCOLNAMEDESC=854;
    public static final int TOK_TABSRC=855;
    public static final int TOK_TABTYPE=856;
    public static final int TOK_TBLORCFILE=857;
    public static final int TOK_TBLPARQUETFILE=858;
    public static final int TOK_TBLRCFILE=859;
    public static final int TOK_TBLSEQUENCEFILE=860;
    public static final int TOK_TBLTEXTFILE=861;
    public static final int TOK_TEMPORARY=862;
    public static final int TOK_TIMESTAMP=863;
    public static final int TOK_TINYINT=864;
    public static final int TOK_TMP_FILE=865;
    public static final int TOK_TRANSFORM=866;
    public static final int TOK_TRUE=867;
    public static final int TOK_TRUNCATETABLE=868;
    public static final int TOK_UNION=869;
    public static final int TOK_UNIONTYPE=870;
    public static final int TOK_UNIQUEJOIN=871;
    public static final int TOK_UNLOCKDB=872;
    public static final int TOK_UNLOCKTABLE=873;
    public static final int TOK_USER=874;
    public static final int TOK_USERSCRIPTCOLNAMES=875;
    public static final int TOK_USERSCRIPTCOLSCHEMA=876;
    public static final int TOK_VARCHAR=877;
    public static final int TOK_VIEWPARTCOLS=878;
    public static final int TOK_WHERE=879;
    public static final int TOK_WINDOWDEF=880;
    public static final int TOK_WINDOWRANGE=881;
    public static final int TOK_WINDOWSPEC=882;
    public static final int TOK_WINDOWVALUES=883;

    // delegates
    public HiveParser_SelectClauseParser gSelectClauseParser;
    public HiveParser_FromClauseParser gFromClauseParser;
    public HiveParser_IdentifiersParser gIdentifiersParser;
    public Parser[] getDelegates() {
        return new Parser[] {gSelectClauseParser, gFromClauseParser, gIdentifiersParser};
    }

    // delegators


    public HiveParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public HiveParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
        gSelectClauseParser = new HiveParser_SelectClauseParser(input, state, this);
        gFromClauseParser = new HiveParser_FromClauseParser(input, state, this);
        gIdentifiersParser = new HiveParser_IdentifiersParser(input, state, this);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
    gSelectClauseParser.setTreeAdaptor(this.adaptor);gFromClauseParser.setTreeAdaptor(this.adaptor);gIdentifiersParser.setTreeAdaptor(this.adaptor);
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return HiveParser.tokenNames; }
    public String getGrammarFileName() { return "org/apache/hadoop/hive/ql/parse/HiveParser.g"; }


      ArrayList<ParseError> errors = new ArrayList<ParseError>();
      Stack msgs = new Stack<String>();

      private static HashMap<String, String> xlateMap;
      static {
        xlateMap = new HashMap<String, String>();

        // Keywords
        xlateMap.put("KW_TRUE", "TRUE");
        xlateMap.put("KW_FALSE", "FALSE");
        xlateMap.put("KW_ALL", "ALL");
        xlateMap.put("KW_NONE", "NONE");
        xlateMap.put("KW_DEFAULT", "DEFAULT");
        xlateMap.put("KW_AND", "AND");
        xlateMap.put("KW_OR", "OR");
        xlateMap.put("KW_NOT", "NOT");
        xlateMap.put("KW_LIKE", "LIKE");

        xlateMap.put("KW_ASC", "ASC");
        xlateMap.put("KW_DESC", "DESC");
        xlateMap.put("KW_ORDER", "ORDER");
        xlateMap.put("KW_BY", "BY");
        xlateMap.put("KW_GROUP", "GROUP");
        xlateMap.put("KW_WHERE", "WHERE");
        xlateMap.put("KW_FROM", "FROM");
        xlateMap.put("KW_AS", "AS");
        xlateMap.put("KW_SELECT", "SELECT");
        xlateMap.put("KW_DISTINCT", "DISTINCT");
        xlateMap.put("KW_INSERT", "INSERT");
        xlateMap.put("KW_OVERWRITE", "OVERWRITE");
        xlateMap.put("KW_OUTER", "OUTER");
        xlateMap.put("KW_JOIN", "JOIN");
        xlateMap.put("KW_LEFT", "LEFT");
        xlateMap.put("KW_RIGHT", "RIGHT");
        xlateMap.put("KW_FULL", "FULL");
        xlateMap.put("KW_ON", "ON");
        xlateMap.put("KW_PARTITION", "PARTITION");
        xlateMap.put("KW_PARTITIONS", "PARTITIONS");
        xlateMap.put("KW_TABLE", "TABLE");
        xlateMap.put("KW_TABLES", "TABLES");
        xlateMap.put("KW_TBLPROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_SHOW", "SHOW");
        xlateMap.put("KW_MSCK", "MSCK");
        xlateMap.put("KW_DIRECTORY", "DIRECTORY");
        xlateMap.put("KW_LOCAL", "LOCAL");
        xlateMap.put("KW_TRANSFORM", "TRANSFORM");
        xlateMap.put("KW_USING", "USING");
        xlateMap.put("KW_CLUSTER", "CLUSTER");
        xlateMap.put("KW_DISTRIBUTE", "DISTRIBUTE");
        xlateMap.put("KW_SORT", "SORT");
        xlateMap.put("KW_UNION", "UNION");
        xlateMap.put("KW_LOAD", "LOAD");
        xlateMap.put("KW_DATA", "DATA");
        xlateMap.put("KW_INPATH", "INPATH");
        xlateMap.put("KW_IS", "IS");
        xlateMap.put("KW_NULL", "NULL");
        xlateMap.put("KW_CREATE", "CREATE");
        xlateMap.put("KW_EXTERNAL", "EXTERNAL");
        xlateMap.put("KW_ALTER", "ALTER");
        xlateMap.put("KW_DESCRIBE", "DESCRIBE");
        xlateMap.put("KW_DROP", "DROP");
        xlateMap.put("KW_RENAME", "RENAME");
        xlateMap.put("KW_TO", "TO");
        xlateMap.put("KW_COMMENT", "COMMENT");
        xlateMap.put("KW_BOOLEAN", "BOOLEAN");
        xlateMap.put("KW_TINYINT", "TINYINT");
        xlateMap.put("KW_SMALLINT", "SMALLINT");
        xlateMap.put("KW_INT", "INT");
        xlateMap.put("KW_BIGINT", "BIGINT");
        xlateMap.put("KW_FLOAT", "FLOAT");
        xlateMap.put("KW_DOUBLE", "DOUBLE");
        xlateMap.put("KW_DATE", "DATE");
        xlateMap.put("KW_DATETIME", "DATETIME");
        xlateMap.put("KW_TIMESTAMP", "TIMESTAMP");
        xlateMap.put("KW_STRING", "STRING");
        xlateMap.put("KW_BINARY", "BINARY");
        xlateMap.put("KW_ARRAY", "ARRAY");
        xlateMap.put("KW_MAP", "MAP");
        xlateMap.put("KW_REDUCE", "REDUCE");
        xlateMap.put("KW_PARTITIONED", "PARTITIONED");
        xlateMap.put("KW_CLUSTERED", "CLUSTERED");
        xlateMap.put("KW_SORTED", "SORTED");
        xlateMap.put("KW_INTO", "INTO");
        xlateMap.put("KW_BUCKETS", "BUCKETS");
        xlateMap.put("KW_ROW", "ROW");
        xlateMap.put("KW_FORMAT", "FORMAT");
        xlateMap.put("KW_DELIMITED", "DELIMITED");
        xlateMap.put("KW_FIELDS", "FIELDS");
        xlateMap.put("KW_TERMINATED", "TERMINATED");
        xlateMap.put("KW_COLLECTION", "COLLECTION");
        xlateMap.put("KW_ITEMS", "ITEMS");
        xlateMap.put("KW_KEYS", "KEYS");
        xlateMap.put("KW_KEY_TYPE", "$KEY$");
        xlateMap.put("KW_LINES", "LINES");
        xlateMap.put("KW_STORED", "STORED");
        xlateMap.put("KW_SEQUENCEFILE", "SEQUENCEFILE");
        xlateMap.put("KW_TEXTFILE", "TEXTFILE");
        xlateMap.put("KW_INPUTFORMAT", "INPUTFORMAT");
        xlateMap.put("KW_OUTPUTFORMAT", "OUTPUTFORMAT");
        xlateMap.put("KW_LOCATION", "LOCATION");
        xlateMap.put("KW_TABLESAMPLE", "TABLESAMPLE");
        xlateMap.put("KW_BUCKET", "BUCKET");
        xlateMap.put("KW_OUT", "OUT");
        xlateMap.put("KW_OF", "OF");
        xlateMap.put("KW_CAST", "CAST");
        xlateMap.put("KW_ADD", "ADD");
        xlateMap.put("KW_REPLACE", "REPLACE");
        xlateMap.put("KW_COLUMNS", "COLUMNS");
        xlateMap.put("KW_RLIKE", "RLIKE");
        xlateMap.put("KW_REGEXP", "REGEXP");
        xlateMap.put("KW_TEMPORARY", "TEMPORARY");
        xlateMap.put("KW_FUNCTION", "FUNCTION");
        xlateMap.put("KW_EXPLAIN", "EXPLAIN");
        xlateMap.put("KW_EXTENDED", "EXTENDED");
        xlateMap.put("KW_SERDE", "SERDE");
        xlateMap.put("KW_WITH", "WITH");
        xlateMap.put("KW_SERDEPROPERTIES", "SERDEPROPERTIES");
        xlateMap.put("KW_LIMIT", "LIMIT");
        xlateMap.put("KW_SET", "SET");
        xlateMap.put("KW_PROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_VALUE_TYPE", "$VALUE$");
        xlateMap.put("KW_ELEM_TYPE", "$ELEM$");
        xlateMap.put("KW_DEFINED", "DEFINED");

        // Operators
        xlateMap.put("DOT", ".");
        xlateMap.put("COLON", ":");
        xlateMap.put("COMMA", ",");
        xlateMap.put("SEMICOLON", ");");

        xlateMap.put("LPAREN", "(");
        xlateMap.put("RPAREN", ")");
        xlateMap.put("LSQUARE", "[");
        xlateMap.put("RSQUARE", "]");

        xlateMap.put("EQUAL", "=");
        xlateMap.put("NOTEQUAL", "<>");
        xlateMap.put("EQUAL_NS", "<=>");
        xlateMap.put("LESSTHANOREQUALTO", "<=");
        xlateMap.put("LESSTHAN", "<");
        xlateMap.put("GREATERTHANOREQUALTO", ">=");
        xlateMap.put("GREATERTHAN", ">");

        xlateMap.put("DIVIDE", "/");
        xlateMap.put("PLUS", "+");
        xlateMap.put("MINUS", "-");
        xlateMap.put("STAR", "*");
        xlateMap.put("MOD", "%");

        xlateMap.put("AMPERSAND", "&");
        xlateMap.put("TILDE", "~");
        xlateMap.put("BITWISEOR", "|");
        xlateMap.put("BITWISEXOR", "^");
        xlateMap.put("CharSetLiteral", "\\'");
      }

      public static Collection<String> getKeywords() {
        return xlateMap.values();
      }

      private static String xlate(String name) {

        String ret = xlateMap.get(name);
        if (ret == null) {
          ret = name;
        }

        return ret;
      }

      @Override
      public Object recoverFromMismatchedSet(IntStream input,
          RecognitionException re, BitSet follow) throws RecognitionException {
        throw re;
      }

      @Override
      public void displayRecognitionError(String[] tokenNames,
          RecognitionException e) {
        errors.add(new ParseError(this, e, tokenNames));
      }

      @Override
      public String getErrorHeader(RecognitionException e) {
        String header = null;
        if (e.charPositionInLine < 0 && input.LT(-1) != null) {
          Token t = input.LT(-1);
          header = "line " + t.getLine() + ":" + t.getCharPositionInLine();
        } else {
          header = super.getErrorHeader(e);
        }

        return header;
      }
      
      @Override
      public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        String msg = null;

        // Translate the token names to something that the user can understand
        String[] xlateNames = new String[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
          xlateNames[i] = HiveParser.xlate(tokenNames[i]);
        }

        if (e instanceof NoViableAltException) {
          @SuppressWarnings("unused")
          NoViableAltException nvae = (NoViableAltException) e;
          // for development, can add
          // "decision=<<"+nvae.grammarDecisionDescription+">>"
          // and "(decision="+nvae.decisionNumber+") and
          // "state "+nvae.stateNumber
          msg = "cannot recognize input near"
                  + (input.LT(1) != null ? " " + getTokenErrorDisplay(input.LT(1)) : "")
                  + (input.LT(2) != null ? " " + getTokenErrorDisplay(input.LT(2)) : "")
                  + (input.LT(3) != null ? " " + getTokenErrorDisplay(input.LT(3)) : "");
        } else if (e instanceof MismatchedTokenException) {
          MismatchedTokenException mte = (MismatchedTokenException) e;
          msg = super.getErrorMessage(e, xlateNames) + (input.LT(-1) == null ? "":" near '" + input.LT(-1).getText()) + "'";
        } else if (e instanceof FailedPredicateException) {
          FailedPredicateException fpe = (FailedPredicateException) e;
          msg = "Failed to recognize predicate '" + fpe.token.getText() + "'. Failed rule: '" + fpe.ruleName + "'";
        } else {
          msg = super.getErrorMessage(e, xlateNames);
        }

        if (msgs.size() > 0) {
          msg = msg + " in " + msgs.peek();
        }
        return msg;
      }
      
      public void pushMsg(String msg, RecognizerSharedState state) {
        // ANTLR generated code does not wrap the @init code wit this backtracking check,
        //  even if the matching @after has it. If we have parser rules with that are doing
        // some lookahead with syntactic predicates this can cause the push() and pop() calls
        // to become unbalanced, so make sure both push/pop check the backtracking state.
        if (state.backtracking == 0) {
          msgs.push(msg);
        }
      }

      public void popMsg(RecognizerSharedState state) {
        if (state.backtracking == 0) {
          msgs.pop();
        }
      }

      // counter to generate unique union aliases
      private int aliasCounter;
      
      private String generateUnionAlias() {
        return "_u" + (++aliasCounter);
      }


    public static class statement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:611:1: statement : ( explainStatement EOF | execStatement EOF );
    public final HiveParser.statement_return statement() throws RecognitionException {
        HiveParser.statement_return retval = new HiveParser.statement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token EOF2=null;
        Token EOF4=null;
        HiveParser.explainStatement_return explainStatement1 =null;

        HiveParser.execStatement_return execStatement3 =null;


        CommonTree EOF2_tree=null;
        CommonTree EOF4_tree=null;

        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:612:2: ( explainStatement EOF | execStatement EOF )
            int alt1=2;
            switch ( input.LA(1) ) {
            case KW_EXPLAIN:
                {
                alt1=1;
                }
                break;
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_CREATE:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_EXPORT:
            case KW_FROM:
            case KW_GRANT:
            case KW_IMPORT:
            case KW_INSERT:
            case KW_LOAD:
            case KW_LOCK:
            case KW_MAP:
            case KW_MSCK:
            case KW_REDUCE:
            case KW_REVOKE:
            case KW_SELECT:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_USE:
            case KW_WITH:
                {
                alt1=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 1, 0, input);

                throw nvae;

            }

            switch (alt1) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:612:4: explainStatement EOF
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_explainStatement_in_statement995);
                    explainStatement1=explainStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, explainStatement1.getTree());

                    EOF2=(Token)match(input,EOF,FOLLOW_EOF_in_statement997); 
                    EOF2_tree = 
                    (CommonTree)adaptor.create(EOF2)
                    ;
                    adaptor.addChild(root_0, EOF2_tree);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:613:4: execStatement EOF
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_execStatement_in_statement1002);
                    execStatement3=execStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, execStatement3.getTree());

                    EOF4=(Token)match(input,EOF,FOLLOW_EOF_in_statement1004); 
                    EOF4_tree = 
                    (CommonTree)adaptor.create(EOF4)
                    ;
                    adaptor.addChild(root_0, EOF4_tree);


                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class explainStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "explainStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:616:1: explainStatement : KW_EXPLAIN (explainOptions= KW_EXTENDED |explainOptions= KW_FORMATTED |explainOptions= KW_DEPENDENCY |explainOptions= KW_LOGICAL )? execStatement -> ^( TOK_EXPLAIN execStatement ( $explainOptions)? ) ;
    public final HiveParser.explainStatement_return explainStatement() throws RecognitionException {
        HiveParser.explainStatement_return retval = new HiveParser.explainStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token explainOptions=null;
        Token KW_EXPLAIN5=null;
        HiveParser.execStatement_return execStatement6 =null;


        CommonTree explainOptions_tree=null;
        CommonTree KW_EXPLAIN5_tree=null;
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_DEPENDENCY=new RewriteRuleTokenStream(adaptor,"token KW_DEPENDENCY");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_EXPLAIN=new RewriteRuleTokenStream(adaptor,"token KW_EXPLAIN");
        RewriteRuleTokenStream stream_KW_LOGICAL=new RewriteRuleTokenStream(adaptor,"token KW_LOGICAL");
        RewriteRuleSubtreeStream stream_execStatement=new RewriteRuleSubtreeStream(adaptor,"rule execStatement");
         pushMsg("explain statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:619:2: ( KW_EXPLAIN (explainOptions= KW_EXTENDED |explainOptions= KW_FORMATTED |explainOptions= KW_DEPENDENCY |explainOptions= KW_LOGICAL )? execStatement -> ^( TOK_EXPLAIN execStatement ( $explainOptions)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:619:4: KW_EXPLAIN (explainOptions= KW_EXTENDED |explainOptions= KW_FORMATTED |explainOptions= KW_DEPENDENCY |explainOptions= KW_LOGICAL )? execStatement
            {
            KW_EXPLAIN5=(Token)match(input,KW_EXPLAIN,FOLLOW_KW_EXPLAIN_in_explainStatement1025);  
            stream_KW_EXPLAIN.add(KW_EXPLAIN5);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:619:15: (explainOptions= KW_EXTENDED |explainOptions= KW_FORMATTED |explainOptions= KW_DEPENDENCY |explainOptions= KW_LOGICAL )?
            int alt2=5;
            switch ( input.LA(1) ) {
                case KW_EXTENDED:
                    {
                    alt2=1;
                    }
                    break;
                case KW_FORMATTED:
                    {
                    alt2=2;
                    }
                    break;
                case KW_DEPENDENCY:
                    {
                    alt2=3;
                    }
                    break;
                case KW_LOGICAL:
                    {
                    alt2=4;
                    }
                    break;
            }

            switch (alt2) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:619:16: explainOptions= KW_EXTENDED
                    {
                    explainOptions=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_explainStatement1030);  
                    stream_KW_EXTENDED.add(explainOptions);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:619:43: explainOptions= KW_FORMATTED
                    {
                    explainOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_explainStatement1034);  
                    stream_KW_FORMATTED.add(explainOptions);


                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:619:71: explainOptions= KW_DEPENDENCY
                    {
                    explainOptions=(Token)match(input,KW_DEPENDENCY,FOLLOW_KW_DEPENDENCY_in_explainStatement1038);  
                    stream_KW_DEPENDENCY.add(explainOptions);


                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:619:100: explainOptions= KW_LOGICAL
                    {
                    explainOptions=(Token)match(input,KW_LOGICAL,FOLLOW_KW_LOGICAL_in_explainStatement1042);  
                    stream_KW_LOGICAL.add(explainOptions);


                    }
                    break;

            }


            pushFollow(FOLLOW_execStatement_in_explainStatement1046);
            execStatement6=execStatement();

            state._fsp--;

            stream_execStatement.add(execStatement6.getTree());

            // AST REWRITE
            // elements: execStatement, explainOptions
            // token labels: explainOptions
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_explainOptions=new RewriteRuleTokenStream(adaptor,"token explainOptions",explainOptions);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 620:7: -> ^( TOK_EXPLAIN execStatement ( $explainOptions)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:620:10: ^( TOK_EXPLAIN execStatement ( $explainOptions)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_EXPLAIN, "TOK_EXPLAIN")
                , root_1);

                adaptor.addChild(root_1, stream_execStatement.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:620:39: ( $explainOptions)?
                if ( stream_explainOptions.hasNext() ) {
                    adaptor.addChild(root_1, stream_explainOptions.nextNode());

                }
                stream_explainOptions.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "explainStatement"


    public static class execStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "execStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:623:1: execStatement : ( queryStatementExpression[true] | loadStatement | exportStatement | importStatement | ddlStatement );
    public final HiveParser.execStatement_return execStatement() throws RecognitionException {
        HiveParser.execStatement_return retval = new HiveParser.execStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.queryStatementExpression_return queryStatementExpression7 =null;

        HiveParser.loadStatement_return loadStatement8 =null;

        HiveParser.exportStatement_return exportStatement9 =null;

        HiveParser.importStatement_return importStatement10 =null;

        HiveParser.ddlStatement_return ddlStatement11 =null;



         pushMsg("statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:626:5: ( queryStatementExpression[true] | loadStatement | exportStatement | importStatement | ddlStatement )
            int alt3=5;
            switch ( input.LA(1) ) {
            case KW_FROM:
            case KW_INSERT:
            case KW_MAP:
            case KW_REDUCE:
            case KW_SELECT:
            case KW_WITH:
                {
                alt3=1;
                }
                break;
            case KW_LOAD:
                {
                alt3=2;
                }
                break;
            case KW_EXPORT:
                {
                alt3=3;
                }
                break;
            case KW_IMPORT:
                {
                alt3=4;
                }
                break;
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_CREATE:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_GRANT:
            case KW_LOCK:
            case KW_MSCK:
            case KW_REVOKE:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_USE:
                {
                alt3=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:626:7: queryStatementExpression[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_queryStatementExpression_in_execStatement1088);
                    queryStatementExpression7=queryStatementExpression(true);

                    state._fsp--;

                    adaptor.addChild(root_0, queryStatementExpression7.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:627:7: loadStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_loadStatement_in_execStatement1097);
                    loadStatement8=loadStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, loadStatement8.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:628:7: exportStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_exportStatement_in_execStatement1105);
                    exportStatement9=exportStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, exportStatement9.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:629:7: importStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_importStatement_in_execStatement1113);
                    importStatement10=importStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, importStatement10.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:630:7: ddlStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_ddlStatement_in_execStatement1121);
                    ddlStatement11=ddlStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, ddlStatement11.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "execStatement"


    public static class loadStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "loadStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:633:1: loadStatement : KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition ) -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? ) ;
    public final HiveParser.loadStatement_return loadStatement() throws RecognitionException {
        HiveParser.loadStatement_return retval = new HiveParser.loadStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token islocal=null;
        Token path=null;
        Token isoverwrite=null;
        Token KW_LOAD12=null;
        Token KW_DATA13=null;
        Token KW_INPATH14=null;
        Token KW_INTO15=null;
        Token KW_TABLE16=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;


        CommonTree islocal_tree=null;
        CommonTree path_tree=null;
        CommonTree isoverwrite_tree=null;
        CommonTree KW_LOAD12_tree=null;
        CommonTree KW_DATA13_tree=null;
        CommonTree KW_INPATH14_tree=null;
        CommonTree KW_INTO15_tree=null;
        CommonTree KW_TABLE16_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INPATH=new RewriteRuleTokenStream(adaptor,"token KW_INPATH");
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_KW_LOCAL=new RewriteRuleTokenStream(adaptor,"token KW_LOCAL");
        RewriteRuleTokenStream stream_KW_OVERWRITE=new RewriteRuleTokenStream(adaptor,"token KW_OVERWRITE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_LOAD=new RewriteRuleTokenStream(adaptor,"token KW_LOAD");
        RewriteRuleTokenStream stream_KW_DATA=new RewriteRuleTokenStream(adaptor,"token KW_DATA");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
         pushMsg("load statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:5: ( KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition ) -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:7: KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition )
            {
            KW_LOAD12=(Token)match(input,KW_LOAD,FOLLOW_KW_LOAD_in_loadStatement1148);  
            stream_KW_LOAD.add(KW_LOAD12);


            KW_DATA13=(Token)match(input,KW_DATA,FOLLOW_KW_DATA_in_loadStatement1150);  
            stream_KW_DATA.add(KW_DATA13);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:23: (islocal= KW_LOCAL )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case KW_LOCAL:
                    {
                    alt4=1;
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:24: islocal= KW_LOCAL
                    {
                    islocal=(Token)match(input,KW_LOCAL,FOLLOW_KW_LOCAL_in_loadStatement1155);  
                    stream_KW_LOCAL.add(islocal);


                    }
                    break;

            }


            KW_INPATH14=(Token)match(input,KW_INPATH,FOLLOW_KW_INPATH_in_loadStatement1159);  
            stream_KW_INPATH.add(KW_INPATH14);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:53: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:54: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_loadStatement1164);  
            stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:74: (isoverwrite= KW_OVERWRITE )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case KW_OVERWRITE:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:75: isoverwrite= KW_OVERWRITE
                    {
                    isoverwrite=(Token)match(input,KW_OVERWRITE,FOLLOW_KW_OVERWRITE_in_loadStatement1170);  
                    stream_KW_OVERWRITE.add(isoverwrite);


                    }
                    break;

            }


            KW_INTO15=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_loadStatement1174);  
            stream_KW_INTO.add(KW_INTO15);


            KW_TABLE16=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_loadStatement1176);  
            stream_KW_TABLE.add(KW_TABLE16);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:119: (tab= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:120: tab= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_loadStatement1181);
            tab=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(tab.getTree());

            }


            // AST REWRITE
            // elements: path, isoverwrite, islocal, tab
            // token labels: islocal, isoverwrite, path
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_islocal=new RewriteRuleTokenStream(adaptor,"token islocal",islocal);
            RewriteRuleTokenStream stream_isoverwrite=new RewriteRuleTokenStream(adaptor,"token isoverwrite",isoverwrite);
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 637:5: -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:637:8: ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOAD, "TOK_LOAD")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextNode());

                adaptor.addChild(root_1, stream_tab.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:637:31: ( $islocal)?
                if ( stream_islocal.hasNext() ) {
                    adaptor.addChild(root_1, stream_islocal.nextNode());

                }
                stream_islocal.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:637:41: ( $isoverwrite)?
                if ( stream_isoverwrite.hasNext() ) {
                    adaptor.addChild(root_1, stream_isoverwrite.nextNode());

                }
                stream_isoverwrite.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "loadStatement"


    public static class exportStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "exportStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:640:1: exportStatement : KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) -> ^( TOK_EXPORT $tab $path) ;
    public final HiveParser.exportStatement_return exportStatement() throws RecognitionException {
        HiveParser.exportStatement_return retval = new HiveParser.exportStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token path=null;
        Token KW_EXPORT17=null;
        Token KW_TABLE18=null;
        Token KW_TO19=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;


        CommonTree path_tree=null;
        CommonTree KW_EXPORT17_tree=null;
        CommonTree KW_TABLE18_tree=null;
        CommonTree KW_TO19_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_EXPORT=new RewriteRuleTokenStream(adaptor,"token KW_EXPORT");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
         pushMsg("export statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:643:5: ( KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) -> ^( TOK_EXPORT $tab $path) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:643:7: KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral )
            {
            KW_EXPORT17=(Token)match(input,KW_EXPORT,FOLLOW_KW_EXPORT_in_exportStatement1233);  
            stream_KW_EXPORT.add(KW_EXPORT17);


            KW_TABLE18=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_exportStatement1235);  
            stream_KW_TABLE.add(KW_TABLE18);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:643:26: (tab= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:643:27: tab= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_exportStatement1240);
            tab=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(tab.getTree());

            }


            KW_TO19=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_exportStatement1243);  
            stream_KW_TO.add(KW_TO19);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:643:55: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:643:56: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_exportStatement1248);  
            stream_StringLiteral.add(path);


            }


            // AST REWRITE
            // elements: tab, path
            // token labels: path
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 644:5: -> ^( TOK_EXPORT $tab $path)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:644:8: ^( TOK_EXPORT $tab $path)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_EXPORT, "TOK_EXPORT")
                , root_1);

                adaptor.addChild(root_1, stream_tab.nextTree());

                adaptor.addChild(root_1, stream_path.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "exportStatement"


    public static class importStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "importStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:647:1: importStatement : KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )? -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? ) ;
    public final HiveParser.importStatement_return importStatement() throws RecognitionException {
        HiveParser.importStatement_return retval = new HiveParser.importStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token ext=null;
        Token path=null;
        Token KW_IMPORT20=null;
        Token KW_TABLE21=null;
        Token KW_FROM22=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;

        HiveParser.tableLocation_return tableLocation23 =null;


        CommonTree ext_tree=null;
        CommonTree path_tree=null;
        CommonTree KW_IMPORT20_tree=null;
        CommonTree KW_TABLE21_tree=null;
        CommonTree KW_FROM22_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_IMPORT=new RewriteRuleTokenStream(adaptor,"token KW_IMPORT");
        RewriteRuleTokenStream stream_KW_EXTERNAL=new RewriteRuleTokenStream(adaptor,"token KW_EXTERNAL");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
         pushMsg("import statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:2: ( KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )? -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:4: KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )?
            {
            KW_IMPORT20=(Token)match(input,KW_IMPORT,FOLLOW_KW_IMPORT_in_importStatement1289);  
            stream_KW_IMPORT.add(KW_IMPORT20);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:14: ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case KW_EXTERNAL:
                case KW_TABLE:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:15: (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:15: (ext= KW_EXTERNAL )?
                    int alt6=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTERNAL:
                            {
                            alt6=1;
                            }
                            break;
                    }

                    switch (alt6) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:16: ext= KW_EXTERNAL
                            {
                            ext=(Token)match(input,KW_EXTERNAL,FOLLOW_KW_EXTERNAL_in_importStatement1295);  
                            stream_KW_EXTERNAL.add(ext);


                            }
                            break;

                    }


                    KW_TABLE21=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_importStatement1299);  
                    stream_KW_TABLE.add(KW_TABLE21);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:43: (tab= tableOrPartition )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:44: tab= tableOrPartition
                    {
                    pushFollow(FOLLOW_tableOrPartition_in_importStatement1304);
                    tab=tableOrPartition();

                    state._fsp--;

                    stream_tableOrPartition.add(tab.getTree());

                    }


                    }
                    break;

            }


            KW_FROM22=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_importStatement1309);  
            stream_KW_FROM.add(KW_FROM22);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:76: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:77: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_importStatement1314);  
            stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:97: ( tableLocation )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:97: tableLocation
                    {
                    pushFollow(FOLLOW_tableLocation_in_importStatement1317);
                    tableLocation23=tableLocation();

                    state._fsp--;

                    stream_tableLocation.add(tableLocation23.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: path, ext, tab, tableLocation
            // token labels: path, ext
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleTokenStream stream_ext=new RewriteRuleTokenStream(adaptor,"token ext",ext);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 651:5: -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:651:8: ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IMPORT, "TOK_IMPORT")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextNode());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:651:28: ( $tab)?
                if ( stream_tab.hasNext() ) {
                    adaptor.addChild(root_1, stream_tab.nextTree());

                }
                stream_tab.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:651:34: ( $ext)?
                if ( stream_ext.hasNext() ) {
                    adaptor.addChild(root_1, stream_ext.nextNode());

                }
                stream_ext.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:651:39: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "importStatement"


    public static class ddlStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ddlStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:654:1: ddlStatement : ( createDatabaseStatement | switchDatabaseStatement | dropDatabaseStatement | createTableStatement | dropTableStatement | truncateTableStatement | alterStatement | descStatement | showStatement | metastoreCheck | createViewStatement | dropViewStatement | createFunctionStatement | createMacroStatement | createIndexStatement | dropIndexStatement | dropFunctionStatement | dropMacroStatement | analyzeStatement | lockStatement | unlockStatement | lockDatabase | unlockDatabase | createRoleStatement | dropRoleStatement | grantPrivileges | revokePrivileges | showGrants | showRoleGrants | showRolePrincipals | showRoles | grantRole | revokeRole | setRole | showCurrentRole );
    public final HiveParser.ddlStatement_return ddlStatement() throws RecognitionException {
        HiveParser.ddlStatement_return retval = new HiveParser.ddlStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.createDatabaseStatement_return createDatabaseStatement24 =null;

        HiveParser.switchDatabaseStatement_return switchDatabaseStatement25 =null;

        HiveParser.dropDatabaseStatement_return dropDatabaseStatement26 =null;

        HiveParser.createTableStatement_return createTableStatement27 =null;

        HiveParser.dropTableStatement_return dropTableStatement28 =null;

        HiveParser.truncateTableStatement_return truncateTableStatement29 =null;

        HiveParser.alterStatement_return alterStatement30 =null;

        HiveParser.descStatement_return descStatement31 =null;

        HiveParser.showStatement_return showStatement32 =null;

        HiveParser.metastoreCheck_return metastoreCheck33 =null;

        HiveParser.createViewStatement_return createViewStatement34 =null;

        HiveParser.dropViewStatement_return dropViewStatement35 =null;

        HiveParser.createFunctionStatement_return createFunctionStatement36 =null;

        HiveParser.createMacroStatement_return createMacroStatement37 =null;

        HiveParser.createIndexStatement_return createIndexStatement38 =null;

        HiveParser.dropIndexStatement_return dropIndexStatement39 =null;

        HiveParser.dropFunctionStatement_return dropFunctionStatement40 =null;

        HiveParser.dropMacroStatement_return dropMacroStatement41 =null;

        HiveParser.analyzeStatement_return analyzeStatement42 =null;

        HiveParser.lockStatement_return lockStatement43 =null;

        HiveParser.unlockStatement_return unlockStatement44 =null;

        HiveParser.lockDatabase_return lockDatabase45 =null;

        HiveParser.unlockDatabase_return unlockDatabase46 =null;

        HiveParser.createRoleStatement_return createRoleStatement47 =null;

        HiveParser.dropRoleStatement_return dropRoleStatement48 =null;

        HiveParser.grantPrivileges_return grantPrivileges49 =null;

        HiveParser.revokePrivileges_return revokePrivileges50 =null;

        HiveParser.showGrants_return showGrants51 =null;

        HiveParser.showRoleGrants_return showRoleGrants52 =null;

        HiveParser.showRolePrincipals_return showRolePrincipals53 =null;

        HiveParser.showRoles_return showRoles54 =null;

        HiveParser.grantRole_return grantRole55 =null;

        HiveParser.revokeRole_return revokeRole56 =null;

        HiveParser.setRole_return setRole57 =null;

        HiveParser.showCurrentRole_return showCurrentRole58 =null;



         pushMsg("ddl statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:657:5: ( createDatabaseStatement | switchDatabaseStatement | dropDatabaseStatement | createTableStatement | dropTableStatement | truncateTableStatement | alterStatement | descStatement | showStatement | metastoreCheck | createViewStatement | dropViewStatement | createFunctionStatement | createMacroStatement | createIndexStatement | dropIndexStatement | dropFunctionStatement | dropMacroStatement | analyzeStatement | lockStatement | unlockStatement | lockDatabase | unlockDatabase | createRoleStatement | dropRoleStatement | grantPrivileges | revokePrivileges | showGrants | showRoleGrants | showRolePrincipals | showRoles | grantRole | revokeRole | setRole | showCurrentRole )
            int alt9=35;
            alt9 = dfa9.predict(input);
            switch (alt9) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:657:7: createDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createDatabaseStatement_in_ddlStatement1369);
                    createDatabaseStatement24=createDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createDatabaseStatement24.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:658:7: switchDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_switchDatabaseStatement_in_ddlStatement1377);
                    switchDatabaseStatement25=switchDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, switchDatabaseStatement25.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:659:7: dropDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropDatabaseStatement_in_ddlStatement1385);
                    dropDatabaseStatement26=dropDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropDatabaseStatement26.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:660:7: createTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createTableStatement_in_ddlStatement1393);
                    createTableStatement27=createTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createTableStatement27.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:661:7: dropTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropTableStatement_in_ddlStatement1401);
                    dropTableStatement28=dropTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropTableStatement28.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:662:7: truncateTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_truncateTableStatement_in_ddlStatement1409);
                    truncateTableStatement29=truncateTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, truncateTableStatement29.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:663:7: alterStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatement_in_ddlStatement1417);
                    alterStatement30=alterStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatement30.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:664:7: descStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_descStatement_in_ddlStatement1425);
                    descStatement31=descStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, descStatement31.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:665:7: showStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showStatement_in_ddlStatement1433);
                    showStatement32=showStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, showStatement32.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:666:7: metastoreCheck
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_metastoreCheck_in_ddlStatement1441);
                    metastoreCheck33=metastoreCheck();

                    state._fsp--;

                    adaptor.addChild(root_0, metastoreCheck33.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:667:7: createViewStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createViewStatement_in_ddlStatement1449);
                    createViewStatement34=createViewStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createViewStatement34.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:668:7: dropViewStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropViewStatement_in_ddlStatement1457);
                    dropViewStatement35=dropViewStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropViewStatement35.getTree());

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:669:7: createFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createFunctionStatement_in_ddlStatement1465);
                    createFunctionStatement36=createFunctionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createFunctionStatement36.getTree());

                    }
                    break;
                case 14 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:670:7: createMacroStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createMacroStatement_in_ddlStatement1473);
                    createMacroStatement37=createMacroStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createMacroStatement37.getTree());

                    }
                    break;
                case 15 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:671:7: createIndexStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createIndexStatement_in_ddlStatement1481);
                    createIndexStatement38=createIndexStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createIndexStatement38.getTree());

                    }
                    break;
                case 16 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:672:7: dropIndexStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropIndexStatement_in_ddlStatement1489);
                    dropIndexStatement39=dropIndexStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropIndexStatement39.getTree());

                    }
                    break;
                case 17 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:673:7: dropFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropFunctionStatement_in_ddlStatement1497);
                    dropFunctionStatement40=dropFunctionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropFunctionStatement40.getTree());

                    }
                    break;
                case 18 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:674:7: dropMacroStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropMacroStatement_in_ddlStatement1505);
                    dropMacroStatement41=dropMacroStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropMacroStatement41.getTree());

                    }
                    break;
                case 19 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:675:7: analyzeStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_analyzeStatement_in_ddlStatement1513);
                    analyzeStatement42=analyzeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, analyzeStatement42.getTree());

                    }
                    break;
                case 20 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:676:7: lockStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lockStatement_in_ddlStatement1521);
                    lockStatement43=lockStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, lockStatement43.getTree());

                    }
                    break;
                case 21 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:677:7: unlockStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_unlockStatement_in_ddlStatement1529);
                    unlockStatement44=unlockStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, unlockStatement44.getTree());

                    }
                    break;
                case 22 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:678:7: lockDatabase
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lockDatabase_in_ddlStatement1537);
                    lockDatabase45=lockDatabase();

                    state._fsp--;

                    adaptor.addChild(root_0, lockDatabase45.getTree());

                    }
                    break;
                case 23 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:7: unlockDatabase
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_unlockDatabase_in_ddlStatement1545);
                    unlockDatabase46=unlockDatabase();

                    state._fsp--;

                    adaptor.addChild(root_0, unlockDatabase46.getTree());

                    }
                    break;
                case 24 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:680:7: createRoleStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createRoleStatement_in_ddlStatement1553);
                    createRoleStatement47=createRoleStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createRoleStatement47.getTree());

                    }
                    break;
                case 25 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:681:7: dropRoleStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropRoleStatement_in_ddlStatement1561);
                    dropRoleStatement48=dropRoleStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropRoleStatement48.getTree());

                    }
                    break;
                case 26 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:682:7: grantPrivileges
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_grantPrivileges_in_ddlStatement1569);
                    grantPrivileges49=grantPrivileges();

                    state._fsp--;

                    adaptor.addChild(root_0, grantPrivileges49.getTree());

                    }
                    break;
                case 27 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:683:7: revokePrivileges
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_revokePrivileges_in_ddlStatement1577);
                    revokePrivileges50=revokePrivileges();

                    state._fsp--;

                    adaptor.addChild(root_0, revokePrivileges50.getTree());

                    }
                    break;
                case 28 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:684:7: showGrants
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showGrants_in_ddlStatement1585);
                    showGrants51=showGrants();

                    state._fsp--;

                    adaptor.addChild(root_0, showGrants51.getTree());

                    }
                    break;
                case 29 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:685:7: showRoleGrants
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRoleGrants_in_ddlStatement1593);
                    showRoleGrants52=showRoleGrants();

                    state._fsp--;

                    adaptor.addChild(root_0, showRoleGrants52.getTree());

                    }
                    break;
                case 30 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:686:7: showRolePrincipals
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRolePrincipals_in_ddlStatement1601);
                    showRolePrincipals53=showRolePrincipals();

                    state._fsp--;

                    adaptor.addChild(root_0, showRolePrincipals53.getTree());

                    }
                    break;
                case 31 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:687:7: showRoles
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRoles_in_ddlStatement1609);
                    showRoles54=showRoles();

                    state._fsp--;

                    adaptor.addChild(root_0, showRoles54.getTree());

                    }
                    break;
                case 32 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:688:7: grantRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_grantRole_in_ddlStatement1617);
                    grantRole55=grantRole();

                    state._fsp--;

                    adaptor.addChild(root_0, grantRole55.getTree());

                    }
                    break;
                case 33 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:689:7: revokeRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_revokeRole_in_ddlStatement1625);
                    revokeRole56=revokeRole();

                    state._fsp--;

                    adaptor.addChild(root_0, revokeRole56.getTree());

                    }
                    break;
                case 34 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:690:7: setRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_setRole_in_ddlStatement1633);
                    setRole57=setRole();

                    state._fsp--;

                    adaptor.addChild(root_0, setRole57.getTree());

                    }
                    break;
                case 35 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:691:7: showCurrentRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showCurrentRole_in_ddlStatement1641);
                    showCurrentRole58=showCurrentRole();

                    state._fsp--;

                    adaptor.addChild(root_0, showCurrentRole58.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ddlStatement"


    public static class ifExists_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ifExists"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:694:1: ifExists : KW_IF KW_EXISTS -> ^( TOK_IFEXISTS ) ;
    public final HiveParser.ifExists_return ifExists() throws RecognitionException {
        HiveParser.ifExists_return retval = new HiveParser.ifExists_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IF59=null;
        Token KW_EXISTS60=null;

        CommonTree KW_IF59_tree=null;
        CommonTree KW_EXISTS60_tree=null;
        RewriteRuleTokenStream stream_KW_IF=new RewriteRuleTokenStream(adaptor,"token KW_IF");
        RewriteRuleTokenStream stream_KW_EXISTS=new RewriteRuleTokenStream(adaptor,"token KW_EXISTS");

         pushMsg("if exists clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:697:5: ( KW_IF KW_EXISTS -> ^( TOK_IFEXISTS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:697:7: KW_IF KW_EXISTS
            {
            KW_IF59=(Token)match(input,KW_IF,FOLLOW_KW_IF_in_ifExists1668);  
            stream_KW_IF.add(KW_IF59);


            KW_EXISTS60=(Token)match(input,KW_EXISTS,FOLLOW_KW_EXISTS_in_ifExists1670);  
            stream_KW_EXISTS.add(KW_EXISTS60);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 698:5: -> ^( TOK_IFEXISTS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:698:8: ^( TOK_IFEXISTS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IFEXISTS, "TOK_IFEXISTS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ifExists"


    public static class restrictOrCascade_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "restrictOrCascade"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:701:1: restrictOrCascade : ( KW_RESTRICT -> ^( TOK_RESTRICT ) | KW_CASCADE -> ^( TOK_CASCADE ) );
    public final HiveParser.restrictOrCascade_return restrictOrCascade() throws RecognitionException {
        HiveParser.restrictOrCascade_return retval = new HiveParser.restrictOrCascade_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RESTRICT61=null;
        Token KW_CASCADE62=null;

        CommonTree KW_RESTRICT61_tree=null;
        CommonTree KW_CASCADE62_tree=null;
        RewriteRuleTokenStream stream_KW_CASCADE=new RewriteRuleTokenStream(adaptor,"token KW_CASCADE");
        RewriteRuleTokenStream stream_KW_RESTRICT=new RewriteRuleTokenStream(adaptor,"token KW_RESTRICT");

         pushMsg("restrict or cascade clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:704:5: ( KW_RESTRICT -> ^( TOK_RESTRICT ) | KW_CASCADE -> ^( TOK_CASCADE ) )
            int alt10=2;
            switch ( input.LA(1) ) {
            case KW_RESTRICT:
                {
                alt10=1;
                }
                break;
            case KW_CASCADE:
                {
                alt10=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;

            }

            switch (alt10) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:704:7: KW_RESTRICT
                    {
                    KW_RESTRICT61=(Token)match(input,KW_RESTRICT,FOLLOW_KW_RESTRICT_in_restrictOrCascade1707);  
                    stream_KW_RESTRICT.add(KW_RESTRICT61);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 705:5: -> ^( TOK_RESTRICT )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:705:8: ^( TOK_RESTRICT )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_RESTRICT, "TOK_RESTRICT")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:706:7: KW_CASCADE
                    {
                    KW_CASCADE62=(Token)match(input,KW_CASCADE,FOLLOW_KW_CASCADE_in_restrictOrCascade1725);  
                    stream_KW_CASCADE.add(KW_CASCADE62);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 707:5: -> ^( TOK_CASCADE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:707:8: ^( TOK_CASCADE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_CASCADE, "TOK_CASCADE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "restrictOrCascade"


    public static class ifNotExists_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ifNotExists"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:710:1: ifNotExists : KW_IF KW_NOT KW_EXISTS -> ^( TOK_IFNOTEXISTS ) ;
    public final HiveParser.ifNotExists_return ifNotExists() throws RecognitionException {
        HiveParser.ifNotExists_return retval = new HiveParser.ifNotExists_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IF63=null;
        Token KW_NOT64=null;
        Token KW_EXISTS65=null;

        CommonTree KW_IF63_tree=null;
        CommonTree KW_NOT64_tree=null;
        CommonTree KW_EXISTS65_tree=null;
        RewriteRuleTokenStream stream_KW_IF=new RewriteRuleTokenStream(adaptor,"token KW_IF");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_EXISTS=new RewriteRuleTokenStream(adaptor,"token KW_EXISTS");

         pushMsg("if not exists clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:713:5: ( KW_IF KW_NOT KW_EXISTS -> ^( TOK_IFNOTEXISTS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:713:7: KW_IF KW_NOT KW_EXISTS
            {
            KW_IF63=(Token)match(input,KW_IF,FOLLOW_KW_IF_in_ifNotExists1762);  
            stream_KW_IF.add(KW_IF63);


            KW_NOT64=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_ifNotExists1764);  
            stream_KW_NOT.add(KW_NOT64);


            KW_EXISTS65=(Token)match(input,KW_EXISTS,FOLLOW_KW_EXISTS_in_ifNotExists1766);  
            stream_KW_EXISTS.add(KW_EXISTS65);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 714:5: -> ^( TOK_IFNOTEXISTS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:714:8: ^( TOK_IFNOTEXISTS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IFNOTEXISTS, "TOK_IFNOTEXISTS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ifNotExists"


    public static class storedAsDirs_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "storedAsDirs"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:717:1: storedAsDirs : KW_STORED KW_AS KW_DIRECTORIES -> ^( TOK_STOREDASDIRS ) ;
    public final HiveParser.storedAsDirs_return storedAsDirs() throws RecognitionException {
        HiveParser.storedAsDirs_return retval = new HiveParser.storedAsDirs_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_STORED66=null;
        Token KW_AS67=null;
        Token KW_DIRECTORIES68=null;

        CommonTree KW_STORED66_tree=null;
        CommonTree KW_AS67_tree=null;
        CommonTree KW_DIRECTORIES68_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_STORED=new RewriteRuleTokenStream(adaptor,"token KW_STORED");
        RewriteRuleTokenStream stream_KW_DIRECTORIES=new RewriteRuleTokenStream(adaptor,"token KW_DIRECTORIES");

         pushMsg("stored as directories", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:720:5: ( KW_STORED KW_AS KW_DIRECTORIES -> ^( TOK_STOREDASDIRS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:720:7: KW_STORED KW_AS KW_DIRECTORIES
            {
            KW_STORED66=(Token)match(input,KW_STORED,FOLLOW_KW_STORED_in_storedAsDirs1803);  
            stream_KW_STORED.add(KW_STORED66);


            KW_AS67=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_storedAsDirs1805);  
            stream_KW_AS.add(KW_AS67);


            KW_DIRECTORIES68=(Token)match(input,KW_DIRECTORIES,FOLLOW_KW_DIRECTORIES_in_storedAsDirs1807);  
            stream_KW_DIRECTORIES.add(KW_DIRECTORIES68);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 721:5: -> ^( TOK_STOREDASDIRS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:721:8: ^( TOK_STOREDASDIRS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_STOREDASDIRS, "TOK_STOREDASDIRS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "storedAsDirs"


    public static class orReplace_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orReplace"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:724:1: orReplace : KW_OR KW_REPLACE -> ^( TOK_ORREPLACE ) ;
    public final HiveParser.orReplace_return orReplace() throws RecognitionException {
        HiveParser.orReplace_return retval = new HiveParser.orReplace_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_OR69=null;
        Token KW_REPLACE70=null;

        CommonTree KW_OR69_tree=null;
        CommonTree KW_REPLACE70_tree=null;
        RewriteRuleTokenStream stream_KW_REPLACE=new RewriteRuleTokenStream(adaptor,"token KW_REPLACE");
        RewriteRuleTokenStream stream_KW_OR=new RewriteRuleTokenStream(adaptor,"token KW_OR");

         pushMsg("or replace clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:727:5: ( KW_OR KW_REPLACE -> ^( TOK_ORREPLACE ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:727:7: KW_OR KW_REPLACE
            {
            KW_OR69=(Token)match(input,KW_OR,FOLLOW_KW_OR_in_orReplace1844);  
            stream_KW_OR.add(KW_OR69);


            KW_REPLACE70=(Token)match(input,KW_REPLACE,FOLLOW_KW_REPLACE_in_orReplace1846);  
            stream_KW_REPLACE.add(KW_REPLACE70);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 728:5: -> ^( TOK_ORREPLACE )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:728:8: ^( TOK_ORREPLACE )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ORREPLACE, "TOK_ORREPLACE")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orReplace"


    public static class ignoreProtection_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ignoreProtection"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:731:1: ignoreProtection : KW_IGNORE KW_PROTECTION -> ^( TOK_IGNOREPROTECTION ) ;
    public final HiveParser.ignoreProtection_return ignoreProtection() throws RecognitionException {
        HiveParser.ignoreProtection_return retval = new HiveParser.ignoreProtection_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IGNORE71=null;
        Token KW_PROTECTION72=null;

        CommonTree KW_IGNORE71_tree=null;
        CommonTree KW_PROTECTION72_tree=null;
        RewriteRuleTokenStream stream_KW_PROTECTION=new RewriteRuleTokenStream(adaptor,"token KW_PROTECTION");
        RewriteRuleTokenStream stream_KW_IGNORE=new RewriteRuleTokenStream(adaptor,"token KW_IGNORE");

         pushMsg("ignore protection clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:9: ( KW_IGNORE KW_PROTECTION -> ^( TOK_IGNOREPROTECTION ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:11: KW_IGNORE KW_PROTECTION
            {
            KW_IGNORE71=(Token)match(input,KW_IGNORE,FOLLOW_KW_IGNORE_in_ignoreProtection1887);  
            stream_KW_IGNORE.add(KW_IGNORE71);


            KW_PROTECTION72=(Token)match(input,KW_PROTECTION,FOLLOW_KW_PROTECTION_in_ignoreProtection1889);  
            stream_KW_PROTECTION.add(KW_PROTECTION72);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 735:9: -> ^( TOK_IGNOREPROTECTION )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:735:12: ^( TOK_IGNOREPROTECTION )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IGNOREPROTECTION, "TOK_IGNOREPROTECTION")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ignoreProtection"


    public static class createDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:738:1: createDatabaseStatement : KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )? -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? ) ;
    public final HiveParser.createDatabaseStatement_return createDatabaseStatement() throws RecognitionException {
        HiveParser.createDatabaseStatement_return retval = new HiveParser.createDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE73=null;
        Token KW_DATABASE74=null;
        Token KW_SCHEMA75=null;
        Token KW_WITH79=null;
        Token KW_DBPROPERTIES80=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.dbProperties_return dbprops =null;

        HiveParser.ifNotExists_return ifNotExists76 =null;

        HiveParser.databaseComment_return databaseComment77 =null;

        HiveParser.dbLocation_return dbLocation78 =null;


        CommonTree KW_CREATE73_tree=null;
        CommonTree KW_DATABASE74_tree=null;
        CommonTree KW_SCHEMA75_tree=null;
        CommonTree KW_WITH79_tree=null;
        CommonTree KW_DBPROPERTIES80_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_DBPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_DBPROPERTIES");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleSubtreeStream stream_dbProperties=new RewriteRuleSubtreeStream(adaptor,"rule dbProperties");
        RewriteRuleSubtreeStream stream_dbLocation=new RewriteRuleSubtreeStream(adaptor,"rule dbLocation");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_databaseComment=new RewriteRuleSubtreeStream(adaptor,"rule databaseComment");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("create database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:5: ( KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )? -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:7: KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )?
            {
            KW_CREATE73=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createDatabaseStatement1934);  
            stream_KW_CREATE.add(KW_CREATE73);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:17: ( KW_DATABASE | KW_SCHEMA )
            int alt11=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt11=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt11=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;

            }

            switch (alt11) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:18: KW_DATABASE
                    {
                    KW_DATABASE74=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_createDatabaseStatement1937);  
                    stream_KW_DATABASE.add(KW_DATABASE74);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:30: KW_SCHEMA
                    {
                    KW_SCHEMA75=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_createDatabaseStatement1939);  
                    stream_KW_SCHEMA.add(KW_SCHEMA75);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:742:9: ( ifNotExists )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:742:9: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createDatabaseStatement1950);
                    ifNotExists76=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists76.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_createDatabaseStatement1963);
            name=identifier();

            state._fsp--;

            stream_identifier.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:744:9: ( databaseComment )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:744:9: databaseComment
                    {
                    pushFollow(FOLLOW_databaseComment_in_createDatabaseStatement1973);
                    databaseComment77=databaseComment();

                    state._fsp--;

                    stream_databaseComment.add(databaseComment77.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:745:9: ( dbLocation )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:745:9: dbLocation
                    {
                    pushFollow(FOLLOW_dbLocation_in_createDatabaseStatement1984);
                    dbLocation78=dbLocation();

                    state._fsp--;

                    stream_dbLocation.add(dbLocation78.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:746:9: ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:746:10: KW_WITH KW_DBPROPERTIES dbprops= dbProperties
                    {
                    KW_WITH79=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_createDatabaseStatement1996);  
                    stream_KW_WITH.add(KW_WITH79);


                    KW_DBPROPERTIES80=(Token)match(input,KW_DBPROPERTIES,FOLLOW_KW_DBPROPERTIES_in_createDatabaseStatement1998);  
                    stream_KW_DBPROPERTIES.add(KW_DBPROPERTIES80);


                    pushFollow(FOLLOW_dbProperties_in_createDatabaseStatement2002);
                    dbprops=dbProperties();

                    state._fsp--;

                    stream_dbProperties.add(dbprops.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: databaseComment, dbLocation, name, dbprops, ifNotExists
            // token labels: 
            // rule labels: retval, name, dbprops
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_dbprops=new RewriteRuleSubtreeStream(adaptor,"rule dbprops",dbprops!=null?dbprops.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 747:5: -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:747:8: ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEDATABASE, "TOK_CREATEDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:747:35: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:747:48: ( dbLocation )?
                if ( stream_dbLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_dbLocation.nextTree());

                }
                stream_dbLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:747:60: ( databaseComment )?
                if ( stream_databaseComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_databaseComment.nextTree());

                }
                stream_databaseComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:747:78: ( $dbprops)?
                if ( stream_dbprops.hasNext() ) {
                    adaptor.addChild(root_1, stream_dbprops.nextTree());

                }
                stream_dbprops.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createDatabaseStatement"


    public static class dbLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:750:1: dbLocation : KW_LOCATION locn= StringLiteral -> ^( TOK_DATABASELOCATION $locn) ;
    public final HiveParser.dbLocation_return dbLocation() throws RecognitionException {
        HiveParser.dbLocation_return retval = new HiveParser.dbLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token locn=null;
        Token KW_LOCATION81=null;

        CommonTree locn_tree=null;
        CommonTree KW_LOCATION81_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

         pushMsg("database location specification", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:753:5: ( KW_LOCATION locn= StringLiteral -> ^( TOK_DATABASELOCATION $locn) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:754:7: KW_LOCATION locn= StringLiteral
            {
            KW_LOCATION81=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_dbLocation2063);  
            stream_KW_LOCATION.add(KW_LOCATION81);


            locn=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_dbLocation2067);  
            stream_StringLiteral.add(locn);


            // AST REWRITE
            // elements: locn
            // token labels: locn
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_locn=new RewriteRuleTokenStream(adaptor,"token locn",locn);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 754:38: -> ^( TOK_DATABASELOCATION $locn)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:754:41: ^( TOK_DATABASELOCATION $locn)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASELOCATION, "TOK_DATABASELOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_locn.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbLocation"


    public static class dbProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:757:1: dbProperties : LPAREN dbPropertiesList RPAREN -> ^( TOK_DATABASEPROPERTIES dbPropertiesList ) ;
    public final HiveParser.dbProperties_return dbProperties() throws RecognitionException {
        HiveParser.dbProperties_return retval = new HiveParser.dbProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN82=null;
        Token RPAREN84=null;
        HiveParser.dbPropertiesList_return dbPropertiesList83 =null;


        CommonTree LPAREN82_tree=null;
        CommonTree RPAREN84_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_dbPropertiesList=new RewriteRuleSubtreeStream(adaptor,"rule dbPropertiesList");
         pushMsg("dbproperties", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:760:5: ( LPAREN dbPropertiesList RPAREN -> ^( TOK_DATABASEPROPERTIES dbPropertiesList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:761:7: LPAREN dbPropertiesList RPAREN
            {
            LPAREN82=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_dbProperties2109);  
            stream_LPAREN.add(LPAREN82);


            pushFollow(FOLLOW_dbPropertiesList_in_dbProperties2111);
            dbPropertiesList83=dbPropertiesList();

            state._fsp--;

            stream_dbPropertiesList.add(dbPropertiesList83.getTree());

            RPAREN84=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_dbProperties2113);  
            stream_RPAREN.add(RPAREN84);


            // AST REWRITE
            // elements: dbPropertiesList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 761:38: -> ^( TOK_DATABASEPROPERTIES dbPropertiesList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:761:41: ^( TOK_DATABASEPROPERTIES dbPropertiesList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASEPROPERTIES, "TOK_DATABASEPROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_dbPropertiesList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbProperties"


    public static class dbPropertiesList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbPropertiesList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:764:1: dbPropertiesList : keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_DBPROPLIST ( keyValueProperty )+ ) ;
    public final HiveParser.dbPropertiesList_return dbPropertiesList() throws RecognitionException {
        HiveParser.dbPropertiesList_return retval = new HiveParser.dbPropertiesList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA86=null;
        HiveParser.keyValueProperty_return keyValueProperty85 =null;

        HiveParser.keyValueProperty_return keyValueProperty87 =null;


        CommonTree COMMA86_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_keyValueProperty=new RewriteRuleSubtreeStream(adaptor,"rule keyValueProperty");
         pushMsg("database properties list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:767:5: ( keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_DBPROPLIST ( keyValueProperty )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:768:7: keyValueProperty ( COMMA keyValueProperty )*
            {
            pushFollow(FOLLOW_keyValueProperty_in_dbPropertiesList2154);
            keyValueProperty85=keyValueProperty();

            state._fsp--;

            stream_keyValueProperty.add(keyValueProperty85.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:768:24: ( COMMA keyValueProperty )*
            loop16:
            do {
                int alt16=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt16=1;
                    }
                    break;

                }

                switch (alt16) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:768:25: COMMA keyValueProperty
            	    {
            	    COMMA86=(Token)match(input,COMMA,FOLLOW_COMMA_in_dbPropertiesList2157);  
            	    stream_COMMA.add(COMMA86);


            	    pushFollow(FOLLOW_keyValueProperty_in_dbPropertiesList2159);
            	    keyValueProperty87=keyValueProperty();

            	    state._fsp--;

            	    stream_keyValueProperty.add(keyValueProperty87.getTree());

            	    }
            	    break;

            	default :
            	    break loop16;
                }
            } while (true);


            // AST REWRITE
            // elements: keyValueProperty
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 768:50: -> ^( TOK_DBPROPLIST ( keyValueProperty )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:768:53: ^( TOK_DBPROPLIST ( keyValueProperty )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DBPROPLIST, "TOK_DBPROPLIST")
                , root_1);

                if ( !(stream_keyValueProperty.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_keyValueProperty.hasNext() ) {
                    adaptor.addChild(root_1, stream_keyValueProperty.nextTree());

                }
                stream_keyValueProperty.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbPropertiesList"


    public static class switchDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "switchDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:772:1: switchDatabaseStatement : KW_USE identifier -> ^( TOK_SWITCHDATABASE identifier ) ;
    public final HiveParser.switchDatabaseStatement_return switchDatabaseStatement() throws RecognitionException {
        HiveParser.switchDatabaseStatement_return retval = new HiveParser.switchDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_USE88=null;
        HiveParser_IdentifiersParser.identifier_return identifier89 =null;


        CommonTree KW_USE88_tree=null;
        RewriteRuleTokenStream stream_KW_USE=new RewriteRuleTokenStream(adaptor,"token KW_USE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("switch database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:775:5: ( KW_USE identifier -> ^( TOK_SWITCHDATABASE identifier ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:775:7: KW_USE identifier
            {
            KW_USE88=(Token)match(input,KW_USE,FOLLOW_KW_USE_in_switchDatabaseStatement2198);  
            stream_KW_USE.add(KW_USE88);


            pushFollow(FOLLOW_identifier_in_switchDatabaseStatement2200);
            identifier89=identifier();

            state._fsp--;

            stream_identifier.add(identifier89.getTree());

            // AST REWRITE
            // elements: identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 776:5: -> ^( TOK_SWITCHDATABASE identifier )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:776:8: ^( TOK_SWITCHDATABASE identifier )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SWITCHDATABASE, "TOK_SWITCHDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "switchDatabaseStatement"


    public static class dropDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:779:1: dropDatabaseStatement : KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )? -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? ) ;
    public final HiveParser.dropDatabaseStatement_return dropDatabaseStatement() throws RecognitionException {
        HiveParser.dropDatabaseStatement_return retval = new HiveParser.dropDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP90=null;
        Token KW_DATABASE91=null;
        Token KW_SCHEMA92=null;
        HiveParser.ifExists_return ifExists93 =null;

        HiveParser_IdentifiersParser.identifier_return identifier94 =null;

        HiveParser.restrictOrCascade_return restrictOrCascade95 =null;


        CommonTree KW_DROP90_tree=null;
        CommonTree KW_DATABASE91_tree=null;
        CommonTree KW_SCHEMA92_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleSubtreeStream stream_restrictOrCascade=new RewriteRuleSubtreeStream(adaptor,"rule restrictOrCascade");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("drop database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:5: ( KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )? -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:7: KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )?
            {
            KW_DROP90=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropDatabaseStatement2239);  
            stream_KW_DROP.add(KW_DROP90);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:15: ( KW_DATABASE | KW_SCHEMA )
            int alt17=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt17=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt17=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;

            }

            switch (alt17) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:16: KW_DATABASE
                    {
                    KW_DATABASE91=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_dropDatabaseStatement2242);  
                    stream_KW_DATABASE.add(KW_DATABASE91);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:28: KW_SCHEMA
                    {
                    KW_SCHEMA92=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_dropDatabaseStatement2244);  
                    stream_KW_SCHEMA.add(KW_SCHEMA92);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:39: ( ifExists )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:39: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropDatabaseStatement2247);
                    ifExists93=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists93.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropDatabaseStatement2250);
            identifier94=identifier();

            state._fsp--;

            stream_identifier.add(identifier94.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:60: ( restrictOrCascade )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case KW_CASCADE:
                case KW_RESTRICT:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:60: restrictOrCascade
                    {
                    pushFollow(FOLLOW_restrictOrCascade_in_dropDatabaseStatement2252);
                    restrictOrCascade95=restrictOrCascade();

                    state._fsp--;

                    stream_restrictOrCascade.add(restrictOrCascade95.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: restrictOrCascade, ifExists, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 783:5: -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:783:8: ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPDATABASE, "TOK_DROPDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:783:38: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:783:48: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropDatabaseStatement"


    public static class databaseComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "databaseComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:786:1: databaseComment : KW_COMMENT comment= StringLiteral -> ^( TOK_DATABASECOMMENT $comment) ;
    public final HiveParser.databaseComment_return databaseComment() throws RecognitionException {
        HiveParser.databaseComment_return retval = new HiveParser.databaseComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT96=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT96_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         pushMsg("database's comment", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:789:5: ( KW_COMMENT comment= StringLiteral -> ^( TOK_DATABASECOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:789:7: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT96=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_databaseComment2298);  
            stream_KW_COMMENT.add(KW_COMMENT96);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_databaseComment2302);  
            stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 790:5: -> ^( TOK_DATABASECOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:790:8: ^( TOK_DATABASECOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASECOMMENT, "TOK_DATABASECOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "databaseComment"


    public static class createTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:793:1: createTableStatement : KW_CREATE (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? ) -> ^( TOK_CREATETABLE $name ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? ) ;
    public final HiveParser.createTableStatement_return createTableStatement() throws RecognitionException {
        HiveParser.createTableStatement_return retval = new HiveParser.createTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token ext=null;
        Token like=null;
        Token KW_CREATE97=null;
        Token KW_TABLE98=null;
        Token LPAREN102=null;
        Token RPAREN104=null;
        Token KW_AS113=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser_FromClauseParser.tableName_return likeName =null;

        HiveParser.ifNotExists_return ifNotExists99 =null;

        HiveParser.tableLocation_return tableLocation100 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed101 =null;

        HiveParser.columnNameTypeList_return columnNameTypeList103 =null;

        HiveParser.tableComment_return tableComment105 =null;

        HiveParser.tablePartition_return tablePartition106 =null;

        HiveParser.tableBuckets_return tableBuckets107 =null;

        HiveParser.tableSkewed_return tableSkewed108 =null;

        HiveParser.tableRowFormat_return tableRowFormat109 =null;

        HiveParser.tableFileFormat_return tableFileFormat110 =null;

        HiveParser.tableLocation_return tableLocation111 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed112 =null;

        HiveParser.selectStatementWithCTE_return selectStatementWithCTE114 =null;


        CommonTree ext_tree=null;
        CommonTree like_tree=null;
        CommonTree KW_CREATE97_tree=null;
        CommonTree KW_TABLE98_tree=null;
        CommonTree LPAREN102_tree=null;
        CommonTree RPAREN104_tree=null;
        CommonTree KW_AS113_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_LIKE=new RewriteRuleTokenStream(adaptor,"token KW_LIKE");
        RewriteRuleTokenStream stream_KW_EXTERNAL=new RewriteRuleTokenStream(adaptor,"token KW_EXTERNAL");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_selectStatementWithCTE=new RewriteRuleSubtreeStream(adaptor,"rule selectStatementWithCTE");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
        RewriteRuleSubtreeStream stream_tableBuckets=new RewriteRuleSubtreeStream(adaptor,"rule tableBuckets");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_tablePartition=new RewriteRuleSubtreeStream(adaptor,"rule tablePartition");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_tableComment=new RewriteRuleSubtreeStream(adaptor,"rule tableComment");
        RewriteRuleSubtreeStream stream_tableRowFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableRowFormat");
        RewriteRuleSubtreeStream stream_tableFileFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableFileFormat");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_tableSkewed=new RewriteRuleSubtreeStream(adaptor,"rule tableSkewed");
         pushMsg("create table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:5: ( KW_CREATE (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? ) -> ^( TOK_CREATETABLE $name ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:7: KW_CREATE (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? )
            {
            KW_CREATE97=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createTableStatement2342);  
            stream_KW_CREATE.add(KW_CREATE97);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:17: (ext= KW_EXTERNAL )?
            int alt20=2;
            switch ( input.LA(1) ) {
                case KW_EXTERNAL:
                    {
                    alt20=1;
                    }
                    break;
            }

            switch (alt20) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:18: ext= KW_EXTERNAL
                    {
                    ext=(Token)match(input,KW_EXTERNAL,FOLLOW_KW_EXTERNAL_in_createTableStatement2347);  
                    stream_KW_EXTERNAL.add(ext);


                    }
                    break;

            }


            KW_TABLE98=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_createTableStatement2351);  
            stream_KW_TABLE.add(KW_TABLE98);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:45: ( ifNotExists )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:45: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createTableStatement2353);
                    ifNotExists99=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists99.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_createTableStatement2358);
            name=tableName();

            state._fsp--;

            stream_tableName.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:797:7: (like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? )
            int alt34=2;
            switch ( input.LA(1) ) {
            case KW_LIKE:
                {
                alt34=1;
                }
                break;
            case EOF:
            case KW_AS:
            case KW_CLUSTERED:
            case KW_COMMENT:
            case KW_LOCATION:
            case KW_PARTITIONED:
            case KW_ROW:
            case KW_SKEWED:
            case KW_STORED:
            case KW_TBLPROPERTIES:
            case LPAREN:
                {
                alt34=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;

            }

            switch (alt34) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:797:10: like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )?
                    {
                    like=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_createTableStatement2371);  
                    stream_KW_LIKE.add(like);


                    pushFollow(FOLLOW_tableName_in_createTableStatement2375);
                    likeName=tableName();

                    state._fsp--;

                    stream_tableName.add(likeName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:798:10: ( tableLocation )?
                    int alt22=2;
                    switch ( input.LA(1) ) {
                        case KW_LOCATION:
                            {
                            alt22=1;
                            }
                            break;
                    }

                    switch (alt22) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:798:10: tableLocation
                            {
                            pushFollow(FOLLOW_tableLocation_in_createTableStatement2386);
                            tableLocation100=tableLocation();

                            state._fsp--;

                            stream_tableLocation.add(tableLocation100.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:799:10: ( tablePropertiesPrefixed )?
                    int alt23=2;
                    switch ( input.LA(1) ) {
                        case KW_TBLPROPERTIES:
                            {
                            alt23=1;
                            }
                            break;
                    }

                    switch (alt23) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:799:10: tablePropertiesPrefixed
                            {
                            pushFollow(FOLLOW_tablePropertiesPrefixed_in_createTableStatement2398);
                            tablePropertiesPrefixed101=tablePropertiesPrefixed();

                            state._fsp--;

                            stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed101.getTree());

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:800:10: ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )?
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:800:10: ( LPAREN columnNameTypeList RPAREN )?
                    int alt24=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt24=1;
                            }
                            break;
                    }

                    switch (alt24) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:800:11: LPAREN columnNameTypeList RPAREN
                            {
                            LPAREN102=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createTableStatement2411);  
                            stream_LPAREN.add(LPAREN102);


                            pushFollow(FOLLOW_columnNameTypeList_in_createTableStatement2413);
                            columnNameTypeList103=columnNameTypeList();

                            state._fsp--;

                            stream_columnNameTypeList.add(columnNameTypeList103.getTree());

                            RPAREN104=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createTableStatement2415);  
                            stream_RPAREN.add(RPAREN104);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:801:10: ( tableComment )?
                    int alt25=2;
                    switch ( input.LA(1) ) {
                        case KW_COMMENT:
                            {
                            alt25=1;
                            }
                            break;
                    }

                    switch (alt25) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:801:10: tableComment
                            {
                            pushFollow(FOLLOW_tableComment_in_createTableStatement2428);
                            tableComment105=tableComment();

                            state._fsp--;

                            stream_tableComment.add(tableComment105.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:802:10: ( tablePartition )?
                    int alt26=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITIONED:
                            {
                            alt26=1;
                            }
                            break;
                    }

                    switch (alt26) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:802:10: tablePartition
                            {
                            pushFollow(FOLLOW_tablePartition_in_createTableStatement2440);
                            tablePartition106=tablePartition();

                            state._fsp--;

                            stream_tablePartition.add(tablePartition106.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:803:10: ( tableBuckets )?
                    int alt27=2;
                    switch ( input.LA(1) ) {
                        case KW_CLUSTERED:
                            {
                            alt27=1;
                            }
                            break;
                    }

                    switch (alt27) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:803:10: tableBuckets
                            {
                            pushFollow(FOLLOW_tableBuckets_in_createTableStatement2452);
                            tableBuckets107=tableBuckets();

                            state._fsp--;

                            stream_tableBuckets.add(tableBuckets107.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:804:10: ( tableSkewed )?
                    int alt28=2;
                    switch ( input.LA(1) ) {
                        case KW_SKEWED:
                            {
                            alt28=1;
                            }
                            break;
                    }

                    switch (alt28) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:804:10: tableSkewed
                            {
                            pushFollow(FOLLOW_tableSkewed_in_createTableStatement2464);
                            tableSkewed108=tableSkewed();

                            state._fsp--;

                            stream_tableSkewed.add(tableSkewed108.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:805:10: ( tableRowFormat )?
                    int alt29=2;
                    switch ( input.LA(1) ) {
                        case KW_ROW:
                            {
                            alt29=1;
                            }
                            break;
                    }

                    switch (alt29) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:805:10: tableRowFormat
                            {
                            pushFollow(FOLLOW_tableRowFormat_in_createTableStatement2476);
                            tableRowFormat109=tableRowFormat();

                            state._fsp--;

                            stream_tableRowFormat.add(tableRowFormat109.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:806:10: ( tableFileFormat )?
                    int alt30=2;
                    switch ( input.LA(1) ) {
                        case KW_STORED:
                            {
                            alt30=1;
                            }
                            break;
                    }

                    switch (alt30) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:806:10: tableFileFormat
                            {
                            pushFollow(FOLLOW_tableFileFormat_in_createTableStatement2488);
                            tableFileFormat110=tableFileFormat();

                            state._fsp--;

                            stream_tableFileFormat.add(tableFileFormat110.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:807:10: ( tableLocation )?
                    int alt31=2;
                    switch ( input.LA(1) ) {
                        case KW_LOCATION:
                            {
                            alt31=1;
                            }
                            break;
                    }

                    switch (alt31) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:807:10: tableLocation
                            {
                            pushFollow(FOLLOW_tableLocation_in_createTableStatement2500);
                            tableLocation111=tableLocation();

                            state._fsp--;

                            stream_tableLocation.add(tableLocation111.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:808:10: ( tablePropertiesPrefixed )?
                    int alt32=2;
                    switch ( input.LA(1) ) {
                        case KW_TBLPROPERTIES:
                            {
                            alt32=1;
                            }
                            break;
                    }

                    switch (alt32) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:808:10: tablePropertiesPrefixed
                            {
                            pushFollow(FOLLOW_tablePropertiesPrefixed_in_createTableStatement2512);
                            tablePropertiesPrefixed112=tablePropertiesPrefixed();

                            state._fsp--;

                            stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed112.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:809:10: ( KW_AS selectStatementWithCTE )?
                    int alt33=2;
                    switch ( input.LA(1) ) {
                        case KW_AS:
                            {
                            alt33=1;
                            }
                            break;
                    }

                    switch (alt33) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:809:11: KW_AS selectStatementWithCTE
                            {
                            KW_AS113=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createTableStatement2525);  
                            stream_KW_AS.add(KW_AS113);


                            pushFollow(FOLLOW_selectStatementWithCTE_in_createTableStatement2527);
                            selectStatementWithCTE114=selectStatementWithCTE();

                            state._fsp--;

                            stream_selectStatementWithCTE.add(selectStatementWithCTE114.getTree());

                            }
                            break;

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: tableBuckets, name, tableLocation, selectStatementWithCTE, ext, tableFileFormat, columnNameTypeList, tableRowFormat, tablePropertiesPrefixed, tableComment, ifNotExists, tablePartition, tableSkewed, likeName
            // token labels: ext
            // rule labels: retval, likeName, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_ext=new RewriteRuleTokenStream(adaptor,"token ext",ext);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_likeName=new RewriteRuleSubtreeStream(adaptor,"rule likeName",likeName!=null?likeName.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 811:5: -> ^( TOK_CREATETABLE $name ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:811:8: ^( TOK_CREATETABLE $name ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATETABLE, "TOK_CREATETABLE")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:811:33: ( $ext)?
                if ( stream_ext.hasNext() ) {
                    adaptor.addChild(root_1, stream_ext.nextNode());

                }
                stream_ext.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:811:38: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:812:10: ^( TOK_LIKETABLE ( $likeName)? )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LIKETABLE, "TOK_LIKETABLE")
                , root_2);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:812:27: ( $likeName)?
                if ( stream_likeName.hasNext() ) {
                    adaptor.addChild(root_2, stream_likeName.nextTree());

                }
                stream_likeName.reset();

                adaptor.addChild(root_1, root_2);
                }

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:813:10: ( columnNameTypeList )?
                if ( stream_columnNameTypeList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                }
                stream_columnNameTypeList.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:814:10: ( tableComment )?
                if ( stream_tableComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableComment.nextTree());

                }
                stream_tableComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:815:10: ( tablePartition )?
                if ( stream_tablePartition.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePartition.nextTree());

                }
                stream_tablePartition.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:816:10: ( tableBuckets )?
                if ( stream_tableBuckets.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableBuckets.nextTree());

                }
                stream_tableBuckets.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:817:10: ( tableSkewed )?
                if ( stream_tableSkewed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableSkewed.nextTree());

                }
                stream_tableSkewed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:818:10: ( tableRowFormat )?
                if ( stream_tableRowFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableRowFormat.nextTree());

                }
                stream_tableRowFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:819:10: ( tableFileFormat )?
                if ( stream_tableFileFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableFileFormat.nextTree());

                }
                stream_tableFileFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:820:10: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:821:10: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:822:10: ( selectStatementWithCTE )?
                if ( stream_selectStatementWithCTE.hasNext() ) {
                    adaptor.addChild(root_1, stream_selectStatementWithCTE.nextTree());

                }
                stream_selectStatementWithCTE.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createTableStatement"


    public static class truncateTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "truncateTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:826:1: truncateTableStatement : KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )? -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? ) ;
    public final HiveParser.truncateTableStatement_return truncateTableStatement() throws RecognitionException {
        HiveParser.truncateTableStatement_return retval = new HiveParser.truncateTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_TRUNCATE115=null;
        Token KW_TABLE116=null;
        Token KW_COLUMNS118=null;
        Token LPAREN119=null;
        Token RPAREN121=null;
        HiveParser.tablePartitionPrefix_return tablePartitionPrefix117 =null;

        HiveParser.columnNameList_return columnNameList120 =null;


        CommonTree KW_TRUNCATE115_tree=null;
        CommonTree KW_TABLE116_tree=null;
        CommonTree KW_COLUMNS118_tree=null;
        CommonTree LPAREN119_tree=null;
        CommonTree RPAREN121_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_TRUNCATE=new RewriteRuleTokenStream(adaptor,"token KW_TRUNCATE");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_tablePartitionPrefix=new RewriteRuleSubtreeStream(adaptor,"rule tablePartitionPrefix");
         pushMsg("truncate table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:5: ( KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )? -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:7: KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )?
            {
            KW_TRUNCATE115=(Token)match(input,KW_TRUNCATE,FOLLOW_KW_TRUNCATE_in_truncateTableStatement2730);  
            stream_KW_TRUNCATE.add(KW_TRUNCATE115);


            KW_TABLE116=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_truncateTableStatement2732);  
            stream_KW_TABLE.add(KW_TABLE116);


            pushFollow(FOLLOW_tablePartitionPrefix_in_truncateTableStatement2734);
            tablePartitionPrefix117=tablePartitionPrefix();

            state._fsp--;

            stream_tablePartitionPrefix.add(tablePartitionPrefix117.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:49: ( KW_COLUMNS LPAREN columnNameList RPAREN )?
            int alt35=2;
            switch ( input.LA(1) ) {
                case KW_COLUMNS:
                    {
                    alt35=1;
                    }
                    break;
            }

            switch (alt35) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:50: KW_COLUMNS LPAREN columnNameList RPAREN
                    {
                    KW_COLUMNS118=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_truncateTableStatement2737);  
                    stream_KW_COLUMNS.add(KW_COLUMNS118);


                    LPAREN119=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_truncateTableStatement2739);  
                    stream_LPAREN.add(LPAREN119);


                    pushFollow(FOLLOW_columnNameList_in_truncateTableStatement2741);
                    columnNameList120=columnNameList();

                    state._fsp--;

                    stream_columnNameList.add(columnNameList120.getTree());

                    RPAREN121=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_truncateTableStatement2743);  
                    stream_RPAREN.add(RPAREN121);


                    }
                    break;

            }


            // AST REWRITE
            // elements: tablePartitionPrefix, columnNameList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 829:92: -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:95: ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TRUNCATETABLE, "TOK_TRUNCATETABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tablePartitionPrefix.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:136: ( columnNameList )?
                if ( stream_columnNameList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameList.nextTree());

                }
                stream_columnNameList.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "truncateTableStatement"


    public static class createIndexStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createIndexStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:831:1: createIndexStatement : KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? ) ;
    public final HiveParser.createIndexStatement_return createIndexStatement() throws RecognitionException {
        HiveParser.createIndexStatement_return retval = new HiveParser.createIndexStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token typeName=null;
        Token KW_CREATE122=null;
        Token KW_INDEX123=null;
        Token KW_ON124=null;
        Token KW_TABLE125=null;
        Token LPAREN126=null;
        Token RPAREN127=null;
        Token KW_AS128=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tab =null;

        HiveParser.columnNameList_return indexedCols =null;

        HiveParser.autoRebuild_return autoRebuild129 =null;

        HiveParser.indexPropertiesPrefixed_return indexPropertiesPrefixed130 =null;

        HiveParser.indexTblName_return indexTblName131 =null;

        HiveParser.tableRowFormat_return tableRowFormat132 =null;

        HiveParser.tableFileFormat_return tableFileFormat133 =null;

        HiveParser.tableLocation_return tableLocation134 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed135 =null;

        HiveParser.indexComment_return indexComment136 =null;


        CommonTree typeName_tree=null;
        CommonTree KW_CREATE122_tree=null;
        CommonTree KW_INDEX123_tree=null;
        CommonTree KW_ON124_tree=null;
        CommonTree KW_TABLE125_tree=null;
        CommonTree LPAREN126_tree=null;
        CommonTree RPAREN127_tree=null;
        CommonTree KW_AS128_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_indexPropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule indexPropertiesPrefixed");
        RewriteRuleSubtreeStream stream_tableRowFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableRowFormat");
        RewriteRuleSubtreeStream stream_tableFileFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableFileFormat");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_autoRebuild=new RewriteRuleSubtreeStream(adaptor,"rule autoRebuild");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_indexTblName=new RewriteRuleSubtreeStream(adaptor,"rule indexTblName");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_indexComment=new RewriteRuleSubtreeStream(adaptor,"rule indexComment");
         pushMsg("create index statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:834:5: ( KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:834:7: KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )?
            {
            KW_CREATE122=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createIndexStatement2778);  
            stream_KW_CREATE.add(KW_CREATE122);


            KW_INDEX123=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_createIndexStatement2780);  
            stream_KW_INDEX.add(KW_INDEX123);


            pushFollow(FOLLOW_identifier_in_createIndexStatement2784);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            KW_ON124=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_createIndexStatement2792);  
            stream_KW_ON.add(KW_ON124);


            KW_TABLE125=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_createIndexStatement2794);  
            stream_KW_TABLE.add(KW_TABLE125);


            pushFollow(FOLLOW_tableName_in_createIndexStatement2798);
            tab=tableName();

            state._fsp--;

            stream_tableName.add(tab.getTree());

            LPAREN126=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createIndexStatement2800);  
            stream_LPAREN.add(LPAREN126);


            pushFollow(FOLLOW_columnNameList_in_createIndexStatement2804);
            indexedCols=columnNameList();

            state._fsp--;

            stream_columnNameList.add(indexedCols.getTree());

            RPAREN127=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createIndexStatement2806);  
            stream_RPAREN.add(RPAREN127);


            KW_AS128=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createIndexStatement2814);  
            stream_KW_AS.add(KW_AS128);


            typeName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_createIndexStatement2818);  
            stream_StringLiteral.add(typeName);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:837:7: ( autoRebuild )?
            int alt36=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt36=1;
                    }
                    break;
            }

            switch (alt36) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:837:7: autoRebuild
                    {
                    pushFollow(FOLLOW_autoRebuild_in_createIndexStatement2826);
                    autoRebuild129=autoRebuild();

                    state._fsp--;

                    stream_autoRebuild.add(autoRebuild129.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:838:7: ( indexPropertiesPrefixed )?
            int alt37=2;
            switch ( input.LA(1) ) {
                case KW_IDXPROPERTIES:
                    {
                    alt37=1;
                    }
                    break;
            }

            switch (alt37) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:838:7: indexPropertiesPrefixed
                    {
                    pushFollow(FOLLOW_indexPropertiesPrefixed_in_createIndexStatement2835);
                    indexPropertiesPrefixed130=indexPropertiesPrefixed();

                    state._fsp--;

                    stream_indexPropertiesPrefixed.add(indexPropertiesPrefixed130.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:839:7: ( indexTblName )?
            int alt38=2;
            switch ( input.LA(1) ) {
                case KW_IN:
                    {
                    alt38=1;
                    }
                    break;
            }

            switch (alt38) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:839:7: indexTblName
                    {
                    pushFollow(FOLLOW_indexTblName_in_createIndexStatement2844);
                    indexTblName131=indexTblName();

                    state._fsp--;

                    stream_indexTblName.add(indexTblName131.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:840:7: ( tableRowFormat )?
            int alt39=2;
            switch ( input.LA(1) ) {
                case KW_ROW:
                    {
                    alt39=1;
                    }
                    break;
            }

            switch (alt39) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:840:7: tableRowFormat
                    {
                    pushFollow(FOLLOW_tableRowFormat_in_createIndexStatement2853);
                    tableRowFormat132=tableRowFormat();

                    state._fsp--;

                    stream_tableRowFormat.add(tableRowFormat132.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:841:7: ( tableFileFormat )?
            int alt40=2;
            switch ( input.LA(1) ) {
                case KW_STORED:
                    {
                    alt40=1;
                    }
                    break;
            }

            switch (alt40) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:841:7: tableFileFormat
                    {
                    pushFollow(FOLLOW_tableFileFormat_in_createIndexStatement2862);
                    tableFileFormat133=tableFileFormat();

                    state._fsp--;

                    stream_tableFileFormat.add(tableFileFormat133.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:842:7: ( tableLocation )?
            int alt41=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt41=1;
                    }
                    break;
            }

            switch (alt41) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:842:7: tableLocation
                    {
                    pushFollow(FOLLOW_tableLocation_in_createIndexStatement2871);
                    tableLocation134=tableLocation();

                    state._fsp--;

                    stream_tableLocation.add(tableLocation134.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:843:7: ( tablePropertiesPrefixed )?
            int alt42=2;
            switch ( input.LA(1) ) {
                case KW_TBLPROPERTIES:
                    {
                    alt42=1;
                    }
                    break;
            }

            switch (alt42) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:843:7: tablePropertiesPrefixed
                    {
                    pushFollow(FOLLOW_tablePropertiesPrefixed_in_createIndexStatement2880);
                    tablePropertiesPrefixed135=tablePropertiesPrefixed();

                    state._fsp--;

                    stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed135.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:844:7: ( indexComment )?
            int alt43=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt43=1;
                    }
                    break;
            }

            switch (alt43) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:844:7: indexComment
                    {
                    pushFollow(FOLLOW_indexComment_in_createIndexStatement2889);
                    indexComment136=indexComment();

                    state._fsp--;

                    stream_indexComment.add(indexComment136.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: indexName, indexPropertiesPrefixed, tableRowFormat, tablePropertiesPrefixed, tab, typeName, indexedCols, tableFileFormat, indexTblName, tableLocation, indexComment, autoRebuild
            // token labels: typeName
            // rule labels: indexedCols, retval, indexName, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_typeName=new RewriteRuleTokenStream(adaptor,"token typeName",typeName);
            RewriteRuleSubtreeStream stream_indexedCols=new RewriteRuleSubtreeStream(adaptor,"rule indexedCols",indexedCols!=null?indexedCols.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 845:5: -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:845:7: ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEINDEX, "TOK_CREATEINDEX")
                , root_1);

                adaptor.addChild(root_1, stream_indexName.nextTree());

                adaptor.addChild(root_1, stream_typeName.nextNode());

                adaptor.addChild(root_1, stream_tab.nextTree());

                adaptor.addChild(root_1, stream_indexedCols.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:846:9: ( autoRebuild )?
                if ( stream_autoRebuild.hasNext() ) {
                    adaptor.addChild(root_1, stream_autoRebuild.nextTree());

                }
                stream_autoRebuild.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:847:9: ( indexPropertiesPrefixed )?
                if ( stream_indexPropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexPropertiesPrefixed.nextTree());

                }
                stream_indexPropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:848:9: ( indexTblName )?
                if ( stream_indexTblName.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexTblName.nextTree());

                }
                stream_indexTblName.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:849:9: ( tableRowFormat )?
                if ( stream_tableRowFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableRowFormat.nextTree());

                }
                stream_tableRowFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:850:9: ( tableFileFormat )?
                if ( stream_tableFileFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableFileFormat.nextTree());

                }
                stream_tableFileFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:851:9: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:852:9: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:853:9: ( indexComment )?
                if ( stream_indexComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexComment.nextTree());

                }
                stream_indexComment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createIndexStatement"


    public static class indexComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:856:1: indexComment : KW_COMMENT comment= StringLiteral -> ^( TOK_INDEXCOMMENT $comment) ;
    public final HiveParser.indexComment_return indexComment() throws RecognitionException {
        HiveParser.indexComment_return retval = new HiveParser.indexComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT137=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT137_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         pushMsg("comment on an index", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:859:9: ( KW_COMMENT comment= StringLiteral -> ^( TOK_INDEXCOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:17: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT137=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_indexComment3046);  
            stream_KW_COMMENT.add(KW_COMMENT137);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_indexComment3050);  
            stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 860:51: -> ^( TOK_INDEXCOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:54: ^( TOK_INDEXCOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXCOMMENT, "TOK_INDEXCOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexComment"


    public static class autoRebuild_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "autoRebuild"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:1: autoRebuild : KW_WITH KW_DEFERRED KW_REBUILD -> ^( TOK_DEFERRED_REBUILDINDEX ) ;
    public final HiveParser.autoRebuild_return autoRebuild() throws RecognitionException {
        HiveParser.autoRebuild_return retval = new HiveParser.autoRebuild_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_WITH138=null;
        Token KW_DEFERRED139=null;
        Token KW_REBUILD140=null;

        CommonTree KW_WITH138_tree=null;
        CommonTree KW_DEFERRED139_tree=null;
        CommonTree KW_REBUILD140_tree=null;
        RewriteRuleTokenStream stream_KW_REBUILD=new RewriteRuleTokenStream(adaptor,"token KW_REBUILD");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_DEFERRED=new RewriteRuleTokenStream(adaptor,"token KW_DEFERRED");

         pushMsg("auto rebuild index", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:866:5: ( KW_WITH KW_DEFERRED KW_REBUILD -> ^( TOK_DEFERRED_REBUILDINDEX ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:866:7: KW_WITH KW_DEFERRED KW_REBUILD
            {
            KW_WITH138=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_autoRebuild3091);  
            stream_KW_WITH.add(KW_WITH138);


            KW_DEFERRED139=(Token)match(input,KW_DEFERRED,FOLLOW_KW_DEFERRED_in_autoRebuild3093);  
            stream_KW_DEFERRED.add(KW_DEFERRED139);


            KW_REBUILD140=(Token)match(input,KW_REBUILD,FOLLOW_KW_REBUILD_in_autoRebuild3095);  
            stream_KW_REBUILD.add(KW_REBUILD140);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 867:5: -> ^( TOK_DEFERRED_REBUILDINDEX )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:867:7: ^( TOK_DEFERRED_REBUILDINDEX )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DEFERRED_REBUILDINDEX, "TOK_DEFERRED_REBUILDINDEX")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "autoRebuild"


    public static class indexTblName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexTblName"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:870:1: indexTblName : KW_IN KW_TABLE indexTbl= tableName -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl) ;
    public final HiveParser.indexTblName_return indexTblName() throws RecognitionException {
        HiveParser.indexTblName_return retval = new HiveParser.indexTblName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IN141=null;
        Token KW_TABLE142=null;
        HiveParser_FromClauseParser.tableName_return indexTbl =null;


        CommonTree KW_IN141_tree=null;
        CommonTree KW_TABLE142_tree=null;
        RewriteRuleTokenStream stream_KW_IN=new RewriteRuleTokenStream(adaptor,"token KW_IN");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("index table name", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:873:5: ( KW_IN KW_TABLE indexTbl= tableName -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:873:7: KW_IN KW_TABLE indexTbl= tableName
            {
            KW_IN141=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_indexTblName3131);  
            stream_KW_IN.add(KW_IN141);


            KW_TABLE142=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_indexTblName3133);  
            stream_KW_TABLE.add(KW_TABLE142);


            pushFollow(FOLLOW_tableName_in_indexTblName3137);
            indexTbl=tableName();

            state._fsp--;

            stream_tableName.add(indexTbl.getTree());

            // AST REWRITE
            // elements: indexTbl
            // token labels: 
            // rule labels: retval, indexTbl
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexTbl=new RewriteRuleSubtreeStream(adaptor,"rule indexTbl",indexTbl!=null?indexTbl.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 874:5: -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:874:7: ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEINDEX_INDEXTBLNAME, "TOK_CREATEINDEX_INDEXTBLNAME")
                , root_1);

                adaptor.addChild(root_1, stream_indexTbl.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexTblName"


    public static class indexPropertiesPrefixed_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexPropertiesPrefixed"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:1: indexPropertiesPrefixed : KW_IDXPROPERTIES ! indexProperties ;
    public final HiveParser.indexPropertiesPrefixed_return indexPropertiesPrefixed() throws RecognitionException {
        HiveParser.indexPropertiesPrefixed_return retval = new HiveParser.indexPropertiesPrefixed_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IDXPROPERTIES143=null;
        HiveParser.indexProperties_return indexProperties144 =null;


        CommonTree KW_IDXPROPERTIES143_tree=null;

         pushMsg("table properties with prefix", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:880:5: ( KW_IDXPROPERTIES ! indexProperties )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:881:9: KW_IDXPROPERTIES ! indexProperties
            {
            root_0 = (CommonTree)adaptor.nil();


            KW_IDXPROPERTIES143=(Token)match(input,KW_IDXPROPERTIES,FOLLOW_KW_IDXPROPERTIES_in_indexPropertiesPrefixed3184); 

            pushFollow(FOLLOW_indexProperties_in_indexPropertiesPrefixed3187);
            indexProperties144=indexProperties();

            state._fsp--;

            adaptor.addChild(root_0, indexProperties144.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexPropertiesPrefixed"


    public static class indexProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:884:1: indexProperties : LPAREN indexPropertiesList RPAREN -> ^( TOK_INDEXPROPERTIES indexPropertiesList ) ;
    public final HiveParser.indexProperties_return indexProperties() throws RecognitionException {
        HiveParser.indexProperties_return retval = new HiveParser.indexProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN145=null;
        Token RPAREN147=null;
        HiveParser.indexPropertiesList_return indexPropertiesList146 =null;


        CommonTree LPAREN145_tree=null;
        CommonTree RPAREN147_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_indexPropertiesList=new RewriteRuleSubtreeStream(adaptor,"rule indexPropertiesList");
         pushMsg("index properties", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:887:5: ( LPAREN indexPropertiesList RPAREN -> ^( TOK_INDEXPROPERTIES indexPropertiesList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:888:7: LPAREN indexPropertiesList RPAREN
            {
            LPAREN145=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_indexProperties3220);  
            stream_LPAREN.add(LPAREN145);


            pushFollow(FOLLOW_indexPropertiesList_in_indexProperties3222);
            indexPropertiesList146=indexPropertiesList();

            state._fsp--;

            stream_indexPropertiesList.add(indexPropertiesList146.getTree());

            RPAREN147=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_indexProperties3224);  
            stream_RPAREN.add(RPAREN147);


            // AST REWRITE
            // elements: indexPropertiesList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 888:41: -> ^( TOK_INDEXPROPERTIES indexPropertiesList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:888:44: ^( TOK_INDEXPROPERTIES indexPropertiesList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXPROPERTIES, "TOK_INDEXPROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_indexPropertiesList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexProperties"


    public static class indexPropertiesList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexPropertiesList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:891:1: indexPropertiesList : keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ ) ;
    public final HiveParser.indexPropertiesList_return indexPropertiesList() throws RecognitionException {
        HiveParser.indexPropertiesList_return retval = new HiveParser.indexPropertiesList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA149=null;
        HiveParser.keyValueProperty_return keyValueProperty148 =null;

        HiveParser.keyValueProperty_return keyValueProperty150 =null;


        CommonTree COMMA149_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_keyValueProperty=new RewriteRuleSubtreeStream(adaptor,"rule keyValueProperty");
         pushMsg("index properties list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:894:5: ( keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:895:7: keyValueProperty ( COMMA keyValueProperty )*
            {
            pushFollow(FOLLOW_keyValueProperty_in_indexPropertiesList3265);
            keyValueProperty148=keyValueProperty();

            state._fsp--;

            stream_keyValueProperty.add(keyValueProperty148.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:895:24: ( COMMA keyValueProperty )*
            loop44:
            do {
                int alt44=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt44=1;
                    }
                    break;

                }

                switch (alt44) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:895:25: COMMA keyValueProperty
            	    {
            	    COMMA149=(Token)match(input,COMMA,FOLLOW_COMMA_in_indexPropertiesList3268);  
            	    stream_COMMA.add(COMMA149);


            	    pushFollow(FOLLOW_keyValueProperty_in_indexPropertiesList3270);
            	    keyValueProperty150=keyValueProperty();

            	    state._fsp--;

            	    stream_keyValueProperty.add(keyValueProperty150.getTree());

            	    }
            	    break;

            	default :
            	    break loop44;
                }
            } while (true);


            // AST REWRITE
            // elements: keyValueProperty
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 895:50: -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:895:53: ^( TOK_INDEXPROPLIST ( keyValueProperty )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXPROPLIST, "TOK_INDEXPROPLIST")
                , root_1);

                if ( !(stream_keyValueProperty.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_keyValueProperty.hasNext() ) {
                    adaptor.addChild(root_1, stream_keyValueProperty.nextTree());

                }
                stream_keyValueProperty.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexPropertiesList"


    public static class dropIndexStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropIndexStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:898:1: dropIndexStatement : KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? ) ;
    public final HiveParser.dropIndexStatement_return dropIndexStatement() throws RecognitionException {
        HiveParser.dropIndexStatement_return retval = new HiveParser.dropIndexStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP151=null;
        Token KW_INDEX152=null;
        Token KW_ON154=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tab =null;

        HiveParser.ifExists_return ifExists153 =null;


        CommonTree KW_DROP151_tree=null;
        CommonTree KW_INDEX152_tree=null;
        CommonTree KW_ON154_tree=null;
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("drop index statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:901:5: ( KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:901:7: KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName
            {
            KW_DROP151=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropIndexStatement3308);  
            stream_KW_DROP.add(KW_DROP151);


            KW_INDEX152=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_dropIndexStatement3310);  
            stream_KW_INDEX.add(KW_INDEX152);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:901:24: ( ifExists )?
            int alt45=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt45=1;
                    }
                    break;
            }

            switch (alt45) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:901:24: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropIndexStatement3312);
                    ifExists153=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists153.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropIndexStatement3317);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            KW_ON154=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_dropIndexStatement3319);  
            stream_KW_ON.add(KW_ON154);


            pushFollow(FOLLOW_tableName_in_dropIndexStatement3323);
            tab=tableName();

            state._fsp--;

            stream_tableName.add(tab.getTree());

            // AST REWRITE
            // elements: ifExists, tab, indexName
            // token labels: 
            // rule labels: retval, indexName, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 902:5: -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:902:7: ^( TOK_DROPINDEX $indexName $tab ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPINDEX, "TOK_DROPINDEX")
                , root_1);

                adaptor.addChild(root_1, stream_indexName.nextTree());

                adaptor.addChild(root_1, stream_tab.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:902:39: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropIndexStatement"


    public static class dropTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:905:1: dropTableStatement : KW_DROP KW_TABLE ( ifExists )? tableName -> ^( TOK_DROPTABLE tableName ( ifExists )? ) ;
    public final HiveParser.dropTableStatement_return dropTableStatement() throws RecognitionException {
        HiveParser.dropTableStatement_return retval = new HiveParser.dropTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP155=null;
        Token KW_TABLE156=null;
        HiveParser.ifExists_return ifExists157 =null;

        HiveParser_FromClauseParser.tableName_return tableName158 =null;


        CommonTree KW_DROP155_tree=null;
        CommonTree KW_TABLE156_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         pushMsg("drop statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:908:5: ( KW_DROP KW_TABLE ( ifExists )? tableName -> ^( TOK_DROPTABLE tableName ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:908:7: KW_DROP KW_TABLE ( ifExists )? tableName
            {
            KW_DROP155=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropTableStatement3368);  
            stream_KW_DROP.add(KW_DROP155);


            KW_TABLE156=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_dropTableStatement3370);  
            stream_KW_TABLE.add(KW_TABLE156);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:908:24: ( ifExists )?
            int alt46=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt46=1;
                    }
                    break;
            }

            switch (alt46) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:908:24: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropTableStatement3372);
                    ifExists157=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists157.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_dropTableStatement3375);
            tableName158=tableName();

            state._fsp--;

            stream_tableName.add(tableName158.getTree());

            // AST REWRITE
            // elements: tableName, ifExists
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 908:44: -> ^( TOK_DROPTABLE tableName ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:908:47: ^( TOK_DROPTABLE tableName ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPTABLE, "TOK_DROPTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:908:73: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropTableStatement"


    public static class alterStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:911:1: alterStatement : KW_ALTER ! ( KW_TABLE ! alterTableStatementSuffix | KW_VIEW ! alterViewStatementSuffix | KW_INDEX ! alterIndexStatementSuffix | KW_DATABASE ! alterDatabaseStatementSuffix ) ;
    public final HiveParser.alterStatement_return alterStatement() throws RecognitionException {
        HiveParser.alterStatement_return retval = new HiveParser.alterStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALTER159=null;
        Token KW_TABLE160=null;
        Token KW_VIEW162=null;
        Token KW_INDEX164=null;
        Token KW_DATABASE166=null;
        HiveParser.alterTableStatementSuffix_return alterTableStatementSuffix161 =null;

        HiveParser.alterViewStatementSuffix_return alterViewStatementSuffix163 =null;

        HiveParser.alterIndexStatementSuffix_return alterIndexStatementSuffix165 =null;

        HiveParser.alterDatabaseStatementSuffix_return alterDatabaseStatementSuffix167 =null;


        CommonTree KW_ALTER159_tree=null;
        CommonTree KW_TABLE160_tree=null;
        CommonTree KW_VIEW162_tree=null;
        CommonTree KW_INDEX164_tree=null;
        CommonTree KW_DATABASE166_tree=null;

         pushMsg("alter statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:914:5: ( KW_ALTER ! ( KW_TABLE ! alterTableStatementSuffix | KW_VIEW ! alterViewStatementSuffix | KW_INDEX ! alterIndexStatementSuffix | KW_DATABASE ! alterDatabaseStatementSuffix ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:914:7: KW_ALTER ! ( KW_TABLE ! alterTableStatementSuffix | KW_VIEW ! alterViewStatementSuffix | KW_INDEX ! alterIndexStatementSuffix | KW_DATABASE ! alterDatabaseStatementSuffix )
            {
            root_0 = (CommonTree)adaptor.nil();


            KW_ALTER159=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3413); 

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:915:9: ( KW_TABLE ! alterTableStatementSuffix | KW_VIEW ! alterViewStatementSuffix | KW_INDEX ! alterIndexStatementSuffix | KW_DATABASE ! alterDatabaseStatementSuffix )
            int alt47=4;
            switch ( input.LA(1) ) {
            case KW_TABLE:
                {
                alt47=1;
                }
                break;
            case KW_VIEW:
                {
                alt47=2;
                }
                break;
            case KW_INDEX:
                {
                alt47=3;
                }
                break;
            case KW_DATABASE:
                {
                alt47=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;

            }

            switch (alt47) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:916:13: KW_TABLE ! alterTableStatementSuffix
                    {
                    KW_TABLE160=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_alterStatement3438); 

                    pushFollow(FOLLOW_alterTableStatementSuffix_in_alterStatement3441);
                    alterTableStatementSuffix161=alterTableStatementSuffix();

                    state._fsp--;

                    adaptor.addChild(root_0, alterTableStatementSuffix161.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:918:13: KW_VIEW ! alterViewStatementSuffix
                    {
                    KW_VIEW162=(Token)match(input,KW_VIEW,FOLLOW_KW_VIEW_in_alterStatement3465); 

                    pushFollow(FOLLOW_alterViewStatementSuffix_in_alterStatement3468);
                    alterViewStatementSuffix163=alterViewStatementSuffix();

                    state._fsp--;

                    adaptor.addChild(root_0, alterViewStatementSuffix163.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:920:13: KW_INDEX ! alterIndexStatementSuffix
                    {
                    KW_INDEX164=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_alterStatement3492); 

                    pushFollow(FOLLOW_alterIndexStatementSuffix_in_alterStatement3495);
                    alterIndexStatementSuffix165=alterIndexStatementSuffix();

                    state._fsp--;

                    adaptor.addChild(root_0, alterIndexStatementSuffix165.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:922:13: KW_DATABASE ! alterDatabaseStatementSuffix
                    {
                    KW_DATABASE166=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_alterStatement3519); 

                    pushFollow(FOLLOW_alterDatabaseStatementSuffix_in_alterStatement3522);
                    alterDatabaseStatementSuffix167=alterDatabaseStatementSuffix();

                    state._fsp--;

                    adaptor.addChild(root_0, alterDatabaseStatementSuffix167.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatement"


    public static class alterTableStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTableStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:926:1: alterTableStatementSuffix : ( alterStatementSuffixRename | alterStatementSuffixAddCol | alterStatementSuffixRenameCol | alterStatementSuffixDropPartitions | alterStatementSuffixAddPartitions | alterStatementSuffixTouch | alterStatementSuffixArchive | alterStatementSuffixUnArchive | alterStatementSuffixProperties | alterTblPartitionStatement | alterStatementSuffixSkewedby | alterStatementSuffixExchangePartition | alterStatementPartitionKeyType );
    public final HiveParser.alterTableStatementSuffix_return alterTableStatementSuffix() throws RecognitionException {
        HiveParser.alterTableStatementSuffix_return retval = new HiveParser.alterTableStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename168 =null;

        HiveParser.alterStatementSuffixAddCol_return alterStatementSuffixAddCol169 =null;

        HiveParser.alterStatementSuffixRenameCol_return alterStatementSuffixRenameCol170 =null;

        HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions171 =null;

        HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions172 =null;

        HiveParser.alterStatementSuffixTouch_return alterStatementSuffixTouch173 =null;

        HiveParser.alterStatementSuffixArchive_return alterStatementSuffixArchive174 =null;

        HiveParser.alterStatementSuffixUnArchive_return alterStatementSuffixUnArchive175 =null;

        HiveParser.alterStatementSuffixProperties_return alterStatementSuffixProperties176 =null;

        HiveParser.alterTblPartitionStatement_return alterTblPartitionStatement177 =null;

        HiveParser.alterStatementSuffixSkewedby_return alterStatementSuffixSkewedby178 =null;

        HiveParser.alterStatementSuffixExchangePartition_return alterStatementSuffixExchangePartition179 =null;

        HiveParser.alterStatementPartitionKeyType_return alterStatementPartitionKeyType180 =null;



         pushMsg("alter table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:929:5: ( alterStatementSuffixRename | alterStatementSuffixAddCol | alterStatementSuffixRenameCol | alterStatementSuffixDropPartitions | alterStatementSuffixAddPartitions | alterStatementSuffixTouch | alterStatementSuffixArchive | alterStatementSuffixUnArchive | alterStatementSuffixProperties | alterTblPartitionStatement | alterStatementSuffixSkewedby | alterStatementSuffixExchangePartition | alterStatementPartitionKeyType )
            int alt48=13;
            alt48 = dfa48.predict(input);
            switch (alt48) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:929:7: alterStatementSuffixRename
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRename_in_alterTableStatementSuffix3559);
                    alterStatementSuffixRename168=alterStatementSuffixRename();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRename168.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:930:7: alterStatementSuffixAddCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddCol_in_alterTableStatementSuffix3567);
                    alterStatementSuffixAddCol169=alterStatementSuffixAddCol();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixAddCol169.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:931:7: alterStatementSuffixRenameCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRenameCol_in_alterTableStatementSuffix3575);
                    alterStatementSuffixRenameCol170=alterStatementSuffixRenameCol();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRenameCol170.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:932:7: alterStatementSuffixDropPartitions
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixDropPartitions_in_alterTableStatementSuffix3583);
                    alterStatementSuffixDropPartitions171=alterStatementSuffixDropPartitions();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixDropPartitions171.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:933:7: alterStatementSuffixAddPartitions
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddPartitions_in_alterTableStatementSuffix3591);
                    alterStatementSuffixAddPartitions172=alterStatementSuffixAddPartitions();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixAddPartitions172.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:934:7: alterStatementSuffixTouch
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixTouch_in_alterTableStatementSuffix3599);
                    alterStatementSuffixTouch173=alterStatementSuffixTouch();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixTouch173.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:935:7: alterStatementSuffixArchive
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixArchive_in_alterTableStatementSuffix3607);
                    alterStatementSuffixArchive174=alterStatementSuffixArchive();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixArchive174.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:936:7: alterStatementSuffixUnArchive
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixUnArchive_in_alterTableStatementSuffix3615);
                    alterStatementSuffixUnArchive175=alterStatementSuffixUnArchive();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixUnArchive175.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:937:7: alterStatementSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixProperties_in_alterTableStatementSuffix3623);
                    alterStatementSuffixProperties176=alterStatementSuffixProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixProperties176.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:7: alterTblPartitionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterTblPartitionStatement_in_alterTableStatementSuffix3631);
                    alterTblPartitionStatement177=alterTblPartitionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, alterTblPartitionStatement177.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:939:7: alterStatementSuffixSkewedby
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixSkewedby_in_alterTableStatementSuffix3639);
                    alterStatementSuffixSkewedby178=alterStatementSuffixSkewedby();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixSkewedby178.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:940:7: alterStatementSuffixExchangePartition
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixExchangePartition_in_alterTableStatementSuffix3647);
                    alterStatementSuffixExchangePartition179=alterStatementSuffixExchangePartition();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixExchangePartition179.getTree());

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:941:7: alterStatementPartitionKeyType
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementPartitionKeyType_in_alterTableStatementSuffix3655);
                    alterStatementPartitionKeyType180=alterStatementPartitionKeyType();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementPartitionKeyType180.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTableStatementSuffix"


    public static class alterStatementPartitionKeyType_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementPartitionKeyType"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:944:1: alterStatementPartitionKeyType : identifier KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN -> ^( TOK_ALTERTABLE_PARTCOLTYPE identifier columnNameType ) ;
    public final HiveParser.alterStatementPartitionKeyType_return alterStatementPartitionKeyType() throws RecognitionException {
        HiveParser.alterStatementPartitionKeyType_return retval = new HiveParser.alterStatementPartitionKeyType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_PARTITION182=null;
        Token KW_COLUMN183=null;
        Token LPAREN184=null;
        Token RPAREN186=null;
        HiveParser_IdentifiersParser.identifier_return identifier181 =null;

        HiveParser.columnNameType_return columnNameType185 =null;


        CommonTree KW_PARTITION182_tree=null;
        CommonTree KW_COLUMN183_tree=null;
        CommonTree LPAREN184_tree=null;
        CommonTree RPAREN186_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_PARTITION=new RewriteRuleTokenStream(adaptor,"token KW_PARTITION");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_columnNameType=new RewriteRuleSubtreeStream(adaptor,"rule columnNameType");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("alter partition key type"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:947:2: ( identifier KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN -> ^( TOK_ALTERTABLE_PARTCOLTYPE identifier columnNameType ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:947:4: identifier KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN
            {
            pushFollow(FOLLOW_identifier_in_alterStatementPartitionKeyType3679);
            identifier181=identifier();

            state._fsp--;

            stream_identifier.add(identifier181.getTree());

            KW_PARTITION182=(Token)match(input,KW_PARTITION,FOLLOW_KW_PARTITION_in_alterStatementPartitionKeyType3681);  
            stream_KW_PARTITION.add(KW_PARTITION182);


            KW_COLUMN183=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementPartitionKeyType3683);  
            stream_KW_COLUMN.add(KW_COLUMN183);


            LPAREN184=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_alterStatementPartitionKeyType3685);  
            stream_LPAREN.add(LPAREN184);


            pushFollow(FOLLOW_columnNameType_in_alterStatementPartitionKeyType3687);
            columnNameType185=columnNameType();

            state._fsp--;

            stream_columnNameType.add(columnNameType185.getTree());

            RPAREN186=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_alterStatementPartitionKeyType3689);  
            stream_RPAREN.add(RPAREN186);


            // AST REWRITE
            // elements: columnNameType, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 948:2: -> ^( TOK_ALTERTABLE_PARTCOLTYPE identifier columnNameType )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:948:5: ^( TOK_ALTERTABLE_PARTCOLTYPE identifier columnNameType )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_PARTCOLTYPE, "TOK_ALTERTABLE_PARTCOLTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, stream_columnNameType.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementPartitionKeyType"


    public static class alterViewStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterViewStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:951:1: alterViewStatementSuffix : ( alterViewSuffixProperties | alterStatementSuffixRename -> ^( TOK_ALTERVIEW_RENAME alterStatementSuffixRename ) | alterStatementSuffixAddPartitions -> ^( TOK_ALTERVIEW_ADDPARTS alterStatementSuffixAddPartitions ) | alterStatementSuffixDropPartitions -> ^( TOK_ALTERVIEW_DROPPARTS alterStatementSuffixDropPartitions ) |name= tableName KW_AS selectStatementWithCTE -> ^( TOK_ALTERVIEW_AS $name selectStatementWithCTE ) );
    public final HiveParser.alterViewStatementSuffix_return alterViewStatementSuffix() throws RecognitionException {
        HiveParser.alterViewStatementSuffix_return retval = new HiveParser.alterViewStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_AS191=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser.alterViewSuffixProperties_return alterViewSuffixProperties187 =null;

        HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename188 =null;

        HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions189 =null;

        HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions190 =null;

        HiveParser.selectStatementWithCTE_return selectStatementWithCTE192 =null;


        CommonTree KW_AS191_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleSubtreeStream stream_selectStatementWithCTE=new RewriteRuleSubtreeStream(adaptor,"rule selectStatementWithCTE");
        RewriteRuleSubtreeStream stream_alterStatementSuffixAddPartitions=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixAddPartitions");
        RewriteRuleSubtreeStream stream_alterStatementSuffixRename=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixRename");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_alterStatementSuffixDropPartitions=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixDropPartitions");
         pushMsg("alter view statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:954:5: ( alterViewSuffixProperties | alterStatementSuffixRename -> ^( TOK_ALTERVIEW_RENAME alterStatementSuffixRename ) | alterStatementSuffixAddPartitions -> ^( TOK_ALTERVIEW_ADDPARTS alterStatementSuffixAddPartitions ) | alterStatementSuffixDropPartitions -> ^( TOK_ALTERVIEW_DROPPARTS alterStatementSuffixDropPartitions ) |name= tableName KW_AS selectStatementWithCTE -> ^( TOK_ALTERVIEW_AS $name selectStatementWithCTE ) )
            int alt49=5;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                case KW_UNSET:
                    {
                    alt49=1;
                    }
                    break;
                case KW_RENAME:
                    {
                    alt49=2;
                    }
                    break;
                case KW_ADD:
                    {
                    alt49=3;
                    }
                    break;
                case KW_DROP:
                    {
                    alt49=4;
                    }
                    break;
                case DOT:
                case KW_AS:
                    {
                    alt49=5;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 49, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARQUETFILE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                case KW_UNSET:
                    {
                    alt49=1;
                    }
                    break;
                case KW_RENAME:
                    {
                    alt49=2;
                    }
                    break;
                case KW_ADD:
                    {
                    alt49=3;
                    }
                    break;
                case KW_DROP:
                    {
                    alt49=4;
                    }
                    break;
                case DOT:
                case KW_AS:
                    {
                    alt49=5;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 49, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 49, 0, input);

                throw nvae;

            }

            switch (alt49) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:954:7: alterViewSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterViewSuffixProperties_in_alterViewStatementSuffix3724);
                    alterViewSuffixProperties187=alterViewSuffixProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterViewSuffixProperties187.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:955:7: alterStatementSuffixRename
                    {
                    pushFollow(FOLLOW_alterStatementSuffixRename_in_alterViewStatementSuffix3732);
                    alterStatementSuffixRename188=alterStatementSuffixRename();

                    state._fsp--;

                    stream_alterStatementSuffixRename.add(alterStatementSuffixRename188.getTree());

                    // AST REWRITE
                    // elements: alterStatementSuffixRename
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 956:9: -> ^( TOK_ALTERVIEW_RENAME alterStatementSuffixRename )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:12: ^( TOK_ALTERVIEW_RENAME alterStatementSuffixRename )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_RENAME, "TOK_ALTERVIEW_RENAME")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterStatementSuffixRename.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:957:7: alterStatementSuffixAddPartitions
                    {
                    pushFollow(FOLLOW_alterStatementSuffixAddPartitions_in_alterViewStatementSuffix3756);
                    alterStatementSuffixAddPartitions189=alterStatementSuffixAddPartitions();

                    state._fsp--;

                    stream_alterStatementSuffixAddPartitions.add(alterStatementSuffixAddPartitions189.getTree());

                    // AST REWRITE
                    // elements: alterStatementSuffixAddPartitions
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 958:9: -> ^( TOK_ALTERVIEW_ADDPARTS alterStatementSuffixAddPartitions )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:958:12: ^( TOK_ALTERVIEW_ADDPARTS alterStatementSuffixAddPartitions )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_ADDPARTS, "TOK_ALTERVIEW_ADDPARTS")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterStatementSuffixAddPartitions.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:959:7: alterStatementSuffixDropPartitions
                    {
                    pushFollow(FOLLOW_alterStatementSuffixDropPartitions_in_alterViewStatementSuffix3780);
                    alterStatementSuffixDropPartitions190=alterStatementSuffixDropPartitions();

                    state._fsp--;

                    stream_alterStatementSuffixDropPartitions.add(alterStatementSuffixDropPartitions190.getTree());

                    // AST REWRITE
                    // elements: alterStatementSuffixDropPartitions
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 960:9: -> ^( TOK_ALTERVIEW_DROPPARTS alterStatementSuffixDropPartitions )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:960:12: ^( TOK_ALTERVIEW_DROPPARTS alterStatementSuffixDropPartitions )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_DROPPARTS, "TOK_ALTERVIEW_DROPPARTS")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterStatementSuffixDropPartitions.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:961:7: name= tableName KW_AS selectStatementWithCTE
                    {
                    pushFollow(FOLLOW_tableName_in_alterViewStatementSuffix3806);
                    name=tableName();

                    state._fsp--;

                    stream_tableName.add(name.getTree());

                    KW_AS191=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_alterViewStatementSuffix3808);  
                    stream_KW_AS.add(KW_AS191);


                    pushFollow(FOLLOW_selectStatementWithCTE_in_alterViewStatementSuffix3810);
                    selectStatementWithCTE192=selectStatementWithCTE();

                    state._fsp--;

                    stream_selectStatementWithCTE.add(selectStatementWithCTE192.getTree());

                    // AST REWRITE
                    // elements: selectStatementWithCTE, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 962:9: -> ^( TOK_ALTERVIEW_AS $name selectStatementWithCTE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:962:12: ^( TOK_ALTERVIEW_AS $name selectStatementWithCTE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_AS, "TOK_ALTERVIEW_AS")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_selectStatementWithCTE.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterViewStatementSuffix"


    public static class alterIndexStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterIndexStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:965:1: alterIndexStatementSuffix : indexName= identifier ( KW_ON tableNameId= identifier ) ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties ) ) ;
    public final HiveParser.alterIndexStatementSuffix_return alterIndexStatementSuffix() throws RecognitionException {
        HiveParser.alterIndexStatementSuffix_return retval = new HiveParser.alterIndexStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ON193=null;
        Token KW_REBUILD195=null;
        Token KW_SET196=null;
        Token KW_IDXPROPERTIES197=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_IdentifiersParser.identifier_return tableNameId =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec194 =null;

        HiveParser.indexProperties_return indexProperties198 =null;


        CommonTree KW_ON193_tree=null;
        CommonTree KW_REBUILD195_tree=null;
        CommonTree KW_SET196_tree=null;
        CommonTree KW_IDXPROPERTIES197_tree=null;
        RewriteRuleTokenStream stream_KW_REBUILD=new RewriteRuleTokenStream(adaptor,"token KW_REBUILD");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_IDXPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_IDXPROPERTIES");
        RewriteRuleSubtreeStream stream_indexProperties=new RewriteRuleSubtreeStream(adaptor,"rule indexProperties");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter index statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:968:5: (indexName= identifier ( KW_ON tableNameId= identifier ) ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties ) ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:968:7: indexName= identifier ( KW_ON tableNameId= identifier ) ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties ) )
            {
            pushFollow(FOLLOW_identifier_in_alterIndexStatementSuffix3858);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:969:7: ( KW_ON tableNameId= identifier )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:969:8: KW_ON tableNameId= identifier
            {
            KW_ON193=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_alterIndexStatementSuffix3867);  
            stream_KW_ON.add(KW_ON193);


            pushFollow(FOLLOW_identifier_in_alterIndexStatementSuffix3871);
            tableNameId=identifier();

            state._fsp--;

            stream_identifier.add(tableNameId.getTree());

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:970:7: ( partitionSpec )?
            int alt50=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt50=1;
                    }
                    break;
            }

            switch (alt50) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:970:7: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_alterIndexStatementSuffix3880);
                    partitionSpec194=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec194.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:971:5: ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties ) )
            int alt51=2;
            switch ( input.LA(1) ) {
            case KW_REBUILD:
                {
                alt51=1;
                }
                break;
            case KW_SET:
                {
                alt51=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 51, 0, input);

                throw nvae;

            }

            switch (alt51) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:972:7: KW_REBUILD
                    {
                    KW_REBUILD195=(Token)match(input,KW_REBUILD,FOLLOW_KW_REBUILD_in_alterIndexStatementSuffix3895);  
                    stream_KW_REBUILD.add(KW_REBUILD195);


                    // AST REWRITE
                    // elements: partitionSpec, tableNameId, indexName
                    // token labels: 
                    // rule labels: retval, tableNameId, indexName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tableNameId=new RewriteRuleSubtreeStream(adaptor,"rule tableNameId",tableNameId!=null?tableNameId.tree:null);
                    RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 973:7: -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:973:9: ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERINDEX_REBUILD, "TOK_ALTERINDEX_REBUILD")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableNameId.nextTree());

                        adaptor.addChild(root_1, stream_indexName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:973:58: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:975:7: KW_SET KW_IDXPROPERTIES indexProperties
                    {
                    KW_SET196=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterIndexStatementSuffix3929);  
                    stream_KW_SET.add(KW_SET196);


                    KW_IDXPROPERTIES197=(Token)match(input,KW_IDXPROPERTIES,FOLLOW_KW_IDXPROPERTIES_in_alterIndexStatementSuffix3931);  
                    stream_KW_IDXPROPERTIES.add(KW_IDXPROPERTIES197);


                    pushFollow(FOLLOW_indexProperties_in_alterIndexStatementSuffix3939);
                    indexProperties198=indexProperties();

                    state._fsp--;

                    stream_indexProperties.add(indexProperties198.getTree());

                    // AST REWRITE
                    // elements: tableNameId, indexProperties, indexName
                    // token labels: 
                    // rule labels: retval, tableNameId, indexName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tableNameId=new RewriteRuleSubtreeStream(adaptor,"rule tableNameId",tableNameId!=null?tableNameId.tree:null);
                    RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 977:7: -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:977:9: ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERINDEX_PROPERTIES, "TOK_ALTERINDEX_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableNameId.nextTree());

                        adaptor.addChild(root_1, stream_indexName.nextTree());

                        adaptor.addChild(root_1, stream_indexProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterIndexStatementSuffix"


    public static class alterDatabaseStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:981:1: alterDatabaseStatementSuffix : ( alterDatabaseSuffixProperties | alterDatabaseSuffixSetOwner );
    public final HiveParser.alterDatabaseStatementSuffix_return alterDatabaseStatementSuffix() throws RecognitionException {
        HiveParser.alterDatabaseStatementSuffix_return retval = new HiveParser.alterDatabaseStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterDatabaseSuffixProperties_return alterDatabaseSuffixProperties199 =null;

        HiveParser.alterDatabaseSuffixSetOwner_return alterDatabaseSuffixSetOwner200 =null;



         pushMsg("alter database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:984:5: ( alterDatabaseSuffixProperties | alterDatabaseSuffixSetOwner )
            int alt52=2;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    switch ( input.LA(3) ) {
                    case KW_DBPROPERTIES:
                        {
                        alt52=1;
                        }
                        break;
                    case KW_OWNER:
                        {
                        alt52=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 52, 3, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 52, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARQUETFILE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    switch ( input.LA(3) ) {
                    case KW_DBPROPERTIES:
                        {
                        alt52=1;
                        }
                        break;
                    case KW_OWNER:
                        {
                        alt52=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 52, 4, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 52, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 52, 0, input);

                throw nvae;

            }

            switch (alt52) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:984:7: alterDatabaseSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterDatabaseSuffixProperties_in_alterDatabaseStatementSuffix3991);
                    alterDatabaseSuffixProperties199=alterDatabaseSuffixProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterDatabaseSuffixProperties199.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:985:7: alterDatabaseSuffixSetOwner
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterDatabaseSuffixSetOwner_in_alterDatabaseStatementSuffix3999);
                    alterDatabaseSuffixSetOwner200=alterDatabaseSuffixSetOwner();

                    state._fsp--;

                    adaptor.addChild(root_0, alterDatabaseSuffixSetOwner200.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseStatementSuffix"


    public static class alterDatabaseSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:988:1: alterDatabaseSuffixProperties : name= identifier KW_SET KW_DBPROPERTIES dbProperties -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties ) ;
    public final HiveParser.alterDatabaseSuffixProperties_return alterDatabaseSuffixProperties() throws RecognitionException {
        HiveParser.alterDatabaseSuffixProperties_return retval = new HiveParser.alterDatabaseSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET201=null;
        Token KW_DBPROPERTIES202=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.dbProperties_return dbProperties203 =null;


        CommonTree KW_SET201_tree=null;
        CommonTree KW_DBPROPERTIES202_tree=null;
        RewriteRuleTokenStream stream_KW_DBPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_DBPROPERTIES");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_dbProperties=new RewriteRuleSubtreeStream(adaptor,"rule dbProperties");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter database properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:5: (name= identifier KW_SET KW_DBPROPERTIES dbProperties -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:7: name= identifier KW_SET KW_DBPROPERTIES dbProperties
            {
            pushFollow(FOLLOW_identifier_in_alterDatabaseSuffixProperties4028);
            name=identifier();

            state._fsp--;

            stream_identifier.add(name.getTree());

            KW_SET201=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterDatabaseSuffixProperties4030);  
            stream_KW_SET.add(KW_SET201);


            KW_DBPROPERTIES202=(Token)match(input,KW_DBPROPERTIES,FOLLOW_KW_DBPROPERTIES_in_alterDatabaseSuffixProperties4032);  
            stream_KW_DBPROPERTIES.add(KW_DBPROPERTIES202);


            pushFollow(FOLLOW_dbProperties_in_alterDatabaseSuffixProperties4034);
            dbProperties203=dbProperties();

            state._fsp--;

            stream_dbProperties.add(dbProperties203.getTree());

            // AST REWRITE
            // elements: name, dbProperties
            // token labels: 
            // rule labels: retval, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 992:5: -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:992:8: ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERDATABASE_PROPERTIES, "TOK_ALTERDATABASE_PROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                adaptor.addChild(root_1, stream_dbProperties.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseSuffixProperties"


    public static class alterDatabaseSuffixSetOwner_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseSuffixSetOwner"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:995:1: alterDatabaseSuffixSetOwner : dbName= identifier KW_SET KW_OWNER principalName -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName ) ;
    public final HiveParser.alterDatabaseSuffixSetOwner_return alterDatabaseSuffixSetOwner() throws RecognitionException {
        HiveParser.alterDatabaseSuffixSetOwner_return retval = new HiveParser.alterDatabaseSuffixSetOwner_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET204=null;
        Token KW_OWNER205=null;
        HiveParser_IdentifiersParser.identifier_return dbName =null;

        HiveParser.principalName_return principalName206 =null;


        CommonTree KW_SET204_tree=null;
        CommonTree KW_OWNER205_tree=null;
        RewriteRuleTokenStream stream_KW_OWNER=new RewriteRuleTokenStream(adaptor,"token KW_OWNER");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter database set owner", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:998:5: (dbName= identifier KW_SET KW_OWNER principalName -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:998:7: dbName= identifier KW_SET KW_OWNER principalName
            {
            pushFollow(FOLLOW_identifier_in_alterDatabaseSuffixSetOwner4078);
            dbName=identifier();

            state._fsp--;

            stream_identifier.add(dbName.getTree());

            KW_SET204=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterDatabaseSuffixSetOwner4080);  
            stream_KW_SET.add(KW_SET204);


            KW_OWNER205=(Token)match(input,KW_OWNER,FOLLOW_KW_OWNER_in_alterDatabaseSuffixSetOwner4082);  
            stream_KW_OWNER.add(KW_OWNER205);


            pushFollow(FOLLOW_principalName_in_alterDatabaseSuffixSetOwner4084);
            principalName206=principalName();

            state._fsp--;

            stream_principalName.add(principalName206.getTree());

            // AST REWRITE
            // elements: principalName, dbName
            // token labels: 
            // rule labels: retval, dbName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_dbName=new RewriteRuleSubtreeStream(adaptor,"rule dbName",dbName!=null?dbName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 999:5: -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:999:8: ^( TOK_ALTERDATABASE_OWNER $dbName principalName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERDATABASE_OWNER, "TOK_ALTERDATABASE_OWNER")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextTree());

                adaptor.addChild(root_1, stream_principalName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseSuffixSetOwner"


    public static class alterStatementSuffixRename_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRename"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1002:1: alterStatementSuffixRename : oldName= identifier KW_RENAME KW_TO newName= identifier -> ^( TOK_ALTERTABLE_RENAME $oldName $newName) ;
    public final HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename() throws RecognitionException {
        HiveParser.alterStatementSuffixRename_return retval = new HiveParser.alterStatementSuffixRename_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RENAME207=null;
        Token KW_TO208=null;
        HiveParser_IdentifiersParser.identifier_return oldName =null;

        HiveParser_IdentifiersParser.identifier_return newName =null;


        CommonTree KW_RENAME207_tree=null;
        CommonTree KW_TO208_tree=null;
        RewriteRuleTokenStream stream_KW_RENAME=new RewriteRuleTokenStream(adaptor,"token KW_RENAME");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("rename statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1005:5: (oldName= identifier KW_RENAME KW_TO newName= identifier -> ^( TOK_ALTERTABLE_RENAME $oldName $newName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1005:7: oldName= identifier KW_RENAME KW_TO newName= identifier
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRename4128);
            oldName=identifier();

            state._fsp--;

            stream_identifier.add(oldName.getTree());

            KW_RENAME207=(Token)match(input,KW_RENAME,FOLLOW_KW_RENAME_in_alterStatementSuffixRename4130);  
            stream_KW_RENAME.add(KW_RENAME207);


            KW_TO208=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_alterStatementSuffixRename4132);  
            stream_KW_TO.add(KW_TO208);


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRename4136);
            newName=identifier();

            state._fsp--;

            stream_identifier.add(newName.getTree());

            // AST REWRITE
            // elements: newName, oldName
            // token labels: 
            // rule labels: retval, newName, oldName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_newName=new RewriteRuleSubtreeStream(adaptor,"rule newName",newName!=null?newName.tree:null);
            RewriteRuleSubtreeStream stream_oldName=new RewriteRuleSubtreeStream(adaptor,"rule oldName",oldName!=null?oldName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1006:5: -> ^( TOK_ALTERTABLE_RENAME $oldName $newName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1006:8: ^( TOK_ALTERTABLE_RENAME $oldName $newName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAME, "TOK_ALTERTABLE_RENAME")
                , root_1);

                adaptor.addChild(root_1, stream_oldName.nextTree());

                adaptor.addChild(root_1, stream_newName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRename"


    public static class alterStatementSuffixAddCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1009:1: alterStatementSuffixAddCol : identifier (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS identifier columnNameTypeList ) -> ^( TOK_ALTERTABLE_REPLACECOLS identifier columnNameTypeList ) ;
    public final HiveParser.alterStatementSuffixAddCol_return alterStatementSuffixAddCol() throws RecognitionException {
        HiveParser.alterStatementSuffixAddCol_return retval = new HiveParser.alterStatementSuffixAddCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token add=null;
        Token replace=null;
        Token KW_COLUMNS210=null;
        Token LPAREN211=null;
        Token RPAREN213=null;
        HiveParser_IdentifiersParser.identifier_return identifier209 =null;

        HiveParser.columnNameTypeList_return columnNameTypeList212 =null;


        CommonTree add_tree=null;
        CommonTree replace_tree=null;
        CommonTree KW_COLUMNS210_tree=null;
        CommonTree LPAREN211_tree=null;
        CommonTree RPAREN213_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_REPLACE=new RewriteRuleTokenStream(adaptor,"token KW_REPLACE");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_ADD=new RewriteRuleTokenStream(adaptor,"token KW_ADD");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("add column statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1012:5: ( identifier (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS identifier columnNameTypeList ) -> ^( TOK_ALTERTABLE_REPLACECOLS identifier columnNameTypeList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1012:7: identifier (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixAddCol4179);
            identifier209=identifier();

            state._fsp--;

            stream_identifier.add(identifier209.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1012:18: (add= KW_ADD |replace= KW_REPLACE )
            int alt53=2;
            switch ( input.LA(1) ) {
            case KW_ADD:
                {
                alt53=1;
                }
                break;
            case KW_REPLACE:
                {
                alt53=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;

            }

            switch (alt53) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1012:19: add= KW_ADD
                    {
                    add=(Token)match(input,KW_ADD,FOLLOW_KW_ADD_in_alterStatementSuffixAddCol4184);  
                    stream_KW_ADD.add(add);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1012:32: replace= KW_REPLACE
                    {
                    replace=(Token)match(input,KW_REPLACE,FOLLOW_KW_REPLACE_in_alterStatementSuffixAddCol4190);  
                    stream_KW_REPLACE.add(replace);


                    }
                    break;

            }


            KW_COLUMNS210=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_alterStatementSuffixAddCol4193);  
            stream_KW_COLUMNS.add(KW_COLUMNS210);


            LPAREN211=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_alterStatementSuffixAddCol4195);  
            stream_LPAREN.add(LPAREN211);


            pushFollow(FOLLOW_columnNameTypeList_in_alterStatementSuffixAddCol4197);
            columnNameTypeList212=columnNameTypeList();

            state._fsp--;

            stream_columnNameTypeList.add(columnNameTypeList212.getTree());

            RPAREN213=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_alterStatementSuffixAddCol4199);  
            stream_RPAREN.add(RPAREN213);


            // AST REWRITE
            // elements: columnNameTypeList, identifier, columnNameTypeList, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1013:5: -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS identifier columnNameTypeList )
            if (add != null) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1013:24: ^( TOK_ALTERTABLE_ADDCOLS identifier columnNameTypeList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ADDCOLS, "TOK_ALTERTABLE_ADDCOLS")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1014:5: -> ^( TOK_ALTERTABLE_REPLACECOLS identifier columnNameTypeList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1014:24: ^( TOK_ALTERTABLE_REPLACECOLS identifier columnNameTypeList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_REPLACECOLS, "TOK_ALTERTABLE_REPLACECOLS")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddCol"


    public static class alterStatementSuffixRenameCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRenameCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1017:1: alterStatementSuffixRenameCol : identifier KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? -> ^( TOK_ALTERTABLE_RENAMECOL identifier $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ) ;
    public final HiveParser.alterStatementSuffixRenameCol_return alterStatementSuffixRenameCol() throws RecognitionException {
        HiveParser.alterStatementSuffixRenameCol_return retval = new HiveParser.alterStatementSuffixRenameCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_CHANGE215=null;
        Token KW_COLUMN216=null;
        Token KW_COMMENT218=null;
        HiveParser_IdentifiersParser.identifier_return oldName =null;

        HiveParser_IdentifiersParser.identifier_return newName =null;

        HiveParser_IdentifiersParser.identifier_return identifier214 =null;

        HiveParser.colType_return colType217 =null;

        HiveParser.alterStatementChangeColPosition_return alterStatementChangeColPosition219 =null;


        CommonTree comment_tree=null;
        CommonTree KW_CHANGE215_tree=null;
        CommonTree KW_COLUMN216_tree=null;
        CommonTree KW_COMMENT218_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_CHANGE=new RewriteRuleTokenStream(adaptor,"token KW_CHANGE");
        RewriteRuleSubtreeStream stream_alterStatementChangeColPosition=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementChangeColPosition");
        RewriteRuleSubtreeStream stream_colType=new RewriteRuleSubtreeStream(adaptor,"rule colType");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("rename column name", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:5: ( identifier KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? -> ^( TOK_ALTERTABLE_RENAMECOL identifier $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:7: identifier KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )?
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4272);
            identifier214=identifier();

            state._fsp--;

            stream_identifier.add(identifier214.getTree());

            KW_CHANGE215=(Token)match(input,KW_CHANGE,FOLLOW_KW_CHANGE_in_alterStatementSuffixRenameCol4274);  
            stream_KW_CHANGE.add(KW_CHANGE215);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:28: ( KW_COLUMN )?
            int alt54=2;
            switch ( input.LA(1) ) {
                case KW_COLUMN:
                    {
                    alt54=1;
                    }
                    break;
            }

            switch (alt54) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:28: KW_COLUMN
                    {
                    KW_COLUMN216=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementSuffixRenameCol4276);  
                    stream_KW_COLUMN.add(KW_COLUMN216);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4281);
            oldName=identifier();

            state._fsp--;

            stream_identifier.add(oldName.getTree());

            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4285);
            newName=identifier();

            state._fsp--;

            stream_identifier.add(newName.getTree());

            pushFollow(FOLLOW_colType_in_alterStatementSuffixRenameCol4287);
            colType217=colType();

            state._fsp--;

            stream_colType.add(colType217.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:85: ( KW_COMMENT comment= StringLiteral )?
            int alt55=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt55=1;
                    }
                    break;
            }

            switch (alt55) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:86: KW_COMMENT comment= StringLiteral
                    {
                    KW_COMMENT218=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_alterStatementSuffixRenameCol4290);  
                    stream_KW_COMMENT.add(KW_COMMENT218);


                    comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixRenameCol4294);  
                    stream_StringLiteral.add(comment);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:121: ( alterStatementChangeColPosition )?
            int alt56=2;
            switch ( input.LA(1) ) {
                case KW_AFTER:
                case KW_FIRST:
                    {
                    alt56=1;
                    }
                    break;
            }

            switch (alt56) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:121: alterStatementChangeColPosition
                    {
                    pushFollow(FOLLOW_alterStatementChangeColPosition_in_alterStatementSuffixRenameCol4298);
                    alterStatementChangeColPosition219=alterStatementChangeColPosition();

                    state._fsp--;

                    stream_alterStatementChangeColPosition.add(alterStatementChangeColPosition219.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: oldName, alterStatementChangeColPosition, comment, newName, colType, identifier
            // token labels: comment
            // rule labels: retval, newName, oldName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_newName=new RewriteRuleSubtreeStream(adaptor,"rule newName",newName!=null?newName.tree:null);
            RewriteRuleSubtreeStream stream_oldName=new RewriteRuleSubtreeStream(adaptor,"rule oldName",oldName!=null?oldName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1021:5: -> ^( TOK_ALTERTABLE_RENAMECOL identifier $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1021:7: ^( TOK_ALTERTABLE_RENAMECOL identifier $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAMECOL, "TOK_ALTERTABLE_RENAMECOL")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, stream_oldName.nextTree());

                adaptor.addChild(root_1, stream_newName.nextTree());

                adaptor.addChild(root_1, stream_colType.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1021:72: ( $comment)?
                if ( stream_comment.hasNext() ) {
                    adaptor.addChild(root_1, stream_comment.nextNode());

                }
                stream_comment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1021:81: ( alterStatementChangeColPosition )?
                if ( stream_alterStatementChangeColPosition.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementChangeColPosition.nextTree());

                }
                stream_alterStatementChangeColPosition.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRenameCol"


    public static class alterStatementChangeColPosition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementChangeColPosition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1024:1: alterStatementChangeColPosition : (first= KW_FIRST | KW_AFTER afterCol= identifier -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION ) -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol) );
    public final HiveParser.alterStatementChangeColPosition_return alterStatementChangeColPosition() throws RecognitionException {
        HiveParser.alterStatementChangeColPosition_return retval = new HiveParser.alterStatementChangeColPosition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token first=null;
        Token KW_AFTER220=null;
        HiveParser_IdentifiersParser.identifier_return afterCol =null;


        CommonTree first_tree=null;
        CommonTree KW_AFTER220_tree=null;
        RewriteRuleTokenStream stream_KW_AFTER=new RewriteRuleTokenStream(adaptor,"token KW_AFTER");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1025:5: (first= KW_FIRST | KW_AFTER afterCol= identifier -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION ) -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol) )
            int alt57=2;
            switch ( input.LA(1) ) {
            case KW_FIRST:
                {
                alt57=1;
                }
                break;
            case KW_AFTER:
                {
                alt57=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 57, 0, input);

                throw nvae;

            }

            switch (alt57) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1025:7: first= KW_FIRST
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    first=(Token)match(input,KW_FIRST,FOLLOW_KW_FIRST_in_alterStatementChangeColPosition4344); 
                    first_tree = 
                    (CommonTree)adaptor.create(first)
                    ;
                    adaptor.addChild(root_0, first_tree);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1025:22: KW_AFTER afterCol= identifier
                    {
                    KW_AFTER220=(Token)match(input,KW_AFTER,FOLLOW_KW_AFTER_in_alterStatementChangeColPosition4346);  
                    stream_KW_AFTER.add(KW_AFTER220);


                    pushFollow(FOLLOW_identifier_in_alterStatementChangeColPosition4350);
                    afterCol=identifier();

                    state._fsp--;

                    stream_identifier.add(afterCol.getTree());

                    // AST REWRITE
                    // elements: afterCol
                    // token labels: 
                    // rule labels: retval, afterCol
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_afterCol=new RewriteRuleSubtreeStream(adaptor,"rule afterCol",afterCol!=null?afterCol.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1026:5: -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION )
                    if (first != null) {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1026:25: ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION, "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 1027:5: -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1027:8: ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION, "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION")
                        , root_1);

                        adaptor.addChild(root_1, stream_afterCol.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementChangeColPosition"


    public static class alterStatementSuffixAddPartitions_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddPartitions"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1030:1: alterStatementSuffixAddPartitions : identifier KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ -> ^( TOK_ALTERTABLE_ADDPARTS identifier ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) ;
    public final HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions() throws RecognitionException {
        HiveParser.alterStatementSuffixAddPartitions_return retval = new HiveParser.alterStatementSuffixAddPartitions_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ADD222=null;
        HiveParser_IdentifiersParser.identifier_return identifier221 =null;

        HiveParser.ifNotExists_return ifNotExists223 =null;

        HiveParser.alterStatementSuffixAddPartitionsElement_return alterStatementSuffixAddPartitionsElement224 =null;


        CommonTree KW_ADD222_tree=null;
        RewriteRuleTokenStream stream_KW_ADD=new RewriteRuleTokenStream(adaptor,"token KW_ADD");
        RewriteRuleSubtreeStream stream_alterStatementSuffixAddPartitionsElement=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixAddPartitionsElement");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("add partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:5: ( identifier KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ -> ^( TOK_ALTERTABLE_ADDPARTS identifier ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:7: identifier KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixAddPartitions4402);
            identifier221=identifier();

            state._fsp--;

            stream_identifier.add(identifier221.getTree());

            KW_ADD222=(Token)match(input,KW_ADD,FOLLOW_KW_ADD_in_alterStatementSuffixAddPartitions4404);  
            stream_KW_ADD.add(KW_ADD222);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:25: ( ifNotExists )?
            int alt58=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt58=1;
                    }
                    break;
            }

            switch (alt58) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:25: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_alterStatementSuffixAddPartitions4406);
                    ifNotExists223=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists223.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:38: ( alterStatementSuffixAddPartitionsElement )+
            int cnt59=0;
            loop59:
            do {
                int alt59=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt59=1;
                    }
                    break;

                }

                switch (alt59) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:38: alterStatementSuffixAddPartitionsElement
            	    {
            	    pushFollow(FOLLOW_alterStatementSuffixAddPartitionsElement_in_alterStatementSuffixAddPartitions4409);
            	    alterStatementSuffixAddPartitionsElement224=alterStatementSuffixAddPartitionsElement();

            	    state._fsp--;

            	    stream_alterStatementSuffixAddPartitionsElement.add(alterStatementSuffixAddPartitionsElement224.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt59 >= 1 ) break loop59;
                        EarlyExitException eee =
                            new EarlyExitException(59, input);
                        throw eee;
                }
                cnt59++;
            } while (true);


            // AST REWRITE
            // elements: alterStatementSuffixAddPartitionsElement, identifier, ifNotExists
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1034:5: -> ^( TOK_ALTERTABLE_ADDPARTS identifier ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1034:8: ^( TOK_ALTERTABLE_ADDPARTS identifier ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ADDPARTS, "TOK_ALTERTABLE_ADDPARTS")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1034:45: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                if ( !(stream_alterStatementSuffixAddPartitionsElement.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_alterStatementSuffixAddPartitionsElement.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementSuffixAddPartitionsElement.nextTree());

                }
                stream_alterStatementSuffixAddPartitionsElement.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddPartitions"


    public static class alterStatementSuffixAddPartitionsElement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddPartitionsElement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1037:1: alterStatementSuffixAddPartitionsElement : partitionSpec ( partitionLocation )? ;
    public final HiveParser.alterStatementSuffixAddPartitionsElement_return alterStatementSuffixAddPartitionsElement() throws RecognitionException {
        HiveParser.alterStatementSuffixAddPartitionsElement_return retval = new HiveParser.alterStatementSuffixAddPartitionsElement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec225 =null;

        HiveParser.partitionLocation_return partitionLocation226 =null;



        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1038:5: ( partitionSpec ( partitionLocation )? )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1038:7: partitionSpec ( partitionLocation )?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixAddPartitionsElement4445);
            partitionSpec225=partitionSpec();

            state._fsp--;

            adaptor.addChild(root_0, partitionSpec225.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1038:21: ( partitionLocation )?
            int alt60=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt60=1;
                    }
                    break;
            }

            switch (alt60) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1038:21: partitionLocation
                    {
                    pushFollow(FOLLOW_partitionLocation_in_alterStatementSuffixAddPartitionsElement4447);
                    partitionLocation226=partitionLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, partitionLocation226.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddPartitionsElement"


    public static class alterStatementSuffixTouch_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixTouch"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1041:1: alterStatementSuffixTouch : identifier KW_TOUCH ( partitionSpec )* -> ^( TOK_ALTERTABLE_TOUCH identifier ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixTouch_return alterStatementSuffixTouch() throws RecognitionException {
        HiveParser.alterStatementSuffixTouch_return retval = new HiveParser.alterStatementSuffixTouch_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_TOUCH228=null;
        HiveParser_IdentifiersParser.identifier_return identifier227 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec229 =null;


        CommonTree KW_TOUCH228_tree=null;
        RewriteRuleTokenStream stream_KW_TOUCH=new RewriteRuleTokenStream(adaptor,"token KW_TOUCH");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("touch statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1044:5: ( identifier KW_TOUCH ( partitionSpec )* -> ^( TOK_ALTERTABLE_TOUCH identifier ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1044:7: identifier KW_TOUCH ( partitionSpec )*
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixTouch4475);
            identifier227=identifier();

            state._fsp--;

            stream_identifier.add(identifier227.getTree());

            KW_TOUCH228=(Token)match(input,KW_TOUCH,FOLLOW_KW_TOUCH_in_alterStatementSuffixTouch4477);  
            stream_KW_TOUCH.add(KW_TOUCH228);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1044:27: ( partitionSpec )*
            loop61:
            do {
                int alt61=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt61=1;
                    }
                    break;

                }

                switch (alt61) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1044:28: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixTouch4480);
            	    partitionSpec229=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec229.getTree());

            	    }
            	    break;

            	default :
            	    break loop61;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1045:5: -> ^( TOK_ALTERTABLE_TOUCH identifier ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1045:8: ^( TOK_ALTERTABLE_TOUCH identifier ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_TOUCH, "TOK_ALTERTABLE_TOUCH")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1045:42: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixTouch"


    public static class alterStatementSuffixArchive_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixArchive"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:1: alterStatementSuffixArchive : identifier KW_ARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_ARCHIVE identifier ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixArchive_return alterStatementSuffixArchive() throws RecognitionException {
        HiveParser.alterStatementSuffixArchive_return retval = new HiveParser.alterStatementSuffixArchive_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ARCHIVE231=null;
        HiveParser_IdentifiersParser.identifier_return identifier230 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec232 =null;


        CommonTree KW_ARCHIVE231_tree=null;
        RewriteRuleTokenStream stream_KW_ARCHIVE=new RewriteRuleTokenStream(adaptor,"token KW_ARCHIVE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("archive statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1051:5: ( identifier KW_ARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_ARCHIVE identifier ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1051:7: identifier KW_ARCHIVE ( partitionSpec )*
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixArchive4526);
            identifier230=identifier();

            state._fsp--;

            stream_identifier.add(identifier230.getTree());

            KW_ARCHIVE231=(Token)match(input,KW_ARCHIVE,FOLLOW_KW_ARCHIVE_in_alterStatementSuffixArchive4528);  
            stream_KW_ARCHIVE.add(KW_ARCHIVE231);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1051:29: ( partitionSpec )*
            loop62:
            do {
                int alt62=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt62=1;
                    }
                    break;

                }

                switch (alt62) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1051:30: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixArchive4531);
            	    partitionSpec232=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec232.getTree());

            	    }
            	    break;

            	default :
            	    break loop62;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1052:5: -> ^( TOK_ALTERTABLE_ARCHIVE identifier ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1052:8: ^( TOK_ALTERTABLE_ARCHIVE identifier ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ARCHIVE, "TOK_ALTERTABLE_ARCHIVE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1052:44: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixArchive"


    public static class alterStatementSuffixUnArchive_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixUnArchive"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1055:1: alterStatementSuffixUnArchive : identifier KW_UNARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_UNARCHIVE identifier ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixUnArchive_return alterStatementSuffixUnArchive() throws RecognitionException {
        HiveParser.alterStatementSuffixUnArchive_return retval = new HiveParser.alterStatementSuffixUnArchive_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_UNARCHIVE234=null;
        HiveParser_IdentifiersParser.identifier_return identifier233 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec235 =null;


        CommonTree KW_UNARCHIVE234_tree=null;
        RewriteRuleTokenStream stream_KW_UNARCHIVE=new RewriteRuleTokenStream(adaptor,"token KW_UNARCHIVE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("unarchive statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:5: ( identifier KW_UNARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_UNARCHIVE identifier ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:7: identifier KW_UNARCHIVE ( partitionSpec )*
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixUnArchive4577);
            identifier233=identifier();

            state._fsp--;

            stream_identifier.add(identifier233.getTree());

            KW_UNARCHIVE234=(Token)match(input,KW_UNARCHIVE,FOLLOW_KW_UNARCHIVE_in_alterStatementSuffixUnArchive4579);  
            stream_KW_UNARCHIVE.add(KW_UNARCHIVE234);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:31: ( partitionSpec )*
            loop63:
            do {
                int alt63=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt63=1;
                    }
                    break;

                }

                switch (alt63) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:32: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixUnArchive4582);
            	    partitionSpec235=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec235.getTree());

            	    }
            	    break;

            	default :
            	    break loop63;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1059:5: -> ^( TOK_ALTERTABLE_UNARCHIVE identifier ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1059:8: ^( TOK_ALTERTABLE_UNARCHIVE identifier ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_UNARCHIVE, "TOK_ALTERTABLE_UNARCHIVE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1059:46: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixUnArchive"


    public static class partitionLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "partitionLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1062:1: partitionLocation : KW_LOCATION locn= StringLiteral -> ^( TOK_PARTITIONLOCATION $locn) ;
    public final HiveParser.partitionLocation_return partitionLocation() throws RecognitionException {
        HiveParser.partitionLocation_return retval = new HiveParser.partitionLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token locn=null;
        Token KW_LOCATION236=null;

        CommonTree locn_tree=null;
        CommonTree KW_LOCATION236_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

         pushMsg("partition location", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1065:5: ( KW_LOCATION locn= StringLiteral -> ^( TOK_PARTITIONLOCATION $locn) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1066:7: KW_LOCATION locn= StringLiteral
            {
            KW_LOCATION236=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_partitionLocation4634);  
            stream_KW_LOCATION.add(KW_LOCATION236);


            locn=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_partitionLocation4638);  
            stream_StringLiteral.add(locn);


            // AST REWRITE
            // elements: locn
            // token labels: locn
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_locn=new RewriteRuleTokenStream(adaptor,"token locn",locn);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1066:38: -> ^( TOK_PARTITIONLOCATION $locn)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1066:41: ^( TOK_PARTITIONLOCATION $locn)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PARTITIONLOCATION, "TOK_PARTITIONLOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_locn.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "partitionLocation"


    public static class alterStatementSuffixDropPartitions_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixDropPartitions"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1069:1: alterStatementSuffixDropPartitions : identifier KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? -> ^( TOK_ALTERTABLE_DROPPARTS identifier ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ) ;
    public final HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions() throws RecognitionException {
        HiveParser.alterStatementSuffixDropPartitions_return retval = new HiveParser.alterStatementSuffixDropPartitions_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP238=null;
        Token COMMA241=null;
        HiveParser_IdentifiersParser.identifier_return identifier237 =null;

        HiveParser.ifExists_return ifExists239 =null;

        HiveParser_IdentifiersParser.dropPartitionSpec_return dropPartitionSpec240 =null;

        HiveParser_IdentifiersParser.dropPartitionSpec_return dropPartitionSpec242 =null;

        HiveParser.ignoreProtection_return ignoreProtection243 =null;


        CommonTree KW_DROP238_tree=null;
        CommonTree COMMA241_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_dropPartitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule dropPartitionSpec");
        RewriteRuleSubtreeStream stream_ignoreProtection=new RewriteRuleSubtreeStream(adaptor,"rule ignoreProtection");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("drop partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:5: ( identifier KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? -> ^( TOK_ALTERTABLE_DROPPARTS identifier ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:7: identifier KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )?
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixDropPartitions4674);
            identifier237=identifier();

            state._fsp--;

            stream_identifier.add(identifier237.getTree());

            KW_DROP238=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_alterStatementSuffixDropPartitions4676);  
            stream_KW_DROP.add(KW_DROP238);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:26: ( ifExists )?
            int alt64=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt64=1;
                    }
                    break;
            }

            switch (alt64) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:26: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_alterStatementSuffixDropPartitions4678);
                    ifExists239=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists239.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_dropPartitionSpec_in_alterStatementSuffixDropPartitions4681);
            dropPartitionSpec240=dropPartitionSpec();

            state._fsp--;

            stream_dropPartitionSpec.add(dropPartitionSpec240.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:54: ( COMMA dropPartitionSpec )*
            loop65:
            do {
                int alt65=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt65=1;
                    }
                    break;

                }

                switch (alt65) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:55: COMMA dropPartitionSpec
            	    {
            	    COMMA241=(Token)match(input,COMMA,FOLLOW_COMMA_in_alterStatementSuffixDropPartitions4684);  
            	    stream_COMMA.add(COMMA241);


            	    pushFollow(FOLLOW_dropPartitionSpec_in_alterStatementSuffixDropPartitions4686);
            	    dropPartitionSpec242=dropPartitionSpec();

            	    state._fsp--;

            	    stream_dropPartitionSpec.add(dropPartitionSpec242.getTree());

            	    }
            	    break;

            	default :
            	    break loop65;
                }
            } while (true);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:81: ( ignoreProtection )?
            int alt66=2;
            switch ( input.LA(1) ) {
                case KW_IGNORE:
                    {
                    alt66=1;
                    }
                    break;
            }

            switch (alt66) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:81: ignoreProtection
                    {
                    pushFollow(FOLLOW_ignoreProtection_in_alterStatementSuffixDropPartitions4690);
                    ignoreProtection243=ignoreProtection();

                    state._fsp--;

                    stream_ignoreProtection.add(ignoreProtection243.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: dropPartitionSpec, ignoreProtection, ifExists, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1073:5: -> ^( TOK_ALTERTABLE_DROPPARTS identifier ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1073:8: ^( TOK_ALTERTABLE_DROPPARTS identifier ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_DROPPARTS, "TOK_ALTERTABLE_DROPPARTS")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                if ( !(stream_dropPartitionSpec.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_dropPartitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_dropPartitionSpec.nextTree());

                }
                stream_dropPartitionSpec.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1073:65: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1073:75: ( ignoreProtection )?
                if ( stream_ignoreProtection.hasNext() ) {
                    adaptor.addChild(root_1, stream_ignoreProtection.nextTree());

                }
                stream_ignoreProtection.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixDropPartitions"


    public static class alterStatementSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:1: alterStatementSuffixProperties : (name= identifier KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_PROPERTIES $name tableProperties ) |name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_DROPTABLE_PROPERTIES $name tableProperties ( ifExists )? ) );
    public final HiveParser.alterStatementSuffixProperties_return alterStatementSuffixProperties() throws RecognitionException {
        HiveParser.alterStatementSuffixProperties_return retval = new HiveParser.alterStatementSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET244=null;
        Token KW_TBLPROPERTIES245=null;
        Token KW_UNSET247=null;
        Token KW_TBLPROPERTIES248=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.tableProperties_return tableProperties246 =null;

        HiveParser.ifExists_return ifExists249 =null;

        HiveParser.tableProperties_return tableProperties250 =null;


        CommonTree KW_SET244_tree=null;
        CommonTree KW_TBLPROPERTIES245_tree=null;
        CommonTree KW_UNSET247_tree=null;
        CommonTree KW_TBLPROPERTIES248_tree=null;
        RewriteRuleTokenStream stream_KW_UNSET=new RewriteRuleTokenStream(adaptor,"token KW_UNSET");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1079:5: (name= identifier KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_PROPERTIES $name tableProperties ) |name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_DROPTABLE_PROPERTIES $name tableProperties ( ifExists )? ) )
            int alt68=2;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    alt68=1;
                    }
                    break;
                case KW_UNSET:
                    {
                    alt68=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 68, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARQUETFILE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    alt68=1;
                    }
                    break;
                case KW_UNSET:
                    {
                    alt68=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 68, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 68, 0, input);

                throw nvae;

            }

            switch (alt68) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1079:7: name= identifier KW_SET KW_TBLPROPERTIES tableProperties
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixProperties4741);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_SET244=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixProperties4743);  
                    stream_KW_SET.add(KW_SET244);


                    KW_TBLPROPERTIES245=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterStatementSuffixProperties4745);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES245);


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixProperties4747);
                    tableProperties246=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties246.getTree());

                    // AST REWRITE
                    // elements: name, tableProperties
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1080:5: -> ^( TOK_ALTERTABLE_PROPERTIES $name tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1080:8: ^( TOK_ALTERTABLE_PROPERTIES $name tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_PROPERTIES, "TOK_ALTERTABLE_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1081:7: name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixProperties4772);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_UNSET247=(Token)match(input,KW_UNSET,FOLLOW_KW_UNSET_in_alterStatementSuffixProperties4774);  
                    stream_KW_UNSET.add(KW_UNSET247);


                    KW_TBLPROPERTIES248=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterStatementSuffixProperties4776);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES248);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1081:49: ( ifExists )?
                    int alt67=2;
                    switch ( input.LA(1) ) {
                        case KW_IF:
                            {
                            alt67=1;
                            }
                            break;
                    }

                    switch (alt67) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1081:49: ifExists
                            {
                            pushFollow(FOLLOW_ifExists_in_alterStatementSuffixProperties4778);
                            ifExists249=ifExists();

                            state._fsp--;

                            stream_ifExists.add(ifExists249.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixProperties4781);
                    tableProperties250=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties250.getTree());

                    // AST REWRITE
                    // elements: tableProperties, ifExists, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1082:5: -> ^( TOK_DROPTABLE_PROPERTIES $name tableProperties ( ifExists )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1082:8: ^( TOK_DROPTABLE_PROPERTIES $name tableProperties ( ifExists )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DROPTABLE_PROPERTIES, "TOK_DROPTABLE_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1082:57: ( ifExists )?
                        if ( stream_ifExists.hasNext() ) {
                            adaptor.addChild(root_1, stream_ifExists.nextTree());

                        }
                        stream_ifExists.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixProperties"


    public static class alterViewSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterViewSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1085:1: alterViewSuffixProperties : (name= identifier KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERVIEW_PROPERTIES $name tableProperties ) |name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_DROPVIEW_PROPERTIES $name tableProperties ( ifExists )? ) );
    public final HiveParser.alterViewSuffixProperties_return alterViewSuffixProperties() throws RecognitionException {
        HiveParser.alterViewSuffixProperties_return retval = new HiveParser.alterViewSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET251=null;
        Token KW_TBLPROPERTIES252=null;
        Token KW_UNSET254=null;
        Token KW_TBLPROPERTIES255=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.tableProperties_return tableProperties253 =null;

        HiveParser.ifExists_return ifExists256 =null;

        HiveParser.tableProperties_return tableProperties257 =null;


        CommonTree KW_SET251_tree=null;
        CommonTree KW_TBLPROPERTIES252_tree=null;
        CommonTree KW_UNSET254_tree=null;
        CommonTree KW_TBLPROPERTIES255_tree=null;
        RewriteRuleTokenStream stream_KW_UNSET=new RewriteRuleTokenStream(adaptor,"token KW_UNSET");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("alter view properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1088:5: (name= identifier KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERVIEW_PROPERTIES $name tableProperties ) |name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_DROPVIEW_PROPERTIES $name tableProperties ( ifExists )? ) )
            int alt70=2;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    alt70=1;
                    }
                    break;
                case KW_UNSET:
                    {
                    alt70=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 70, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARQUETFILE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    alt70=1;
                    }
                    break;
                case KW_UNSET:
                    {
                    alt70=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 70, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;

            }

            switch (alt70) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1088:7: name= identifier KW_SET KW_TBLPROPERTIES tableProperties
                    {
                    pushFollow(FOLLOW_identifier_in_alterViewSuffixProperties4828);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_SET251=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterViewSuffixProperties4830);  
                    stream_KW_SET.add(KW_SET251);


                    KW_TBLPROPERTIES252=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterViewSuffixProperties4832);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES252);


                    pushFollow(FOLLOW_tableProperties_in_alterViewSuffixProperties4834);
                    tableProperties253=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties253.getTree());

                    // AST REWRITE
                    // elements: name, tableProperties
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1089:5: -> ^( TOK_ALTERVIEW_PROPERTIES $name tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1089:8: ^( TOK_ALTERVIEW_PROPERTIES $name tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_PROPERTIES, "TOK_ALTERVIEW_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1090:7: name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties
                    {
                    pushFollow(FOLLOW_identifier_in_alterViewSuffixProperties4859);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_UNSET254=(Token)match(input,KW_UNSET,FOLLOW_KW_UNSET_in_alterViewSuffixProperties4861);  
                    stream_KW_UNSET.add(KW_UNSET254);


                    KW_TBLPROPERTIES255=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterViewSuffixProperties4863);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES255);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1090:49: ( ifExists )?
                    int alt69=2;
                    switch ( input.LA(1) ) {
                        case KW_IF:
                            {
                            alt69=1;
                            }
                            break;
                    }

                    switch (alt69) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1090:49: ifExists
                            {
                            pushFollow(FOLLOW_ifExists_in_alterViewSuffixProperties4865);
                            ifExists256=ifExists();

                            state._fsp--;

                            stream_ifExists.add(ifExists256.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableProperties_in_alterViewSuffixProperties4868);
                    tableProperties257=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties257.getTree());

                    // AST REWRITE
                    // elements: tableProperties, ifExists, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1091:5: -> ^( TOK_DROPVIEW_PROPERTIES $name tableProperties ( ifExists )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1091:8: ^( TOK_DROPVIEW_PROPERTIES $name tableProperties ( ifExists )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DROPVIEW_PROPERTIES, "TOK_DROPVIEW_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1091:56: ( ifExists )?
                        if ( stream_ifExists.hasNext() ) {
                            adaptor.addChild(root_1, stream_ifExists.nextTree());

                        }
                        stream_ifExists.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterViewSuffixProperties"


    public static class alterStatementSuffixSerdeProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixSerdeProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1094:1: alterStatementSuffixSerdeProperties : ( KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )? -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? ) | KW_SET KW_SERDEPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties ) );
    public final HiveParser.alterStatementSuffixSerdeProperties_return alterStatementSuffixSerdeProperties() throws RecognitionException {
        HiveParser.alterStatementSuffixSerdeProperties_return retval = new HiveParser.alterStatementSuffixSerdeProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token serdeName=null;
        Token KW_SET258=null;
        Token KW_SERDE259=null;
        Token KW_WITH260=null;
        Token KW_SERDEPROPERTIES261=null;
        Token KW_SET263=null;
        Token KW_SERDEPROPERTIES264=null;
        HiveParser.tableProperties_return tableProperties262 =null;

        HiveParser.tableProperties_return tableProperties265 =null;


        CommonTree serdeName_tree=null;
        CommonTree KW_SET258_tree=null;
        CommonTree KW_SERDE259_tree=null;
        CommonTree KW_WITH260_tree=null;
        CommonTree KW_SERDEPROPERTIES261_tree=null;
        CommonTree KW_SET263_tree=null;
        CommonTree KW_SERDEPROPERTIES264_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_SERDE=new RewriteRuleTokenStream(adaptor,"token KW_SERDE");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_SERDEPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_SERDEPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
         pushMsg("alter serdes statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1097:5: ( KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )? -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? ) | KW_SET KW_SERDEPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties ) )
            int alt72=2;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_SERDE:
                    {
                    alt72=1;
                    }
                    break;
                case KW_SERDEPROPERTIES:
                    {
                    alt72=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 72, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 72, 0, input);

                throw nvae;

            }

            switch (alt72) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1097:7: KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )?
                    {
                    KW_SET258=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixSerdeProperties4913);  
                    stream_KW_SET.add(KW_SET258);


                    KW_SERDE259=(Token)match(input,KW_SERDE,FOLLOW_KW_SERDE_in_alterStatementSuffixSerdeProperties4915);  
                    stream_KW_SERDE.add(KW_SERDE259);


                    serdeName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixSerdeProperties4919);  
                    stream_StringLiteral.add(serdeName);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1097:47: ( KW_WITH KW_SERDEPROPERTIES tableProperties )?
                    int alt71=2;
                    switch ( input.LA(1) ) {
                        case KW_WITH:
                            {
                            alt71=1;
                            }
                            break;
                    }

                    switch (alt71) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1097:48: KW_WITH KW_SERDEPROPERTIES tableProperties
                            {
                            KW_WITH260=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_alterStatementSuffixSerdeProperties4922);  
                            stream_KW_WITH.add(KW_WITH260);


                            KW_SERDEPROPERTIES261=(Token)match(input,KW_SERDEPROPERTIES,FOLLOW_KW_SERDEPROPERTIES_in_alterStatementSuffixSerdeProperties4924);  
                            stream_KW_SERDEPROPERTIES.add(KW_SERDEPROPERTIES261);


                            pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixSerdeProperties4926);
                            tableProperties262=tableProperties();

                            state._fsp--;

                            stream_tableProperties.add(tableProperties262.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: serdeName, tableProperties
                    // token labels: serdeName
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_serdeName=new RewriteRuleTokenStream(adaptor,"token serdeName",serdeName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1098:5: -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1098:8: ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SERIALIZER, "TOK_ALTERTABLE_SERIALIZER")
                        , root_1);

                        adaptor.addChild(root_1, stream_serdeName.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1098:47: ( tableProperties )?
                        if ( stream_tableProperties.hasNext() ) {
                            adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        }
                        stream_tableProperties.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1099:7: KW_SET KW_SERDEPROPERTIES tableProperties
                    {
                    KW_SET263=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixSerdeProperties4952);  
                    stream_KW_SET.add(KW_SET263);


                    KW_SERDEPROPERTIES264=(Token)match(input,KW_SERDEPROPERTIES,FOLLOW_KW_SERDEPROPERTIES_in_alterStatementSuffixSerdeProperties4954);  
                    stream_KW_SERDEPROPERTIES.add(KW_SERDEPROPERTIES264);


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixSerdeProperties4956);
                    tableProperties265=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties265.getTree());

                    // AST REWRITE
                    // elements: tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1100:5: -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1100:8: ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SERDEPROPERTIES, "TOK_ALTERTABLE_SERDEPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixSerdeProperties"


    public static class tablePartitionPrefix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tablePartitionPrefix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1103:1: tablePartitionPrefix : name= identifier ( partitionSpec )? -> ^( TOK_TABLE_PARTITION $name ( partitionSpec )? ) ;
    public final HiveParser.tablePartitionPrefix_return tablePartitionPrefix() throws RecognitionException {
        HiveParser.tablePartitionPrefix_return retval = new HiveParser.tablePartitionPrefix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec266 =null;


        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("table partition prefix", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1106:3: (name= identifier ( partitionSpec )? -> ^( TOK_TABLE_PARTITION $name ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1106:4: name= identifier ( partitionSpec )?
            {
            pushFollow(FOLLOW_identifier_in_tablePartitionPrefix4994);
            name=identifier();

            state._fsp--;

            stream_identifier.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1106:20: ( partitionSpec )?
            int alt73=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt73=1;
                    }
                    break;
            }

            switch (alt73) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1106:20: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_tablePartitionPrefix4996);
                    partitionSpec266=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec266.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, name
            // token labels: 
            // rule labels: retval, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1107:3: -> ^( TOK_TABLE_PARTITION $name ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1107:5: ^( TOK_TABLE_PARTITION $name ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLE_PARTITION, "TOK_TABLE_PARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1107:33: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tablePartitionPrefix"


    public static class alterTblPartitionStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1110:1: alterTblPartitionStatement : tablePartitionPrefix alterTblPartitionStatementSuffix -> ^( TOK_ALTERTABLE_PARTITION tablePartitionPrefix alterTblPartitionStatementSuffix ) ;
    public final HiveParser.alterTblPartitionStatement_return alterTblPartitionStatement() throws RecognitionException {
        HiveParser.alterTblPartitionStatement_return retval = new HiveParser.alterTblPartitionStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.tablePartitionPrefix_return tablePartitionPrefix267 =null;

        HiveParser.alterTblPartitionStatementSuffix_return alterTblPartitionStatementSuffix268 =null;


        RewriteRuleSubtreeStream stream_alterTblPartitionStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterTblPartitionStatementSuffix");
        RewriteRuleSubtreeStream stream_tablePartitionPrefix=new RewriteRuleSubtreeStream(adaptor,"rule tablePartitionPrefix");
        pushMsg("alter table partition statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1113:3: ( tablePartitionPrefix alterTblPartitionStatementSuffix -> ^( TOK_ALTERTABLE_PARTITION tablePartitionPrefix alterTblPartitionStatementSuffix ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1113:5: tablePartitionPrefix alterTblPartitionStatementSuffix
            {
            pushFollow(FOLLOW_tablePartitionPrefix_in_alterTblPartitionStatement5033);
            tablePartitionPrefix267=tablePartitionPrefix();

            state._fsp--;

            stream_tablePartitionPrefix.add(tablePartitionPrefix267.getTree());

            pushFollow(FOLLOW_alterTblPartitionStatementSuffix_in_alterTblPartitionStatement5035);
            alterTblPartitionStatementSuffix268=alterTblPartitionStatementSuffix();

            state._fsp--;

            stream_alterTblPartitionStatementSuffix.add(alterTblPartitionStatementSuffix268.getTree());

            // AST REWRITE
            // elements: alterTblPartitionStatementSuffix, tablePartitionPrefix
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1114:3: -> ^( TOK_ALTERTABLE_PARTITION tablePartitionPrefix alterTblPartitionStatementSuffix )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1114:6: ^( TOK_ALTERTABLE_PARTITION tablePartitionPrefix alterTblPartitionStatementSuffix )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_PARTITION, "TOK_ALTERTABLE_PARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_tablePartitionPrefix.nextTree());

                adaptor.addChild(root_1, stream_alterTblPartitionStatementSuffix.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatement"


    public static class alterTblPartitionStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1117:1: alterTblPartitionStatementSuffix : ( alterStatementSuffixFileFormat | alterStatementSuffixLocation | alterStatementSuffixProtectMode | alterStatementSuffixMergeFiles | alterStatementSuffixSerdeProperties | alterStatementSuffixRenamePart | alterStatementSuffixBucketNum | alterTblPartitionStatementSuffixSkewedLocation | alterStatementSuffixClusterbySortby | alterStatementSuffixCompact );
    public final HiveParser.alterTblPartitionStatementSuffix_return alterTblPartitionStatementSuffix() throws RecognitionException {
        HiveParser.alterTblPartitionStatementSuffix_return retval = new HiveParser.alterTblPartitionStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterStatementSuffixFileFormat_return alterStatementSuffixFileFormat269 =null;

        HiveParser.alterStatementSuffixLocation_return alterStatementSuffixLocation270 =null;

        HiveParser.alterStatementSuffixProtectMode_return alterStatementSuffixProtectMode271 =null;

        HiveParser.alterStatementSuffixMergeFiles_return alterStatementSuffixMergeFiles272 =null;

        HiveParser.alterStatementSuffixSerdeProperties_return alterStatementSuffixSerdeProperties273 =null;

        HiveParser.alterStatementSuffixRenamePart_return alterStatementSuffixRenamePart274 =null;

        HiveParser.alterStatementSuffixBucketNum_return alterStatementSuffixBucketNum275 =null;

        HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return alterTblPartitionStatementSuffixSkewedLocation276 =null;

        HiveParser.alterStatementSuffixClusterbySortby_return alterStatementSuffixClusterbySortby277 =null;

        HiveParser.alterStatementSuffixCompact_return alterStatementSuffixCompact278 =null;



        pushMsg("alter table partition statement suffix", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1120:3: ( alterStatementSuffixFileFormat | alterStatementSuffixLocation | alterStatementSuffixProtectMode | alterStatementSuffixMergeFiles | alterStatementSuffixSerdeProperties | alterStatementSuffixRenamePart | alterStatementSuffixBucketNum | alterTblPartitionStatementSuffixSkewedLocation | alterStatementSuffixClusterbySortby | alterStatementSuffixCompact )
            int alt74=10;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_FILEFORMAT:
                    {
                    alt74=1;
                    }
                    break;
                case KW_LOCATION:
                    {
                    alt74=2;
                    }
                    break;
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                    {
                    alt74=5;
                    }
                    break;
                case KW_SKEWED:
                    {
                    alt74=8;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 74, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_DISABLE:
            case KW_ENABLE:
                {
                alt74=3;
                }
                break;
            case KW_CONCATENATE:
                {
                alt74=4;
                }
                break;
            case KW_RENAME:
                {
                alt74=6;
                }
                break;
            case KW_INTO:
                {
                alt74=7;
                }
                break;
            case KW_CLUSTERED:
            case KW_NOT:
                {
                alt74=9;
                }
                break;
            case KW_COMPACT:
                {
                alt74=10;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 74, 0, input);

                throw nvae;

            }

            switch (alt74) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1120:5: alterStatementSuffixFileFormat
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixFileFormat_in_alterTblPartitionStatementSuffix5070);
                    alterStatementSuffixFileFormat269=alterStatementSuffixFileFormat();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixFileFormat269.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1121:5: alterStatementSuffixLocation
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixLocation_in_alterTblPartitionStatementSuffix5076);
                    alterStatementSuffixLocation270=alterStatementSuffixLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixLocation270.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1122:5: alterStatementSuffixProtectMode
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixProtectMode_in_alterTblPartitionStatementSuffix5082);
                    alterStatementSuffixProtectMode271=alterStatementSuffixProtectMode();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixProtectMode271.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1123:5: alterStatementSuffixMergeFiles
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixMergeFiles_in_alterTblPartitionStatementSuffix5088);
                    alterStatementSuffixMergeFiles272=alterStatementSuffixMergeFiles();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixMergeFiles272.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1124:5: alterStatementSuffixSerdeProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixSerdeProperties_in_alterTblPartitionStatementSuffix5094);
                    alterStatementSuffixSerdeProperties273=alterStatementSuffixSerdeProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixSerdeProperties273.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1125:5: alterStatementSuffixRenamePart
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRenamePart_in_alterTblPartitionStatementSuffix5100);
                    alterStatementSuffixRenamePart274=alterStatementSuffixRenamePart();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRenamePart274.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1126:5: alterStatementSuffixBucketNum
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixBucketNum_in_alterTblPartitionStatementSuffix5106);
                    alterStatementSuffixBucketNum275=alterStatementSuffixBucketNum();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixBucketNum275.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1127:5: alterTblPartitionStatementSuffixSkewedLocation
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterTblPartitionStatementSuffixSkewedLocation_in_alterTblPartitionStatementSuffix5112);
                    alterTblPartitionStatementSuffixSkewedLocation276=alterTblPartitionStatementSuffixSkewedLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, alterTblPartitionStatementSuffixSkewedLocation276.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1128:5: alterStatementSuffixClusterbySortby
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixClusterbySortby_in_alterTblPartitionStatementSuffix5118);
                    alterStatementSuffixClusterbySortby277=alterStatementSuffixClusterbySortby();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixClusterbySortby277.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1129:5: alterStatementSuffixCompact
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixCompact_in_alterTblPartitionStatementSuffix5124);
                    alterStatementSuffixCompact278=alterStatementSuffixCompact();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixCompact278.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatementSuffix"


    public static class alterStatementSuffixFileFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixFileFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1132:1: alterStatementSuffixFileFormat : KW_SET KW_FILEFORMAT fileFormat -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat ) ;
    public final HiveParser.alterStatementSuffixFileFormat_return alterStatementSuffixFileFormat() throws RecognitionException {
        HiveParser.alterStatementSuffixFileFormat_return retval = new HiveParser.alterStatementSuffixFileFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET279=null;
        Token KW_FILEFORMAT280=null;
        HiveParser.fileFormat_return fileFormat281 =null;


        CommonTree KW_SET279_tree=null;
        CommonTree KW_FILEFORMAT280_tree=null;
        RewriteRuleTokenStream stream_KW_FILEFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_FILEFORMAT");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_fileFormat=new RewriteRuleSubtreeStream(adaptor,"rule fileFormat");
        pushMsg("alter fileformat statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:2: ( KW_SET KW_FILEFORMAT fileFormat -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:4: KW_SET KW_FILEFORMAT fileFormat
            {
            KW_SET279=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixFileFormat5146);  
            stream_KW_SET.add(KW_SET279);


            KW_FILEFORMAT280=(Token)match(input,KW_FILEFORMAT,FOLLOW_KW_FILEFORMAT_in_alterStatementSuffixFileFormat5148);  
            stream_KW_FILEFORMAT.add(KW_FILEFORMAT280);


            pushFollow(FOLLOW_fileFormat_in_alterStatementSuffixFileFormat5150);
            fileFormat281=fileFormat();

            state._fsp--;

            stream_fileFormat.add(fileFormat281.getTree());

            // AST REWRITE
            // elements: fileFormat
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1136:2: -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1136:5: ^( TOK_ALTERTABLE_FILEFORMAT fileFormat )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_FILEFORMAT, "TOK_ALTERTABLE_FILEFORMAT")
                , root_1);

                adaptor.addChild(root_1, stream_fileFormat.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixFileFormat"


    public static class alterStatementSuffixClusterbySortby_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixClusterbySortby"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1139:1: alterStatementSuffixClusterbySortby : ( KW_NOT KW_CLUSTERED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED ) | KW_NOT KW_SORTED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED ) | tableBuckets -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets ) );
    public final HiveParser.alterStatementSuffixClusterbySortby_return alterStatementSuffixClusterbySortby() throws RecognitionException {
        HiveParser.alterStatementSuffixClusterbySortby_return retval = new HiveParser.alterStatementSuffixClusterbySortby_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_NOT282=null;
        Token KW_CLUSTERED283=null;
        Token KW_NOT284=null;
        Token KW_SORTED285=null;
        HiveParser.tableBuckets_return tableBuckets286 =null;


        CommonTree KW_NOT282_tree=null;
        CommonTree KW_CLUSTERED283_tree=null;
        CommonTree KW_NOT284_tree=null;
        CommonTree KW_SORTED285_tree=null;
        RewriteRuleTokenStream stream_KW_CLUSTERED=new RewriteRuleTokenStream(adaptor,"token KW_CLUSTERED");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_SORTED=new RewriteRuleTokenStream(adaptor,"token KW_SORTED");
        RewriteRuleSubtreeStream stream_tableBuckets=new RewriteRuleSubtreeStream(adaptor,"rule tableBuckets");
        pushMsg("alter partition cluster by sort by statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:3: ( KW_NOT KW_CLUSTERED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED ) | KW_NOT KW_SORTED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED ) | tableBuckets -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets ) )
            int alt75=3;
            switch ( input.LA(1) ) {
            case KW_NOT:
                {
                switch ( input.LA(2) ) {
                case KW_CLUSTERED:
                    {
                    alt75=1;
                    }
                    break;
                case KW_SORTED:
                    {
                    alt75=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 75, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_CLUSTERED:
                {
                alt75=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 75, 0, input);

                throw nvae;

            }

            switch (alt75) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:5: KW_NOT KW_CLUSTERED
                    {
                    KW_NOT282=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixClusterbySortby5181);  
                    stream_KW_NOT.add(KW_NOT282);


                    KW_CLUSTERED283=(Token)match(input,KW_CLUSTERED,FOLLOW_KW_CLUSTERED_in_alterStatementSuffixClusterbySortby5183);  
                    stream_KW_CLUSTERED.add(KW_CLUSTERED283);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1142:25: -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:28: ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_NOT_CLUSTERED, "TOK_NOT_CLUSTERED")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1143:5: KW_NOT KW_SORTED
                    {
                    KW_NOT284=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixClusterbySortby5197);  
                    stream_KW_NOT.add(KW_NOT284);


                    KW_SORTED285=(Token)match(input,KW_SORTED,FOLLOW_KW_SORTED_in_alterStatementSuffixClusterbySortby5199);  
                    stream_KW_SORTED.add(KW_SORTED285);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1143:22: -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1143:25: ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_NOT_SORTED, "TOK_NOT_SORTED")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1144:5: tableBuckets
                    {
                    pushFollow(FOLLOW_tableBuckets_in_alterStatementSuffixClusterbySortby5213);
                    tableBuckets286=tableBuckets();

                    state._fsp--;

                    stream_tableBuckets.add(tableBuckets286.getTree());

                    // AST REWRITE
                    // elements: tableBuckets
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1144:18: -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1144:21: ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableBuckets.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixClusterbySortby"


    public static class alterTblPartitionStatementSuffixSkewedLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatementSuffixSkewedLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1147:1: alterTblPartitionStatementSuffixSkewedLocation : KW_SET KW_SKEWED KW_LOCATION skewedLocations -> ^( TOK_ALTERTBLPART_SKEWED_LOCATION skewedLocations ) ;
    public final HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return alterTblPartitionStatementSuffixSkewedLocation() throws RecognitionException {
        HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return retval = new HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET287=null;
        Token KW_SKEWED288=null;
        Token KW_LOCATION289=null;
        HiveParser.skewedLocations_return skewedLocations290 =null;


        CommonTree KW_SET287_tree=null;
        CommonTree KW_SKEWED288_tree=null;
        CommonTree KW_LOCATION289_tree=null;
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");
        RewriteRuleSubtreeStream stream_skewedLocations=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocations");
        pushMsg("alter partition skewed location", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1150:3: ( KW_SET KW_SKEWED KW_LOCATION skewedLocations -> ^( TOK_ALTERTBLPART_SKEWED_LOCATION skewedLocations ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1150:5: KW_SET KW_SKEWED KW_LOCATION skewedLocations
            {
            KW_SET287=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterTblPartitionStatementSuffixSkewedLocation5244);  
            stream_KW_SET.add(KW_SET287);


            KW_SKEWED288=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_alterTblPartitionStatementSuffixSkewedLocation5246);  
            stream_KW_SKEWED.add(KW_SKEWED288);


            KW_LOCATION289=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_alterTblPartitionStatementSuffixSkewedLocation5248);  
            stream_KW_LOCATION.add(KW_LOCATION289);


            pushFollow(FOLLOW_skewedLocations_in_alterTblPartitionStatementSuffixSkewedLocation5250);
            skewedLocations290=skewedLocations();

            state._fsp--;

            stream_skewedLocations.add(skewedLocations290.getTree());

            // AST REWRITE
            // elements: skewedLocations
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1151:3: -> ^( TOK_ALTERTBLPART_SKEWED_LOCATION skewedLocations )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1151:6: ^( TOK_ALTERTBLPART_SKEWED_LOCATION skewedLocations )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTBLPART_SKEWED_LOCATION, "TOK_ALTERTBLPART_SKEWED_LOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_skewedLocations.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatementSuffixSkewedLocation"


    public static class skewedLocations_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocations"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1154:1: skewedLocations : LPAREN skewedLocationsList RPAREN -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList ) ;
    public final HiveParser.skewedLocations_return skewedLocations() throws RecognitionException {
        HiveParser.skewedLocations_return retval = new HiveParser.skewedLocations_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN291=null;
        Token RPAREN293=null;
        HiveParser.skewedLocationsList_return skewedLocationsList292 =null;


        CommonTree LPAREN291_tree=null;
        CommonTree RPAREN293_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_skewedLocationsList=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocationsList");
         pushMsg("skewed locations", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1157:5: ( LPAREN skewedLocationsList RPAREN -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1158:7: LPAREN skewedLocationsList RPAREN
            {
            LPAREN291=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_skewedLocations5293);  
            stream_LPAREN.add(LPAREN291);


            pushFollow(FOLLOW_skewedLocationsList_in_skewedLocations5295);
            skewedLocationsList292=skewedLocationsList();

            state._fsp--;

            stream_skewedLocationsList.add(skewedLocationsList292.getTree());

            RPAREN293=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_skewedLocations5297);  
            stream_RPAREN.add(RPAREN293);


            // AST REWRITE
            // elements: skewedLocationsList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1158:41: -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1158:44: ^( TOK_SKEWED_LOCATIONS skewedLocationsList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATIONS, "TOK_SKEWED_LOCATIONS")
                , root_1);

                adaptor.addChild(root_1, stream_skewedLocationsList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocations"


    public static class skewedLocationsList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocationsList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1161:1: skewedLocationsList : skewedLocationMap ( COMMA skewedLocationMap )* -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ ) ;
    public final HiveParser.skewedLocationsList_return skewedLocationsList() throws RecognitionException {
        HiveParser.skewedLocationsList_return retval = new HiveParser.skewedLocationsList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA295=null;
        HiveParser.skewedLocationMap_return skewedLocationMap294 =null;

        HiveParser.skewedLocationMap_return skewedLocationMap296 =null;


        CommonTree COMMA295_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_skewedLocationMap=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocationMap");
         pushMsg("skewed locations list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1164:5: ( skewedLocationMap ( COMMA skewedLocationMap )* -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:7: skewedLocationMap ( COMMA skewedLocationMap )*
            {
            pushFollow(FOLLOW_skewedLocationMap_in_skewedLocationsList5338);
            skewedLocationMap294=skewedLocationMap();

            state._fsp--;

            stream_skewedLocationMap.add(skewedLocationMap294.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:25: ( COMMA skewedLocationMap )*
            loop76:
            do {
                int alt76=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt76=1;
                    }
                    break;

                }

                switch (alt76) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:26: COMMA skewedLocationMap
            	    {
            	    COMMA295=(Token)match(input,COMMA,FOLLOW_COMMA_in_skewedLocationsList5341);  
            	    stream_COMMA.add(COMMA295);


            	    pushFollow(FOLLOW_skewedLocationMap_in_skewedLocationsList5343);
            	    skewedLocationMap296=skewedLocationMap();

            	    state._fsp--;

            	    stream_skewedLocationMap.add(skewedLocationMap296.getTree());

            	    }
            	    break;

            	default :
            	    break loop76;
                }
            } while (true);


            // AST REWRITE
            // elements: skewedLocationMap
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1165:52: -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:55: ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATION_LIST, "TOK_SKEWED_LOCATION_LIST")
                , root_1);

                if ( !(stream_skewedLocationMap.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_skewedLocationMap.hasNext() ) {
                    adaptor.addChild(root_1, stream_skewedLocationMap.nextTree());

                }
                stream_skewedLocationMap.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocationsList"


    public static class skewedLocationMap_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocationMap"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1168:1: skewedLocationMap : key= skewedValueLocationElement EQUAL value= StringLiteral -> ^( TOK_SKEWED_LOCATION_MAP $key $value) ;
    public final HiveParser.skewedLocationMap_return skewedLocationMap() throws RecognitionException {
        HiveParser.skewedLocationMap_return retval = new HiveParser.skewedLocationMap_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token value=null;
        Token EQUAL297=null;
        HiveParser.skewedValueLocationElement_return key =null;


        CommonTree value_tree=null;
        CommonTree EQUAL297_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
        RewriteRuleSubtreeStream stream_skewedValueLocationElement=new RewriteRuleSubtreeStream(adaptor,"rule skewedValueLocationElement");
         pushMsg("specifying skewed location map", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1171:5: (key= skewedValueLocationElement EQUAL value= StringLiteral -> ^( TOK_SKEWED_LOCATION_MAP $key $value) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1172:7: key= skewedValueLocationElement EQUAL value= StringLiteral
            {
            pushFollow(FOLLOW_skewedValueLocationElement_in_skewedLocationMap5389);
            key=skewedValueLocationElement();

            state._fsp--;

            stream_skewedValueLocationElement.add(key.getTree());

            EQUAL297=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_skewedLocationMap5391);  
            stream_EQUAL.add(EQUAL297);


            value=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_skewedLocationMap5395);  
            stream_StringLiteral.add(value);


            // AST REWRITE
            // elements: key, value
            // token labels: value
            // rule labels: retval, key
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_value=new RewriteRuleTokenStream(adaptor,"token value",value);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_key=new RewriteRuleSubtreeStream(adaptor,"rule key",key!=null?key.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1172:64: -> ^( TOK_SKEWED_LOCATION_MAP $key $value)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1172:67: ^( TOK_SKEWED_LOCATION_MAP $key $value)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATION_MAP, "TOK_SKEWED_LOCATION_MAP")
                , root_1);

                adaptor.addChild(root_1, stream_key.nextTree());

                adaptor.addChild(root_1, stream_value.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocationMap"


    public static class alterStatementSuffixLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1175:1: alterStatementSuffixLocation : KW_SET KW_LOCATION newLoc= StringLiteral -> ^( TOK_ALTERTABLE_LOCATION $newLoc) ;
    public final HiveParser.alterStatementSuffixLocation_return alterStatementSuffixLocation() throws RecognitionException {
        HiveParser.alterStatementSuffixLocation_return retval = new HiveParser.alterStatementSuffixLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token newLoc=null;
        Token KW_SET298=null;
        Token KW_LOCATION299=null;

        CommonTree newLoc_tree=null;
        CommonTree KW_SET298_tree=null;
        CommonTree KW_LOCATION299_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

        pushMsg("alter location", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1178:3: ( KW_SET KW_LOCATION newLoc= StringLiteral -> ^( TOK_ALTERTABLE_LOCATION $newLoc) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1178:5: KW_SET KW_LOCATION newLoc= StringLiteral
            {
            KW_SET298=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixLocation5432);  
            stream_KW_SET.add(KW_SET298);


            KW_LOCATION299=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_alterStatementSuffixLocation5434);  
            stream_KW_LOCATION.add(KW_LOCATION299);


            newLoc=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixLocation5438);  
            stream_StringLiteral.add(newLoc);


            // AST REWRITE
            // elements: newLoc
            // token labels: newLoc
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_newLoc=new RewriteRuleTokenStream(adaptor,"token newLoc",newLoc);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1179:3: -> ^( TOK_ALTERTABLE_LOCATION $newLoc)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1179:6: ^( TOK_ALTERTABLE_LOCATION $newLoc)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_LOCATION, "TOK_ALTERTABLE_LOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_newLoc.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixLocation"


    public static class alterStatementSuffixSkewedby_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixSkewedby"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1183:1: alterStatementSuffixSkewedby : (name= identifier tableSkewed -> ^( TOK_ALTERTABLE_SKEWED $name tableSkewed ) |name= identifier KW_NOT KW_SKEWED -> ^( TOK_ALTERTABLE_SKEWED $name) |name= identifier KW_NOT storedAsDirs -> ^( TOK_ALTERTABLE_SKEWED $name storedAsDirs ) );
    public final HiveParser.alterStatementSuffixSkewedby_return alterStatementSuffixSkewedby() throws RecognitionException {
        HiveParser.alterStatementSuffixSkewedby_return retval = new HiveParser.alterStatementSuffixSkewedby_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_NOT301=null;
        Token KW_SKEWED302=null;
        Token KW_NOT303=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.tableSkewed_return tableSkewed300 =null;

        HiveParser.storedAsDirs_return storedAsDirs304 =null;


        CommonTree KW_NOT301_tree=null;
        CommonTree KW_SKEWED302_tree=null;
        CommonTree KW_NOT303_tree=null;
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleSubtreeStream stream_storedAsDirs=new RewriteRuleSubtreeStream(adaptor,"rule storedAsDirs");
        RewriteRuleSubtreeStream stream_tableSkewed=new RewriteRuleSubtreeStream(adaptor,"rule tableSkewed");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("alter skewed by statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1186:2: (name= identifier tableSkewed -> ^( TOK_ALTERTABLE_SKEWED $name tableSkewed ) |name= identifier KW_NOT KW_SKEWED -> ^( TOK_ALTERTABLE_SKEWED $name) |name= identifier KW_NOT storedAsDirs -> ^( TOK_ALTERTABLE_SKEWED $name storedAsDirs ) )
            int alt77=3;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SKEWED:
                    {
                    alt77=1;
                    }
                    break;
                case KW_NOT:
                    {
                    switch ( input.LA(3) ) {
                    case KW_SKEWED:
                        {
                        alt77=2;
                        }
                        break;
                    case KW_STORED:
                        {
                        alt77=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 77, 4, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 77, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARQUETFILE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SKEWED:
                    {
                    alt77=1;
                    }
                    break;
                case KW_NOT:
                    {
                    switch ( input.LA(3) ) {
                    case KW_SKEWED:
                        {
                        alt77=2;
                        }
                        break;
                    case KW_STORED:
                        {
                        alt77=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 77, 6, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 77, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 77, 0, input);

                throw nvae;

            }

            switch (alt77) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1186:3: name= identifier tableSkewed
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixSkewedby5473);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    pushFollow(FOLLOW_tableSkewed_in_alterStatementSuffixSkewedby5475);
                    tableSkewed300=tableSkewed();

                    state._fsp--;

                    stream_tableSkewed.add(tableSkewed300.getTree());

                    // AST REWRITE
                    // elements: name, tableSkewed
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1187:2: -> ^( TOK_ALTERTABLE_SKEWED $name tableSkewed )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1187:4: ^( TOK_ALTERTABLE_SKEWED $name tableSkewed )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableSkewed.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1189:2: name= identifier KW_NOT KW_SKEWED
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixSkewedby5494);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_NOT301=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixSkewedby5496);  
                    stream_KW_NOT.add(KW_NOT301);


                    KW_SKEWED302=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_alterStatementSuffixSkewedby5498);  
                    stream_KW_SKEWED.add(KW_SKEWED302);


                    // AST REWRITE
                    // elements: name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1190:2: -> ^( TOK_ALTERTABLE_SKEWED $name)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1190:4: ^( TOK_ALTERTABLE_SKEWED $name)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1192:2: name= identifier KW_NOT storedAsDirs
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixSkewedby5515);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_NOT303=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixSkewedby5517);  
                    stream_KW_NOT.add(KW_NOT303);


                    pushFollow(FOLLOW_storedAsDirs_in_alterStatementSuffixSkewedby5519);
                    storedAsDirs304=storedAsDirs();

                    state._fsp--;

                    stream_storedAsDirs.add(storedAsDirs304.getTree());

                    // AST REWRITE
                    // elements: storedAsDirs, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1193:2: -> ^( TOK_ALTERTABLE_SKEWED $name storedAsDirs )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1193:4: ^( TOK_ALTERTABLE_SKEWED $name storedAsDirs )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_storedAsDirs.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixSkewedby"


    public static class alterStatementSuffixExchangePartition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixExchangePartition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1196:1: alterStatementSuffixExchangePartition : name= tableName KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName -> ^( TOK_EXCHANGEPARTITION $name partitionSpec $exchangename) ;
    public final HiveParser.alterStatementSuffixExchangePartition_return alterStatementSuffixExchangePartition() throws RecognitionException {
        HiveParser.alterStatementSuffixExchangePartition_return retval = new HiveParser.alterStatementSuffixExchangePartition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_EXCHANGE305=null;
        Token KW_WITH307=null;
        Token KW_TABLE308=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser_FromClauseParser.tableName_return exchangename =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec306 =null;


        CommonTree KW_EXCHANGE305_tree=null;
        CommonTree KW_WITH307_tree=null;
        CommonTree KW_TABLE308_tree=null;
        RewriteRuleTokenStream stream_KW_EXCHANGE=new RewriteRuleTokenStream(adaptor,"token KW_EXCHANGE");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        pushMsg("alter exchange partition", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1199:5: (name= tableName KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName -> ^( TOK_EXCHANGEPARTITION $name partitionSpec $exchangename) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1199:7: name= tableName KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName
            {
            pushFollow(FOLLOW_tableName_in_alterStatementSuffixExchangePartition5555);
            name=tableName();

            state._fsp--;

            stream_tableName.add(name.getTree());

            KW_EXCHANGE305=(Token)match(input,KW_EXCHANGE,FOLLOW_KW_EXCHANGE_in_alterStatementSuffixExchangePartition5557);  
            stream_KW_EXCHANGE.add(KW_EXCHANGE305);


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixExchangePartition5559);
            partitionSpec306=partitionSpec();

            state._fsp--;

            stream_partitionSpec.add(partitionSpec306.getTree());

            KW_WITH307=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_alterStatementSuffixExchangePartition5561);  
            stream_KW_WITH.add(KW_WITH307);


            KW_TABLE308=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_alterStatementSuffixExchangePartition5563);  
            stream_KW_TABLE.add(KW_TABLE308);


            pushFollow(FOLLOW_tableName_in_alterStatementSuffixExchangePartition5567);
            exchangename=tableName();

            state._fsp--;

            stream_tableName.add(exchangename.getTree());

            // AST REWRITE
            // elements: exchangename, name, partitionSpec
            // token labels: 
            // rule labels: exchangename, retval, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_exchangename=new RewriteRuleSubtreeStream(adaptor,"rule exchangename",exchangename!=null?exchangename.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1200:5: -> ^( TOK_EXCHANGEPARTITION $name partitionSpec $exchangename)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:8: ^( TOK_EXCHANGEPARTITION $name partitionSpec $exchangename)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_EXCHANGEPARTITION, "TOK_EXCHANGEPARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                adaptor.addChild(root_1, stream_exchangename.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixExchangePartition"


    public static class alterStatementSuffixProtectMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixProtectMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1203:1: alterStatementSuffixProtectMode : alterProtectMode -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode ) ;
    public final HiveParser.alterStatementSuffixProtectMode_return alterStatementSuffixProtectMode() throws RecognitionException {
        HiveParser.alterStatementSuffixProtectMode_return retval = new HiveParser.alterStatementSuffixProtectMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterProtectMode_return alterProtectMode309 =null;


        RewriteRuleSubtreeStream stream_alterProtectMode=new RewriteRuleSubtreeStream(adaptor,"rule alterProtectMode");
         pushMsg("alter partition protect mode statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1206:5: ( alterProtectMode -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1206:7: alterProtectMode
            {
            pushFollow(FOLLOW_alterProtectMode_in_alterStatementSuffixProtectMode5612);
            alterProtectMode309=alterProtectMode();

            state._fsp--;

            stream_alterProtectMode.add(alterProtectMode309.getTree());

            // AST REWRITE
            // elements: alterProtectMode
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1207:5: -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:8: ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_PROTECTMODE, "TOK_ALTERTABLE_PROTECTMODE")
                , root_1);

                adaptor.addChild(root_1, stream_alterProtectMode.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixProtectMode"


    public static class alterStatementSuffixRenamePart_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRenamePart"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1210:1: alterStatementSuffixRenamePart : KW_RENAME KW_TO partitionSpec -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec ) ;
    public final HiveParser.alterStatementSuffixRenamePart_return alterStatementSuffixRenamePart() throws RecognitionException {
        HiveParser.alterStatementSuffixRenamePart_return retval = new HiveParser.alterStatementSuffixRenamePart_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RENAME310=null;
        Token KW_TO311=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec312 =null;


        CommonTree KW_RENAME310_tree=null;
        CommonTree KW_TO311_tree=null;
        RewriteRuleTokenStream stream_KW_RENAME=new RewriteRuleTokenStream(adaptor,"token KW_RENAME");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("alter table rename partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:5: ( KW_RENAME KW_TO partitionSpec -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:7: KW_RENAME KW_TO partitionSpec
            {
            KW_RENAME310=(Token)match(input,KW_RENAME,FOLLOW_KW_RENAME_in_alterStatementSuffixRenamePart5651);  
            stream_KW_RENAME.add(KW_RENAME310);


            KW_TO311=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_alterStatementSuffixRenamePart5653);  
            stream_KW_TO.add(KW_TO311);


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixRenamePart5655);
            partitionSpec312=partitionSpec();

            state._fsp--;

            stream_partitionSpec.add(partitionSpec312.getTree());

            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1214:5: -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1214:7: ^( TOK_ALTERTABLE_RENAMEPART partitionSpec )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAMEPART, "TOK_ALTERTABLE_RENAMEPART")
                , root_1);

                adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRenamePart"


    public static class alterStatementSuffixMergeFiles_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixMergeFiles"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1217:1: alterStatementSuffixMergeFiles : KW_CONCATENATE -> ^( TOK_ALTERTABLE_MERGEFILES ) ;
    public final HiveParser.alterStatementSuffixMergeFiles_return alterStatementSuffixMergeFiles() throws RecognitionException {
        HiveParser.alterStatementSuffixMergeFiles_return retval = new HiveParser.alterStatementSuffixMergeFiles_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CONCATENATE313=null;

        CommonTree KW_CONCATENATE313_tree=null;
        RewriteRuleTokenStream stream_KW_CONCATENATE=new RewriteRuleTokenStream(adaptor,"token KW_CONCATENATE");

         pushMsg("", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1220:5: ( KW_CONCATENATE -> ^( TOK_ALTERTABLE_MERGEFILES ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1220:7: KW_CONCATENATE
            {
            KW_CONCATENATE313=(Token)match(input,KW_CONCATENATE,FOLLOW_KW_CONCATENATE_in_alterStatementSuffixMergeFiles5693);  
            stream_KW_CONCATENATE.add(KW_CONCATENATE313);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1221:5: -> ^( TOK_ALTERTABLE_MERGEFILES )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1221:8: ^( TOK_ALTERTABLE_MERGEFILES )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_MERGEFILES, "TOK_ALTERTABLE_MERGEFILES")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixMergeFiles"


    public static class alterProtectMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterProtectMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1224:1: alterProtectMode : ( KW_ENABLE alterProtectModeMode -> ^( TOK_ENABLE alterProtectModeMode ) | KW_DISABLE alterProtectModeMode -> ^( TOK_DISABLE alterProtectModeMode ) );
    public final HiveParser.alterProtectMode_return alterProtectMode() throws RecognitionException {
        HiveParser.alterProtectMode_return retval = new HiveParser.alterProtectMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ENABLE314=null;
        Token KW_DISABLE316=null;
        HiveParser.alterProtectModeMode_return alterProtectModeMode315 =null;

        HiveParser.alterProtectModeMode_return alterProtectModeMode317 =null;


        CommonTree KW_ENABLE314_tree=null;
        CommonTree KW_DISABLE316_tree=null;
        RewriteRuleTokenStream stream_KW_DISABLE=new RewriteRuleTokenStream(adaptor,"token KW_DISABLE");
        RewriteRuleTokenStream stream_KW_ENABLE=new RewriteRuleTokenStream(adaptor,"token KW_ENABLE");
        RewriteRuleSubtreeStream stream_alterProtectModeMode=new RewriteRuleSubtreeStream(adaptor,"rule alterProtectModeMode");
         pushMsg("protect mode specification enable", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:5: ( KW_ENABLE alterProtectModeMode -> ^( TOK_ENABLE alterProtectModeMode ) | KW_DISABLE alterProtectModeMode -> ^( TOK_DISABLE alterProtectModeMode ) )
            int alt78=2;
            switch ( input.LA(1) ) {
            case KW_ENABLE:
                {
                alt78=1;
                }
                break;
            case KW_DISABLE:
                {
                alt78=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;

            }

            switch (alt78) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:7: KW_ENABLE alterProtectModeMode
                    {
                    KW_ENABLE314=(Token)match(input,KW_ENABLE,FOLLOW_KW_ENABLE_in_alterProtectMode5730);  
                    stream_KW_ENABLE.add(KW_ENABLE314);


                    pushFollow(FOLLOW_alterProtectModeMode_in_alterProtectMode5732);
                    alterProtectModeMode315=alterProtectModeMode();

                    state._fsp--;

                    stream_alterProtectModeMode.add(alterProtectModeMode315.getTree());

                    // AST REWRITE
                    // elements: alterProtectModeMode
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1227:39: -> ^( TOK_ENABLE alterProtectModeMode )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:42: ^( TOK_ENABLE alterProtectModeMode )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ENABLE, "TOK_ENABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterProtectModeMode.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1228:7: KW_DISABLE alterProtectModeMode
                    {
                    KW_DISABLE316=(Token)match(input,KW_DISABLE,FOLLOW_KW_DISABLE_in_alterProtectMode5749);  
                    stream_KW_DISABLE.add(KW_DISABLE316);


                    pushFollow(FOLLOW_alterProtectModeMode_in_alterProtectMode5751);
                    alterProtectModeMode317=alterProtectModeMode();

                    state._fsp--;

                    stream_alterProtectModeMode.add(alterProtectModeMode317.getTree());

                    // AST REWRITE
                    // elements: alterProtectModeMode
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1228:40: -> ^( TOK_DISABLE alterProtectModeMode )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1228:43: ^( TOK_DISABLE alterProtectModeMode )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DISABLE, "TOK_DISABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterProtectModeMode.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterProtectMode"


    public static class alterProtectModeMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterProtectModeMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1231:1: alterProtectModeMode : ( KW_OFFLINE -> ^( TOK_OFFLINE ) | KW_NO_DROP ( KW_CASCADE )? -> ^( TOK_NO_DROP ( KW_CASCADE )? ) | KW_READONLY -> ^( TOK_READONLY ) );
    public final HiveParser.alterProtectModeMode_return alterProtectModeMode() throws RecognitionException {
        HiveParser.alterProtectModeMode_return retval = new HiveParser.alterProtectModeMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_OFFLINE318=null;
        Token KW_NO_DROP319=null;
        Token KW_CASCADE320=null;
        Token KW_READONLY321=null;

        CommonTree KW_OFFLINE318_tree=null;
        CommonTree KW_NO_DROP319_tree=null;
        CommonTree KW_CASCADE320_tree=null;
        CommonTree KW_READONLY321_tree=null;
        RewriteRuleTokenStream stream_KW_READONLY=new RewriteRuleTokenStream(adaptor,"token KW_READONLY");
        RewriteRuleTokenStream stream_KW_NO_DROP=new RewriteRuleTokenStream(adaptor,"token KW_NO_DROP");
        RewriteRuleTokenStream stream_KW_CASCADE=new RewriteRuleTokenStream(adaptor,"token KW_CASCADE");
        RewriteRuleTokenStream stream_KW_OFFLINE=new RewriteRuleTokenStream(adaptor,"token KW_OFFLINE");

         pushMsg("protect mode specification enable", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1234:5: ( KW_OFFLINE -> ^( TOK_OFFLINE ) | KW_NO_DROP ( KW_CASCADE )? -> ^( TOK_NO_DROP ( KW_CASCADE )? ) | KW_READONLY -> ^( TOK_READONLY ) )
            int alt80=3;
            switch ( input.LA(1) ) {
            case KW_OFFLINE:
                {
                alt80=1;
                }
                break;
            case KW_NO_DROP:
                {
                alt80=2;
                }
                break;
            case KW_READONLY:
                {
                alt80=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 80, 0, input);

                throw nvae;

            }

            switch (alt80) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1234:7: KW_OFFLINE
                    {
                    KW_OFFLINE318=(Token)match(input,KW_OFFLINE,FOLLOW_KW_OFFLINE_in_alterProtectModeMode5787);  
                    stream_KW_OFFLINE.add(KW_OFFLINE318);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1234:19: -> ^( TOK_OFFLINE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1234:22: ^( TOK_OFFLINE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_OFFLINE, "TOK_OFFLINE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1235:7: KW_NO_DROP ( KW_CASCADE )?
                    {
                    KW_NO_DROP319=(Token)match(input,KW_NO_DROP,FOLLOW_KW_NO_DROP_in_alterProtectModeMode5802);  
                    stream_KW_NO_DROP.add(KW_NO_DROP319);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1235:18: ( KW_CASCADE )?
                    int alt79=2;
                    switch ( input.LA(1) ) {
                        case KW_CASCADE:
                            {
                            alt79=1;
                            }
                            break;
                    }

                    switch (alt79) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1235:18: KW_CASCADE
                            {
                            KW_CASCADE320=(Token)match(input,KW_CASCADE,FOLLOW_KW_CASCADE_in_alterProtectModeMode5804);  
                            stream_KW_CASCADE.add(KW_CASCADE320);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: KW_CASCADE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1235:30: -> ^( TOK_NO_DROP ( KW_CASCADE )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1235:33: ^( TOK_NO_DROP ( KW_CASCADE )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_NO_DROP, "TOK_NO_DROP")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1235:47: ( KW_CASCADE )?
                        if ( stream_KW_CASCADE.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_CASCADE.nextNode()
                            );

                        }
                        stream_KW_CASCADE.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1236:7: KW_READONLY
                    {
                    KW_READONLY321=(Token)match(input,KW_READONLY,FOLLOW_KW_READONLY_in_alterProtectModeMode5822);  
                    stream_KW_READONLY.add(KW_READONLY321);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1236:20: -> ^( TOK_READONLY )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1236:23: ^( TOK_READONLY )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_READONLY, "TOK_READONLY")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterProtectModeMode"


    public static class alterStatementSuffixBucketNum_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixBucketNum"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:1: alterStatementSuffixBucketNum : KW_INTO num= Number KW_BUCKETS -> ^( TOK_TABLEBUCKETS $num) ;
    public final HiveParser.alterStatementSuffixBucketNum_return alterStatementSuffixBucketNum() throws RecognitionException {
        HiveParser.alterStatementSuffixBucketNum_return retval = new HiveParser.alterStatementSuffixBucketNum_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token num=null;
        Token KW_INTO322=null;
        Token KW_BUCKETS323=null;

        CommonTree num_tree=null;
        CommonTree KW_INTO322_tree=null;
        CommonTree KW_BUCKETS323_tree=null;
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_Number=new RewriteRuleTokenStream(adaptor,"token Number");
        RewriteRuleTokenStream stream_KW_BUCKETS=new RewriteRuleTokenStream(adaptor,"token KW_BUCKETS");

         pushMsg("", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1242:5: ( KW_INTO num= Number KW_BUCKETS -> ^( TOK_TABLEBUCKETS $num) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1242:7: KW_INTO num= Number KW_BUCKETS
            {
            KW_INTO322=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_alterStatementSuffixBucketNum5856);  
            stream_KW_INTO.add(KW_INTO322);


            num=(Token)match(input,Number,FOLLOW_Number_in_alterStatementSuffixBucketNum5860);  
            stream_Number.add(num);


            KW_BUCKETS323=(Token)match(input,KW_BUCKETS,FOLLOW_KW_BUCKETS_in_alterStatementSuffixBucketNum5862);  
            stream_KW_BUCKETS.add(KW_BUCKETS323);


            // AST REWRITE
            // elements: num
            // token labels: num
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_num=new RewriteRuleTokenStream(adaptor,"token num",num);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1243:5: -> ^( TOK_TABLEBUCKETS $num)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:8: ^( TOK_TABLEBUCKETS $num)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLEBUCKETS, "TOK_TABLEBUCKETS")
                , root_1);

                adaptor.addChild(root_1, stream_num.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixBucketNum"


    public static class alterStatementSuffixCompact_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixCompact"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:1: alterStatementSuffixCompact : KW_COMPACT compactType= StringLiteral -> ^( TOK_COMPACT $compactType) ;
    public final HiveParser.alterStatementSuffixCompact_return alterStatementSuffixCompact() throws RecognitionException {
        HiveParser.alterStatementSuffixCompact_return retval = new HiveParser.alterStatementSuffixCompact_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token compactType=null;
        Token KW_COMPACT324=null;

        CommonTree compactType_tree=null;
        CommonTree KW_COMPACT324_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMPACT=new RewriteRuleTokenStream(adaptor,"token KW_COMPACT");

         msgs.push("compaction request"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:5: ( KW_COMPACT compactType= StringLiteral -> ^( TOK_COMPACT $compactType) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:7: KW_COMPACT compactType= StringLiteral
            {
            KW_COMPACT324=(Token)match(input,KW_COMPACT,FOLLOW_KW_COMPACT_in_alterStatementSuffixCompact5902);  
            stream_KW_COMPACT.add(KW_COMPACT324);


            compactType=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixCompact5906);  
            stream_StringLiteral.add(compactType);


            // AST REWRITE
            // elements: compactType
            // token labels: compactType
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_compactType=new RewriteRuleTokenStream(adaptor,"token compactType",compactType);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1250:5: -> ^( TOK_COMPACT $compactType)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:8: ^( TOK_COMPACT $compactType)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_COMPACT, "TOK_COMPACT")
                , root_1);

                adaptor.addChild(root_1, stream_compactType.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixCompact"


    public static class fileFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fileFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1254:1: fileFormat : ( KW_SEQUENCEFILE -> ^( TOK_TBLSEQUENCEFILE ) | KW_TEXTFILE -> ^( TOK_TBLTEXTFILE ) | KW_RCFILE -> ^( TOK_TBLRCFILE ) | KW_ORCFILE -> ^( TOK_TBLORCFILE ) | KW_PARQUETFILE -> ^( TOK_TBLPARQUETFILE ) | KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )? -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt ( $inDriver)? ( $outDriver)? ) |genericSpec= identifier -> ^( TOK_FILEFORMAT_GENERIC $genericSpec) );
    public final HiveParser.fileFormat_return fileFormat() throws RecognitionException {
        HiveParser.fileFormat_return retval = new HiveParser.fileFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token inFmt=null;
        Token outFmt=null;
        Token inDriver=null;
        Token outDriver=null;
        Token KW_SEQUENCEFILE325=null;
        Token KW_TEXTFILE326=null;
        Token KW_RCFILE327=null;
        Token KW_ORCFILE328=null;
        Token KW_PARQUETFILE329=null;
        Token KW_INPUTFORMAT330=null;
        Token KW_OUTPUTFORMAT331=null;
        Token KW_INPUTDRIVER332=null;
        Token KW_OUTPUTDRIVER333=null;
        HiveParser_IdentifiersParser.identifier_return genericSpec =null;


        CommonTree inFmt_tree=null;
        CommonTree outFmt_tree=null;
        CommonTree inDriver_tree=null;
        CommonTree outDriver_tree=null;
        CommonTree KW_SEQUENCEFILE325_tree=null;
        CommonTree KW_TEXTFILE326_tree=null;
        CommonTree KW_RCFILE327_tree=null;
        CommonTree KW_ORCFILE328_tree=null;
        CommonTree KW_PARQUETFILE329_tree=null;
        CommonTree KW_INPUTFORMAT330_tree=null;
        CommonTree KW_OUTPUTFORMAT331_tree=null;
        CommonTree KW_INPUTDRIVER332_tree=null;
        CommonTree KW_OUTPUTDRIVER333_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INPUTDRIVER=new RewriteRuleTokenStream(adaptor,"token KW_INPUTDRIVER");
        RewriteRuleTokenStream stream_KW_RCFILE=new RewriteRuleTokenStream(adaptor,"token KW_RCFILE");
        RewriteRuleTokenStream stream_KW_INPUTFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_INPUTFORMAT");
        RewriteRuleTokenStream stream_KW_OUTPUTFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_OUTPUTFORMAT");
        RewriteRuleTokenStream stream_KW_PARQUETFILE=new RewriteRuleTokenStream(adaptor,"token KW_PARQUETFILE");
        RewriteRuleTokenStream stream_KW_OUTPUTDRIVER=new RewriteRuleTokenStream(adaptor,"token KW_OUTPUTDRIVER");
        RewriteRuleTokenStream stream_KW_SEQUENCEFILE=new RewriteRuleTokenStream(adaptor,"token KW_SEQUENCEFILE");
        RewriteRuleTokenStream stream_KW_ORCFILE=new RewriteRuleTokenStream(adaptor,"token KW_ORCFILE");
        RewriteRuleTokenStream stream_KW_TEXTFILE=new RewriteRuleTokenStream(adaptor,"token KW_TEXTFILE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("file format specification", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:5: ( KW_SEQUENCEFILE -> ^( TOK_TBLSEQUENCEFILE ) | KW_TEXTFILE -> ^( TOK_TBLTEXTFILE ) | KW_RCFILE -> ^( TOK_TBLRCFILE ) | KW_ORCFILE -> ^( TOK_TBLORCFILE ) | KW_PARQUETFILE -> ^( TOK_TBLPARQUETFILE ) | KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )? -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt ( $inDriver)? ( $outDriver)? ) |genericSpec= identifier -> ^( TOK_FILEFORMAT_GENERIC $genericSpec) )
            int alt82=7;
            switch ( input.LA(1) ) {
            case KW_SEQUENCEFILE:
                {
                alt82=1;
                }
                break;
            case KW_TEXTFILE:
                {
                alt82=2;
                }
                break;
            case KW_RCFILE:
                {
                alt82=3;
                }
                break;
            case KW_ORCFILE:
                {
                alt82=4;
                }
                break;
            case KW_PARQUETFILE:
                {
                alt82=5;
                }
                break;
            case KW_INPUTFORMAT:
                {
                switch ( input.LA(2) ) {
                case StringLiteral:
                    {
                    alt82=6;
                    }
                    break;
                case EOF:
                    {
                    alt82=7;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 82, 6, input);

                    throw nvae;

                }

                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt82=7;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 82, 0, input);

                throw nvae;

            }

            switch (alt82) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:7: KW_SEQUENCEFILE
                    {
                    KW_SEQUENCEFILE325=(Token)match(input,KW_SEQUENCEFILE,FOLLOW_KW_SEQUENCEFILE_in_fileFormat5947);  
                    stream_KW_SEQUENCEFILE.add(KW_SEQUENCEFILE325);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1257:24: -> ^( TOK_TBLSEQUENCEFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:27: ^( TOK_TBLSEQUENCEFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLSEQUENCEFILE, "TOK_TBLSEQUENCEFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1258:7: KW_TEXTFILE
                    {
                    KW_TEXTFILE326=(Token)match(input,KW_TEXTFILE,FOLLOW_KW_TEXTFILE_in_fileFormat5962);  
                    stream_KW_TEXTFILE.add(KW_TEXTFILE326);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1258:20: -> ^( TOK_TBLTEXTFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1258:23: ^( TOK_TBLTEXTFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLTEXTFILE, "TOK_TBLTEXTFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1259:7: KW_RCFILE
                    {
                    KW_RCFILE327=(Token)match(input,KW_RCFILE,FOLLOW_KW_RCFILE_in_fileFormat5977);  
                    stream_KW_RCFILE.add(KW_RCFILE327);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1259:18: -> ^( TOK_TBLRCFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1259:21: ^( TOK_TBLRCFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLRCFILE, "TOK_TBLRCFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1260:7: KW_ORCFILE
                    {
                    KW_ORCFILE328=(Token)match(input,KW_ORCFILE,FOLLOW_KW_ORCFILE_in_fileFormat5992);  
                    stream_KW_ORCFILE.add(KW_ORCFILE328);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1260:18: -> ^( TOK_TBLORCFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1260:21: ^( TOK_TBLORCFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLORCFILE, "TOK_TBLORCFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1261:7: KW_PARQUETFILE
                    {
                    KW_PARQUETFILE329=(Token)match(input,KW_PARQUETFILE,FOLLOW_KW_PARQUETFILE_in_fileFormat6006);  
                    stream_KW_PARQUETFILE.add(KW_PARQUETFILE329);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1261:22: -> ^( TOK_TBLPARQUETFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1261:25: ^( TOK_TBLPARQUETFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLPARQUETFILE, "TOK_TBLPARQUETFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1262:7: KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )?
                    {
                    KW_INPUTFORMAT330=(Token)match(input,KW_INPUTFORMAT,FOLLOW_KW_INPUTFORMAT_in_fileFormat6020);  
                    stream_KW_INPUTFORMAT.add(KW_INPUTFORMAT330);


                    inFmt=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6024);  
                    stream_StringLiteral.add(inFmt);


                    KW_OUTPUTFORMAT331=(Token)match(input,KW_OUTPUTFORMAT,FOLLOW_KW_OUTPUTFORMAT_in_fileFormat6026);  
                    stream_KW_OUTPUTFORMAT.add(KW_OUTPUTFORMAT331);


                    outFmt=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6030);  
                    stream_StringLiteral.add(outFmt);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1262:79: ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )?
                    int alt81=2;
                    switch ( input.LA(1) ) {
                        case KW_INPUTDRIVER:
                            {
                            alt81=1;
                            }
                            break;
                    }

                    switch (alt81) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1262:80: KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral
                            {
                            KW_INPUTDRIVER332=(Token)match(input,KW_INPUTDRIVER,FOLLOW_KW_INPUTDRIVER_in_fileFormat6033);  
                            stream_KW_INPUTDRIVER.add(KW_INPUTDRIVER332);


                            inDriver=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6037);  
                            stream_StringLiteral.add(inDriver);


                            KW_OUTPUTDRIVER333=(Token)match(input,KW_OUTPUTDRIVER,FOLLOW_KW_OUTPUTDRIVER_in_fileFormat6039);  
                            stream_KW_OUTPUTDRIVER.add(KW_OUTPUTDRIVER333);


                            outDriver=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6043);  
                            stream_StringLiteral.add(outDriver);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: inFmt, outDriver, outFmt, inDriver
                    // token labels: outDriver, outFmt, inDriver, inFmt
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_outDriver=new RewriteRuleTokenStream(adaptor,"token outDriver",outDriver);
                    RewriteRuleTokenStream stream_outFmt=new RewriteRuleTokenStream(adaptor,"token outFmt",outFmt);
                    RewriteRuleTokenStream stream_inDriver=new RewriteRuleTokenStream(adaptor,"token inDriver",inDriver);
                    RewriteRuleTokenStream stream_inFmt=new RewriteRuleTokenStream(adaptor,"token inFmt",inFmt);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1263:7: -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt ( $inDriver)? ( $outDriver)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1263:10: ^( TOK_TABLEFILEFORMAT $inFmt $outFmt ( $inDriver)? ( $outDriver)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TABLEFILEFORMAT, "TOK_TABLEFILEFORMAT")
                        , root_1);

                        adaptor.addChild(root_1, stream_inFmt.nextNode());

                        adaptor.addChild(root_1, stream_outFmt.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1263:48: ( $inDriver)?
                        if ( stream_inDriver.hasNext() ) {
                            adaptor.addChild(root_1, stream_inDriver.nextNode());

                        }
                        stream_inDriver.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1263:59: ( $outDriver)?
                        if ( stream_outDriver.hasNext() ) {
                            adaptor.addChild(root_1, stream_outDriver.nextNode());

                        }
                        stream_outDriver.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1264:7: genericSpec= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_fileFormat6081);
                    genericSpec=identifier();

                    state._fsp--;

                    stream_identifier.add(genericSpec.getTree());

                    // AST REWRITE
                    // elements: genericSpec
                    // token labels: 
                    // rule labels: retval, genericSpec
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_genericSpec=new RewriteRuleSubtreeStream(adaptor,"rule genericSpec",genericSpec!=null?genericSpec.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1264:30: -> ^( TOK_FILEFORMAT_GENERIC $genericSpec)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1264:33: ^( TOK_FILEFORMAT_GENERIC $genericSpec)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_FILEFORMAT_GENERIC, "TOK_FILEFORMAT_GENERIC")
                        , root_1);

                        adaptor.addChild(root_1, stream_genericSpec.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fileFormat"


    public static class tabTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tabTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1267:1: tabTypeExpr : identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ;
    public final HiveParser.tabTypeExpr_return tabTypeExpr() throws RecognitionException {
        HiveParser.tabTypeExpr_return retval = new HiveParser.tabTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token DOT335=null;
        Token KW_ELEM_TYPE336=null;
        Token KW_KEY_TYPE337=null;
        Token KW_VALUE_TYPE338=null;
        HiveParser_IdentifiersParser.identifier_return identifier334 =null;

        HiveParser_IdentifiersParser.identifier_return identifier339 =null;


        CommonTree DOT335_tree=null;
        CommonTree KW_ELEM_TYPE336_tree=null;
        CommonTree KW_KEY_TYPE337_tree=null;
        CommonTree KW_VALUE_TYPE338_tree=null;

         pushMsg("specifying table types", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:4: ( identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:6: identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_identifier_in_tabTypeExpr6117);
            identifier334=identifier();

            state._fsp--;

            adaptor.addChild(root_0, identifier334.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:17: ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            loop84:
            do {
                int alt84=2;
                switch ( input.LA(1) ) {
                case DOT:
                    {
                    alt84=1;
                    }
                    break;

                }

                switch (alt84) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:18: DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    {
            	    DOT335=(Token)match(input,DOT,FOLLOW_DOT_in_tabTypeExpr6120); 
            	    DOT335_tree = 
            	    (CommonTree)adaptor.create(DOT335)
            	    ;
            	    root_0 = (CommonTree)adaptor.becomeRoot(DOT335_tree, root_0);


            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:23: ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    int alt83=4;
            	    switch ( input.LA(1) ) {
            	    case KW_ELEM_TYPE:
            	        {
            	        alt83=1;
            	        }
            	        break;
            	    case KW_KEY_TYPE:
            	        {
            	        alt83=2;
            	        }
            	        break;
            	    case KW_VALUE_TYPE:
            	        {
            	        alt83=3;
            	        }
            	        break;
            	    case Identifier:
            	    case KW_ADD:
            	    case KW_ADMIN:
            	    case KW_AFTER:
            	    case KW_ALL:
            	    case KW_ALTER:
            	    case KW_ANALYZE:
            	    case KW_ARCHIVE:
            	    case KW_ARRAY:
            	    case KW_AS:
            	    case KW_ASC:
            	    case KW_BEFORE:
            	    case KW_BETWEEN:
            	    case KW_BIGINT:
            	    case KW_BINARY:
            	    case KW_BOOLEAN:
            	    case KW_BOTH:
            	    case KW_BUCKET:
            	    case KW_BUCKETS:
            	    case KW_BY:
            	    case KW_CASCADE:
            	    case KW_CHANGE:
            	    case KW_CLUSTER:
            	    case KW_CLUSTERED:
            	    case KW_CLUSTERSTATUS:
            	    case KW_COLLECTION:
            	    case KW_COLUMNS:
            	    case KW_COMMENT:
            	    case KW_COMPACT:
            	    case KW_COMPACTIONS:
            	    case KW_COMPUTE:
            	    case KW_CONCATENATE:
            	    case KW_CONTINUE:
            	    case KW_CREATE:
            	    case KW_CUBE:
            	    case KW_CURSOR:
            	    case KW_DATA:
            	    case KW_DATABASES:
            	    case KW_DATE:
            	    case KW_DATETIME:
            	    case KW_DBPROPERTIES:
            	    case KW_DECIMAL:
            	    case KW_DEFAULT:
            	    case KW_DEFERRED:
            	    case KW_DEFINED:
            	    case KW_DELETE:
            	    case KW_DELIMITED:
            	    case KW_DEPENDENCY:
            	    case KW_DESC:
            	    case KW_DESCRIBE:
            	    case KW_DIRECTORIES:
            	    case KW_DIRECTORY:
            	    case KW_DISABLE:
            	    case KW_DISTRIBUTE:
            	    case KW_DOUBLE:
            	    case KW_DROP:
            	    case KW_ENABLE:
            	    case KW_ESCAPED:
            	    case KW_EXCLUSIVE:
            	    case KW_EXISTS:
            	    case KW_EXPLAIN:
            	    case KW_EXPORT:
            	    case KW_EXTERNAL:
            	    case KW_FALSE:
            	    case KW_FETCH:
            	    case KW_FIELDS:
            	    case KW_FILE:
            	    case KW_FILEFORMAT:
            	    case KW_FIRST:
            	    case KW_FLOAT:
            	    case KW_FOR:
            	    case KW_FORMAT:
            	    case KW_FORMATTED:
            	    case KW_FULL:
            	    case KW_FUNCTIONS:
            	    case KW_GRANT:
            	    case KW_GROUP:
            	    case KW_GROUPING:
            	    case KW_HOLD_DDLTIME:
            	    case KW_IDXPROPERTIES:
            	    case KW_IGNORE:
            	    case KW_IMPORT:
            	    case KW_IN:
            	    case KW_INDEX:
            	    case KW_INDEXES:
            	    case KW_INNER:
            	    case KW_INPATH:
            	    case KW_INPUTDRIVER:
            	    case KW_INPUTFORMAT:
            	    case KW_INSERT:
            	    case KW_INT:
            	    case KW_INTERSECT:
            	    case KW_INTO:
            	    case KW_IS:
            	    case KW_ITEMS:
            	    case KW_JAR:
            	    case KW_KEYS:
            	    case KW_LATERAL:
            	    case KW_LEFT:
            	    case KW_LIKE:
            	    case KW_LIMIT:
            	    case KW_LINES:
            	    case KW_LOAD:
            	    case KW_LOCAL:
            	    case KW_LOCATION:
            	    case KW_LOCK:
            	    case KW_LOCKS:
            	    case KW_LOGICAL:
            	    case KW_LONG:
            	    case KW_MAPJOIN:
            	    case KW_MATERIALIZED:
            	    case KW_MINUS:
            	    case KW_MSCK:
            	    case KW_NONE:
            	    case KW_NOSCAN:
            	    case KW_NO_DROP:
            	    case KW_NULL:
            	    case KW_OF:
            	    case KW_OFFLINE:
            	    case KW_OPTION:
            	    case KW_ORCFILE:
            	    case KW_ORDER:
            	    case KW_OUT:
            	    case KW_OUTER:
            	    case KW_OUTPUTDRIVER:
            	    case KW_OUTPUTFORMAT:
            	    case KW_OVERWRITE:
            	    case KW_OWNER:
            	    case KW_PARQUETFILE:
            	    case KW_PARTITION:
            	    case KW_PARTITIONED:
            	    case KW_PARTITIONS:
            	    case KW_PERCENT:
            	    case KW_PLUS:
            	    case KW_PRETTY:
            	    case KW_PRINCIPALS:
            	    case KW_PROCEDURE:
            	    case KW_PROTECTION:
            	    case KW_PURGE:
            	    case KW_RANGE:
            	    case KW_RCFILE:
            	    case KW_READ:
            	    case KW_READONLY:
            	    case KW_READS:
            	    case KW_REBUILD:
            	    case KW_RECORDREADER:
            	    case KW_RECORDWRITER:
            	    case KW_REGEXP:
            	    case KW_RENAME:
            	    case KW_REPAIR:
            	    case KW_REPLACE:
            	    case KW_RESTRICT:
            	    case KW_REVOKE:
            	    case KW_RIGHT:
            	    case KW_RLIKE:
            	    case KW_ROLE:
            	    case KW_ROLES:
            	    case KW_ROLLUP:
            	    case KW_ROW:
            	    case KW_ROWS:
            	    case KW_SCHEMA:
            	    case KW_SCHEMAS:
            	    case KW_SEMI:
            	    case KW_SEQUENCEFILE:
            	    case KW_SERDE:
            	    case KW_SERDEPROPERTIES:
            	    case KW_SET:
            	    case KW_SETS:
            	    case KW_SHARED:
            	    case KW_SHOW:
            	    case KW_SHOW_DATABASE:
            	    case KW_SKEWED:
            	    case KW_SMALLINT:
            	    case KW_SORT:
            	    case KW_SORTED:
            	    case KW_SSL:
            	    case KW_STATISTICS:
            	    case KW_STORED:
            	    case KW_STREAMTABLE:
            	    case KW_STRING:
            	    case KW_STRUCT:
            	    case KW_TABLE:
            	    case KW_TABLES:
            	    case KW_TBLPROPERTIES:
            	    case KW_TEMPORARY:
            	    case KW_TERMINATED:
            	    case KW_TEXTFILE:
            	    case KW_TIMESTAMP:
            	    case KW_TINYINT:
            	    case KW_TO:
            	    case KW_TOUCH:
            	    case KW_TRANSACTIONS:
            	    case KW_TRIGGER:
            	    case KW_TRUE:
            	    case KW_TRUNCATE:
            	    case KW_UNARCHIVE:
            	    case KW_UNDO:
            	    case KW_UNION:
            	    case KW_UNIONTYPE:
            	    case KW_UNLOCK:
            	    case KW_UNSET:
            	    case KW_UNSIGNED:
            	    case KW_UPDATE:
            	    case KW_USE:
            	    case KW_USER:
            	    case KW_USING:
            	    case KW_UTC:
            	    case KW_UTCTIMESTAMP:
            	    case KW_VIEW:
            	    case KW_WHILE:
            	    case KW_WITH:
            	        {
            	        alt83=4;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 83, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt83) {
            	        case 1 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:24: KW_ELEM_TYPE
            	            {
            	            KW_ELEM_TYPE336=(Token)match(input,KW_ELEM_TYPE,FOLLOW_KW_ELEM_TYPE_in_tabTypeExpr6124); 
            	            KW_ELEM_TYPE336_tree = 
            	            (CommonTree)adaptor.create(KW_ELEM_TYPE336)
            	            ;
            	            adaptor.addChild(root_0, KW_ELEM_TYPE336_tree);


            	            }
            	            break;
            	        case 2 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:39: KW_KEY_TYPE
            	            {
            	            KW_KEY_TYPE337=(Token)match(input,KW_KEY_TYPE,FOLLOW_KW_KEY_TYPE_in_tabTypeExpr6128); 
            	            KW_KEY_TYPE337_tree = 
            	            (CommonTree)adaptor.create(KW_KEY_TYPE337)
            	            ;
            	            adaptor.addChild(root_0, KW_KEY_TYPE337_tree);


            	            }
            	            break;
            	        case 3 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:53: KW_VALUE_TYPE
            	            {
            	            KW_VALUE_TYPE338=(Token)match(input,KW_VALUE_TYPE,FOLLOW_KW_VALUE_TYPE_in_tabTypeExpr6132); 
            	            KW_VALUE_TYPE338_tree = 
            	            (CommonTree)adaptor.create(KW_VALUE_TYPE338)
            	            ;
            	            adaptor.addChild(root_0, KW_VALUE_TYPE338_tree);


            	            }
            	            break;
            	        case 4 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1271:69: identifier
            	            {
            	            pushFollow(FOLLOW_identifier_in_tabTypeExpr6136);
            	            identifier339=identifier();

            	            state._fsp--;

            	            adaptor.addChild(root_0, identifier339.getTree());

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop84;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tabTypeExpr"


    public static class descTabTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descTabTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1274:1: descTabTypeExpr : identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )? ;
    public final HiveParser.descTabTypeExpr_return descTabTypeExpr() throws RecognitionException {
        HiveParser.descTabTypeExpr_return retval = new HiveParser.descTabTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token DOT341=null;
        Token KW_ELEM_TYPE342=null;
        Token KW_KEY_TYPE343=null;
        Token KW_VALUE_TYPE344=null;
        HiveParser_IdentifiersParser.identifier_return identifier340 =null;

        HiveParser_IdentifiersParser.identifier_return identifier345 =null;

        HiveParser_IdentifiersParser.identifier_return identifier346 =null;


        CommonTree DOT341_tree=null;
        CommonTree KW_ELEM_TYPE342_tree=null;
        CommonTree KW_KEY_TYPE343_tree=null;
        CommonTree KW_VALUE_TYPE344_tree=null;

         pushMsg("specifying describe table types", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:4: ( identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )? )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:6: identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_identifier_in_descTabTypeExpr6165);
            identifier340=identifier();

            state._fsp--;

            adaptor.addChild(root_0, identifier340.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:17: ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            loop86:
            do {
                int alt86=2;
                switch ( input.LA(1) ) {
                case DOT:
                    {
                    alt86=1;
                    }
                    break;

                }

                switch (alt86) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:18: DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    {
            	    DOT341=(Token)match(input,DOT,FOLLOW_DOT_in_descTabTypeExpr6168); 
            	    DOT341_tree = 
            	    (CommonTree)adaptor.create(DOT341)
            	    ;
            	    root_0 = (CommonTree)adaptor.becomeRoot(DOT341_tree, root_0);


            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:23: ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    int alt85=4;
            	    switch ( input.LA(1) ) {
            	    case KW_ELEM_TYPE:
            	        {
            	        alt85=1;
            	        }
            	        break;
            	    case KW_KEY_TYPE:
            	        {
            	        alt85=2;
            	        }
            	        break;
            	    case KW_VALUE_TYPE:
            	        {
            	        alt85=3;
            	        }
            	        break;
            	    case Identifier:
            	    case KW_ADD:
            	    case KW_ADMIN:
            	    case KW_AFTER:
            	    case KW_ALL:
            	    case KW_ALTER:
            	    case KW_ANALYZE:
            	    case KW_ARCHIVE:
            	    case KW_ARRAY:
            	    case KW_AS:
            	    case KW_ASC:
            	    case KW_BEFORE:
            	    case KW_BETWEEN:
            	    case KW_BIGINT:
            	    case KW_BINARY:
            	    case KW_BOOLEAN:
            	    case KW_BOTH:
            	    case KW_BUCKET:
            	    case KW_BUCKETS:
            	    case KW_BY:
            	    case KW_CASCADE:
            	    case KW_CHANGE:
            	    case KW_CLUSTER:
            	    case KW_CLUSTERED:
            	    case KW_CLUSTERSTATUS:
            	    case KW_COLLECTION:
            	    case KW_COLUMNS:
            	    case KW_COMMENT:
            	    case KW_COMPACT:
            	    case KW_COMPACTIONS:
            	    case KW_COMPUTE:
            	    case KW_CONCATENATE:
            	    case KW_CONTINUE:
            	    case KW_CREATE:
            	    case KW_CUBE:
            	    case KW_CURSOR:
            	    case KW_DATA:
            	    case KW_DATABASES:
            	    case KW_DATE:
            	    case KW_DATETIME:
            	    case KW_DBPROPERTIES:
            	    case KW_DECIMAL:
            	    case KW_DEFAULT:
            	    case KW_DEFERRED:
            	    case KW_DEFINED:
            	    case KW_DELETE:
            	    case KW_DELIMITED:
            	    case KW_DEPENDENCY:
            	    case KW_DESC:
            	    case KW_DESCRIBE:
            	    case KW_DIRECTORIES:
            	    case KW_DIRECTORY:
            	    case KW_DISABLE:
            	    case KW_DISTRIBUTE:
            	    case KW_DOUBLE:
            	    case KW_DROP:
            	    case KW_ENABLE:
            	    case KW_ESCAPED:
            	    case KW_EXCLUSIVE:
            	    case KW_EXISTS:
            	    case KW_EXPLAIN:
            	    case KW_EXPORT:
            	    case KW_EXTERNAL:
            	    case KW_FALSE:
            	    case KW_FETCH:
            	    case KW_FIELDS:
            	    case KW_FILE:
            	    case KW_FILEFORMAT:
            	    case KW_FIRST:
            	    case KW_FLOAT:
            	    case KW_FOR:
            	    case KW_FORMAT:
            	    case KW_FORMATTED:
            	    case KW_FULL:
            	    case KW_FUNCTIONS:
            	    case KW_GRANT:
            	    case KW_GROUP:
            	    case KW_GROUPING:
            	    case KW_HOLD_DDLTIME:
            	    case KW_IDXPROPERTIES:
            	    case KW_IGNORE:
            	    case KW_IMPORT:
            	    case KW_IN:
            	    case KW_INDEX:
            	    case KW_INDEXES:
            	    case KW_INNER:
            	    case KW_INPATH:
            	    case KW_INPUTDRIVER:
            	    case KW_INPUTFORMAT:
            	    case KW_INSERT:
            	    case KW_INT:
            	    case KW_INTERSECT:
            	    case KW_INTO:
            	    case KW_IS:
            	    case KW_ITEMS:
            	    case KW_JAR:
            	    case KW_KEYS:
            	    case KW_LATERAL:
            	    case KW_LEFT:
            	    case KW_LIKE:
            	    case KW_LIMIT:
            	    case KW_LINES:
            	    case KW_LOAD:
            	    case KW_LOCAL:
            	    case KW_LOCATION:
            	    case KW_LOCK:
            	    case KW_LOCKS:
            	    case KW_LOGICAL:
            	    case KW_LONG:
            	    case KW_MAPJOIN:
            	    case KW_MATERIALIZED:
            	    case KW_MINUS:
            	    case KW_MSCK:
            	    case KW_NONE:
            	    case KW_NOSCAN:
            	    case KW_NO_DROP:
            	    case KW_NULL:
            	    case KW_OF:
            	    case KW_OFFLINE:
            	    case KW_OPTION:
            	    case KW_ORCFILE:
            	    case KW_ORDER:
            	    case KW_OUT:
            	    case KW_OUTER:
            	    case KW_OUTPUTDRIVER:
            	    case KW_OUTPUTFORMAT:
            	    case KW_OVERWRITE:
            	    case KW_OWNER:
            	    case KW_PARQUETFILE:
            	    case KW_PARTITION:
            	    case KW_PARTITIONED:
            	    case KW_PARTITIONS:
            	    case KW_PERCENT:
            	    case KW_PLUS:
            	    case KW_PRETTY:
            	    case KW_PRINCIPALS:
            	    case KW_PROCEDURE:
            	    case KW_PROTECTION:
            	    case KW_PURGE:
            	    case KW_RANGE:
            	    case KW_RCFILE:
            	    case KW_READ:
            	    case KW_READONLY:
            	    case KW_READS:
            	    case KW_REBUILD:
            	    case KW_RECORDREADER:
            	    case KW_RECORDWRITER:
            	    case KW_REGEXP:
            	    case KW_RENAME:
            	    case KW_REPAIR:
            	    case KW_REPLACE:
            	    case KW_RESTRICT:
            	    case KW_REVOKE:
            	    case KW_RIGHT:
            	    case KW_RLIKE:
            	    case KW_ROLE:
            	    case KW_ROLES:
            	    case KW_ROLLUP:
            	    case KW_ROW:
            	    case KW_ROWS:
            	    case KW_SCHEMA:
            	    case KW_SCHEMAS:
            	    case KW_SEMI:
            	    case KW_SEQUENCEFILE:
            	    case KW_SERDE:
            	    case KW_SERDEPROPERTIES:
            	    case KW_SET:
            	    case KW_SETS:
            	    case KW_SHARED:
            	    case KW_SHOW:
            	    case KW_SHOW_DATABASE:
            	    case KW_SKEWED:
            	    case KW_SMALLINT:
            	    case KW_SORT:
            	    case KW_SORTED:
            	    case KW_SSL:
            	    case KW_STATISTICS:
            	    case KW_STORED:
            	    case KW_STREAMTABLE:
            	    case KW_STRING:
            	    case KW_STRUCT:
            	    case KW_TABLE:
            	    case KW_TABLES:
            	    case KW_TBLPROPERTIES:
            	    case KW_TEMPORARY:
            	    case KW_TERMINATED:
            	    case KW_TEXTFILE:
            	    case KW_TIMESTAMP:
            	    case KW_TINYINT:
            	    case KW_TO:
            	    case KW_TOUCH:
            	    case KW_TRANSACTIONS:
            	    case KW_TRIGGER:
            	    case KW_TRUE:
            	    case KW_TRUNCATE:
            	    case KW_UNARCHIVE:
            	    case KW_UNDO:
            	    case KW_UNION:
            	    case KW_UNIONTYPE:
            	    case KW_UNLOCK:
            	    case KW_UNSET:
            	    case KW_UNSIGNED:
            	    case KW_UPDATE:
            	    case KW_USE:
            	    case KW_USER:
            	    case KW_USING:
            	    case KW_UTC:
            	    case KW_UTCTIMESTAMP:
            	    case KW_VIEW:
            	    case KW_WHILE:
            	    case KW_WITH:
            	        {
            	        alt85=4;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 85, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt85) {
            	        case 1 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:24: KW_ELEM_TYPE
            	            {
            	            KW_ELEM_TYPE342=(Token)match(input,KW_ELEM_TYPE,FOLLOW_KW_ELEM_TYPE_in_descTabTypeExpr6172); 
            	            KW_ELEM_TYPE342_tree = 
            	            (CommonTree)adaptor.create(KW_ELEM_TYPE342)
            	            ;
            	            adaptor.addChild(root_0, KW_ELEM_TYPE342_tree);


            	            }
            	            break;
            	        case 2 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:39: KW_KEY_TYPE
            	            {
            	            KW_KEY_TYPE343=(Token)match(input,KW_KEY_TYPE,FOLLOW_KW_KEY_TYPE_in_descTabTypeExpr6176); 
            	            KW_KEY_TYPE343_tree = 
            	            (CommonTree)adaptor.create(KW_KEY_TYPE343)
            	            ;
            	            adaptor.addChild(root_0, KW_KEY_TYPE343_tree);


            	            }
            	            break;
            	        case 3 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:53: KW_VALUE_TYPE
            	            {
            	            KW_VALUE_TYPE344=(Token)match(input,KW_VALUE_TYPE,FOLLOW_KW_VALUE_TYPE_in_descTabTypeExpr6180); 
            	            KW_VALUE_TYPE344_tree = 
            	            (CommonTree)adaptor.create(KW_VALUE_TYPE344)
            	            ;
            	            adaptor.addChild(root_0, KW_VALUE_TYPE344_tree);


            	            }
            	            break;
            	        case 4 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:69: identifier
            	            {
            	            pushFollow(FOLLOW_identifier_in_descTabTypeExpr6184);
            	            identifier345=identifier();

            	            state._fsp--;

            	            adaptor.addChild(root_0, identifier345.getTree());

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop86;
                }
            } while (true);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:83: ( identifier )?
            int alt87=2;
            switch ( input.LA(1) ) {
                case Identifier:
                case KW_ADD:
                case KW_ADMIN:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPACT:
                case KW_COMPACTIONS:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILE:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_JAR:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORCFILE:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_OWNER:
                case KW_PARQUETFILE:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PRINCIPALS:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_RCFILE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SEQUENCEFILE:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TEXTFILE:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRANSACTIONS:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt87=1;
                    }
                    break;
                case KW_PARTITION:
                    {
                    switch ( input.LA(2) ) {
                        case EOF:
                        case KW_PARTITION:
                            {
                            alt87=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt87) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1278:83: identifier
                    {
                    pushFollow(FOLLOW_identifier_in_descTabTypeExpr6189);
                    identifier346=identifier();

                    state._fsp--;

                    adaptor.addChild(root_0, identifier346.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descTabTypeExpr"


    public static class partTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "partTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1281:1: partTypeExpr : tabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? ) ;
    public final HiveParser.partTypeExpr_return partTypeExpr() throws RecognitionException {
        HiveParser.partTypeExpr_return retval = new HiveParser.partTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.tabTypeExpr_return tabTypeExpr347 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec348 =null;


        RewriteRuleSubtreeStream stream_tabTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule tabTypeExpr");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("specifying table partitions", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1284:5: ( tabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1284:8: tabTypeExpr ( partitionSpec )?
            {
            pushFollow(FOLLOW_tabTypeExpr_in_partTypeExpr6217);
            tabTypeExpr347=tabTypeExpr();

            state._fsp--;

            stream_tabTypeExpr.add(tabTypeExpr347.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1284:20: ( partitionSpec )?
            int alt88=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt88=1;
                    }
                    break;
            }

            switch (alt88) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1284:20: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_partTypeExpr6219);
                    partitionSpec348=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec348.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: tabTypeExpr, partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1284:35: -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1284:38: ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABTYPE, "TOK_TABTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_tabTypeExpr.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1284:64: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "partTypeExpr"


    public static class descPartTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descPartTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1287:1: descPartTypeExpr : descTabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? ) ;
    public final HiveParser.descPartTypeExpr_return descPartTypeExpr() throws RecognitionException {
        HiveParser.descPartTypeExpr_return retval = new HiveParser.descPartTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.descTabTypeExpr_return descTabTypeExpr349 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec350 =null;


        RewriteRuleSubtreeStream stream_descTabTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule descTabTypeExpr");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("specifying describe table partitions", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:5: ( descTabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:8: descTabTypeExpr ( partitionSpec )?
            {
            pushFollow(FOLLOW_descTabTypeExpr_in_descPartTypeExpr6259);
            descTabTypeExpr349=descTabTypeExpr();

            state._fsp--;

            stream_descTabTypeExpr.add(descTabTypeExpr349.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:24: ( partitionSpec )?
            int alt89=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt89=1;
                    }
                    break;
            }

            switch (alt89) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:24: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_descPartTypeExpr6261);
                    partitionSpec350=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec350.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: descTabTypeExpr, partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1290:39: -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:42: ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABTYPE, "TOK_TABTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_descTabTypeExpr.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:72: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descPartTypeExpr"


    public static class descStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1293:1: descStatement : ( ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr ) -> ^( TOK_DESCTABLE $parttype ( $descOptions)? ) | ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) | ( KW_DESCRIBE | KW_DESC ) KW_DATABASE ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) );
    public final HiveParser.descStatement_return descStatement() throws RecognitionException {
        HiveParser.descStatement_return retval = new HiveParser.descStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token descOptions=null;
        Token KW_DESCRIBE351=null;
        Token KW_DESC352=null;
        Token KW_DESCRIBE353=null;
        Token KW_DESC354=null;
        Token KW_FUNCTION355=null;
        Token KW_EXTENDED356=null;
        Token KW_DESCRIBE357=null;
        Token KW_DESC358=null;
        Token KW_DATABASE359=null;
        Token KW_EXTENDED360=null;
        HiveParser.descPartTypeExpr_return parttype =null;

        HiveParser_IdentifiersParser.descFuncNames_return name =null;

        HiveParser_IdentifiersParser.identifier_return dbName =null;


        CommonTree descOptions_tree=null;
        CommonTree KW_DESCRIBE351_tree=null;
        CommonTree KW_DESC352_tree=null;
        CommonTree KW_DESCRIBE353_tree=null;
        CommonTree KW_DESC354_tree=null;
        CommonTree KW_FUNCTION355_tree=null;
        CommonTree KW_EXTENDED356_tree=null;
        CommonTree KW_DESCRIBE357_tree=null;
        CommonTree KW_DESC358_tree=null;
        CommonTree KW_DATABASE359_tree=null;
        CommonTree KW_EXTENDED360_tree=null;
        RewriteRuleTokenStream stream_KW_DESC=new RewriteRuleTokenStream(adaptor,"token KW_DESC");
        RewriteRuleTokenStream stream_KW_FUNCTION=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTION");
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_PRETTY=new RewriteRuleTokenStream(adaptor,"token KW_PRETTY");
        RewriteRuleTokenStream stream_KW_DESCRIBE=new RewriteRuleTokenStream(adaptor,"token KW_DESCRIBE");
        RewriteRuleSubtreeStream stream_descPartTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule descPartTypeExpr");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_descFuncNames=new RewriteRuleSubtreeStream(adaptor,"rule descFuncNames");
         pushMsg("describe statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:5: ( ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr ) -> ^( TOK_DESCTABLE $parttype ( $descOptions)? ) | ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) | ( KW_DESCRIBE | KW_DESC ) KW_DATABASE ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) )
            int alt96=3;
            switch ( input.LA(1) ) {
            case KW_DESCRIBE:
                {
                switch ( input.LA(2) ) {
                case Identifier:
                case KW_ADD:
                case KW_ADMIN:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPACT:
                case KW_COMPACTIONS:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTENDED:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILE:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_JAR:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORCFILE:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_OWNER:
                case KW_PARQUETFILE:
                case KW_PARTITION:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PRINCIPALS:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_RCFILE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SEQUENCEFILE:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TEXTFILE:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRANSACTIONS:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt96=1;
                    }
                    break;
                case KW_FUNCTION:
                    {
                    alt96=2;
                    }
                    break;
                case KW_DATABASE:
                    {
                    alt96=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_DESC:
                {
                switch ( input.LA(2) ) {
                case Identifier:
                case KW_ADD:
                case KW_ADMIN:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPACT:
                case KW_COMPACTIONS:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTENDED:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILE:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_JAR:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORCFILE:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_OWNER:
                case KW_PARQUETFILE:
                case KW_PARTITION:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PRINCIPALS:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_RCFILE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SEQUENCEFILE:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TEXTFILE:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRANSACTIONS:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt96=1;
                    }
                    break;
                case KW_FUNCTION:
                    {
                    alt96=2;
                    }
                    break;
                case KW_DATABASE:
                    {
                    alt96=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 96, 0, input);

                throw nvae;

            }

            switch (alt96) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:7: ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:7: ( KW_DESCRIBE | KW_DESC )
                    int alt90=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt90=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt90=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 90, 0, input);

                        throw nvae;

                    }

                    switch (alt90) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE351=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6301);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE351);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:20: KW_DESC
                            {
                            KW_DESC352=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6303);  
                            stream_KW_DESC.add(KW_DESC352);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:29: (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )?
                    int alt91=4;
                    switch ( input.LA(1) ) {
                        case KW_FORMATTED:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                    {
                                    alt91=1;
                                    }
                                    break;
                                case KW_PARTITION:
                                    {
                                    alt91=1;
                                    }
                                    break;
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARQUETFILE:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt91=1;
                                    }
                                    break;
                            }

                            }
                            break;
                        case KW_EXTENDED:
                            {
                            alt91=2;
                            }
                            break;
                        case KW_PRETTY:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                    {
                                    alt91=3;
                                    }
                                    break;
                                case KW_PARTITION:
                                    {
                                    alt91=3;
                                    }
                                    break;
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARQUETFILE:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt91=3;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt91) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:30: descOptions= KW_FORMATTED
                            {
                            descOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_descStatement6309);  
                            stream_KW_FORMATTED.add(descOptions);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:55: descOptions= KW_EXTENDED
                            {
                            descOptions=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6313);  
                            stream_KW_EXTENDED.add(descOptions);


                            }
                            break;
                        case 3 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:79: descOptions= KW_PRETTY
                            {
                            descOptions=(Token)match(input,KW_PRETTY,FOLLOW_KW_PRETTY_in_descStatement6317);  
                            stream_KW_PRETTY.add(descOptions);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:103: (parttype= descPartTypeExpr )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:104: parttype= descPartTypeExpr
                    {
                    pushFollow(FOLLOW_descPartTypeExpr_in_descStatement6324);
                    parttype=descPartTypeExpr();

                    state._fsp--;

                    stream_descPartTypeExpr.add(parttype.getTree());

                    }


                    // AST REWRITE
                    // elements: descOptions, parttype
                    // token labels: descOptions
                    // rule labels: retval, parttype
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_descOptions=new RewriteRuleTokenStream(adaptor,"token descOptions",descOptions);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1296:131: -> ^( TOK_DESCTABLE $parttype ( $descOptions)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:134: ^( TOK_DESCTABLE $parttype ( $descOptions)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCTABLE, "TOK_DESCTABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_parttype.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:161: ( $descOptions)?
                        if ( stream_descOptions.hasNext() ) {
                            adaptor.addChild(root_1, stream_descOptions.nextNode());

                        }
                        stream_descOptions.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:7: ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:7: ( KW_DESCRIBE | KW_DESC )
                    int alt92=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt92=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt92=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 92, 0, input);

                        throw nvae;

                    }

                    switch (alt92) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE353=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6347);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE353);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:20: KW_DESC
                            {
                            KW_DESC354=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6349);  
                            stream_KW_DESC.add(KW_DESC354);


                            }
                            break;

                    }


                    KW_FUNCTION355=(Token)match(input,KW_FUNCTION,FOLLOW_KW_FUNCTION_in_descStatement6352);  
                    stream_KW_FUNCTION.add(KW_FUNCTION355);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:41: ( KW_EXTENDED )?
                    int alt93=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt93=1;
                            }
                            break;
                    }

                    switch (alt93) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:41: KW_EXTENDED
                            {
                            KW_EXTENDED356=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6354);  
                            stream_KW_EXTENDED.add(KW_EXTENDED356);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:54: (name= descFuncNames )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:55: name= descFuncNames
                    {
                    pushFollow(FOLLOW_descFuncNames_in_descStatement6360);
                    name=descFuncNames();

                    state._fsp--;

                    stream_descFuncNames.add(name.getTree());

                    }


                    // AST REWRITE
                    // elements: KW_EXTENDED, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1297:75: -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:78: ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCFUNCTION, "TOK_DESCFUNCTION")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:103: ( KW_EXTENDED )?
                        if ( stream_KW_EXTENDED.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_EXTENDED.nextNode()
                            );

                        }
                        stream_KW_EXTENDED.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:7: ( KW_DESCRIBE | KW_DESC ) KW_DATABASE ( KW_EXTENDED )? (dbName= identifier )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:7: ( KW_DESCRIBE | KW_DESC )
                    int alt94=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt94=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt94=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 94, 0, input);

                        throw nvae;

                    }

                    switch (alt94) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE357=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6382);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE357);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:20: KW_DESC
                            {
                            KW_DESC358=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6384);  
                            stream_KW_DESC.add(KW_DESC358);


                            }
                            break;

                    }


                    KW_DATABASE359=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_descStatement6387);  
                    stream_KW_DATABASE.add(KW_DATABASE359);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:41: ( KW_EXTENDED )?
                    int alt95=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt95=1;
                            }
                            break;
                    }

                    switch (alt95) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:41: KW_EXTENDED
                            {
                            KW_EXTENDED360=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6389);  
                            stream_KW_EXTENDED.add(KW_EXTENDED360);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:54: (dbName= identifier )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:55: dbName= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_descStatement6395);
                    dbName=identifier();

                    state._fsp--;

                    stream_identifier.add(dbName.getTree());

                    }


                    // AST REWRITE
                    // elements: KW_EXTENDED, dbName
                    // token labels: 
                    // rule labels: retval, dbName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_dbName=new RewriteRuleSubtreeStream(adaptor,"rule dbName",dbName!=null?dbName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1298:74: -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:77: ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCDATABASE, "TOK_DESCDATABASE")
                        , root_1);

                        adaptor.addChild(root_1, stream_dbName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1298:104: ( KW_EXTENDED )?
                        if ( stream_KW_EXTENDED.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_EXTENDED.nextNode()
                            );

                        }
                        stream_KW_EXTENDED.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descStatement"


    public static class analyzeStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "analyzeStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1301:1: analyzeStatement : KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS statsColumnName= columnNameList ) )? -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( $statsColumnName)? ) ;
    public final HiveParser.analyzeStatement_return analyzeStatement() throws RecognitionException {
        HiveParser.analyzeStatement_return retval = new HiveParser.analyzeStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token noscan=null;
        Token partialscan=null;
        Token KW_ANALYZE361=null;
        Token KW_TABLE362=null;
        Token KW_COMPUTE363=null;
        Token KW_STATISTICS364=null;
        Token KW_FOR365=null;
        Token KW_COLUMNS366=null;
        HiveParser_IdentifiersParser.tableOrPartition_return parttype =null;

        HiveParser.columnNameList_return statsColumnName =null;


        CommonTree noscan_tree=null;
        CommonTree partialscan_tree=null;
        CommonTree KW_ANALYZE361_tree=null;
        CommonTree KW_TABLE362_tree=null;
        CommonTree KW_COMPUTE363_tree=null;
        CommonTree KW_STATISTICS364_tree=null;
        CommonTree KW_FOR365_tree=null;
        CommonTree KW_COLUMNS366_tree=null;
        RewriteRuleTokenStream stream_KW_ANALYZE=new RewriteRuleTokenStream(adaptor,"token KW_ANALYZE");
        RewriteRuleTokenStream stream_KW_NOSCAN=new RewriteRuleTokenStream(adaptor,"token KW_NOSCAN");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_STATISTICS=new RewriteRuleTokenStream(adaptor,"token KW_STATISTICS");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_COMPUTE=new RewriteRuleTokenStream(adaptor,"token KW_COMPUTE");
        RewriteRuleTokenStream stream_KW_PARTIALSCAN=new RewriteRuleTokenStream(adaptor,"token KW_PARTIALSCAN");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
         pushMsg("analyze statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:5: ( KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS statsColumnName= columnNameList ) )? -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( $statsColumnName)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:7: KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS statsColumnName= columnNameList ) )?
            {
            KW_ANALYZE361=(Token)match(input,KW_ANALYZE,FOLLOW_KW_ANALYZE_in_analyzeStatement6435);  
            stream_KW_ANALYZE.add(KW_ANALYZE361);


            KW_TABLE362=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_analyzeStatement6437);  
            stream_KW_TABLE.add(KW_TABLE362);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:27: (parttype= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:28: parttype= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_analyzeStatement6442);
            parttype=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(parttype.getTree());

            }


            KW_COMPUTE363=(Token)match(input,KW_COMPUTE,FOLLOW_KW_COMPUTE_in_analyzeStatement6445);  
            stream_KW_COMPUTE.add(KW_COMPUTE363);


            KW_STATISTICS364=(Token)match(input,KW_STATISTICS,FOLLOW_KW_STATISTICS_in_analyzeStatement6447);  
            stream_KW_STATISTICS.add(KW_STATISTICS364);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:80: ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS statsColumnName= columnNameList ) )?
            int alt97=4;
            switch ( input.LA(1) ) {
                case KW_NOSCAN:
                    {
                    alt97=1;
                    }
                    break;
                case KW_PARTIALSCAN:
                    {
                    alt97=2;
                    }
                    break;
                case KW_FOR:
                    {
                    alt97=3;
                    }
                    break;
            }

            switch (alt97) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:81: (noscan= KW_NOSCAN )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:81: (noscan= KW_NOSCAN )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:82: noscan= KW_NOSCAN
                    {
                    noscan=(Token)match(input,KW_NOSCAN,FOLLOW_KW_NOSCAN_in_analyzeStatement6453);  
                    stream_KW_NOSCAN.add(noscan);


                    }


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:102: (partialscan= KW_PARTIALSCAN )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:102: (partialscan= KW_PARTIALSCAN )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:103: partialscan= KW_PARTIALSCAN
                    {
                    partialscan=(Token)match(input,KW_PARTIALSCAN,FOLLOW_KW_PARTIALSCAN_in_analyzeStatement6461);  
                    stream_KW_PARTIALSCAN.add(partialscan);


                    }


                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:133: ( KW_FOR KW_COLUMNS statsColumnName= columnNameList )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:133: ( KW_FOR KW_COLUMNS statsColumnName= columnNameList )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:134: KW_FOR KW_COLUMNS statsColumnName= columnNameList
                    {
                    KW_FOR365=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_analyzeStatement6467);  
                    stream_KW_FOR.add(KW_FOR365);


                    KW_COLUMNS366=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_analyzeStatement6469);  
                    stream_KW_COLUMNS.add(KW_COLUMNS366);


                    pushFollow(FOLLOW_columnNameList_in_analyzeStatement6473);
                    statsColumnName=columnNameList();

                    state._fsp--;

                    stream_columnNameList.add(statsColumnName.getTree());

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: noscan, partialscan, statsColumnName, parttype
            // token labels: partialscan, noscan
            // rule labels: retval, parttype, statsColumnName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_partialscan=new RewriteRuleTokenStream(adaptor,"token partialscan",partialscan);
            RewriteRuleTokenStream stream_noscan=new RewriteRuleTokenStream(adaptor,"token noscan",noscan);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);
            RewriteRuleSubtreeStream stream_statsColumnName=new RewriteRuleSubtreeStream(adaptor,"rule statsColumnName",statsColumnName!=null?statsColumnName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1304:186: -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( $statsColumnName)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:189: ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( $statsColumnName)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ANALYZE, "TOK_ANALYZE")
                , root_1);

                adaptor.addChild(root_1, stream_parttype.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:214: ( $noscan)?
                if ( stream_noscan.hasNext() ) {
                    adaptor.addChild(root_1, stream_noscan.nextNode());

                }
                stream_noscan.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:223: ( $partialscan)?
                if ( stream_partialscan.hasNext() ) {
                    adaptor.addChild(root_1, stream_partialscan.nextNode());

                }
                stream_partialscan.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:237: ( $statsColumnName)?
                if ( stream_statsColumnName.hasNext() ) {
                    adaptor.addChild(root_1, stream_statsColumnName.nextTree());

                }
                stream_statsColumnName.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "analyzeStatement"


    public static class showStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1307:1: showStatement : ( KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )? -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? ) | KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )? -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? ) | KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tabname= tableName ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWCOLUMNS ( $db_name)? $tabname) | KW_SHOW KW_FUNCTIONS ( showFunctionIdentifier )? -> ^( TOK_SHOWFUNCTIONS ( showFunctionIdentifier )? ) | KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )? -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? ) | KW_SHOW KW_CREATE KW_TABLE tabName= tableName -> ^( TOK_SHOW_CREATETABLE $tabName) | KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )? -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? ) | KW_SHOW KW_TBLPROPERTIES tblName= identifier ( LPAREN prptyName= StringLiteral RPAREN )? -> ^( TOK_SHOW_TBLPROPERTIES $tblName ( $prptyName)? ) | KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) | KW_SHOW KW_LOCKS KW_DATABASE (dbName= Identifier ) (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? ) | KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? ) | KW_SHOW KW_COMPACTIONS -> ^( TOK_SHOW_COMPACTIONS ) | KW_SHOW KW_TRANSACTIONS -> ^( TOK_SHOW_TRANSACTIONS ) );
    public final HiveParser.showStatement_return showStatement() throws RecognitionException {
        HiveParser.showStatement_return retval = new HiveParser.showStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token prptyName=null;
        Token isExtended=null;
        Token dbName=null;
        Token showOptions=null;
        Token KW_SHOW367=null;
        Token KW_DATABASES368=null;
        Token KW_SCHEMAS369=null;
        Token KW_LIKE370=null;
        Token KW_SHOW372=null;
        Token KW_TABLES373=null;
        Token KW_FROM374=null;
        Token KW_IN375=null;
        Token KW_LIKE376=null;
        Token KW_SHOW379=null;
        Token KW_COLUMNS380=null;
        Token KW_FROM381=null;
        Token KW_IN382=null;
        Token KW_FROM383=null;
        Token KW_IN384=null;
        Token KW_SHOW385=null;
        Token KW_FUNCTIONS386=null;
        Token KW_SHOW388=null;
        Token KW_PARTITIONS389=null;
        Token KW_SHOW391=null;
        Token KW_CREATE392=null;
        Token KW_TABLE393=null;
        Token KW_SHOW394=null;
        Token KW_TABLE395=null;
        Token KW_EXTENDED396=null;
        Token KW_FROM397=null;
        Token KW_IN398=null;
        Token KW_LIKE399=null;
        Token KW_SHOW402=null;
        Token KW_TBLPROPERTIES403=null;
        Token LPAREN404=null;
        Token RPAREN405=null;
        Token KW_SHOW406=null;
        Token KW_LOCKS407=null;
        Token KW_SHOW408=null;
        Token KW_LOCKS409=null;
        Token KW_DATABASE410=null;
        Token KW_SHOW411=null;
        Token KW_INDEX412=null;
        Token KW_INDEXES413=null;
        Token KW_ON414=null;
        Token KW_FROM416=null;
        Token KW_IN417=null;
        Token KW_SHOW418=null;
        Token KW_COMPACTIONS419=null;
        Token KW_SHOW420=null;
        Token KW_TRANSACTIONS421=null;
        HiveParser_IdentifiersParser.identifier_return db_name =null;

        HiveParser_FromClauseParser.tableName_return tabname =null;

        HiveParser_FromClauseParser.tableName_return tabName =null;

        HiveParser_IdentifiersParser.identifier_return tblName =null;

        HiveParser.partTypeExpr_return parttype =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier371 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier377 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier378 =null;

        HiveParser.showFunctionIdentifier_return showFunctionIdentifier387 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec390 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier400 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec401 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier415 =null;


        CommonTree prptyName_tree=null;
        CommonTree isExtended_tree=null;
        CommonTree dbName_tree=null;
        CommonTree showOptions_tree=null;
        CommonTree KW_SHOW367_tree=null;
        CommonTree KW_DATABASES368_tree=null;
        CommonTree KW_SCHEMAS369_tree=null;
        CommonTree KW_LIKE370_tree=null;
        CommonTree KW_SHOW372_tree=null;
        CommonTree KW_TABLES373_tree=null;
        CommonTree KW_FROM374_tree=null;
        CommonTree KW_IN375_tree=null;
        CommonTree KW_LIKE376_tree=null;
        CommonTree KW_SHOW379_tree=null;
        CommonTree KW_COLUMNS380_tree=null;
        CommonTree KW_FROM381_tree=null;
        CommonTree KW_IN382_tree=null;
        CommonTree KW_FROM383_tree=null;
        CommonTree KW_IN384_tree=null;
        CommonTree KW_SHOW385_tree=null;
        CommonTree KW_FUNCTIONS386_tree=null;
        CommonTree KW_SHOW388_tree=null;
        CommonTree KW_PARTITIONS389_tree=null;
        CommonTree KW_SHOW391_tree=null;
        CommonTree KW_CREATE392_tree=null;
        CommonTree KW_TABLE393_tree=null;
        CommonTree KW_SHOW394_tree=null;
        CommonTree KW_TABLE395_tree=null;
        CommonTree KW_EXTENDED396_tree=null;
        CommonTree KW_FROM397_tree=null;
        CommonTree KW_IN398_tree=null;
        CommonTree KW_LIKE399_tree=null;
        CommonTree KW_SHOW402_tree=null;
        CommonTree KW_TBLPROPERTIES403_tree=null;
        CommonTree LPAREN404_tree=null;
        CommonTree RPAREN405_tree=null;
        CommonTree KW_SHOW406_tree=null;
        CommonTree KW_LOCKS407_tree=null;
        CommonTree KW_SHOW408_tree=null;
        CommonTree KW_LOCKS409_tree=null;
        CommonTree KW_DATABASE410_tree=null;
        CommonTree KW_SHOW411_tree=null;
        CommonTree KW_INDEX412_tree=null;
        CommonTree KW_INDEXES413_tree=null;
        CommonTree KW_ON414_tree=null;
        CommonTree KW_FROM416_tree=null;
        CommonTree KW_IN417_tree=null;
        CommonTree KW_SHOW418_tree=null;
        CommonTree KW_COMPACTIONS419_tree=null;
        CommonTree KW_SHOW420_tree=null;
        CommonTree KW_TRANSACTIONS421_tree=null;
        RewriteRuleTokenStream stream_KW_LIKE=new RewriteRuleTokenStream(adaptor,"token KW_LIKE");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_TRANSACTIONS=new RewriteRuleTokenStream(adaptor,"token KW_TRANSACTIONS");
        RewriteRuleTokenStream stream_KW_FUNCTIONS=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTIONS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_INDEXES=new RewriteRuleTokenStream(adaptor,"token KW_INDEXES");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_LOCKS=new RewriteRuleTokenStream(adaptor,"token KW_LOCKS");
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_PARTITIONS=new RewriteRuleTokenStream(adaptor,"token KW_PARTITIONS");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_IN=new RewriteRuleTokenStream(adaptor,"token KW_IN");
        RewriteRuleTokenStream stream_KW_COMPACTIONS=new RewriteRuleTokenStream(adaptor,"token KW_COMPACTIONS");
        RewriteRuleTokenStream stream_KW_SCHEMAS=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMAS");
        RewriteRuleTokenStream stream_KW_TABLES=new RewriteRuleTokenStream(adaptor,"token KW_TABLES");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_DATABASES=new RewriteRuleTokenStream(adaptor,"token KW_DATABASES");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_showStmtIdentifier=new RewriteRuleSubtreeStream(adaptor,"rule showStmtIdentifier");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_showFunctionIdentifier=new RewriteRuleSubtreeStream(adaptor,"rule showFunctionIdentifier");
        RewriteRuleSubtreeStream stream_partTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule partTypeExpr");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("show statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:5: ( KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )? -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? ) | KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )? -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? ) | KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tabname= tableName ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWCOLUMNS ( $db_name)? $tabname) | KW_SHOW KW_FUNCTIONS ( showFunctionIdentifier )? -> ^( TOK_SHOWFUNCTIONS ( showFunctionIdentifier )? ) | KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )? -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? ) | KW_SHOW KW_CREATE KW_TABLE tabName= tableName -> ^( TOK_SHOW_CREATETABLE $tabName) | KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )? -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? ) | KW_SHOW KW_TBLPROPERTIES tblName= identifier ( LPAREN prptyName= StringLiteral RPAREN )? -> ^( TOK_SHOW_TBLPROPERTIES $tblName ( $prptyName)? ) | KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) | KW_SHOW KW_LOCKS KW_DATABASE (dbName= Identifier ) (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? ) | KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? ) | KW_SHOW KW_COMPACTIONS -> ^( TOK_SHOW_COMPACTIONS ) | KW_SHOW KW_TRANSACTIONS -> ^( TOK_SHOW_TRANSACTIONS ) )
            int alt119=13;
            switch ( input.LA(1) ) {
            case KW_SHOW:
                {
                switch ( input.LA(2) ) {
                case KW_TABLES:
                    {
                    alt119=2;
                    }
                    break;
                case KW_COLUMNS:
                    {
                    alt119=3;
                    }
                    break;
                case KW_FUNCTIONS:
                    {
                    alt119=4;
                    }
                    break;
                case KW_PARTITIONS:
                    {
                    alt119=5;
                    }
                    break;
                case KW_CREATE:
                    {
                    alt119=6;
                    }
                    break;
                case KW_TABLE:
                    {
                    alt119=7;
                    }
                    break;
                case KW_TBLPROPERTIES:
                    {
                    alt119=8;
                    }
                    break;
                case KW_LOCKS:
                    {
                    switch ( input.LA(3) ) {
                    case KW_DATABASE:
                        {
                        alt119=10;
                        }
                        break;
                    case EOF:
                    case Identifier:
                    case KW_ADD:
                    case KW_ADMIN:
                    case KW_AFTER:
                    case KW_ALL:
                    case KW_ALTER:
                    case KW_ANALYZE:
                    case KW_ARCHIVE:
                    case KW_ARRAY:
                    case KW_AS:
                    case KW_ASC:
                    case KW_BEFORE:
                    case KW_BETWEEN:
                    case KW_BIGINT:
                    case KW_BINARY:
                    case KW_BOOLEAN:
                    case KW_BOTH:
                    case KW_BUCKET:
                    case KW_BUCKETS:
                    case KW_BY:
                    case KW_CASCADE:
                    case KW_CHANGE:
                    case KW_CLUSTER:
                    case KW_CLUSTERED:
                    case KW_CLUSTERSTATUS:
                    case KW_COLLECTION:
                    case KW_COLUMNS:
                    case KW_COMMENT:
                    case KW_COMPACT:
                    case KW_COMPACTIONS:
                    case KW_COMPUTE:
                    case KW_CONCATENATE:
                    case KW_CONTINUE:
                    case KW_CREATE:
                    case KW_CUBE:
                    case KW_CURSOR:
                    case KW_DATA:
                    case KW_DATABASES:
                    case KW_DATE:
                    case KW_DATETIME:
                    case KW_DBPROPERTIES:
                    case KW_DECIMAL:
                    case KW_DEFAULT:
                    case KW_DEFERRED:
                    case KW_DEFINED:
                    case KW_DELETE:
                    case KW_DELIMITED:
                    case KW_DEPENDENCY:
                    case KW_DESC:
                    case KW_DESCRIBE:
                    case KW_DIRECTORIES:
                    case KW_DIRECTORY:
                    case KW_DISABLE:
                    case KW_DISTRIBUTE:
                    case KW_DOUBLE:
                    case KW_DROP:
                    case KW_ELEM_TYPE:
                    case KW_ENABLE:
                    case KW_ESCAPED:
                    case KW_EXCLUSIVE:
                    case KW_EXISTS:
                    case KW_EXPLAIN:
                    case KW_EXPORT:
                    case KW_EXTENDED:
                    case KW_EXTERNAL:
                    case KW_FALSE:
                    case KW_FETCH:
                    case KW_FIELDS:
                    case KW_FILE:
                    case KW_FILEFORMAT:
                    case KW_FIRST:
                    case KW_FLOAT:
                    case KW_FOR:
                    case KW_FORMAT:
                    case KW_FORMATTED:
                    case KW_FULL:
                    case KW_FUNCTIONS:
                    case KW_GRANT:
                    case KW_GROUP:
                    case KW_GROUPING:
                    case KW_HOLD_DDLTIME:
                    case KW_IDXPROPERTIES:
                    case KW_IGNORE:
                    case KW_IMPORT:
                    case KW_IN:
                    case KW_INDEX:
                    case KW_INDEXES:
                    case KW_INNER:
                    case KW_INPATH:
                    case KW_INPUTDRIVER:
                    case KW_INPUTFORMAT:
                    case KW_INSERT:
                    case KW_INT:
                    case KW_INTERSECT:
                    case KW_INTO:
                    case KW_IS:
                    case KW_ITEMS:
                    case KW_JAR:
                    case KW_KEYS:
                    case KW_KEY_TYPE:
                    case KW_LATERAL:
                    case KW_LEFT:
                    case KW_LIKE:
                    case KW_LIMIT:
                    case KW_LINES:
                    case KW_LOAD:
                    case KW_LOCAL:
                    case KW_LOCATION:
                    case KW_LOCK:
                    case KW_LOCKS:
                    case KW_LOGICAL:
                    case KW_LONG:
                    case KW_MAPJOIN:
                    case KW_MATERIALIZED:
                    case KW_MINUS:
                    case KW_MSCK:
                    case KW_NONE:
                    case KW_NOSCAN:
                    case KW_NO_DROP:
                    case KW_NULL:
                    case KW_OF:
                    case KW_OFFLINE:
                    case KW_OPTION:
                    case KW_ORCFILE:
                    case KW_ORDER:
                    case KW_OUT:
                    case KW_OUTER:
                    case KW_OUTPUTDRIVER:
                    case KW_OUTPUTFORMAT:
                    case KW_OVERWRITE:
                    case KW_OWNER:
                    case KW_PARQUETFILE:
                    case KW_PARTITION:
                    case KW_PARTITIONED:
                    case KW_PARTITIONS:
                    case KW_PERCENT:
                    case KW_PLUS:
                    case KW_PRETTY:
                    case KW_PRINCIPALS:
                    case KW_PROCEDURE:
                    case KW_PROTECTION:
                    case KW_PURGE:
                    case KW_RANGE:
                    case KW_RCFILE:
                    case KW_READ:
                    case KW_READONLY:
                    case KW_READS:
                    case KW_REBUILD:
                    case KW_RECORDREADER:
                    case KW_RECORDWRITER:
                    case KW_REGEXP:
                    case KW_RENAME:
                    case KW_REPAIR:
                    case KW_REPLACE:
                    case KW_RESTRICT:
                    case KW_REVOKE:
                    case KW_RIGHT:
                    case KW_RLIKE:
                    case KW_ROLE:
                    case KW_ROLES:
                    case KW_ROLLUP:
                    case KW_ROW:
                    case KW_ROWS:
                    case KW_SCHEMA:
                    case KW_SCHEMAS:
                    case KW_SEMI:
                    case KW_SEQUENCEFILE:
                    case KW_SERDE:
                    case KW_SERDEPROPERTIES:
                    case KW_SET:
                    case KW_SETS:
                    case KW_SHARED:
                    case KW_SHOW:
                    case KW_SHOW_DATABASE:
                    case KW_SKEWED:
                    case KW_SMALLINT:
                    case KW_SORT:
                    case KW_SORTED:
                    case KW_SSL:
                    case KW_STATISTICS:
                    case KW_STORED:
                    case KW_STREAMTABLE:
                    case KW_STRING:
                    case KW_STRUCT:
                    case KW_TABLE:
                    case KW_TABLES:
                    case KW_TBLPROPERTIES:
                    case KW_TEMPORARY:
                    case KW_TERMINATED:
                    case KW_TEXTFILE:
                    case KW_TIMESTAMP:
                    case KW_TINYINT:
                    case KW_TO:
                    case KW_TOUCH:
                    case KW_TRANSACTIONS:
                    case KW_TRIGGER:
                    case KW_TRUE:
                    case KW_TRUNCATE:
                    case KW_UNARCHIVE:
                    case KW_UNDO:
                    case KW_UNION:
                    case KW_UNIONTYPE:
                    case KW_UNLOCK:
                    case KW_UNSET:
                    case KW_UNSIGNED:
                    case KW_UPDATE:
                    case KW_USE:
                    case KW_USER:
                    case KW_USING:
                    case KW_UTC:
                    case KW_UTCTIMESTAMP:
                    case KW_VALUE_TYPE:
                    case KW_VIEW:
                    case KW_WHILE:
                    case KW_WITH:
                        {
                        alt119=9;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 119, 9, input);

                        throw nvae;

                    }

                    }
                    break;
                case KW_COMPACTIONS:
                    {
                    alt119=12;
                    }
                    break;
                case KW_TRANSACTIONS:
                    {
                    alt119=13;
                    }
                    break;
                case KW_DATABASES:
                case KW_SCHEMAS:
                    {
                    alt119=1;
                    }
                    break;
                case KW_FORMATTED:
                case KW_INDEX:
                case KW_INDEXES:
                    {
                    alt119=11;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 119, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 119, 0, input);

                throw nvae;

            }

            switch (alt119) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:7: KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )?
                    {
                    KW_SHOW367=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6524);  
                    stream_KW_SHOW.add(KW_SHOW367);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:15: ( KW_DATABASES | KW_SCHEMAS )
                    int alt98=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASES:
                        {
                        alt98=1;
                        }
                        break;
                    case KW_SCHEMAS:
                        {
                        alt98=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 98, 0, input);

                        throw nvae;

                    }

                    switch (alt98) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:16: KW_DATABASES
                            {
                            KW_DATABASES368=(Token)match(input,KW_DATABASES,FOLLOW_KW_DATABASES_in_showStatement6527);  
                            stream_KW_DATABASES.add(KW_DATABASES368);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:29: KW_SCHEMAS
                            {
                            KW_SCHEMAS369=(Token)match(input,KW_SCHEMAS,FOLLOW_KW_SCHEMAS_in_showStatement6529);  
                            stream_KW_SCHEMAS.add(KW_SCHEMAS369);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:41: ( KW_LIKE showStmtIdentifier )?
                    int alt99=2;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            alt99=1;
                            }
                            break;
                    }

                    switch (alt99) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:42: KW_LIKE showStmtIdentifier
                            {
                            KW_LIKE370=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6533);  
                            stream_KW_LIKE.add(KW_LIKE370);


                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6535);
                            showStmtIdentifier371=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier371.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1310:71: -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:74: ^( TOK_SHOWDATABASES ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWDATABASES, "TOK_SHOWDATABASES")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:94: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:7: KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )?
                    {
                    KW_SHOW372=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6554);  
                    stream_KW_SHOW.add(KW_SHOW372);


                    KW_TABLES373=(Token)match(input,KW_TABLES,FOLLOW_KW_TABLES_in_showStatement6556);  
                    stream_KW_TABLES.add(KW_TABLES373);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:25: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt101=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                            {
                            alt101=1;
                            }
                            break;
                        case KW_IN:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARQUETFILE:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt101=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt101) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:26: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:26: ( KW_FROM | KW_IN )
                            int alt100=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt100=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt100=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 100, 0, input);

                                throw nvae;

                            }

                            switch (alt100) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:27: KW_FROM
                                    {
                                    KW_FROM374=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6560);  
                                    stream_KW_FROM.add(KW_FROM374);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:35: KW_IN
                                    {
                                    KW_IN375=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6562);  
                                    stream_KW_IN.add(KW_IN375);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6567);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:63: ( KW_LIKE showStmtIdentifier | showStmtIdentifier )?
                    int alt102=3;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARQUETFILE:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                case StringLiteral:
                                    {
                                    alt102=1;
                                    }
                                    break;
                                case EOF:
                                    {
                                    alt102=2;
                                    }
                                    break;
                            }

                            }
                            break;
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORCFILE:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARQUETFILE:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_RCFILE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SEQUENCEFILE:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TEXTFILE:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case StringLiteral:
                            {
                            alt102=2;
                            }
                            break;
                    }

                    switch (alt102) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:64: KW_LIKE showStmtIdentifier
                            {
                            KW_LIKE376=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6572);  
                            stream_KW_LIKE.add(KW_LIKE376);


                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6574);
                            showStmtIdentifier377=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier377.getTree());

                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:91: showStmtIdentifier
                            {
                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6576);
                            showStmtIdentifier378=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier378.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier, db_name
                    // token labels: 
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1311:113: -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:116: ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWTABLES, "TOK_SHOWTABLES")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:133: ( TOK_FROM $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, 
                            (CommonTree)adaptor.create(TOK_FROM, "TOK_FROM")
                            );

                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:154: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:7: KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tabname= tableName ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    {
                    KW_SHOW379=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6604);  
                    stream_KW_SHOW.add(KW_SHOW379);


                    KW_COLUMNS380=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_showStatement6606);  
                    stream_KW_COLUMNS.add(KW_COLUMNS380);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:26: ( KW_FROM | KW_IN )
                    int alt103=2;
                    switch ( input.LA(1) ) {
                    case KW_FROM:
                        {
                        alt103=1;
                        }
                        break;
                    case KW_IN:
                        {
                        alt103=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 103, 0, input);

                        throw nvae;

                    }

                    switch (alt103) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:27: KW_FROM
                            {
                            KW_FROM381=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6609);  
                            stream_KW_FROM.add(KW_FROM381);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:35: KW_IN
                            {
                            KW_IN382=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6611);  
                            stream_KW_IN.add(KW_IN382);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableName_in_showStatement6616);
                    tabname=tableName();

                    state._fsp--;

                    stream_tableName.add(tabname.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:60: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt105=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt105=1;
                            }
                            break;
                    }

                    switch (alt105) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:61: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:61: ( KW_FROM | KW_IN )
                            int alt104=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt104=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt104=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 104, 0, input);

                                throw nvae;

                            }

                            switch (alt104) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:62: KW_FROM
                                    {
                                    KW_FROM383=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6620);  
                                    stream_KW_FROM.add(KW_FROM383);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1312:70: KW_IN
                                    {
                                    KW_IN384=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6622);  
                                    stream_KW_IN.add(KW_IN384);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6627);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: db_name, tabname
                    // token labels: 
                    // rule labels: retval, db_name, tabname
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);
                    RewriteRuleSubtreeStream stream_tabname=new RewriteRuleSubtreeStream(adaptor,"rule tabname",tabname!=null?tabname.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1313:5: -> ^( TOK_SHOWCOLUMNS ( $db_name)? $tabname)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1313:8: ^( TOK_SHOWCOLUMNS ( $db_name)? $tabname)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWCOLUMNS, "TOK_SHOWCOLUMNS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1313:27: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        adaptor.addChild(root_1, stream_tabname.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1314:7: KW_SHOW KW_FUNCTIONS ( showFunctionIdentifier )?
                    {
                    KW_SHOW385=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6655);  
                    stream_KW_SHOW.add(KW_SHOW385);


                    KW_FUNCTIONS386=(Token)match(input,KW_FUNCTIONS,FOLLOW_KW_FUNCTIONS_in_showStatement6657);  
                    stream_KW_FUNCTIONS.add(KW_FUNCTIONS386);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1314:28: ( showFunctionIdentifier )?
                    int alt106=2;
                    switch ( input.LA(1) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORCFILE:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARQUETFILE:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_RCFILE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SEQUENCEFILE:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TEXTFILE:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case StringLiteral:
                            {
                            alt106=1;
                            }
                            break;
                    }

                    switch (alt106) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1314:28: showFunctionIdentifier
                            {
                            pushFollow(FOLLOW_showFunctionIdentifier_in_showStatement6659);
                            showFunctionIdentifier387=showFunctionIdentifier();

                            state._fsp--;

                            stream_showFunctionIdentifier.add(showFunctionIdentifier387.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showFunctionIdentifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1314:53: -> ^( TOK_SHOWFUNCTIONS ( showFunctionIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1314:56: ^( TOK_SHOWFUNCTIONS ( showFunctionIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWFUNCTIONS, "TOK_SHOWFUNCTIONS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1314:76: ( showFunctionIdentifier )?
                        if ( stream_showFunctionIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showFunctionIdentifier.nextTree());

                        }
                        stream_showFunctionIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:7: KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )?
                    {
                    KW_SHOW388=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6678);  
                    stream_KW_SHOW.add(KW_SHOW388);


                    KW_PARTITIONS389=(Token)match(input,KW_PARTITIONS,FOLLOW_KW_PARTITIONS_in_showStatement6680);  
                    stream_KW_PARTITIONS.add(KW_PARTITIONS389);


                    pushFollow(FOLLOW_tableName_in_showStatement6684);
                    tabName=tableName();

                    state._fsp--;

                    stream_tableName.add(tabName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:47: ( partitionSpec )?
                    int alt107=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt107=1;
                            }
                            break;
                    }

                    switch (alt107) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:47: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_showStatement6686);
                            partitionSpec390=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec390.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: tabName, partitionSpec
                    // token labels: 
                    // rule labels: retval, tabName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tabName=new RewriteRuleSubtreeStream(adaptor,"rule tabName",tabName!=null?tabName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1315:62: -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:65: ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWPARTITIONS, "TOK_SHOWPARTITIONS")
                        , root_1);

                        adaptor.addChild(root_1, stream_tabName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1315:95: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1316:7: KW_SHOW KW_CREATE KW_TABLE tabName= tableName
                    {
                    KW_SHOW391=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6708);  
                    stream_KW_SHOW.add(KW_SHOW391);


                    KW_CREATE392=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_showStatement6710);  
                    stream_KW_CREATE.add(KW_CREATE392);


                    KW_TABLE393=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_showStatement6712);  
                    stream_KW_TABLE.add(KW_TABLE393);


                    pushFollow(FOLLOW_tableName_in_showStatement6716);
                    tabName=tableName();

                    state._fsp--;

                    stream_tableName.add(tabName.getTree());

                    // AST REWRITE
                    // elements: tabName
                    // token labels: 
                    // rule labels: retval, tabName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tabName=new RewriteRuleSubtreeStream(adaptor,"rule tabName",tabName!=null?tabName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1316:52: -> ^( TOK_SHOW_CREATETABLE $tabName)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1316:55: ^( TOK_SHOW_CREATETABLE $tabName)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_CREATETABLE, "TOK_SHOW_CREATETABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_tabName.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:7: KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )?
                    {
                    KW_SHOW394=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6733);  
                    stream_KW_SHOW.add(KW_SHOW394);


                    KW_TABLE395=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_showStatement6735);  
                    stream_KW_TABLE.add(KW_TABLE395);


                    KW_EXTENDED396=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement6737);  
                    stream_KW_EXTENDED.add(KW_EXTENDED396);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:36: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt109=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt109=1;
                            }
                            break;
                    }

                    switch (alt109) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:37: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:37: ( KW_FROM | KW_IN )
                            int alt108=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt108=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt108=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 108, 0, input);

                                throw nvae;

                            }

                            switch (alt108) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:38: KW_FROM
                                    {
                                    KW_FROM397=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6741);  
                                    stream_KW_FROM.add(KW_FROM397);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:46: KW_IN
                                    {
                                    KW_IN398=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6743);  
                                    stream_KW_IN.add(KW_IN398);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6748);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    KW_LIKE399=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6752);  
                    stream_KW_LIKE.add(KW_LIKE399);


                    pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6754);
                    showStmtIdentifier400=showStmtIdentifier();

                    state._fsp--;

                    stream_showStmtIdentifier.add(showStmtIdentifier400.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:101: ( partitionSpec )?
                    int alt110=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt110=1;
                            }
                            break;
                    }

                    switch (alt110) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:101: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_showStatement6756);
                            partitionSpec401=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec401.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: partitionSpec, db_name, showStmtIdentifier
                    // token labels: 
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1318:5: -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:8: ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TABLESTATUS, "TOK_SHOW_TABLESTATUS")
                        , root_1);

                        adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:51: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:60: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1319:7: KW_SHOW KW_TBLPROPERTIES tblName= identifier ( LPAREN prptyName= StringLiteral RPAREN )?
                    {
                    KW_SHOW402=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6784);  
                    stream_KW_SHOW.add(KW_SHOW402);


                    KW_TBLPROPERTIES403=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_showStatement6786);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES403);


                    pushFollow(FOLLOW_identifier_in_showStatement6790);
                    tblName=identifier();

                    state._fsp--;

                    stream_identifier.add(tblName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1319:51: ( LPAREN prptyName= StringLiteral RPAREN )?
                    int alt111=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt111=1;
                            }
                            break;
                    }

                    switch (alt111) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1319:52: LPAREN prptyName= StringLiteral RPAREN
                            {
                            LPAREN404=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_showStatement6793);  
                            stream_LPAREN.add(LPAREN404);


                            prptyName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_showStatement6797);  
                            stream_StringLiteral.add(prptyName);


                            RPAREN405=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_showStatement6799);  
                            stream_RPAREN.add(RPAREN405);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: prptyName, tblName
                    // token labels: prptyName
                    // rule labels: retval, tblName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_prptyName=new RewriteRuleTokenStream(adaptor,"token prptyName",prptyName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tblName=new RewriteRuleSubtreeStream(adaptor,"rule tblName",tblName!=null?tblName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1319:92: -> ^( TOK_SHOW_TBLPROPERTIES $tblName ( $prptyName)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1319:95: ^( TOK_SHOW_TBLPROPERTIES $tblName ( $prptyName)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TBLPROPERTIES, "TOK_SHOW_TBLPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tblName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1319:130: ( $prptyName)?
                        if ( stream_prptyName.hasNext() ) {
                            adaptor.addChild(root_1, stream_prptyName.nextNode());

                        }
                        stream_prptyName.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:7: KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )?
                    {
                    KW_SHOW406=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6822);  
                    stream_KW_SHOW.add(KW_SHOW406);


                    KW_LOCKS407=(Token)match(input,KW_LOCKS,FOLLOW_KW_LOCKS_in_showStatement6824);  
                    stream_KW_LOCKS.add(KW_LOCKS407);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:24: (parttype= partTypeExpr )?
                    int alt112=2;
                    switch ( input.LA(1) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORCFILE:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARQUETFILE:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_RCFILE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SEQUENCEFILE:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TEXTFILE:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                            {
                            alt112=1;
                            }
                            break;
                    }

                    switch (alt112) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:25: parttype= partTypeExpr
                            {
                            pushFollow(FOLLOW_partTypeExpr_in_showStatement6829);
                            parttype=partTypeExpr();

                            state._fsp--;

                            stream_partTypeExpr.add(parttype.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:49: (isExtended= KW_EXTENDED )?
                    int alt113=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt113=1;
                            }
                            break;
                    }

                    switch (alt113) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:50: isExtended= KW_EXTENDED
                            {
                            isExtended=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement6836);  
                            stream_KW_EXTENDED.add(isExtended);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: isExtended, parttype
                    // token labels: isExtended
                    // rule labels: retval, parttype
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_isExtended=new RewriteRuleTokenStream(adaptor,"token isExtended",isExtended);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1320:75: -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:78: ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWLOCKS, "TOK_SHOWLOCKS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:95: ( $parttype)?
                        if ( stream_parttype.hasNext() ) {
                            adaptor.addChild(root_1, stream_parttype.nextTree());

                        }
                        stream_parttype.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:106: ( $isExtended)?
                        if ( stream_isExtended.hasNext() ) {
                            adaptor.addChild(root_1, stream_isExtended.nextNode());

                        }
                        stream_isExtended.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:7: KW_SHOW KW_LOCKS KW_DATABASE (dbName= Identifier ) (isExtended= KW_EXTENDED )?
                    {
                    KW_SHOW408=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6860);  
                    stream_KW_SHOW.add(KW_SHOW408);


                    KW_LOCKS409=(Token)match(input,KW_LOCKS,FOLLOW_KW_LOCKS_in_showStatement6862);  
                    stream_KW_LOCKS.add(KW_LOCKS409);


                    KW_DATABASE410=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_showStatement6864);  
                    stream_KW_DATABASE.add(KW_DATABASE410);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:36: (dbName= Identifier )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:37: dbName= Identifier
                    {
                    dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_showStatement6869);  
                    stream_Identifier.add(dbName);


                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:56: (isExtended= KW_EXTENDED )?
                    int alt114=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt114=1;
                            }
                            break;
                    }

                    switch (alt114) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:57: isExtended= KW_EXTENDED
                            {
                            isExtended=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement6875);  
                            stream_KW_EXTENDED.add(isExtended);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: isExtended, dbName
                    // token labels: isExtended, dbName
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_isExtended=new RewriteRuleTokenStream(adaptor,"token isExtended",isExtended);
                    RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1321:82: -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:85: ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWDBLOCKS, "TOK_SHOWDBLOCKS")
                        , root_1);

                        adaptor.addChild(root_1, stream_dbName.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:112: ( $isExtended)?
                        if ( stream_isExtended.hasNext() ) {
                            adaptor.addChild(root_1, stream_isExtended.nextNode());

                        }
                        stream_isExtended.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:7: KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    {
                    KW_SHOW411=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6898);  
                    stream_KW_SHOW.add(KW_SHOW411);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:15: (showOptions= KW_FORMATTED )?
                    int alt115=2;
                    switch ( input.LA(1) ) {
                        case KW_FORMATTED:
                            {
                            alt115=1;
                            }
                            break;
                    }

                    switch (alt115) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:16: showOptions= KW_FORMATTED
                            {
                            showOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_showStatement6903);  
                            stream_KW_FORMATTED.add(showOptions);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:43: ( KW_INDEX | KW_INDEXES )
                    int alt116=2;
                    switch ( input.LA(1) ) {
                    case KW_INDEX:
                        {
                        alt116=1;
                        }
                        break;
                    case KW_INDEXES:
                        {
                        alt116=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 116, 0, input);

                        throw nvae;

                    }

                    switch (alt116) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:44: KW_INDEX
                            {
                            KW_INDEX412=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_showStatement6908);  
                            stream_KW_INDEX.add(KW_INDEX412);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:53: KW_INDEXES
                            {
                            KW_INDEXES413=(Token)match(input,KW_INDEXES,FOLLOW_KW_INDEXES_in_showStatement6910);  
                            stream_KW_INDEXES.add(KW_INDEXES413);


                            }
                            break;

                    }


                    KW_ON414=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_showStatement6913);  
                    stream_KW_ON.add(KW_ON414);


                    pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6915);
                    showStmtIdentifier415=showStmtIdentifier();

                    state._fsp--;

                    stream_showStmtIdentifier.add(showStmtIdentifier415.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:90: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt118=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt118=1;
                            }
                            break;
                    }

                    switch (alt118) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:91: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:91: ( KW_FROM | KW_IN )
                            int alt117=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt117=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt117=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 117, 0, input);

                                throw nvae;

                            }

                            switch (alt117) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:92: KW_FROM
                                    {
                                    KW_FROM416=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6919);  
                                    stream_KW_FROM.add(KW_FROM416);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:100: KW_IN
                                    {
                                    KW_IN417=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6921);  
                                    stream_KW_IN.add(KW_IN417);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6926);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: db_name, showOptions, showStmtIdentifier
                    // token labels: showOptions
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_showOptions=new RewriteRuleTokenStream(adaptor,"token showOptions",showOptions);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1323:5: -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:8: ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWINDEXES, "TOK_SHOWINDEXES")
                        , root_1);

                        adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:46: ( $showOptions)?
                        if ( stream_showOptions.hasNext() ) {
                            adaptor.addChild(root_1, stream_showOptions.nextNode());

                        }
                        stream_showOptions.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1323:60: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1324:7: KW_SHOW KW_COMPACTIONS
                    {
                    KW_SHOW418=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6956);  
                    stream_KW_SHOW.add(KW_SHOW418);


                    KW_COMPACTIONS419=(Token)match(input,KW_COMPACTIONS,FOLLOW_KW_COMPACTIONS_in_showStatement6958);  
                    stream_KW_COMPACTIONS.add(KW_COMPACTIONS419);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1324:30: -> ^( TOK_SHOW_COMPACTIONS )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1324:33: ^( TOK_SHOW_COMPACTIONS )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_COMPACTIONS, "TOK_SHOW_COMPACTIONS")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1325:7: KW_SHOW KW_TRANSACTIONS
                    {
                    KW_SHOW420=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6972);  
                    stream_KW_SHOW.add(KW_SHOW420);


                    KW_TRANSACTIONS421=(Token)match(input,KW_TRANSACTIONS,FOLLOW_KW_TRANSACTIONS_in_showStatement6974);  
                    stream_KW_TRANSACTIONS.add(KW_TRANSACTIONS421);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1325:31: -> ^( TOK_SHOW_TRANSACTIONS )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1325:34: ^( TOK_SHOW_TRANSACTIONS )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TRANSACTIONS, "TOK_SHOW_TRANSACTIONS")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showStatement"


    public static class lockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1328:1: lockStatement : KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? ) ;
    public final HiveParser.lockStatement_return lockStatement() throws RecognitionException {
        HiveParser.lockStatement_return retval = new HiveParser.lockStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_LOCK422=null;
        Token KW_TABLE423=null;
        HiveParser_FromClauseParser.tableName_return tableName424 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec425 =null;

        HiveParser.lockMode_return lockMode426 =null;


        CommonTree KW_LOCK422_tree=null;
        CommonTree KW_TABLE423_tree=null;
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_lockMode=new RewriteRuleSubtreeStream(adaptor,"rule lockMode");
         pushMsg("lock statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:5: ( KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:7: KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode
            {
            KW_LOCK422=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_lockStatement7007);  
            stream_KW_LOCK.add(KW_LOCK422);


            KW_TABLE423=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_lockStatement7009);  
            stream_KW_TABLE.add(KW_TABLE423);


            pushFollow(FOLLOW_tableName_in_lockStatement7011);
            tableName424=tableName();

            state._fsp--;

            stream_tableName.add(tableName424.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:34: ( partitionSpec )?
            int alt120=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt120=1;
                    }
                    break;
            }

            switch (alt120) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:34: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_lockStatement7013);
                    partitionSpec425=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec425.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_lockMode_in_lockStatement7016);
            lockMode426=lockMode();

            state._fsp--;

            stream_lockMode.add(lockMode426.getTree());

            // AST REWRITE
            // elements: partitionSpec, tableName, lockMode
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1331:58: -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:61: ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOCKTABLE, "TOK_LOCKTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                adaptor.addChild(root_1, stream_lockMode.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:96: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockStatement"


    public static class lockDatabase_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockDatabase"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1334:1: lockDatabase : KW_LOCK KW_DATABASE (dbName= Identifier ) lockMode -> ^( TOK_LOCKDB $dbName lockMode ) ;
    public final HiveParser.lockDatabase_return lockDatabase() throws RecognitionException {
        HiveParser.lockDatabase_return retval = new HiveParser.lockDatabase_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token dbName=null;
        Token KW_LOCK427=null;
        Token KW_DATABASE428=null;
        HiveParser.lockMode_return lockMode429 =null;


        CommonTree dbName_tree=null;
        CommonTree KW_LOCK427_tree=null;
        CommonTree KW_DATABASE428_tree=null;
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleSubtreeStream stream_lockMode=new RewriteRuleSubtreeStream(adaptor,"rule lockMode");
         pushMsg("lock database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1337:5: ( KW_LOCK KW_DATABASE (dbName= Identifier ) lockMode -> ^( TOK_LOCKDB $dbName lockMode ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1337:7: KW_LOCK KW_DATABASE (dbName= Identifier ) lockMode
            {
            KW_LOCK427=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_lockDatabase7056);  
            stream_KW_LOCK.add(KW_LOCK427);


            KW_DATABASE428=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_lockDatabase7058);  
            stream_KW_DATABASE.add(KW_DATABASE428);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1337:27: (dbName= Identifier )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1337:28: dbName= Identifier
            {
            dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_lockDatabase7063);  
            stream_Identifier.add(dbName);


            }


            pushFollow(FOLLOW_lockMode_in_lockDatabase7066);
            lockMode429=lockMode();

            state._fsp--;

            stream_lockMode.add(lockMode429.getTree());

            // AST REWRITE
            // elements: lockMode, dbName
            // token labels: dbName
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1337:56: -> ^( TOK_LOCKDB $dbName lockMode )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1337:59: ^( TOK_LOCKDB $dbName lockMode )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOCKDB, "TOK_LOCKDB")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextNode());

                adaptor.addChild(root_1, stream_lockMode.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockDatabase"


    public static class lockMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:1: lockMode : ( KW_SHARED | KW_EXCLUSIVE );
    public final HiveParser.lockMode_return lockMode() throws RecognitionException {
        HiveParser.lockMode_return retval = new HiveParser.lockMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token set430=null;

        CommonTree set430_tree=null;

         pushMsg("lock mode", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1343:5: ( KW_SHARED | KW_EXCLUSIVE )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:
            {
            root_0 = (CommonTree)adaptor.nil();


            set430=(Token)input.LT(1);

            if ( input.LA(1)==KW_EXCLUSIVE||input.LA(1)==KW_SHARED ) {
                input.consume();
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(set430)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockMode"


    public static class unlockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unlockStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1346:1: unlockStatement : KW_UNLOCK KW_TABLE tableName ( partitionSpec )? -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? ) ;
    public final HiveParser.unlockStatement_return unlockStatement() throws RecognitionException {
        HiveParser.unlockStatement_return retval = new HiveParser.unlockStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_UNLOCK431=null;
        Token KW_TABLE432=null;
        HiveParser_FromClauseParser.tableName_return tableName433 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec434 =null;


        CommonTree KW_UNLOCK431_tree=null;
        CommonTree KW_TABLE432_tree=null;
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_UNLOCK=new RewriteRuleTokenStream(adaptor,"token KW_UNLOCK");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("unlock statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:5: ( KW_UNLOCK KW_TABLE tableName ( partitionSpec )? -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:7: KW_UNLOCK KW_TABLE tableName ( partitionSpec )?
            {
            KW_UNLOCK431=(Token)match(input,KW_UNLOCK,FOLLOW_KW_UNLOCK_in_unlockStatement7135);  
            stream_KW_UNLOCK.add(KW_UNLOCK431);


            KW_TABLE432=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_unlockStatement7137);  
            stream_KW_TABLE.add(KW_TABLE432);


            pushFollow(FOLLOW_tableName_in_unlockStatement7139);
            tableName433=tableName();

            state._fsp--;

            stream_tableName.add(tableName433.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:36: ( partitionSpec )?
            int alt121=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt121=1;
                    }
                    break;
            }

            switch (alt121) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:36: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_unlockStatement7141);
                    partitionSpec434=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec434.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1349:52: -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:55: ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_UNLOCKTABLE, "TOK_UNLOCKTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:83: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unlockStatement"


    public static class unlockDatabase_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unlockDatabase"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1352:1: unlockDatabase : KW_UNLOCK KW_DATABASE (dbName= Identifier ) -> ^( TOK_UNLOCKDB $dbName) ;
    public final HiveParser.unlockDatabase_return unlockDatabase() throws RecognitionException {
        HiveParser.unlockDatabase_return retval = new HiveParser.unlockDatabase_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token dbName=null;
        Token KW_UNLOCK435=null;
        Token KW_DATABASE436=null;

        CommonTree dbName_tree=null;
        CommonTree KW_UNLOCK435_tree=null;
        CommonTree KW_DATABASE436_tree=null;
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_UNLOCK=new RewriteRuleTokenStream(adaptor,"token KW_UNLOCK");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");

         pushMsg("unlock database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:5: ( KW_UNLOCK KW_DATABASE (dbName= Identifier ) -> ^( TOK_UNLOCKDB $dbName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:7: KW_UNLOCK KW_DATABASE (dbName= Identifier )
            {
            KW_UNLOCK435=(Token)match(input,KW_UNLOCK,FOLLOW_KW_UNLOCK_in_unlockDatabase7181);  
            stream_KW_UNLOCK.add(KW_UNLOCK435);


            KW_DATABASE436=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_unlockDatabase7183);  
            stream_KW_DATABASE.add(KW_DATABASE436);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:29: (dbName= Identifier )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:30: dbName= Identifier
            {
            dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_unlockDatabase7188);  
            stream_Identifier.add(dbName);


            }


            // AST REWRITE
            // elements: dbName
            // token labels: dbName
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1355:49: -> ^( TOK_UNLOCKDB $dbName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:52: ^( TOK_UNLOCKDB $dbName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_UNLOCKDB, "TOK_UNLOCKDB")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unlockDatabase"


    public static class createRoleStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createRoleStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1358:1: createRoleStatement : KW_CREATE KW_ROLE roleName= identifier -> ^( TOK_CREATEROLE $roleName) ;
    public final HiveParser.createRoleStatement_return createRoleStatement() throws RecognitionException {
        HiveParser.createRoleStatement_return retval = new HiveParser.createRoleStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE437=null;
        Token KW_ROLE438=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_CREATE437_tree=null;
        CommonTree KW_ROLE438_tree=null;
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("create role", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1361:5: ( KW_CREATE KW_ROLE roleName= identifier -> ^( TOK_CREATEROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1361:7: KW_CREATE KW_ROLE roleName= identifier
            {
            KW_CREATE437=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createRoleStatement7225);  
            stream_KW_CREATE.add(KW_CREATE437);


            KW_ROLE438=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_createRoleStatement7227);  
            stream_KW_ROLE.add(KW_ROLE438);


            pushFollow(FOLLOW_identifier_in_createRoleStatement7231);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1362:5: -> ^( TOK_CREATEROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:8: ^( TOK_CREATEROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEROLE, "TOK_CREATEROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createRoleStatement"


    public static class dropRoleStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropRoleStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1365:1: dropRoleStatement : KW_DROP KW_ROLE roleName= identifier -> ^( TOK_DROPROLE $roleName) ;
    public final HiveParser.dropRoleStatement_return dropRoleStatement() throws RecognitionException {
        HiveParser.dropRoleStatement_return retval = new HiveParser.dropRoleStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP439=null;
        Token KW_ROLE440=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_DROP439_tree=null;
        CommonTree KW_ROLE440_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("drop role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1368:5: ( KW_DROP KW_ROLE roleName= identifier -> ^( TOK_DROPROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1368:7: KW_DROP KW_ROLE roleName= identifier
            {
            KW_DROP439=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropRoleStatement7271);  
            stream_KW_DROP.add(KW_DROP439);


            KW_ROLE440=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_dropRoleStatement7273);  
            stream_KW_ROLE.add(KW_ROLE440);


            pushFollow(FOLLOW_identifier_in_dropRoleStatement7277);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1369:5: -> ^( TOK_DROPROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1369:8: ^( TOK_DROPROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPROLE, "TOK_DROPROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropRoleStatement"


    public static class grantPrivileges_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantPrivileges"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1372:1: grantPrivileges : KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )? -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? ) ;
    public final HiveParser.grantPrivileges_return grantPrivileges() throws RecognitionException {
        HiveParser.grantPrivileges_return retval = new HiveParser.grantPrivileges_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT441=null;
        Token KW_TO443=null;
        HiveParser.privilegeList_return privList =null;

        HiveParser.privilegeObject_return privilegeObject442 =null;

        HiveParser.principalSpecification_return principalSpecification444 =null;

        HiveParser.withGrantOption_return withGrantOption445 =null;


        CommonTree KW_GRANT441_tree=null;
        CommonTree KW_TO443_tree=null;
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_withGrantOption=new RewriteRuleSubtreeStream(adaptor,"rule withGrantOption");
        RewriteRuleSubtreeStream stream_privilegeList=new RewriteRuleSubtreeStream(adaptor,"rule privilegeList");
        RewriteRuleSubtreeStream stream_privilegeObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeObject");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        pushMsg("grant privileges", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:5: ( KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )? -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:7: KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )?
            {
            KW_GRANT441=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_grantPrivileges7317);  
            stream_KW_GRANT.add(KW_GRANT441);


            pushFollow(FOLLOW_privilegeList_in_grantPrivileges7321);
            privList=privilegeList();

            state._fsp--;

            stream_privilegeList.add(privList.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1376:7: ( privilegeObject )?
            int alt122=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt122=1;
                    }
                    break;
            }

            switch (alt122) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1376:7: privilegeObject
                    {
                    pushFollow(FOLLOW_privilegeObject_in_grantPrivileges7329);
                    privilegeObject442=privilegeObject();

                    state._fsp--;

                    stream_privilegeObject.add(privilegeObject442.getTree());

                    }
                    break;

            }


            KW_TO443=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_grantPrivileges7338);  
            stream_KW_TO.add(KW_TO443);


            pushFollow(FOLLOW_principalSpecification_in_grantPrivileges7340);
            principalSpecification444=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification444.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:7: ( withGrantOption )?
            int alt123=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt123=1;
                    }
                    break;
            }

            switch (alt123) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:7: withGrantOption
                    {
                    pushFollow(FOLLOW_withGrantOption_in_grantPrivileges7348);
                    withGrantOption445=withGrantOption();

                    state._fsp--;

                    stream_withGrantOption.add(withGrantOption445.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: withGrantOption, privList, principalSpecification, privilegeObject
            // token labels: 
            // rule labels: retval, privList
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_privList=new RewriteRuleSubtreeStream(adaptor,"rule privList",privList!=null?privList.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1379:5: -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1379:8: ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT, "TOK_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_privList.nextTree());

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1379:53: ( privilegeObject )?
                if ( stream_privilegeObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeObject.nextTree());

                }
                stream_privilegeObject.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1379:70: ( withGrantOption )?
                if ( stream_withGrantOption.hasNext() ) {
                    adaptor.addChild(root_1, stream_withGrantOption.nextTree());

                }
                stream_withGrantOption.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantPrivileges"


    public static class revokePrivileges_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "revokePrivileges"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1382:1: revokePrivileges : KW_REVOKE privilegeList ( privilegeObject )? KW_FROM principalSpecification -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ) ;
    public final HiveParser.revokePrivileges_return revokePrivileges() throws RecognitionException {
        HiveParser.revokePrivileges_return retval = new HiveParser.revokePrivileges_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_REVOKE446=null;
        Token KW_FROM449=null;
        HiveParser.privilegeList_return privilegeList447 =null;

        HiveParser.privilegeObject_return privilegeObject448 =null;

        HiveParser.principalSpecification_return principalSpecification450 =null;


        CommonTree KW_REVOKE446_tree=null;
        CommonTree KW_FROM449_tree=null;
        RewriteRuleTokenStream stream_KW_REVOKE=new RewriteRuleTokenStream(adaptor,"token KW_REVOKE");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_privilegeList=new RewriteRuleSubtreeStream(adaptor,"rule privilegeList");
        RewriteRuleSubtreeStream stream_privilegeObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeObject");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        pushMsg("revoke privileges", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:5: ( KW_REVOKE privilegeList ( privilegeObject )? KW_FROM principalSpecification -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:7: KW_REVOKE privilegeList ( privilegeObject )? KW_FROM principalSpecification
            {
            KW_REVOKE446=(Token)match(input,KW_REVOKE,FOLLOW_KW_REVOKE_in_revokePrivileges7397);  
            stream_KW_REVOKE.add(KW_REVOKE446);


            pushFollow(FOLLOW_privilegeList_in_revokePrivileges7399);
            privilegeList447=privilegeList();

            state._fsp--;

            stream_privilegeList.add(privilegeList447.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:31: ( privilegeObject )?
            int alt124=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt124=1;
                    }
                    break;
            }

            switch (alt124) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:31: privilegeObject
                    {
                    pushFollow(FOLLOW_privilegeObject_in_revokePrivileges7401);
                    privilegeObject448=privilegeObject();

                    state._fsp--;

                    stream_privilegeObject.add(privilegeObject448.getTree());

                    }
                    break;

            }


            KW_FROM449=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_revokePrivileges7404);  
            stream_KW_FROM.add(KW_FROM449);


            pushFollow(FOLLOW_principalSpecification_in_revokePrivileges7406);
            principalSpecification450=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification450.getTree());

            // AST REWRITE
            // elements: privilegeList, privilegeObject, principalSpecification
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1386:5: -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:8: ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REVOKE, "TOK_REVOKE")
                , root_1);

                adaptor.addChild(root_1, stream_privilegeList.nextTree());

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:58: ( privilegeObject )?
                if ( stream_privilegeObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeObject.nextTree());

                }
                stream_privilegeObject.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "revokePrivileges"


    public static class grantRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1389:1: grantRole : KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )? -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ ) ;
    public final HiveParser.grantRole_return grantRole() throws RecognitionException {
        HiveParser.grantRole_return retval = new HiveParser.grantRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT451=null;
        Token KW_ROLE452=null;
        Token COMMA454=null;
        Token KW_TO456=null;
        HiveParser_IdentifiersParser.identifier_return identifier453 =null;

        HiveParser_IdentifiersParser.identifier_return identifier455 =null;

        HiveParser.principalSpecification_return principalSpecification457 =null;

        HiveParser.withAdminOption_return withAdminOption458 =null;


        CommonTree KW_GRANT451_tree=null;
        CommonTree KW_ROLE452_tree=null;
        CommonTree COMMA454_tree=null;
        CommonTree KW_TO456_tree=null;
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_withAdminOption=new RewriteRuleSubtreeStream(adaptor,"rule withAdminOption");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("grant role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:5: ( KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )? -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:7: KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )?
            {
            KW_GRANT451=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_grantRole7450);  
            stream_KW_GRANT.add(KW_GRANT451);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:16: ( KW_ROLE )?
            int alt125=2;
            switch ( input.LA(1) ) {
                case KW_ROLE:
                    {
                    switch ( input.LA(2) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORCFILE:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARQUETFILE:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_RCFILE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SEQUENCEFILE:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TEXTFILE:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                            {
                            alt125=1;
                            }
                            break;
                        case KW_TO:
                            {
                            switch ( input.LA(3) ) {
                                case COMMA:
                                case KW_TO:
                                    {
                                    alt125=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt125) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:16: KW_ROLE
                    {
                    KW_ROLE452=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_grantRole7452);  
                    stream_KW_ROLE.add(KW_ROLE452);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_grantRole7455);
            identifier453=identifier();

            state._fsp--;

            stream_identifier.add(identifier453.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:36: ( COMMA identifier )*
            loop126:
            do {
                int alt126=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt126=1;
                    }
                    break;

                }

                switch (alt126) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:37: COMMA identifier
            	    {
            	    COMMA454=(Token)match(input,COMMA,FOLLOW_COMMA_in_grantRole7458);  
            	    stream_COMMA.add(COMMA454);


            	    pushFollow(FOLLOW_identifier_in_grantRole7460);
            	    identifier455=identifier();

            	    state._fsp--;

            	    stream_identifier.add(identifier455.getTree());

            	    }
            	    break;

            	default :
            	    break loop126;
                }
            } while (true);


            KW_TO456=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_grantRole7464);  
            stream_KW_TO.add(KW_TO456);


            pushFollow(FOLLOW_principalSpecification_in_grantRole7466);
            principalSpecification457=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification457.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:85: ( withAdminOption )?
            int alt127=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt127=1;
                    }
                    break;
            }

            switch (alt127) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:85: withAdminOption
                    {
                    pushFollow(FOLLOW_withAdminOption_in_grantRole7468);
                    withAdminOption458=withAdminOption();

                    state._fsp--;

                    stream_withAdminOption.add(withAdminOption458.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: withAdminOption, principalSpecification, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1393:5: -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:8: ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT_ROLE, "TOK_GRANT_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:48: ( withAdminOption )?
                if ( stream_withAdminOption.hasNext() ) {
                    adaptor.addChild(root_1, stream_withAdminOption.nextTree());

                }
                stream_withAdminOption.reset();

                if ( !(stream_identifier.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_identifier.hasNext() ) {
                    adaptor.addChild(root_1, stream_identifier.nextTree());

                }
                stream_identifier.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantRole"


    public static class revokeRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "revokeRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1396:1: revokeRole : KW_REVOKE ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification ( withAdminOption )? -> ^( TOK_REVOKE_ROLE principalSpecification ( withAdminOption )? ( identifier )+ ) ;
    public final HiveParser.revokeRole_return revokeRole() throws RecognitionException {
        HiveParser.revokeRole_return retval = new HiveParser.revokeRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_REVOKE459=null;
        Token KW_ROLE460=null;
        Token COMMA462=null;
        Token KW_FROM464=null;
        HiveParser_IdentifiersParser.identifier_return identifier461 =null;

        HiveParser_IdentifiersParser.identifier_return identifier463 =null;

        HiveParser.principalSpecification_return principalSpecification465 =null;

        HiveParser.withAdminOption_return withAdminOption466 =null;


        CommonTree KW_REVOKE459_tree=null;
        CommonTree KW_ROLE460_tree=null;
        CommonTree COMMA462_tree=null;
        CommonTree KW_FROM464_tree=null;
        RewriteRuleTokenStream stream_KW_REVOKE=new RewriteRuleTokenStream(adaptor,"token KW_REVOKE");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_withAdminOption=new RewriteRuleSubtreeStream(adaptor,"rule withAdminOption");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("revoke role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:5: ( KW_REVOKE ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification ( withAdminOption )? -> ^( TOK_REVOKE_ROLE principalSpecification ( withAdminOption )? ( identifier )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:7: KW_REVOKE ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification ( withAdminOption )?
            {
            KW_REVOKE459=(Token)match(input,KW_REVOKE,FOLLOW_KW_REVOKE_in_revokeRole7514);  
            stream_KW_REVOKE.add(KW_REVOKE459);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:17: ( KW_ROLE )?
            int alt128=2;
            switch ( input.LA(1) ) {
                case KW_ROLE:
                    {
                    switch ( input.LA(2) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORCFILE:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARQUETFILE:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_RCFILE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SEQUENCEFILE:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TEXTFILE:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                            {
                            alt128=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt128) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:17: KW_ROLE
                    {
                    KW_ROLE460=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_revokeRole7516);  
                    stream_KW_ROLE.add(KW_ROLE460);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_revokeRole7519);
            identifier461=identifier();

            state._fsp--;

            stream_identifier.add(identifier461.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:37: ( COMMA identifier )*
            loop129:
            do {
                int alt129=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt129=1;
                    }
                    break;

                }

                switch (alt129) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:38: COMMA identifier
            	    {
            	    COMMA462=(Token)match(input,COMMA,FOLLOW_COMMA_in_revokeRole7522);  
            	    stream_COMMA.add(COMMA462);


            	    pushFollow(FOLLOW_identifier_in_revokeRole7524);
            	    identifier463=identifier();

            	    state._fsp--;

            	    stream_identifier.add(identifier463.getTree());

            	    }
            	    break;

            	default :
            	    break loop129;
                }
            } while (true);


            KW_FROM464=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_revokeRole7528);  
            stream_KW_FROM.add(KW_FROM464);


            pushFollow(FOLLOW_principalSpecification_in_revokeRole7530);
            principalSpecification465=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification465.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:88: ( withAdminOption )?
            int alt130=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt130=1;
                    }
                    break;
            }

            switch (alt130) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:88: withAdminOption
                    {
                    pushFollow(FOLLOW_withAdminOption_in_revokeRole7532);
                    withAdminOption466=withAdminOption();

                    state._fsp--;

                    stream_withAdminOption.add(withAdminOption466.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: identifier, principalSpecification, withAdminOption
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1400:5: -> ^( TOK_REVOKE_ROLE principalSpecification ( withAdminOption )? ( identifier )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:8: ^( TOK_REVOKE_ROLE principalSpecification ( withAdminOption )? ( identifier )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REVOKE_ROLE, "TOK_REVOKE_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:49: ( withAdminOption )?
                if ( stream_withAdminOption.hasNext() ) {
                    adaptor.addChild(root_1, stream_withAdminOption.nextTree());

                }
                stream_withAdminOption.reset();

                if ( !(stream_identifier.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_identifier.hasNext() ) {
                    adaptor.addChild(root_1, stream_identifier.nextTree());

                }
                stream_identifier.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "revokeRole"


    public static class showRoleGrants_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRoleGrants"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1403:1: showRoleGrants : KW_SHOW KW_ROLE KW_GRANT principalName -> ^( TOK_SHOW_ROLE_GRANT principalName ) ;
    public final HiveParser.showRoleGrants_return showRoleGrants() throws RecognitionException {
        HiveParser.showRoleGrants_return retval = new HiveParser.showRoleGrants_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW467=null;
        Token KW_ROLE468=null;
        Token KW_GRANT469=null;
        HiveParser.principalName_return principalName470 =null;


        CommonTree KW_SHOW467_tree=null;
        CommonTree KW_ROLE468_tree=null;
        CommonTree KW_GRANT469_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        pushMsg("show role grants", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:5: ( KW_SHOW KW_ROLE KW_GRANT principalName -> ^( TOK_SHOW_ROLE_GRANT principalName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:7: KW_SHOW KW_ROLE KW_GRANT principalName
            {
            KW_SHOW467=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRoleGrants7578);  
            stream_KW_SHOW.add(KW_SHOW467);


            KW_ROLE468=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_showRoleGrants7580);  
            stream_KW_ROLE.add(KW_ROLE468);


            KW_GRANT469=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_showRoleGrants7582);  
            stream_KW_GRANT.add(KW_GRANT469);


            pushFollow(FOLLOW_principalName_in_showRoleGrants7584);
            principalName470=principalName();

            state._fsp--;

            stream_principalName.add(principalName470.getTree());

            // AST REWRITE
            // elements: principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1407:5: -> ^( TOK_SHOW_ROLE_GRANT principalName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1407:8: ^( TOK_SHOW_ROLE_GRANT principalName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLE_GRANT, "TOK_SHOW_ROLE_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_principalName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRoleGrants"


    public static class showRoles_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRoles"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1411:1: showRoles : KW_SHOW KW_ROLES -> ^( TOK_SHOW_ROLES ) ;
    public final HiveParser.showRoles_return showRoles() throws RecognitionException {
        HiveParser.showRoles_return retval = new HiveParser.showRoles_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW471=null;
        Token KW_ROLES472=null;

        CommonTree KW_SHOW471_tree=null;
        CommonTree KW_ROLES472_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_ROLES=new RewriteRuleTokenStream(adaptor,"token KW_ROLES");

        pushMsg("show roles", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:5: ( KW_SHOW KW_ROLES -> ^( TOK_SHOW_ROLES ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:7: KW_SHOW KW_ROLES
            {
            KW_SHOW471=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRoles7624);  
            stream_KW_SHOW.add(KW_SHOW471);


            KW_ROLES472=(Token)match(input,KW_ROLES,FOLLOW_KW_ROLES_in_showRoles7626);  
            stream_KW_ROLES.add(KW_ROLES472);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1415:5: -> ^( TOK_SHOW_ROLES )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1415:8: ^( TOK_SHOW_ROLES )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLES, "TOK_SHOW_ROLES")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRoles"


    public static class showCurrentRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showCurrentRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:1: showCurrentRole : KW_SHOW KW_CURRENT KW_ROLES -> ^( TOK_SHOW_SET_ROLE ) ;
    public final HiveParser.showCurrentRole_return showCurrentRole() throws RecognitionException {
        HiveParser.showCurrentRole_return retval = new HiveParser.showCurrentRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW473=null;
        Token KW_CURRENT474=null;
        Token KW_ROLES475=null;

        CommonTree KW_SHOW473_tree=null;
        CommonTree KW_CURRENT474_tree=null;
        CommonTree KW_ROLES475_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_CURRENT=new RewriteRuleTokenStream(adaptor,"token KW_CURRENT");
        RewriteRuleTokenStream stream_KW_ROLES=new RewriteRuleTokenStream(adaptor,"token KW_ROLES");

        pushMsg("show current role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:5: ( KW_SHOW KW_CURRENT KW_ROLES -> ^( TOK_SHOW_SET_ROLE ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:7: KW_SHOW KW_CURRENT KW_ROLES
            {
            KW_SHOW473=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showCurrentRole7663);  
            stream_KW_SHOW.add(KW_SHOW473);


            KW_CURRENT474=(Token)match(input,KW_CURRENT,FOLLOW_KW_CURRENT_in_showCurrentRole7665);  
            stream_KW_CURRENT.add(KW_CURRENT474);


            KW_ROLES475=(Token)match(input,KW_ROLES,FOLLOW_KW_ROLES_in_showCurrentRole7667);  
            stream_KW_ROLES.add(KW_ROLES475);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1422:5: -> ^( TOK_SHOW_SET_ROLE )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1422:8: ^( TOK_SHOW_SET_ROLE )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showCurrentRole"


    public static class setRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1425:1: setRole : KW_SET KW_ROLE roleName= identifier -> ^( TOK_SHOW_SET_ROLE $roleName) ;
    public final HiveParser.setRole_return setRole() throws RecognitionException {
        HiveParser.setRole_return retval = new HiveParser.setRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET476=null;
        Token KW_ROLE477=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_SET476_tree=null;
        CommonTree KW_ROLE477_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("set role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:5: ( KW_SET KW_ROLE roleName= identifier -> ^( TOK_SHOW_SET_ROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:7: KW_SET KW_ROLE roleName= identifier
            {
            KW_SET476=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_setRole7704);  
            stream_KW_SET.add(KW_SET476);


            KW_ROLE477=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_setRole7706);  
            stream_KW_ROLE.add(KW_ROLE477);


            pushFollow(FOLLOW_identifier_in_setRole7710);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1429:5: -> ^( TOK_SHOW_SET_ROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1429:8: ^( TOK_SHOW_SET_ROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setRole"


    public static class showGrants_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showGrants"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1432:1: showGrants : KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )? -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? ) ;
    public final HiveParser.showGrants_return showGrants() throws RecognitionException {
        HiveParser.showGrants_return retval = new HiveParser.showGrants_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW478=null;
        Token KW_GRANT479=null;
        Token KW_ON481=null;
        HiveParser.principalName_return principalName480 =null;

        HiveParser.privilegeIncludeColObject_return privilegeIncludeColObject482 =null;


        CommonTree KW_SHOW478_tree=null;
        CommonTree KW_GRANT479_tree=null;
        CommonTree KW_ON481_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        RewriteRuleSubtreeStream stream_privilegeIncludeColObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeIncludeColObject");
        pushMsg("show grants", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:5: ( KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )? -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:7: KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )?
            {
            KW_SHOW478=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showGrants7750);  
            stream_KW_SHOW.add(KW_SHOW478);


            KW_GRANT479=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_showGrants7752);  
            stream_KW_GRANT.add(KW_GRANT479);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:24: ( principalName )?
            int alt131=2;
            switch ( input.LA(1) ) {
                case KW_GROUP:
                case KW_ROLE:
                case KW_USER:
                    {
                    alt131=1;
                    }
                    break;
            }

            switch (alt131) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:24: principalName
                    {
                    pushFollow(FOLLOW_principalName_in_showGrants7754);
                    principalName480=principalName();

                    state._fsp--;

                    stream_principalName.add(principalName480.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:39: ( KW_ON privilegeIncludeColObject )?
            int alt132=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt132=1;
                    }
                    break;
            }

            switch (alt132) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:40: KW_ON privilegeIncludeColObject
                    {
                    KW_ON481=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_showGrants7758);  
                    stream_KW_ON.add(KW_ON481);


                    pushFollow(FOLLOW_privilegeIncludeColObject_in_showGrants7760);
                    privilegeIncludeColObject482=privilegeIncludeColObject();

                    state._fsp--;

                    stream_privilegeIncludeColObject.add(privilegeIncludeColObject482.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: privilegeIncludeColObject, principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1436:5: -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:8: ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_GRANT, "TOK_SHOW_GRANT")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:25: ( principalName )?
                if ( stream_principalName.hasNext() ) {
                    adaptor.addChild(root_1, stream_principalName.nextTree());

                }
                stream_principalName.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:40: ( privilegeIncludeColObject )?
                if ( stream_privilegeIncludeColObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeIncludeColObject.nextTree());

                }
                stream_privilegeIncludeColObject.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showGrants"


    public static class showRolePrincipals_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRolePrincipals"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1439:1: showRolePrincipals : KW_SHOW KW_PRINCIPALS roleName= identifier -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName) ;
    public final HiveParser.showRolePrincipals_return showRolePrincipals() throws RecognitionException {
        HiveParser.showRolePrincipals_return retval = new HiveParser.showRolePrincipals_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW483=null;
        Token KW_PRINCIPALS484=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_SHOW483_tree=null;
        CommonTree KW_PRINCIPALS484_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_PRINCIPALS=new RewriteRuleTokenStream(adaptor,"token KW_PRINCIPALS");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("show role principals", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:5: ( KW_SHOW KW_PRINCIPALS roleName= identifier -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:7: KW_SHOW KW_PRINCIPALS roleName= identifier
            {
            KW_SHOW483=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRolePrincipals7805);  
            stream_KW_SHOW.add(KW_SHOW483);


            KW_PRINCIPALS484=(Token)match(input,KW_PRINCIPALS,FOLLOW_KW_PRINCIPALS_in_showRolePrincipals7807);  
            stream_KW_PRINCIPALS.add(KW_PRINCIPALS484);


            pushFollow(FOLLOW_identifier_in_showRolePrincipals7811);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1443:5: -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1443:8: ^( TOK_SHOW_ROLE_PRINCIPALS $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLE_PRINCIPALS, "TOK_SHOW_ROLE_PRINCIPALS")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRolePrincipals"


    public static class privilegeIncludeColObject_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeIncludeColObject"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1447:1: privilegeIncludeColObject : ( KW_ALL -> ^( TOK_RESOURCE_ALL ) | privObjectType identifier ( LPAREN cols= columnNameList RPAREN )? ( partitionSpec )? -> ^( TOK_PRIV_OBJECT_COL identifier privObjectType ( $cols)? ( partitionSpec )? ) );
    public final HiveParser.privilegeIncludeColObject_return privilegeIncludeColObject() throws RecognitionException {
        HiveParser.privilegeIncludeColObject_return retval = new HiveParser.privilegeIncludeColObject_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALL485=null;
        Token LPAREN488=null;
        Token RPAREN489=null;
        HiveParser.columnNameList_return cols =null;

        HiveParser.privObjectType_return privObjectType486 =null;

        HiveParser_IdentifiersParser.identifier_return identifier487 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec490 =null;


        CommonTree KW_ALL485_tree=null;
        CommonTree LPAREN488_tree=null;
        CommonTree RPAREN489_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_ALL=new RewriteRuleTokenStream(adaptor,"token KW_ALL");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_privObjectType=new RewriteRuleSubtreeStream(adaptor,"rule privObjectType");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("privilege object including columns", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:5: ( KW_ALL -> ^( TOK_RESOURCE_ALL ) | privObjectType identifier ( LPAREN cols= columnNameList RPAREN )? ( partitionSpec )? -> ^( TOK_PRIV_OBJECT_COL identifier privObjectType ( $cols)? ( partitionSpec )? ) )
            int alt135=2;
            switch ( input.LA(1) ) {
            case KW_ALL:
                {
                alt135=1;
                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASE:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARQUETFILE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt135=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 135, 0, input);

                throw nvae;

            }

            switch (alt135) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:7: KW_ALL
                    {
                    KW_ALL485=(Token)match(input,KW_ALL,FOLLOW_KW_ALL_in_privilegeIncludeColObject7852);  
                    stream_KW_ALL.add(KW_ALL485);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1450:14: -> ^( TOK_RESOURCE_ALL )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:17: ^( TOK_RESOURCE_ALL )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_RESOURCE_ALL, "TOK_RESOURCE_ALL")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1451:7: privObjectType identifier ( LPAREN cols= columnNameList RPAREN )? ( partitionSpec )?
                    {
                    pushFollow(FOLLOW_privObjectType_in_privilegeIncludeColObject7866);
                    privObjectType486=privObjectType();

                    state._fsp--;

                    stream_privObjectType.add(privObjectType486.getTree());

                    pushFollow(FOLLOW_identifier_in_privilegeIncludeColObject7868);
                    identifier487=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier487.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1451:33: ( LPAREN cols= columnNameList RPAREN )?
                    int alt133=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt133=1;
                            }
                            break;
                    }

                    switch (alt133) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1451:34: LPAREN cols= columnNameList RPAREN
                            {
                            LPAREN488=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_privilegeIncludeColObject7871);  
                            stream_LPAREN.add(LPAREN488);


                            pushFollow(FOLLOW_columnNameList_in_privilegeIncludeColObject7875);
                            cols=columnNameList();

                            state._fsp--;

                            stream_columnNameList.add(cols.getTree());

                            RPAREN489=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_privilegeIncludeColObject7877);  
                            stream_RPAREN.add(RPAREN489);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1451:70: ( partitionSpec )?
                    int alt134=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt134=1;
                            }
                            break;
                    }

                    switch (alt134) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1451:70: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_privilegeIncludeColObject7881);
                            partitionSpec490=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec490.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: privObjectType, cols, partitionSpec, identifier
                    // token labels: 
                    // rule labels: retval, cols
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_cols=new RewriteRuleSubtreeStream(adaptor,"rule cols",cols!=null?cols.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1452:5: -> ^( TOK_PRIV_OBJECT_COL identifier privObjectType ( $cols)? ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1452:8: ^( TOK_PRIV_OBJECT_COL identifier privObjectType ( $cols)? ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_OBJECT_COL, "TOK_PRIV_OBJECT_COL")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_1, stream_privObjectType.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1452:57: ( $cols)?
                        if ( stream_cols.hasNext() ) {
                            adaptor.addChild(root_1, stream_cols.nextTree());

                        }
                        stream_cols.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1452:63: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeIncludeColObject"


    public static class privilegeObject_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeObject"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1455:1: privilegeObject : KW_ON privObjectType identifier ( partitionSpec )? -> ^( TOK_PRIV_OBJECT identifier privObjectType ( partitionSpec )? ) ;
    public final HiveParser.privilegeObject_return privilegeObject() throws RecognitionException {
        HiveParser.privilegeObject_return retval = new HiveParser.privilegeObject_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ON491=null;
        HiveParser.privObjectType_return privObjectType492 =null;

        HiveParser_IdentifiersParser.identifier_return identifier493 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec494 =null;


        CommonTree KW_ON491_tree=null;
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_privObjectType=new RewriteRuleSubtreeStream(adaptor,"rule privObjectType");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("privilege subject", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1458:5: ( KW_ON privObjectType identifier ( partitionSpec )? -> ^( TOK_PRIV_OBJECT identifier privObjectType ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1458:7: KW_ON privObjectType identifier ( partitionSpec )?
            {
            KW_ON491=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_privilegeObject7930);  
            stream_KW_ON.add(KW_ON491);


            pushFollow(FOLLOW_privObjectType_in_privilegeObject7932);
            privObjectType492=privObjectType();

            state._fsp--;

            stream_privObjectType.add(privObjectType492.getTree());

            pushFollow(FOLLOW_identifier_in_privilegeObject7934);
            identifier493=identifier();

            state._fsp--;

            stream_identifier.add(identifier493.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1458:39: ( partitionSpec )?
            int alt136=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt136=1;
                    }
                    break;
            }

            switch (alt136) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1458:39: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_privilegeObject7936);
                    partitionSpec494=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec494.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, privObjectType, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1459:5: -> ^( TOK_PRIV_OBJECT identifier privObjectType ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:8: ^( TOK_PRIV_OBJECT identifier privObjectType ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRIV_OBJECT, "TOK_PRIV_OBJECT")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, stream_privObjectType.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:52: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeObject"


    public static class privObjectType_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privObjectType"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:1: privObjectType : ( KW_DATABASE -> ^( TOK_DB_TYPE ) | ( KW_TABLE )? -> ^( TOK_TABLE_TYPE ) );
    public final HiveParser.privObjectType_return privObjectType() throws RecognitionException {
        HiveParser.privObjectType_return retval = new HiveParser.privObjectType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DATABASE495=null;
        Token KW_TABLE496=null;

        CommonTree KW_DATABASE495_tree=null;
        CommonTree KW_TABLE496_tree=null;
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");

        pushMsg("privilege object type type", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1467:5: ( KW_DATABASE -> ^( TOK_DB_TYPE ) | ( KW_TABLE )? -> ^( TOK_TABLE_TYPE ) )
            int alt138=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt138=1;
                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARQUETFILE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt138=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;

            }

            switch (alt138) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1467:7: KW_DATABASE
                    {
                    KW_DATABASE495=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_privObjectType7983);  
                    stream_KW_DATABASE.add(KW_DATABASE495);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1467:19: -> ^( TOK_DB_TYPE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1467:22: ^( TOK_DB_TYPE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DB_TYPE, "TOK_DB_TYPE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1468:7: ( KW_TABLE )?
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1468:7: ( KW_TABLE )?
                    int alt137=2;
                    switch ( input.LA(1) ) {
                        case KW_TABLE:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARQUETFILE:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt137=1;
                                    }
                                    break;
                                case KW_PARTITION:
                                    {
                                    switch ( input.LA(3) ) {
                                        case LPAREN:
                                            {
                                            alt137=1;
                                            }
                                            break;
                                        case EOF:
                                        case KW_FROM:
                                        case KW_PARTITION:
                                        case KW_TO:
                                            {
                                            alt137=1;
                                            }
                                            break;
                                    }

                                    }
                                    break;
                                case KW_TO:
                                    {
                                    switch ( input.LA(3) ) {
                                        case EOF:
                                        case KW_FROM:
                                        case KW_PARTITION:
                                        case KW_TO:
                                        case LPAREN:
                                            {
                                            alt137=1;
                                            }
                                            break;
                                    }

                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt137) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1468:7: KW_TABLE
                            {
                            KW_TABLE496=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_privObjectType7997);  
                            stream_KW_TABLE.add(KW_TABLE496);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1468:17: -> ^( TOK_TABLE_TYPE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1468:20: ^( TOK_TABLE_TYPE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TABLE_TYPE, "TOK_TABLE_TYPE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privObjectType"


    public static class privilegeList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1472:1: privilegeList : privlegeDef ( COMMA privlegeDef )* -> ^( TOK_PRIVILEGE_LIST ( privlegeDef )+ ) ;
    public final HiveParser.privilegeList_return privilegeList() throws RecognitionException {
        HiveParser.privilegeList_return retval = new HiveParser.privilegeList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA498=null;
        HiveParser.privlegeDef_return privlegeDef497 =null;

        HiveParser.privlegeDef_return privlegeDef499 =null;


        CommonTree COMMA498_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_privlegeDef=new RewriteRuleSubtreeStream(adaptor,"rule privlegeDef");
        pushMsg("grant privilege list", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1475:5: ( privlegeDef ( COMMA privlegeDef )* -> ^( TOK_PRIVILEGE_LIST ( privlegeDef )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1475:7: privlegeDef ( COMMA privlegeDef )*
            {
            pushFollow(FOLLOW_privlegeDef_in_privilegeList8032);
            privlegeDef497=privlegeDef();

            state._fsp--;

            stream_privlegeDef.add(privlegeDef497.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1475:19: ( COMMA privlegeDef )*
            loop139:
            do {
                int alt139=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt139=1;
                    }
                    break;

                }

                switch (alt139) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1475:20: COMMA privlegeDef
            	    {
            	    COMMA498=(Token)match(input,COMMA,FOLLOW_COMMA_in_privilegeList8035);  
            	    stream_COMMA.add(COMMA498);


            	    pushFollow(FOLLOW_privlegeDef_in_privilegeList8037);
            	    privlegeDef499=privlegeDef();

            	    state._fsp--;

            	    stream_privlegeDef.add(privlegeDef499.getTree());

            	    }
            	    break;

            	default :
            	    break loop139;
                }
            } while (true);


            // AST REWRITE
            // elements: privlegeDef
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1476:5: -> ^( TOK_PRIVILEGE_LIST ( privlegeDef )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1476:8: ^( TOK_PRIVILEGE_LIST ( privlegeDef )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRIVILEGE_LIST, "TOK_PRIVILEGE_LIST")
                , root_1);

                if ( !(stream_privlegeDef.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_privlegeDef.hasNext() ) {
                    adaptor.addChild(root_1, stream_privlegeDef.nextTree());

                }
                stream_privlegeDef.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeList"


    public static class privlegeDef_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privlegeDef"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:1: privlegeDef : privilegeType ( LPAREN cols= columnNameList RPAREN )? -> ^( TOK_PRIVILEGE privilegeType ( $cols)? ) ;
    public final HiveParser.privlegeDef_return privlegeDef() throws RecognitionException {
        HiveParser.privlegeDef_return retval = new HiveParser.privlegeDef_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN501=null;
        Token RPAREN502=null;
        HiveParser.columnNameList_return cols =null;

        HiveParser.privilegeType_return privilegeType500 =null;


        CommonTree LPAREN501_tree=null;
        CommonTree RPAREN502_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_privilegeType=new RewriteRuleSubtreeStream(adaptor,"rule privilegeType");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        pushMsg("grant privilege", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1482:5: ( privilegeType ( LPAREN cols= columnNameList RPAREN )? -> ^( TOK_PRIVILEGE privilegeType ( $cols)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1482:7: privilegeType ( LPAREN cols= columnNameList RPAREN )?
            {
            pushFollow(FOLLOW_privilegeType_in_privlegeDef8079);
            privilegeType500=privilegeType();

            state._fsp--;

            stream_privilegeType.add(privilegeType500.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1482:21: ( LPAREN cols= columnNameList RPAREN )?
            int alt140=2;
            switch ( input.LA(1) ) {
                case LPAREN:
                    {
                    alt140=1;
                    }
                    break;
            }

            switch (alt140) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1482:22: LPAREN cols= columnNameList RPAREN
                    {
                    LPAREN501=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_privlegeDef8082);  
                    stream_LPAREN.add(LPAREN501);


                    pushFollow(FOLLOW_columnNameList_in_privlegeDef8086);
                    cols=columnNameList();

                    state._fsp--;

                    stream_columnNameList.add(cols.getTree());

                    RPAREN502=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_privlegeDef8088);  
                    stream_RPAREN.add(RPAREN502);


                    }
                    break;

            }


            // AST REWRITE
            // elements: cols, privilegeType
            // token labels: 
            // rule labels: retval, cols
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_cols=new RewriteRuleSubtreeStream(adaptor,"rule cols",cols!=null?cols.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1483:5: -> ^( TOK_PRIVILEGE privilegeType ( $cols)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1483:8: ^( TOK_PRIVILEGE privilegeType ( $cols)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRIVILEGE, "TOK_PRIVILEGE")
                , root_1);

                adaptor.addChild(root_1, stream_privilegeType.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1483:39: ( $cols)?
                if ( stream_cols.hasNext() ) {
                    adaptor.addChild(root_1, stream_cols.nextTree());

                }
                stream_cols.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privlegeDef"


    public static class privilegeType_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeType"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:1: privilegeType : ( KW_ALL -> ^( TOK_PRIV_ALL ) | KW_ALTER -> ^( TOK_PRIV_ALTER_METADATA ) | KW_UPDATE -> ^( TOK_PRIV_ALTER_DATA ) | KW_CREATE -> ^( TOK_PRIV_CREATE ) | KW_DROP -> ^( TOK_PRIV_DROP ) | KW_INDEX -> ^( TOK_PRIV_INDEX ) | KW_LOCK -> ^( TOK_PRIV_LOCK ) | KW_SELECT -> ^( TOK_PRIV_SELECT ) | KW_SHOW_DATABASE -> ^( TOK_PRIV_SHOW_DATABASE ) | KW_INSERT -> ^( TOK_PRIV_INSERT ) | KW_DELETE -> ^( TOK_PRIV_DELETE ) );
    public final HiveParser.privilegeType_return privilegeType() throws RecognitionException {
        HiveParser.privilegeType_return retval = new HiveParser.privilegeType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALL503=null;
        Token KW_ALTER504=null;
        Token KW_UPDATE505=null;
        Token KW_CREATE506=null;
        Token KW_DROP507=null;
        Token KW_INDEX508=null;
        Token KW_LOCK509=null;
        Token KW_SELECT510=null;
        Token KW_SHOW_DATABASE511=null;
        Token KW_INSERT512=null;
        Token KW_DELETE513=null;

        CommonTree KW_ALL503_tree=null;
        CommonTree KW_ALTER504_tree=null;
        CommonTree KW_UPDATE505_tree=null;
        CommonTree KW_CREATE506_tree=null;
        CommonTree KW_DROP507_tree=null;
        CommonTree KW_INDEX508_tree=null;
        CommonTree KW_LOCK509_tree=null;
        CommonTree KW_SELECT510_tree=null;
        CommonTree KW_SHOW_DATABASE511_tree=null;
        CommonTree KW_INSERT512_tree=null;
        CommonTree KW_DELETE513_tree=null;
        RewriteRuleTokenStream stream_KW_ALTER=new RewriteRuleTokenStream(adaptor,"token KW_ALTER");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_ALL=new RewriteRuleTokenStream(adaptor,"token KW_ALL");
        RewriteRuleTokenStream stream_KW_SELECT=new RewriteRuleTokenStream(adaptor,"token KW_SELECT");
        RewriteRuleTokenStream stream_KW_UPDATE=new RewriteRuleTokenStream(adaptor,"token KW_UPDATE");
        RewriteRuleTokenStream stream_KW_SHOW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_SHOW_DATABASE");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_DELETE=new RewriteRuleTokenStream(adaptor,"token KW_DELETE");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleTokenStream stream_KW_INSERT=new RewriteRuleTokenStream(adaptor,"token KW_INSERT");

        pushMsg("privilege type", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1489:5: ( KW_ALL -> ^( TOK_PRIV_ALL ) | KW_ALTER -> ^( TOK_PRIV_ALTER_METADATA ) | KW_UPDATE -> ^( TOK_PRIV_ALTER_DATA ) | KW_CREATE -> ^( TOK_PRIV_CREATE ) | KW_DROP -> ^( TOK_PRIV_DROP ) | KW_INDEX -> ^( TOK_PRIV_INDEX ) | KW_LOCK -> ^( TOK_PRIV_LOCK ) | KW_SELECT -> ^( TOK_PRIV_SELECT ) | KW_SHOW_DATABASE -> ^( TOK_PRIV_SHOW_DATABASE ) | KW_INSERT -> ^( TOK_PRIV_INSERT ) | KW_DELETE -> ^( TOK_PRIV_DELETE ) )
            int alt141=11;
            switch ( input.LA(1) ) {
            case KW_ALL:
                {
                alt141=1;
                }
                break;
            case KW_ALTER:
                {
                alt141=2;
                }
                break;
            case KW_UPDATE:
                {
                alt141=3;
                }
                break;
            case KW_CREATE:
                {
                alt141=4;
                }
                break;
            case KW_DROP:
                {
                alt141=5;
                }
                break;
            case KW_INDEX:
                {
                alt141=6;
                }
                break;
            case KW_LOCK:
                {
                alt141=7;
                }
                break;
            case KW_SELECT:
                {
                alt141=8;
                }
                break;
            case KW_SHOW_DATABASE:
                {
                alt141=9;
                }
                break;
            case KW_INSERT:
                {
                alt141=10;
                }
                break;
            case KW_DELETE:
                {
                alt141=11;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 141, 0, input);

                throw nvae;

            }

            switch (alt141) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1489:7: KW_ALL
                    {
                    KW_ALL503=(Token)match(input,KW_ALL,FOLLOW_KW_ALL_in_privilegeType8133);  
                    stream_KW_ALL.add(KW_ALL503);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1489:14: -> ^( TOK_PRIV_ALL )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1489:17: ^( TOK_PRIV_ALL )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_ALL, "TOK_PRIV_ALL")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1490:7: KW_ALTER
                    {
                    KW_ALTER504=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_privilegeType8147);  
                    stream_KW_ALTER.add(KW_ALTER504);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1490:16: -> ^( TOK_PRIV_ALTER_METADATA )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1490:19: ^( TOK_PRIV_ALTER_METADATA )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_ALTER_METADATA, "TOK_PRIV_ALTER_METADATA")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1491:7: KW_UPDATE
                    {
                    KW_UPDATE505=(Token)match(input,KW_UPDATE,FOLLOW_KW_UPDATE_in_privilegeType8161);  
                    stream_KW_UPDATE.add(KW_UPDATE505);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1491:17: -> ^( TOK_PRIV_ALTER_DATA )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1491:20: ^( TOK_PRIV_ALTER_DATA )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_ALTER_DATA, "TOK_PRIV_ALTER_DATA")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1492:7: KW_CREATE
                    {
                    KW_CREATE506=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_privilegeType8175);  
                    stream_KW_CREATE.add(KW_CREATE506);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1492:17: -> ^( TOK_PRIV_CREATE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1492:20: ^( TOK_PRIV_CREATE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_CREATE, "TOK_PRIV_CREATE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1493:7: KW_DROP
                    {
                    KW_DROP507=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_privilegeType8189);  
                    stream_KW_DROP.add(KW_DROP507);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1493:15: -> ^( TOK_PRIV_DROP )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1493:18: ^( TOK_PRIV_DROP )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_DROP, "TOK_PRIV_DROP")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1494:7: KW_INDEX
                    {
                    KW_INDEX508=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_privilegeType8203);  
                    stream_KW_INDEX.add(KW_INDEX508);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1494:16: -> ^( TOK_PRIV_INDEX )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1494:19: ^( TOK_PRIV_INDEX )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_INDEX, "TOK_PRIV_INDEX")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1495:7: KW_LOCK
                    {
                    KW_LOCK509=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_privilegeType8217);  
                    stream_KW_LOCK.add(KW_LOCK509);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1495:15: -> ^( TOK_PRIV_LOCK )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1495:18: ^( TOK_PRIV_LOCK )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_LOCK, "TOK_PRIV_LOCK")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1496:7: KW_SELECT
                    {
                    KW_SELECT510=(Token)match(input,KW_SELECT,FOLLOW_KW_SELECT_in_privilegeType8231);  
                    stream_KW_SELECT.add(KW_SELECT510);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1496:17: -> ^( TOK_PRIV_SELECT )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1496:20: ^( TOK_PRIV_SELECT )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_SELECT, "TOK_PRIV_SELECT")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1497:7: KW_SHOW_DATABASE
                    {
                    KW_SHOW_DATABASE511=(Token)match(input,KW_SHOW_DATABASE,FOLLOW_KW_SHOW_DATABASE_in_privilegeType8245);  
                    stream_KW_SHOW_DATABASE.add(KW_SHOW_DATABASE511);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1497:24: -> ^( TOK_PRIV_SHOW_DATABASE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1497:27: ^( TOK_PRIV_SHOW_DATABASE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_SHOW_DATABASE, "TOK_PRIV_SHOW_DATABASE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1498:7: KW_INSERT
                    {
                    KW_INSERT512=(Token)match(input,KW_INSERT,FOLLOW_KW_INSERT_in_privilegeType8259);  
                    stream_KW_INSERT.add(KW_INSERT512);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1498:17: -> ^( TOK_PRIV_INSERT )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1498:20: ^( TOK_PRIV_INSERT )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_INSERT, "TOK_PRIV_INSERT")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1499:7: KW_DELETE
                    {
                    KW_DELETE513=(Token)match(input,KW_DELETE,FOLLOW_KW_DELETE_in_privilegeType8273);  
                    stream_KW_DELETE.add(KW_DELETE513);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1499:17: -> ^( TOK_PRIV_DELETE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1499:20: ^( TOK_PRIV_DELETE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_DELETE, "TOK_PRIV_DELETE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeType"


    public static class principalSpecification_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "principalSpecification"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1502:1: principalSpecification : principalName ( COMMA principalName )* -> ^( TOK_PRINCIPAL_NAME ( principalName )+ ) ;
    public final HiveParser.principalSpecification_return principalSpecification() throws RecognitionException {
        HiveParser.principalSpecification_return retval = new HiveParser.principalSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA515=null;
        HiveParser.principalName_return principalName514 =null;

        HiveParser.principalName_return principalName516 =null;


        CommonTree COMMA515_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
         pushMsg("user/group/role name list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1505:5: ( principalName ( COMMA principalName )* -> ^( TOK_PRINCIPAL_NAME ( principalName )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1505:7: principalName ( COMMA principalName )*
            {
            pushFollow(FOLLOW_principalName_in_principalSpecification8306);
            principalName514=principalName();

            state._fsp--;

            stream_principalName.add(principalName514.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1505:21: ( COMMA principalName )*
            loop142:
            do {
                int alt142=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt142=1;
                    }
                    break;

                }

                switch (alt142) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1505:22: COMMA principalName
            	    {
            	    COMMA515=(Token)match(input,COMMA,FOLLOW_COMMA_in_principalSpecification8309);  
            	    stream_COMMA.add(COMMA515);


            	    pushFollow(FOLLOW_principalName_in_principalSpecification8311);
            	    principalName516=principalName();

            	    state._fsp--;

            	    stream_principalName.add(principalName516.getTree());

            	    }
            	    break;

            	default :
            	    break loop142;
                }
            } while (true);


            // AST REWRITE
            // elements: principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1505:44: -> ^( TOK_PRINCIPAL_NAME ( principalName )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1505:47: ^( TOK_PRINCIPAL_NAME ( principalName )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRINCIPAL_NAME, "TOK_PRINCIPAL_NAME")
                , root_1);

                if ( !(stream_principalName.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_principalName.hasNext() ) {
                    adaptor.addChild(root_1, stream_principalName.nextTree());

                }
                stream_principalName.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             popMsg(state); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "principalSpecification"


    public static class principalName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "principalName"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1508:1: principalName : ( KW_USER identifier -> ^( TOK_USER identifier ) | KW_GROUP identifier -> ^( TOK_GROUP identifier ) | KW_ROLE identifier -> ^( TOK_ROLE identifier ) );
    public final HiveParser.principalName_return principalName() throws RecognitionException {
        HiveParser.principalName_return retval = new HiveParser.principalName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_USER517=null;
        Token KW_GROUP519=null;
        Token KW_ROLE521=null;
        HiveParser_IdentifiersParser.identifier_return identifier518 =null;

        HiveParser_IdentifiersParser.identifier_return identifier520 =null;

        HiveParser_IdentifiersParser.identifier_return identifier522 =null;


        CommonTree KW_USER517_tree=null;
        CommonTree KW_GROUP519_tree=null;
        CommonTree KW_ROLE521_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_GROUP=new RewriteRuleTokenStream(adaptor,"token KW_GROUP");
        RewriteRuleTokenStream stream_KW_USER=new RewriteRuleTokenStream(adaptor,"token KW_USER");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("user|group|role name", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1511:5: ( KW_USER identifier -> ^( TOK_USER identifier ) | KW_GROUP identifier -> ^( TOK_GROUP identifier ) | KW_ROLE identifier -> ^( TOK_ROLE identifier ) )
            int alt143=3;
            switch ( input.LA(1) ) {
            case KW_USER:
                {
                alt143=1;
                }
                break;
            case KW_GROUP:
                {
                alt143=2;
                }
                break;
            case KW_ROLE:
                {
                alt143=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 143, 0, input);

                throw nvae;

            }

            switch (alt143) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1511:7: KW_USER identifier
                    {
                    KW_USER517=(Token)match(input,KW_USER,FOLLOW_KW_USER_in_principalName8349);  
                    stream_KW_USER.add(KW_USER517);


                    pushFollow(FOLLOW_identifier_in_principalName8351);
                    identifier518=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier518.getTree());

                    // AST REWRITE
                    // elements: identifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1511:26: -> ^( TOK_USER identifier )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1511:29: ^( TOK_USER identifier )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_USER, "TOK_USER")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1512:7: KW_GROUP identifier
                    {
                    KW_GROUP519=(Token)match(input,KW_GROUP,FOLLOW_KW_GROUP_in_principalName8367);  
                    stream_KW_GROUP.add(KW_GROUP519);


                    pushFollow(FOLLOW_identifier_in_principalName8369);
                    identifier520=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier520.getTree());

                    // AST REWRITE
                    // elements: identifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1512:27: -> ^( TOK_GROUP identifier )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1512:30: ^( TOK_GROUP identifier )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_GROUP, "TOK_GROUP")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1513:7: KW_ROLE identifier
                    {
                    KW_ROLE521=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_principalName8385);  
                    stream_KW_ROLE.add(KW_ROLE521);


                    pushFollow(FOLLOW_identifier_in_principalName8387);
                    identifier522=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier522.getTree());

                    // AST REWRITE
                    // elements: identifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1513:26: -> ^( TOK_ROLE identifier )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1513:29: ^( TOK_ROLE identifier )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ROLE, "TOK_ROLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            popMsg(state);
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "principalName"


    public static class withGrantOption_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "withGrantOption"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1516:1: withGrantOption : KW_WITH KW_GRANT KW_OPTION -> ^( TOK_GRANT_WITH_OPTION ) ;
    public final HiveParser.withGrantOption_return withGrantOption() throws RecognitionException {
        HiveParser.withGrantOption_return retval = new HiveParser.withGrantOption_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_WITH523=null;
        Token KW_GRANT524=null;
        Token KW_OPTION525=null;

        CommonTree KW_WITH523_tree=null;
        CommonTree KW_GRANT524_tree=null;
        CommonTree KW_OPTION525_tree=null;
        RewriteRuleTokenStream stream_KW_OPTION=new RewriteRuleTokenStream(adaptor,"token KW_OPTION");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");

        pushMsg("with grant option", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1519:5: ( KW_WITH KW_GRANT KW_OPTION -> ^( TOK_GRANT_WITH_OPTION ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1519:7: KW_WITH KW_GRANT KW_OPTION
         