/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.hadoop.hive.serde2.lazy.LazyBoolean;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyDouble;
import org.apache.hadoop.hive.serde2.lazy.LazyFloat;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveDecimal;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.lazy.LazyUnion;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyListObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyUnionObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyPrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.lazydio.LazyDioBoolean;
import org.apache.hadoop.hive.serde2.lazydio.LazyDioByte;
import org.apache.hadoop.hive.serde2.lazydio.LazyDioDouble;
import org.apache.hadoop.hive.serde2.lazydio.LazyDioFloat;
import org.apache.hadoop.hive.serde2.lazydio.LazyDioInteger;
import org.apache.hadoop.hive.serde2.lazydio.LazyDioLong;
import org.apache.hadoop.hive.serde2.lazydio.LazyDioShort;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public final class LazyFactory {
    public static LazyPrimitive<? extends ObjectInspector, ? extends Writable> createLazyPrimitiveClass(PrimitiveObjectInspector poi, boolean typeBinary) {
        if (typeBinary) {
            return LazyFactory.createLazyPrimitiveBinaryClass(poi);
        }
        return LazyFactory.createLazyPrimitiveClass(poi);
    }

    public static LazyPrimitive<? extends ObjectInspector, ? extends Writable> createLazyPrimitiveClass(PrimitiveObjectInspector oi) {
        PrimitiveObjectInspector.PrimitiveCategory p = oi.getPrimitiveCategory();
        switch (p) {
            case BOOLEAN: {
                return new LazyBoolean((LazyBooleanObjectInspector)oi);
            }
            case BYTE: {
                return new LazyByte((LazyByteObjectInspector)oi);
            }
            case SHORT: {
                return new LazyShort((LazyShortObjectInspector)oi);
            }
            case INT: {
                return new LazyInteger((LazyIntObjectInspector)oi);
            }
            case LONG: {
                return new LazyLong((LazyLongObjectInspector)oi);
            }
            case FLOAT: {
                return new LazyFloat((LazyFloatObjectInspector)oi);
            }
            case DOUBLE: {
                return new LazyDouble((LazyDoubleObjectInspector)oi);
            }
            case STRING: {
                return new LazyString((LazyStringObjectInspector)oi);
            }
            case TIMESTAMP: {
                return new LazyTimestamp((LazyTimestampObjectInspector)oi);
            }
            case BINARY: {
                return new LazyBinary((LazyBinaryObjectInspector)oi);
            }
            case DECIMAL: {
                return new LazyHiveDecimal((LazyHiveDecimalObjectInspector)oi);
            }
        }
        throw new RuntimeException("Internal error: no LazyObject for " + (Object)((Object)p));
    }

    public static LazyPrimitive<? extends ObjectInspector, ? extends Writable> createLazyPrimitiveBinaryClass(PrimitiveObjectInspector poi) {
        PrimitiveObjectInspector.PrimitiveCategory pc = poi.getPrimitiveCategory();
        switch (pc) {
            case BOOLEAN: {
                return new LazyDioBoolean((LazyBooleanObjectInspector)poi);
            }
            case BYTE: {
                return new LazyDioByte((LazyByteObjectInspector)poi);
            }
            case SHORT: {
                return new LazyDioShort((LazyShortObjectInspector)poi);
            }
            case INT: {
                return new LazyDioInteger((LazyIntObjectInspector)poi);
            }
            case LONG: {
                return new LazyDioLong((LazyLongObjectInspector)poi);
            }
            case FLOAT: {
                return new LazyDioFloat((LazyFloatObjectInspector)poi);
            }
            case DOUBLE: {
                return new LazyDioDouble((LazyDoubleObjectInspector)poi);
            }
        }
        throw new RuntimeException("Hive Internal Error: no LazyObject for " + poi);
    }

    public static LazyObject<? extends ObjectInspector> createLazyObject(ObjectInspector oi) {
        ObjectInspector.Category c = oi.getCategory();
        switch (c) {
            case PRIMITIVE: {
                return LazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)oi);
            }
            case MAP: {
                return new LazyMap((LazyMapObjectInspector)oi);
            }
            case LIST: {
                return new LazyArray((LazyListObjectInspector)oi);
            }
            case STRUCT: {
                return new LazyStruct((LazySimpleStructObjectInspector)oi);
            }
            case UNION: {
                return new LazyUnion((LazyUnionObjectInspector)oi);
            }
        }
        throw new RuntimeException("Hive LazySerDe Internal error.");
    }

    public static LazyObject<? extends ObjectInspector> createLazyObject(ObjectInspector oi, boolean typeBinary) {
        if (oi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return LazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)oi, typeBinary);
        }
        return LazyFactory.createLazyObject(oi);
    }

    public static ObjectInspector createLazyObjectInspector(TypeInfo typeInfo, byte[] separator, int separatorIndex, Text nullSequence, boolean escaped, byte escapeChar) {
        ObjectInspector.Category c = typeInfo.getCategory();
        switch (c) {
            case PRIMITIVE: {
                return LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector(((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory(), escaped, escapeChar);
            }
            case MAP: {
                return LazyObjectInspectorFactory.getLazySimpleMapObjectInspector(LazyFactory.createLazyObjectInspector(((MapTypeInfo)typeInfo).getMapKeyTypeInfo(), separator, separatorIndex + 2, nullSequence, escaped, escapeChar), LazyFactory.createLazyObjectInspector(((MapTypeInfo)typeInfo).getMapValueTypeInfo(), separator, separatorIndex + 2, nullSequence, escaped, escapeChar), separator[separatorIndex], separator[separatorIndex + 1], nullSequence, escaped, escapeChar);
            }
            case LIST: {
                return LazyObjectInspectorFactory.getLazySimpleListObjectInspector(LazyFactory.createLazyObjectInspector(((ListTypeInfo)typeInfo).getListElementTypeInfo(), separator, separatorIndex + 1, nullSequence, escaped, escapeChar), separator[separatorIndex], nullSequence, escaped, escapeChar);
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
                ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                    fieldObjectInspectors.add(LazyFactory.createLazyObjectInspector((TypeInfo)fieldTypeInfos.get(i), separator, separatorIndex + 1, nullSequence, escaped, escapeChar));
                }
                return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(fieldNames, fieldObjectInspectors, separator[separatorIndex], nullSequence, false, escaped, escapeChar);
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                ArrayList<ObjectInspector> lazyOIs = new ArrayList<ObjectInspector>();
                for (TypeInfo uti : unionTypeInfo.getAllUnionObjectTypeInfos()) {
                    lazyOIs.add(LazyFactory.createLazyObjectInspector(uti, separator, separatorIndex + 1, nullSequence, escaped, escapeChar));
                }
                return LazyObjectInspectorFactory.getLazyUnionObjectInspector(lazyOIs, separator[separatorIndex], nullSequence, escaped, escapeChar);
            }
        }
        throw new RuntimeException("Hive LazySerDe Internal error.");
    }

    public static ObjectInspector createLazyStructInspector(List<String> columnNames, List<TypeInfo> typeInfos, byte[] separators, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        ArrayList<ObjectInspector> columnObjectInspectors = new ArrayList<ObjectInspector>(typeInfos.size());
        for (int i = 0; i < typeInfos.size(); ++i) {
            columnObjectInspectors.add(LazyFactory.createLazyObjectInspector(typeInfos.get(i), separators, 1, nullSequence, escaped, escapeChar));
        }
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(columnNames, columnObjectInspectors, separators[0], nullSequence, lastColumnTakesRest, escaped, escapeChar);
    }

    public static ObjectInspector createColumnarStructInspector(List<String> columnNames, List<TypeInfo> columnTypes, byte[] separators, Text nullSequence, boolean escaped, byte escapeChar) {
        ArrayList<ObjectInspector> columnObjectInspectors = new ArrayList<ObjectInspector>(columnTypes.size());
        for (int i = 0; i < columnTypes.size(); ++i) {
            columnObjectInspectors.add(LazyFactory.createLazyObjectInspector(columnTypes.get(i), separators, 1, nullSequence, escaped, escapeChar));
        }
        return ObjectInspectorFactory.getColumnarStructObjectInspector(columnNames, columnObjectInspectors);
    }

    private LazyFactory() {
    }
}

