/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.text.DecimalFormat;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="format_number", value="_FUNC_(X, D) - Formats the number X to a format like '#,###,###.##', rounded to D decimal places, and returns the result as a string. If D is 0, the result has no decimal point or fractional part. This is supposed to function like MySQL's FORMAT", extended="Example:\n  > SELECT _FUNC_(12332.123456, 4) FROM src LIMIT 1;\n  '12,332.1235'")
public class GenericUDFFormatNumber
extends GenericUDF {
    private ObjectInspector[] argumentOIs;
    private final Text resultText = new Text();
    private final StringBuilder pattern = new StringBuilder("");
    private final DecimalFormat numberFormat = new DecimalFormat("");
    private int lastDValue = -1;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function FORMAT_NUMBER(X, D) needs two arguments.");
        }
        switch (arguments[0].getCategory()) {
            case PRIMITIVE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Argument 1 of function FORMAT_NUMBER must be \"tinyint\" or \"smallint\" or \"int\" or \"bigint\" or \"double\" or \"float\", but \"" + arguments[0].getTypeName() + "\" was found.");
            }
        }
        switch (arguments[1].getCategory()) {
            case PRIMITIVE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(1, "Argument 2 of function FORMAT_NUMBER must be \"tinyint\" or \"smallint\" or \"int\" or \"bigint\", but \"" + arguments[1].getTypeName() + "\" was found.");
            }
        }
        PrimitiveObjectInspector xObjectInspector = (PrimitiveObjectInspector)arguments[0];
        PrimitiveObjectInspector dObjectInspector = (PrimitiveObjectInspector)arguments[1];
        switch (xObjectInspector.getPrimitiveCategory()) {
            case VOID: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Argument 1 of function FORMAT_NUMBER must be \"tinyint\" or \"smallint\" or \"int\" or \"bigint\" or \"double\" or \"float\", but \"" + arguments[0].getTypeName() + "\" was found.");
            }
        }
        switch (dObjectInspector.getPrimitiveCategory()) {
            case VOID: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(1, "Argument 2 of function FORMAT_NUMBER must be \"tinyint\" or \"smallint\" or \"int\" or \"bigint\", but \"" + arguments[1].getTypeName() + "\" was found.");
            }
        }
        this.argumentOIs = arguments;
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int dValue = ((IntObjectInspector)this.argumentOIs[1]).get(arguments[1].get());
        if (dValue < 0) {
            throw new HiveException("Argument 2 of function FORMAT_NUMBER must be >= 0, but \"" + dValue + "\" was found");
        }
        if (dValue != this.lastDValue) {
            this.pattern.delete(0, this.pattern.length());
            this.pattern.append("#,###,###,###,###,###,##0");
            if (dValue > 0) {
                this.pattern.append(".");
                for (int i = 0; i < dValue; ++i) {
                    this.pattern.append("0");
                }
            }
            DecimalFormat dFormat = new DecimalFormat(this.pattern.toString());
            this.lastDValue = dValue;
            this.numberFormat.applyPattern(dFormat.toPattern());
        }
        double xDoubleValue = 0.0;
        int xIntValue = 0;
        long xLongValue = 0L;
        PrimitiveObjectInspector xObjectInspector = (PrimitiveObjectInspector)this.argumentOIs[0];
        switch (xObjectInspector.getPrimitiveCategory()) {
            case VOID: 
            case FLOAT: 
            case DOUBLE: {
                xDoubleValue = ((DoubleObjectInspector)this.argumentOIs[0]).get(arguments[0].get());
                this.resultText.set(this.numberFormat.format(xDoubleValue));
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                xIntValue = ((IntObjectInspector)this.argumentOIs[0]).get(arguments[0].get());
                this.resultText.set(this.numberFormat.format(xIntValue));
                break;
            }
            case LONG: {
                xLongValue = ((LongObjectInspector)this.argumentOIs[0]).get(arguments[0].get());
                this.resultText.set(this.numberFormat.format(xLongValue));
                break;
            }
            default: {
                throw new HiveException("Argument 1 of function FORMAT_NUMBER must be tinyint\" or \"smallint\" or \"int\" or \"bigint\" or \"double\" or \"float\", but \"" + this.argumentOIs[0].getTypeName() + "\" was found.");
            }
        }
        return this.resultText;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        StringBuilder sb = new StringBuilder();
        sb.append("format_number(");
        for (int i = 0; i < children.length - 1; ++i) {
            sb.append(children[i]).append(", ");
        }
        sb.append(children[children.length - 1]).append(")");
        return sb.toString();
    }
}

