/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

@Description(name="/", value="a _FUNC_ b - Divide a by b", extended="Example:\n  > SELECT 3 _FUNC_ 2 FROM src LIMIT 1;\n  1.5")
public class UDFOPDivide
extends UDF {
    private final DoubleWritable doubleWritable = new DoubleWritable();
    private final HiveDecimalWritable decimalWritable = new HiveDecimalWritable();

    public DoubleWritable evaluate(DoubleWritable a, DoubleWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.doubleWritable.set(a.get() / b.get());
        return this.doubleWritable;
    }

    public HiveDecimalWritable evaluate(HiveDecimalWritable a, HiveDecimalWritable b) {
        if (a == null || b == null) {
            return null;
        }
        if (b.getHiveDecimal().compareTo(HiveDecimal.ZERO) == 0) {
            return null;
        }
        this.decimalWritable.set(a.getHiveDecimal().divide(b.getHiveDecimal()));
        return this.decimalWritable;
    }
}

