/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;

public class PTFInvocationSpec {
    PartitionedTableFunctionSpec function;

    public PartitionedTableFunctionSpec getFunction() {
        return this.function;
    }

    public void setFunction(PartitionedTableFunctionSpec function) {
        this.function = function;
    }

    public PartitionedTableFunctionSpec getStartOfChain() {
        return this.function == null ? null : this.function.getStartOfChain();
    }

    public String getQueryInputName() {
        return this.function == null ? null : this.function.getQueryInputName();
    }

    public PTFQueryInputSpec getQueryInput() {
        return this.function == null ? null : this.function.getQueryInput();
    }

    public static class OrderExpression
    extends PartitionExpression {
        Order order;

        public OrderExpression() {
        }

        public OrderExpression(PartitionExpression peSpec) {
            super(peSpec);
            this.order = Order.ASC;
        }

        public Order getOrder() {
            return this.order;
        }

        public void setOrder(Order order) {
            this.order = order;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrderExpression other = (OrderExpression)obj;
            return this.order == other.order;
        }

        @Override
        public String toString() {
            return String.format("%s %s", new Object[]{super.toString(), this.order});
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }

    public static class OrderSpec {
        ArrayList<OrderExpression> expressions;

        public OrderSpec() {
        }

        public OrderSpec(PartitionSpec pSpec) {
            for (PartitionExpression peSpec : pSpec.getExpressions()) {
                this.addExpression(new OrderExpression(peSpec));
            }
        }

        public ArrayList<OrderExpression> getExpressions() {
            return this.expressions;
        }

        public void setExpressions(ArrayList<OrderExpression> columns) {
            this.expressions = columns;
        }

        public void addExpression(OrderExpression c) {
            this.expressions = this.expressions == null ? new ArrayList<OrderExpression>() : this.expressions;
            this.expressions.add(c);
        }

        protected boolean isPrefixedBy(PartitionSpec pSpec) {
            int exprCnt;
            if (pSpec == null || pSpec.getExpressions() == null) {
                return true;
            }
            int pExprCnt = pSpec.getExpressions().size();
            int n = exprCnt = this.getExpressions() == null ? 0 : this.getExpressions().size();
            if (exprCnt < pExprCnt) {
                return false;
            }
            for (int i = 0; i < pExprCnt; ++i) {
                if (pSpec.getExpressions().get(i).equals(this.getExpressions().get(i))) continue;
                return false;
            }
            return true;
        }

        protected void prefixBy(PartitionSpec pSpec) {
            if (pSpec == null || pSpec.getExpressions() == null) {
                return;
            }
            if (this.expressions == null) {
                this.expressions = new ArrayList();
            }
            for (int i = pSpec.getExpressions().size() - 1; i >= 0; --i) {
                this.expressions.add(0, new OrderExpression(pSpec.getExpressions().get(i)));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expressions == null ? 0 : this.expressions.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrderSpec other = (OrderSpec)obj;
            return !(this.expressions == null ? other.expressions != null : !this.expressions.equals(other.expressions));
        }

        public String toString() {
            return String.format("orderColumns=%s", PTFUtils.toString(this.expressions));
        }
    }

    public static class PartitionExpression {
        ASTNode expression;

        public PartitionExpression() {
        }

        public PartitionExpression(PartitionExpression peSpec) {
            this.expression = peSpec.getExpression();
        }

        public ASTNode getExpression() {
            return this.expression;
        }

        public void setExpression(ASTNode expression) {
            this.expression = expression;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expression == null ? 0 : this.expression.toStringTree().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isAssignableFrom(obj.getClass())) {
                return false;
            }
            PartitionExpression other = (PartitionExpression)obj;
            return !(this.expression == null ? other.expression != null : !this.expression.toStringTree().equals(other.expression.toStringTree()));
        }

        public String toString() {
            return this.expression.toStringTree();
        }
    }

    public static class PartitionSpec {
        ArrayList<PartitionExpression> expressions;

        public ArrayList<PartitionExpression> getExpressions() {
            return this.expressions;
        }

        public void setExpressions(ArrayList<PartitionExpression> columns) {
            this.expressions = columns;
        }

        public void addExpression(PartitionExpression c) {
            this.expressions = this.expressions == null ? new ArrayList<PartitionExpression>() : this.expressions;
            this.expressions.add(c);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expressions == null ? 0 : this.expressions.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionSpec other = (PartitionSpec)obj;
            return !(this.expressions == null ? other.expressions != null : !this.expressions.equals(other.expressions));
        }

        public String toString() {
            return String.format("partitionColumns=%s", PTFUtils.toString(this.expressions));
        }
    }

    public static class PartitioningSpec {
        PartitionSpec partSpec;
        OrderSpec orderSpec;

        public PartitionSpec getPartSpec() {
            return this.partSpec;
        }

        public void setPartSpec(PartitionSpec partSpec) {
            this.partSpec = partSpec;
        }

        public OrderSpec getOrderSpec() {
            return this.orderSpec;
        }

        public void setOrderSpec(OrderSpec orderSpec) {
            this.orderSpec = orderSpec;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.orderSpec == null ? 0 : this.orderSpec.hashCode());
            result = 31 * result + (this.partSpec == null ? 0 : this.partSpec.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitioningSpec other = (PartitioningSpec)obj;
            if (this.orderSpec == null ? other.orderSpec != null : !this.orderSpec.equals(other.orderSpec)) {
                return false;
            }
            return !(this.partSpec == null ? other.partSpec != null : !this.partSpec.equals(other.partSpec));
        }
    }

    public static class PartitionedTableFunctionSpec
    extends PTFInputSpec {
        String name;
        String alias;
        ArrayList<ASTNode> args;
        PartitioningSpec partitioning;
        PTFInputSpec input;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public ArrayList<ASTNode> getArgs() {
            return this.args;
        }

        public void setArgs(ArrayList<ASTNode> args) {
            this.args = args;
        }

        public PartitioningSpec getPartitioning() {
            return this.partitioning;
        }

        public void setPartitioning(PartitioningSpec partitioning) {
            this.partitioning = partitioning;
        }

        @Override
        public PTFInputSpec getInput() {
            return this.input;
        }

        public void setInput(PTFInputSpec input) {
            this.input = input;
        }

        public PartitionSpec getPartition() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getPartSpec();
        }

        public void setPartition(PartitionSpec partSpec) {
            this.partitioning = this.partitioning == null ? new PartitioningSpec() : this.partitioning;
            this.partitioning.setPartSpec(partSpec);
        }

        public OrderSpec getOrder() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getOrderSpec();
        }

        public void setOrder(OrderSpec orderSpec) {
            this.partitioning = this.partitioning == null ? new PartitioningSpec() : this.partitioning;
            this.partitioning.setOrderSpec(orderSpec);
        }

        public void addArg(ASTNode arg) {
            this.args = this.args == null ? new ArrayList<ASTNode>() : this.args;
            this.args.add(arg);
        }

        public PartitionedTableFunctionSpec getStartOfChain() {
            if (this.input instanceof PartitionedTableFunctionSpec) {
                return ((PartitionedTableFunctionSpec)this.input).getStartOfChain();
            }
            return this;
        }

        @Override
        public String getQueryInputName() {
            return this.input.getQueryInputName();
        }

        @Override
        public PTFQueryInputSpec getQueryInput() {
            return this.input.getQueryInput();
        }
    }

    public static class PTFQueryInputSpec
    extends PTFInputSpec {
        String source;
        PTFQueryInputType type;

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public PTFQueryInputType getType() {
            return this.type;
        }

        public void setType(PTFQueryInputType type) {
            this.type = type;
        }

        @Override
        public PTFInputSpec getInput() {
            return null;
        }

        @Override
        public String getQueryInputName() {
            return this.getSource();
        }

        @Override
        public PTFQueryInputSpec getQueryInput() {
            return this;
        }
    }

    public static enum PTFQueryInputType {
        TABLE,
        SUBQUERY,
        PTFCOMPONENT,
        WINDOWING;

    }

    public static abstract class PTFInputSpec {
        ASTNode astNode;

        public ASTNode getAstNode() {
            return this.astNode;
        }

        public void setAstNode(ASTNode astNode) {
            this.astNode = astNode;
        }

        public abstract PTFInputSpec getInput();

        public abstract String getQueryInputName();

        public abstract PTFQueryInputSpec getQueryInput();
    }
}

