/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanWork;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class GenMRTableScan1
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        TableScanOperator op = (TableScanOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        MapredWork currWork = GenMapRedUtils.getMapRedWork(parseCtx);
        Task<MapredWork> currTask = TaskFactory.get(currWork, parseCtx.getConf(), new Task[0]);
        TableScanOperator currTopOp = op;
        ctx.setCurrTask(currTask);
        ctx.setCurrTopOp(currTopOp);
        for (String alias : parseCtx.getTopOps().keySet()) {
            Operator<? extends OperatorDesc> currOp = parseCtx.getTopOps().get(alias);
            if (currOp != op) continue;
            String currAliasId = alias;
            ctx.setCurrAliasId(currAliasId);
            mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(currTask, currTopOp, currAliasId));
            QBParseInfo parseInfo = parseCtx.getQB().getParseInfo();
            if (parseInfo.isAnalyzeCommand()) {
                StatsWork statsWork = new StatsWork(parseCtx.getQB().getParseInfo().getTableSpec());
                statsWork.setAggKey(((TableScanDesc)op.getConf()).getStatsAggPrefix());
                statsWork.setStatsReliable(parseCtx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
                Task<StatsWork> statsTask = TaskFactory.get(statsWork, parseCtx.getConf(), new Task[0]);
                currTask.addDependentTask(statsTask);
                if (!ctx.getRootTasks().contains(currTask)) {
                    ctx.getRootTasks().add(currTask);
                }
                if (parseInfo.isNoScanAnalyzeCommand()) {
                    statsTask.setParentTasks(null);
                    statsWork.setNoScanAnalyzeCommand(true);
                    ctx.getRootTasks().remove(currTask);
                    ctx.getRootTasks().add(statsTask);
                }
                if (parseInfo.isPartialScanAnalyzeCommand()) {
                    this.handlePartialScanCommand(op, ctx, parseCtx, currTask, parseInfo, statsWork, statsTask);
                }
                currWork.setGatheringStats(true);
                HashSet<Partition> confirmedPartns = new HashSet<Partition>();
                BaseSemanticAnalyzer.tableSpec tblSpec = parseInfo.getTableSpec();
                if (tblSpec.specType == BaseSemanticAnalyzer.tableSpec.SpecType.STATIC_PARTITION) {
                    if (tblSpec.partHandle != null) {
                        confirmedPartns.add(tblSpec.partHandle);
                    } else {
                        assert (parseInfo.isNoScanAnalyzeCommand());
                        confirmedPartns.addAll(tblSpec.partitions);
                    }
                } else if (tblSpec.specType == BaseSemanticAnalyzer.tableSpec.SpecType.DYNAMIC_PARTITION) {
                    confirmedPartns.addAll(tblSpec.partitions);
                }
                if (confirmedPartns.size() > 0) {
                    Table source = parseCtx.getQB().getMetaData().getTableForAlias(alias);
                    PrunedPartitionList partList = new PrunedPartitionList(source, confirmedPartns, new HashSet<Partition>(), null);
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currWork, false, ctx, partList);
                } else {
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currWork, false, ctx);
                }
            }
            return null;
        }
        assert (false);
        return null;
    }

    private void handlePartialScanCommand(TableScanOperator op, GenMRProcContext ctx, ParseContext parseCtx, Task<? extends Serializable> currTask, QBParseInfo parseInfo, StatsWork statsWork, Task<StatsWork> statsTask) throws SemanticException {
        String aggregationKey = ((TableScanDesc)op.getConf()).getStatsAggPrefix();
        ArrayList<String> inputPaths = new ArrayList<String>();
        switch (parseInfo.getTableSpec().specType) {
            case TABLE_ONLY: {
                inputPaths.add(parseInfo.getTableSpec().tableHandle.getPath().toString());
                break;
            }
            case STATIC_PARTITION: {
                Partition part = parseInfo.getTableSpec().partHandle;
                try {
                    aggregationKey = aggregationKey + Warehouse.makePartPath(part.getSpec());
                }
                catch (MetaException e) {
                    throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_AGGKEY.getMsg(part.getPartitionPath().toString() + e.getMessage()));
                }
                inputPaths.add(part.getPartitionPath().toString());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        PartialScanWork scanWork = new PartialScanWork(inputPaths);
        scanWork.setMapperCannotSpanPartns(true);
        scanWork.setAggKey(aggregationKey);
        statsWork.setPartialScanAnalyzeCommand(true);
        DriverContext driverCxt = new DriverContext();
        Task<PartialScanWork> psTask = TaskFactory.get(scanWork, parseCtx.getConf(), new Task[0]);
        psTask.initialize(parseCtx.getConf(), null, driverCxt);
        psTask.setWork(scanWork);
        ctx.getRootTasks().remove(currTask);
        ctx.getRootTasks().add(psTask);
        psTask.addDependentTask(statsTask);
        ArrayList<Task<? extends Serializable>> parentTasks = new ArrayList<Task<? extends Serializable>>();
        parentTasks.add(psTask);
        statsTask.setParentTasks(parentTasks);
    }
}

