/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.BigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.SizeBasedBigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class AvgPartitionSizeBasedBigTableSelectorForAutoSMJ
extends SizeBasedBigTableSelectorForAutoSMJ
implements BigTableSelectorForAutoSMJ {
    private static final Log LOG = LogFactory.getLog((String)AvgPartitionSizeBasedBigTableSelectorForAutoSMJ.class.getName());

    @Override
    public int getBigTablePosition(ParseContext parseCtx, JoinOperator joinOp) throws SemanticException {
        int bigTablePos = 0;
        long maxSize = 0L;
        int numPartitionsCurrentBigTable = 0;
        HiveConf conf = parseCtx.getConf();
        try {
            ArrayList<TableScanOperator> topOps = new ArrayList<TableScanOperator>();
            this.getListTopOps(joinOp, topOps);
            int currentPos = 0;
            for (TableScanOperator topOp : topOps) {
                if (topOp == null) {
                    return -1;
                }
                int numPartitions = 1;
                Table table = parseCtx.getTopToTable().get(topOp);
                long averageSize = 0L;
                if (!table.isPartitioned()) {
                    averageSize = this.getSize(conf, table);
                } else {
                    PrunedPartitionList partsList = PartitionPruner.prune(parseCtx.getTopToTable().get(topOp), parseCtx.getOpToPartPruner().get(topOp), parseCtx.getConf(), null, parseCtx.getPrunedPartitions());
                    numPartitions = partsList.getNotDeniedPartns().size();
                    long totalSize = 0L;
                    for (Partition part : partsList.getNotDeniedPartns()) {
                        totalSize += this.getSize(conf, part);
                    }
                    averageSize = totalSize / (long)numPartitions;
                }
                if (averageSize > maxSize) {
                    maxSize = averageSize;
                    bigTablePos = currentPos;
                    numPartitionsCurrentBigTable = numPartitions;
                } else if (averageSize == maxSize && numPartitions < numPartitionsCurrentBigTable) {
                    bigTablePos = currentPos;
                    numPartitionsCurrentBigTable = numPartitions;
                }
                ++currentPos;
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage());
        }
        return bigTablePos;
    }
}

