/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

@Category(value={MediumTests.class})
public class TestTableName
extends TestWatcher {
    private TableName tableName;
    String[] emptyNames = new String[]{"", " "};
    String[] invalidNamespace = new String[]{":a", "%:a"};
    String[] legalTableNames = new String[]{"foo", "with-dash_under.dot", "_under_start_ok", "with-dash.with_underscore", "02-01-2012.my_table_01-02", "xyz._mytable_", "9_9_0.table_02", "dot1.dot2.table", "new.-mytable", "with-dash.with.dot", "legal..t2", "legal..legal.t2", "trailingdots..", "trailing.dots...", "ns:mytable", "ns:_mytable_", "ns:my_table_01-02"};
    String[] illegalTableNames = new String[]{".dot_start_illegal", "-dash_start_illegal", "spaces not ok", "-dash-.start_illegal", "new.table with space", "01 .table", "ns:-illegaldash", "new:.illegaldot", "new:illegalcolon1:", "new:illegalcolon1:2"};
    Names[] names = new Names[]{new Names("n1", "n1"), new Names("n2", "n2"), new Names("table1", "table1"), new Names("table2", "table2"), new Names("table2", "table1"), new Names("table1", "table2"), new Names("n1", "table1"), new Names("n1", "table1"), new Names("n2", "table2"), new Names("n2", "table2")};

    protected void starting(Description description) {
        this.tableName = TableName.valueOf((String)description.getMethodName());
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNamespace() {
        for (String tn : this.invalidNamespace) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
            Assert.fail((String)("invalid namespace " + tn + " should have failed with IllegalArgumentException for namespace"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyNamespaceName() {
        for (String nn : this.emptyNames) {
            TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)nn));
            Assert.fail((String)("invalid Namespace name " + nn + " should have failed with IllegalArgumentException"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyTableName() {
        for (String tn : this.emptyNames) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
            Assert.fail((String)("invalid tablename " + tn + " should have failed with IllegalArgumentException"));
        }
    }

    @Test
    public void testLegalHTableNames() {
        for (String tn : this.legalTableNames) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
        }
    }

    @Test
    public void testIllegalHTableNames() {
        for (String tn : this.illegalTableNames) {
            try {
                TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
                Assert.fail((String)("invalid tablename " + tn + " should have failed"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testValueOf() {
        HashMap<String, TableName> inCache = new HashMap<String, TableName>();
        for (Names name : this.names) {
            inCache.put(name.nn, TableName.valueOf((String)name.ns, (String)name.tn));
        }
        for (Names name : this.names) {
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((String)name.ns, (String)name.tn), name));
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((byte[])name.nsb, (byte[])name.tnb), name));
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((String)name.nn), name));
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((byte[])name.nnb), name));
            Assert.assertSame(inCache.get(name.nn), (Object)this.validateNames(TableName.valueOf((ByteBuffer)ByteBuffer.wrap(name.nsb), (ByteBuffer)ByteBuffer.wrap(name.tnb)), name));
        }
    }

    private TableName validateNames(TableName expected, Names names) {
        Assert.assertEquals((Object)expected.getNameAsString(), (Object)names.nn);
        Assert.assertArrayEquals((byte[])expected.getName(), (byte[])names.nnb);
        Assert.assertEquals((Object)expected.getQualifierAsString(), (Object)names.tn);
        Assert.assertArrayEquals((byte[])expected.getQualifier(), (byte[])names.tnb);
        Assert.assertEquals((Object)expected.getNamespaceAsString(), (Object)names.ns);
        Assert.assertArrayEquals((byte[])expected.getNamespace(), (byte[])names.nsb);
        return expected;
    }

    class Names {
        String ns;
        byte[] nsb;
        String tn;
        byte[] tnb;
        String nn;
        byte[] nnb;

        Names(String ns, String tn) {
            this.ns = ns;
            this.nsb = ns.getBytes();
            this.tn = tn;
            this.tnb = tn.getBytes();
            this.nn = this.ns + ":" + this.tn;
            this.nnb = this.nn.getBytes();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Names names = (Names)o;
            if (!this.ns.equals(names.ns)) {
                return false;
            }
            return this.tn.equals(names.tn);
        }

        public int hashCode() {
            int result = this.ns.hashCode();
            result = 31 * result + this.tn.hashCode();
            return result;
        }
    }
}

