/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestUsersOperationsWithSecureHadoop {
    @Test
    public void testUserLoginInSecureHadoop() throws Exception {
        UserGroupInformation defaultLogin = UserGroupInformation.getLoginUser();
        Configuration conf = HBaseKerberosUtils.getConfigurationWoPrincipal();
        User.login((Configuration)conf, (String)"hbase.regionserver.keytab.file", (String)"hbase.regionserver.kerberos.principal", (String)"localhost");
        UserGroupInformation failLogin = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"ugi should be the same in case fail login", (boolean)defaultLogin.equals((Object)failLogin));
        Assume.assumeTrue((boolean)HBaseKerberosUtils.isKerberosPropertySetted());
        String nnKeyTab = HBaseKerberosUtils.getKeytabFileForTesting();
        String dnPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        Assert.assertNotNull((String)"KerberosKeytab was not specified", (Object)nnKeyTab);
        Assert.assertNotNull((String)"KerberosPrincipal was not specified", (Object)dnPrincipal);
        conf = HBaseKerberosUtils.getSecuredConfiguration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        User.login((Configuration)conf, (String)"hbase.regionserver.keytab.file", (String)"hbase.regionserver.kerberos.principal", (String)"localhost");
        UserGroupInformation successLogin = UserGroupInformation.getLoginUser();
        Assert.assertFalse((String)"ugi should be different in in case success login", (boolean)defaultLogin.equals((Object)successLogin));
    }
}

