/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapperImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterMetricsWrapper {
    private static final Log LOG = LogFactory.getLog(TestMasterMetricsWrapper.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(1, 4);
    }

    @AfterClass
    public static void teardown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=30000L)
    public void testInfo() {
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        MetricsMasterWrapperImpl info = new MetricsMasterWrapperImpl(master);
        Assert.assertEquals((double)master.getAverageLoad(), (double)info.getAverageLoad(), (double)0.0);
        Assert.assertEquals((Object)master.getClusterId(), (Object)info.getClusterId());
        Assert.assertEquals((long)master.getMasterActiveTime(), (long)info.getActiveTime());
        Assert.assertEquals((long)master.getMasterStartTime(), (long)info.getStartTime());
        Assert.assertEquals((long)master.getCoprocessors().length, (long)info.getCoprocessors().length);
        Assert.assertEquals((long)master.getServerManager().getOnlineServersList().size(), (long)info.getNumRegionServers());
        Assert.assertTrue((info.getNumRegionServers() == 4 ? 1 : 0) != 0);
        String zkServers = info.getZookeeperQuorum();
        Assert.assertEquals((long)zkServers.split(",").length, (long)TEST_UTIL.getZkCluster().getZooKeeperServerNum());
        int index = 3;
        LOG.info((Object)("Stopping " + TEST_UTIL.getMiniHBaseCluster().getRegionServer(3)));
        TEST_UTIL.getMiniHBaseCluster().stopRegionServer(3, false);
        TEST_UTIL.getMiniHBaseCluster().waitOnRegionServer(3);
        while (TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getOnlineServers().size() != 3) {
            Threads.sleep((long)10L);
        }
        Assert.assertTrue((info.getNumRegionServers() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((info.getNumDeadRegionServers() == 1 ? 1 : 0) != 0);
    }
}

