/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class MergeRandomAdjacentRegionsOfTableAction
extends Action {
    private final byte[] tableNameBytes;
    private final String tableName;
    private final long sleepTime;

    public MergeRandomAdjacentRegionsOfTableAction(String tableName) {
        this(-1, tableName);
    }

    public MergeRandomAdjacentRegionsOfTableAction(int sleepTime, String tableName) {
        this.tableNameBytes = Bytes.toBytes((String)tableName);
        this.tableName = tableName;
        this.sleepTime = sleepTime;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        LOG.info((Object)("Performing action: Merge random adjacent regions of table " + this.tableName));
        List regions = admin.getTableRegions(this.tableNameBytes);
        if (regions == null || regions.size() < 2) {
            LOG.info((Object)("Table " + this.tableName + " doesn't have enough regions to merge"));
            return;
        }
        int i = RandomUtils.nextInt((int)(regions.size() - 1));
        HRegionInfo a = (HRegionInfo)regions.get(i++);
        HRegionInfo b = (HRegionInfo)regions.get(i);
        LOG.debug((Object)("Merging " + a.getRegionNameAsString() + " and " + b.getRegionNameAsString()));
        try {
            admin.mergeRegions(a.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), false);
        }
        catch (Exception ex) {
            LOG.warn((Object)("Merge failed, might be caused by other chaos: " + ex.getMessage()));
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

