/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNodeUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;

public class NodesListManager
extends AbstractService
implements EventHandler<NodesListManagerEvent> {
    private static final Log LOG = LogFactory.getLog(NodesListManager.class);
    private HostsFileReader hostsReader;
    private Configuration conf;
    private Set<RMNode> unusableRMNodesConcurrentSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final RMContext rmContext;

    public NodesListManager(RMContext rmContext) {
        super(NodesListManager.class.getName());
        this.rmContext = rmContext;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        try {
            this.hostsReader = new HostsFileReader(conf.get("yarn.resourcemanager.nodes.include-path", ""), conf.get("yarn.resourcemanager.nodes.exclude-path", ""));
            this.printConfiguredHosts();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Failed to init hostsReader, disabling", (Throwable)ioe);
            try {
                this.hostsReader = new HostsFileReader("", "");
            }
            catch (IOException ioe2) {
                this.hostsReader = null;
                throw new YarnRuntimeException((Throwable)ioe2);
            }
        }
        super.serviceInit(conf);
    }

    private void printConfiguredHosts() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)("hostsReader: in=" + this.conf.get("yarn.resourcemanager.nodes.include-path", "") + " out=" + this.conf.get("yarn.resourcemanager.nodes.exclude-path", "")));
        for (String include : this.hostsReader.getHosts()) {
            LOG.debug((Object)("include: " + include));
        }
        for (String exclude : this.hostsReader.getExcludedHosts()) {
            LOG.debug((Object)("exclude: " + exclude));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNodes(Configuration yarnConf) throws IOException {
        HostsFileReader hostsFileReader = this.hostsReader;
        synchronized (hostsFileReader) {
            if (null == yarnConf) {
                yarnConf = new YarnConfiguration();
            }
            this.hostsReader.updateFileNames(yarnConf.get("yarn.resourcemanager.nodes.include-path", ""), yarnConf.get("yarn.resourcemanager.nodes.exclude-path", ""));
            this.hostsReader.refresh();
            this.printConfiguredHosts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidNode(String hostName) {
        HostsFileReader hostsFileReader = this.hostsReader;
        synchronized (hostsFileReader) {
            Set hostsList = this.hostsReader.getHosts();
            Set excludeList = this.hostsReader.getExcludedHosts();
            String ip = NetUtils.normalizeHostName((String)hostName);
            return (hostsList.isEmpty() || hostsList.contains(hostName) || hostsList.contains(ip)) && !excludeList.contains(hostName) && !excludeList.contains(ip);
        }
    }

    public int getUnusableNodes(Collection<RMNode> unUsableNodes) {
        unUsableNodes.addAll(this.unusableRMNodesConcurrentSet);
        return this.unusableRMNodesConcurrentSet.size();
    }

    public void handle(NodesListManagerEvent event) {
        RMNode eventNode = event.getNode();
        switch ((NodesListManagerEventType)event.getType()) {
            case NODE_UNUSABLE: {
                LOG.debug((Object)(eventNode + " reported unusable"));
                this.unusableRMNodesConcurrentSet.add(eventNode);
                for (RMApp app : this.rmContext.getRMApps().values()) {
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppNodeUpdateEvent(app.getApplicationId(), eventNode, RMAppNodeUpdateEvent.RMAppNodeUpdateType.NODE_UNUSABLE));
                }
                break;
            }
            case NODE_USABLE: {
                if (this.unusableRMNodesConcurrentSet.contains(eventNode)) {
                    LOG.debug((Object)(eventNode + " reported usable"));
                    this.unusableRMNodesConcurrentSet.remove(eventNode);
                    for (RMApp app : this.rmContext.getRMApps().values()) {
                        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppNodeUpdateEvent(app.getApplicationId(), eventNode, RMAppNodeUpdateEvent.RMAppNodeUpdateType.NODE_USABLE));
                    }
                    break;
                }
                LOG.warn((Object)(eventNode + " reported usable without first reporting unusable"));
                break;
            }
            default: {
                LOG.error((Object)("Ignoring invalid eventtype " + event.getType()));
            }
        }
    }
}

