/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.FSDownload;
import org.apache.hadoop.yarn.util.TestFSDownload;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestFSDownload {
    private static final Log LOG = LogFactory.getLog(TestFSDownload.class);
    private static AtomicLong uniqueNumberGenerator = new AtomicLong(System.currentTimeMillis());
    static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @AfterClass
    public static void deleteTestDir() throws IOException {
        FileContext fs = FileContext.getLocalFSFileContext();
        fs.delete(new Path("target", TestFSDownload.class.getSimpleName()), true);
    }

    static LocalResource createFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException {
        TestFSDownload.createFile((FileContext)files, (Path)p, (int)len, (Random)r);
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(ConverterUtils.getYarnUrlFromPath((Path)p));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.FILE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(p).getModificationTime());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createFile(FileContext files, Path p, int len, Random r) throws IOException {
        FSDataOutputStream out = null;
        try {
            byte[] bytes = new byte[len];
            out = files.create(p, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
            r.nextBytes(bytes);
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    static LocalResource createJar(FileContext files, Path p, LocalResourceVisibility vis) throws IOException {
        LOG.info((Object)("Create jar file " + p));
        File jarFile = new File(files.makeQualified(p).toUri());
        FileOutputStream stream = new FileOutputStream(jarFile);
        LOG.info((Object)"Create jar out stream ");
        JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
        LOG.info((Object)"Done writing jar stream ");
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(ConverterUtils.getYarnUrlFromPath((Path)p));
        FileStatus status = files.getFileStatus(p);
        ret.setSize(status.getLen());
        ret.setTimestamp(status.getModificationTime());
        ret.setType(LocalResourceType.PATTERN);
        ret.setVisibility(vis);
        ret.setPattern("classes/.*");
        return ret;
    }

    static LocalResource createTarFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException, URISyntaxException {
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        File archiveFile = new File(p.toUri().getPath() + ".tar");
        archiveFile.createNewFile();
        TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new FileOutputStream(archiveFile));
        TarArchiveEntry entry = new TarArchiveEntry(p.getName());
        entry.setSize((long)bytes.length);
        out.putArchiveEntry((ArchiveEntry)entry);
        out.write(bytes);
        out.closeArchiveEntry();
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(ConverterUtils.getYarnUrlFromPath((Path)new Path(p.toString() + ".tar")));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.ARCHIVE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(new Path(p.toString() + ".tar")).getModificationTime());
        return ret;
    }

    static LocalResource createTgzFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException, URISyntaxException {
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        File gzipFile = new File(p.toUri().getPath() + ".tar.gz");
        gzipFile.createNewFile();
        TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(gzipFile)));
        TarArchiveEntry entry = new TarArchiveEntry(p.getName());
        entry.setSize((long)bytes.length);
        out.putArchiveEntry((ArchiveEntry)entry);
        out.write(bytes);
        out.closeArchiveEntry();
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(ConverterUtils.getYarnUrlFromPath((Path)new Path(p.toString() + ".tar.gz")));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.ARCHIVE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(new Path(p.toString() + ".tar.gz")).getModificationTime());
        return ret;
    }

    static LocalResource createJarFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException, URISyntaxException {
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        File archiveFile = new File(p.toUri().getPath() + ".jar");
        archiveFile.createNewFile();
        JarOutputStream out = new JarOutputStream(new FileOutputStream(archiveFile));
        out.putNextEntry(new JarEntry(p.getName()));
        out.write(bytes);
        out.closeEntry();
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(ConverterUtils.getYarnUrlFromPath((Path)new Path(p.toString() + ".jar")));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.ARCHIVE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(new Path(p.toString() + ".jar")).getModificationTime());
        return ret;
    }

    static LocalResource createZipFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException, URISyntaxException {
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        File archiveFile = new File(p.toUri().getPath() + ".zip");
        archiveFile.createNewFile();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(archiveFile));
        out.putNextEntry(new ZipEntry(p.getName()));
        out.write(bytes);
        out.closeEntry();
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(ConverterUtils.getYarnUrlFromPath((Path)new Path(p.toString() + ".zip")));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.ARCHIVE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(new Path(p.toString() + ".zip")).getModificationTime());
        return ret;
    }

    @Test(timeout=10000L)
    public void testDownloadBadPublic() throws IOException, URISyntaxException, InterruptedException {
        Configuration conf = new Configuration();
        conf.set("fs.permissions.umask-mode", "077");
        FileContext files = FileContext.getLocalFSFileContext((Configuration)conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        HashMap<LocalResource, LocalResourceVisibility> rsrcVis = new HashMap<LocalResource, LocalResourceVisibility>();
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        System.out.println("SEED: " + sharedSeed);
        HashMap pending = new HashMap();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        int size = 512;
        LocalResourceVisibility vis = LocalResourceVisibility.PUBLIC;
        Path path = new Path(basedir, "test-file");
        LocalResource rsrc = TestFSDownload.createFile((FileContext)files, (Path)path, (int)size, (Random)rand, (LocalResourceVisibility)vis);
        rsrcVis.put(rsrc, vis);
        Path destPath = dirs.getLocalPathForWrite(basedir.toString(), (long)size, conf);
        destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
        FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), conf, destPath, rsrc);
        pending.put(rsrc, exec.submit(fsd));
        exec.shutdown();
        while (!exec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        Assert.assertTrue((boolean)((Future)pending.get(rsrc)).isDone());
        try {
            for (Map.Entry p : pending.entrySet()) {
                ((Future)p.getValue()).get();
                Assert.fail((String)"We localized a file that is not public.");
            }
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDownloadPublicWithStatCache() throws IOException, URISyntaxException, InterruptedException, ExecutionException {
        Configuration conf = new Configuration();
        FileContext files = FileContext.getLocalFSFileContext((Configuration)conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        FileSystem f = basedir.getFileSystem(conf);
        Assume.assumeTrue((boolean)FSDownload.ancestorsHaveExecutePermissions((FileSystem)f, (Path)basedir, null));
        files.mkdir(basedir, null, true);
        conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        int size = 512;
        ConcurrentHashMap counts = new ConcurrentHashMap();
        CacheLoader loader = FSDownload.createStatusCacheLoader((Configuration)conf);
        LoadingCache statCache = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
        int fileCount = 3;
        ArrayList<2> tasks = new ArrayList<2>();
        for (int i = 0; i < 3; ++i) {
            Random rand = new Random();
            long sharedSeed = rand.nextLong();
            rand.setSeed(sharedSeed);
            System.out.println("SEED: " + sharedSeed);
            Path path = new Path(basedir, "test-file-" + i);
            TestFSDownload.createFile((FileContext)files, (Path)path, (int)size, (Random)rand);
            FileSystem fs = path.getFileSystem(conf);
            FileStatus sStat = fs.getFileStatus(path);
            tasks.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        ExecutorService exec = Executors.newFixedThreadPool(3);
        try {
            List futures = exec.invokeAll(tasks);
            for (Future future : futures) {
                Assert.assertTrue((boolean)((Boolean)future.get()));
            }
            for (AtomicInteger count : counts.values()) {
                Assert.assertSame((Object)count.get(), (Object)1);
            }
        }
        finally {
            exec.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=10000L)
    public void testDownload() throws IOException, URISyntaxException, InterruptedException {
        Configuration conf = new Configuration();
        conf.set("fs.permissions.umask-mode", "077");
        FileContext files = FileContext.getLocalFSFileContext((Configuration)conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        HashMap<LocalResource, void> rsrcVis = new HashMap<LocalResource, void>();
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        System.out.println("SEED: " + sharedSeed);
        HashMap pending = new HashMap();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        int[] sizes = new int[10];
        for (int i = 0; i < 10; ++i) {
            void var13_14;
            sizes[i] = rand.nextInt(512) + 512;
            LocalResourceVisibility localResourceVisibility = LocalResourceVisibility.PRIVATE;
            if (i % 2 == 1) {
                LocalResourceVisibility localResourceVisibility2 = LocalResourceVisibility.APPLICATION;
            }
            Path p = new Path(basedir, "" + i);
            LocalResource rsrc = TestFSDownload.createFile((FileContext)files, (Path)p, (int)sizes[i], (Random)rand, (LocalResourceVisibility)var13_14);
            rsrcVis.put(rsrc, var13_14);
            Path destPath = dirs.getLocalPathForWrite(basedir.toString(), (long)sizes[i], conf);
            destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
            FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), conf, destPath, rsrc);
            pending.put(rsrc, exec.submit(fsd));
        }
        exec.shutdown();
        while (!exec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        for (Future future : pending.values()) {
            Assert.assertTrue((boolean)future.isDone());
        }
        try {
            for (Map.Entry entry : pending.entrySet()) {
                Path localized = (Path)((Future)entry.getValue()).get();
                Assert.assertEquals((long)sizes[Integer.valueOf(localized.getName())], (long)((LocalResource)entry.getKey()).getSize());
                FileStatus status = files.getFileStatus(localized.getParent());
                FsPermission perm = status.getPermission();
                Assert.assertEquals((String)"Cache directory permissions are incorrect", (Object)new FsPermission(493), (Object)perm);
                status = files.getFileStatus(localized);
                perm = status.getPermission();
                System.out.println("File permission " + perm + " for rsrc vis " + ((LocalResource)entry.getKey()).getVisibility().name());
                assert (rsrcVis.containsKey(entry.getKey()));
                Assert.assertTrue((String)"Private file should be 500", (perm.toShort() == FSDownload.PRIVATE_FILE_PERMS.toShort() ? 1 : 0) != 0);
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Failed exec", e);
        }
    }

    private void downloadWithFileType(TEST_FILE_TYPE fileType) throws IOException, URISyntaxException, InterruptedException {
        Configuration conf = new Configuration();
        conf.set("fs.permissions.umask-mode", "077");
        FileContext files = FileContext.getLocalFSFileContext((Configuration)conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        System.out.println("SEED: " + sharedSeed);
        HashMap pending = new HashMap();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        int size = rand.nextInt(512) + 512;
        LocalResourceVisibility vis = LocalResourceVisibility.PRIVATE;
        Path p = new Path(basedir, "1");
        LocalResource rsrc = null;
        switch (3.$SwitchMap$org$apache$hadoop$yarn$util$TestFSDownload$TEST_FILE_TYPE[fileType.ordinal()]) {
            case 1: {
                rsrc = TestFSDownload.createTarFile((FileContext)files, (Path)p, (int)size, (Random)rand, (LocalResourceVisibility)vis);
                break;
            }
            case 2: {
                rsrc = TestFSDownload.createJarFile((FileContext)files, (Path)p, (int)size, (Random)rand, (LocalResourceVisibility)vis);
                rsrc.setType(LocalResourceType.PATTERN);
                break;
            }
            case 3: {
                rsrc = TestFSDownload.createZipFile((FileContext)files, (Path)p, (int)size, (Random)rand, (LocalResourceVisibility)vis);
                break;
            }
            case 4: {
                rsrc = TestFSDownload.createTgzFile((FileContext)files, (Path)p, (int)size, (Random)rand, (LocalResourceVisibility)vis);
            }
        }
        Path destPath = dirs.getLocalPathForWrite(basedir.toString(), (long)size, conf);
        destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
        FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), conf, destPath, rsrc);
        pending.put(rsrc, exec.submit(fsd));
        exec.shutdown();
        while (!exec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        Assert.assertTrue((boolean)((Future)pending.get(rsrc)).isDone());
        try {
            FileStatus[] filesstatus;
            for (FileStatus filestatus : filesstatus = files.getDefaultFileSystem().listStatus(basedir)) {
                FileStatus[] childFiles;
                if (!filestatus.isDirectory()) continue;
                for (FileStatus childfile : childFiles = files.getDefaultFileSystem().listStatus(filestatus.getPath())) {
                    if (!childfile.getPath().getName().startsWith("tmp")) continue;
                    Assert.fail((String)("Tmp File should not have been there " + childfile.getPath()));
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed exec", e);
        }
    }

    @Test(timeout=10000L)
    public void testDownloadArchive() throws IOException, URISyntaxException, InterruptedException {
        this.downloadWithFileType(TEST_FILE_TYPE.TAR);
    }

    @Test(timeout=10000L)
    public void testDownloadPatternJar() throws IOException, URISyntaxException, InterruptedException {
        this.downloadWithFileType(TEST_FILE_TYPE.JAR);
    }

    @Test(timeout=10000L)
    public void testDownloadArchiveZip() throws IOException, URISyntaxException, InterruptedException {
        this.downloadWithFileType(TEST_FILE_TYPE.ZIP);
    }

    @Test(timeout=10000L)
    public void testDownloadArchiveTgz() throws IOException, URISyntaxException, InterruptedException {
        this.downloadWithFileType(TEST_FILE_TYPE.TGZ);
    }

    private void verifyPermsRecursively(FileSystem fs, FileContext files, Path p, LocalResourceVisibility vis) throws IOException {
        FileStatus status = files.getFileStatus(p);
        if (status.isDirectory()) {
            if (vis == LocalResourceVisibility.PUBLIC) {
                Assert.assertTrue((status.getPermission().toShort() == FSDownload.PUBLIC_DIR_PERMS.toShort() ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((status.getPermission().toShort() == FSDownload.PRIVATE_DIR_PERMS.toShort() ? 1 : 0) != 0);
            }
            if (!status.isSymlink()) {
                FileStatus[] statuses;
                for (FileStatus stat : statuses = fs.listStatus(p)) {
                    this.verifyPermsRecursively(fs, files, stat.getPath(), vis);
                }
            }
        } else if (vis == LocalResourceVisibility.PUBLIC) {
            Assert.assertTrue((status.getPermission().toShort() == FSDownload.PUBLIC_FILE_PERMS.toShort() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((status.getPermission().toShort() == FSDownload.PRIVATE_FILE_PERMS.toShort() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=10000L)
    public void testDirDownload() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        FileContext files = FileContext.getLocalFSFileContext((Configuration)conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        HashMap<LocalResource, void> rsrcVis = new HashMap<LocalResource, void>();
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        System.out.println("SEED: " + sharedSeed);
        HashMap pending = new HashMap();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        for (int i = 0; i < 5; ++i) {
            void var12_13;
            LocalResourceVisibility localResourceVisibility = LocalResourceVisibility.PRIVATE;
            if (i % 2 == 1) {
                LocalResourceVisibility localResourceVisibility2 = LocalResourceVisibility.APPLICATION;
            }
            Path p = new Path(basedir, "dir" + i + ".jar");
            LocalResource rsrc = TestFSDownload.createJar((FileContext)files, (Path)p, (LocalResourceVisibility)var12_13);
            rsrcVis.put(rsrc, var12_13);
            Path destPath = dirs.getLocalPathForWrite(basedir.toString(), conf);
            destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
            FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), conf, destPath, rsrc);
            pending.put(rsrc, exec.submit(fsd));
        }
        exec.shutdown();
        while (!exec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        for (Future future : pending.values()) {
            Assert.assertTrue((boolean)future.isDone());
        }
        try {
            for (Map.Entry entry : pending.entrySet()) {
                Path localized = (Path)((Future)entry.getValue()).get();
                FileStatus status = files.getFileStatus(localized);
                System.out.println("Testing path " + localized);
                assert (status.isDirectory());
                assert (rsrcVis.containsKey(entry.getKey()));
                this.verifyPermsRecursively(localized.getFileSystem(conf), files, localized, (LocalResourceVisibility)rsrcVis.get(entry.getKey()));
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Failed exec", e);
        }
    }

    @Test(timeout=10000L)
    public void testUniqueDestinationPath() throws Exception {
        Configuration conf = new Configuration();
        FileContext files = FileContext.getLocalFSFileContext((Configuration)conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        ExecutorService singleThreadedExec = Executors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        Path destPath = dirs.getLocalPathForWrite(basedir.toString(), conf);
        destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
        Path p = new Path(basedir, "dir0.jar");
        LocalResourceVisibility vis = LocalResourceVisibility.PRIVATE;
        LocalResource rsrc = TestFSDownload.createJar((FileContext)files, (Path)p, (LocalResourceVisibility)vis);
        FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), conf, destPath, rsrc);
        Future rPath = singleThreadedExec.submit(fsd);
        singleThreadedExec.shutdown();
        while (!singleThreadedExec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        Assert.assertTrue((boolean)rPath.isDone());
        Assert.assertEquals((Object)destPath, (Object)((Path)rPath.get()).getParent());
    }
}

