/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeJspHelper;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.NamenodeJspHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ServletUtil;
import org.znerd.xmlenc.XMLOutputter;

@InterfaceAudience.Private
public class FileChecksumServlets {

    @InterfaceAudience.Private
    public static class GetServlet
    extends DfsServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            String path = ServletUtil.getDecodedPath((HttpServletRequest)request, (String)"/getFileChecksum");
            XMLOutputter xml = new XMLOutputter((Writer)out, "UTF-8");
            xml.declaration();
            ServletContext context = this.getServletContext();
            DataNode datanode = (DataNode)context.getAttribute("datanode");
            HdfsConfiguration conf = new HdfsConfiguration(datanode.getConf());
            try {
                DFSClient dfs = DatanodeJspHelper.getDFSClient(request, datanode, conf, this.getUGI(request, conf));
                MD5MD5CRC32FileChecksum checksum = dfs.getFileChecksum(path);
                MD5MD5CRC32FileChecksum.write((XMLOutputter)xml, (MD5MD5CRC32FileChecksum)checksum);
            }
            catch (IOException ioe) {
                this.writeXml(ioe, path, xml);
            }
            catch (InterruptedException e) {
                this.writeXml(e, path, xml);
            }
            xml.endDocument();
        }
    }

    @InterfaceAudience.Private
    public static class RedirectServlet
    extends DfsServlet {
        private static final long serialVersionUID = 1L;

        private URL createRedirectURL(UserGroupInformation ugi, DatanodeID host, HttpServletRequest request, NameNode nn) throws IOException {
            String hostname = host instanceof DatanodeInfo ? ((DatanodeInfo)host).getHostName() : host.getIpAddr();
            String scheme = request.getScheme();
            int port = "https".equals(scheme) ? ((Integer)this.getServletContext().getAttribute("datanode.https.port")).intValue() : host.getInfoPort();
            String encodedPath = ServletUtil.getRawPath((HttpServletRequest)request, (String)"/fileChecksum");
            String dtParam = "";
            if (UserGroupInformation.isSecurityEnabled()) {
                String tokenString = ((Token)ugi.getTokens().iterator().next()).encodeToUrlString();
                dtParam = JspHelper.getDelegationTokenUrlParam(tokenString);
            }
            String addr = nn.getNameNodeAddressHostPortString();
            String addrParam = JspHelper.getUrlParam("nnaddr", addr);
            return new URL(scheme, hostname, port, "/getFileChecksum" + encodedPath + '?' + "ugi=" + ServletUtil.encodeQueryValue((String)ugi.getShortUserName()) + dtParam + addrParam);
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ServletContext context = this.getServletContext();
            Configuration conf = NameNodeHttpServer.getConfFromContext(context);
            UserGroupInformation ugi = this.getUGI(request, conf);
            NameNode namenode = NameNodeHttpServer.getNameNodeFromContext(context);
            DatanodeDescriptor datanode = NamenodeJspHelper.getRandomDatanode(namenode);
            try {
                response.sendRedirect(this.createRedirectURL(ugi, datanode, request, namenode).toString());
            }
            catch (IOException e) {
                response.sendError(400, e.getMessage());
            }
        }
    }
}

