/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ClientId;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcClientException;
import org.apache.hadoop.ipc.RpcConstants;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.IpcConnectionContextProtos;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ProtoUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;

public class Client {
    public static final Log LOG = LogFactory.getLog(Client.class);
    private static final AtomicInteger callIdCounter = new AtomicInteger();
    private static final ThreadLocal<Integer> callId = new ThreadLocal();
    private static final ThreadLocal<Integer> retryCount = new ThreadLocal();
    private Hashtable<ConnectionId, Connection> connections = new Hashtable();
    private Class<? extends Writable> valueClass;
    private AtomicBoolean running = new AtomicBoolean(true);
    private final Configuration conf;
    private SocketFactory socketFactory;
    private int refCount = 1;
    private final int connectionTimeout;
    private final boolean fallbackAllowed;
    private final byte[] clientId;
    static final int CONNECTION_CONTEXT_CALL_ID = -3;
    private final ExecutorService sendParamsExecutor;
    private static final ClientExecutorServiceFactory clientExcecutorFactory = new ClientExecutorServiceFactory();

    public static void setCallIdAndRetryCount(int cid, int rc) {
        Preconditions.checkArgument((cid != -2 ? 1 : 0) != 0);
        Preconditions.checkState((callId.get() == null ? 1 : 0) != 0);
        Preconditions.checkArgument((rc != -1 ? 1 : 0) != 0);
        callId.set(cid);
        retryCount.set(rc);
    }

    public static final void setPingInterval(Configuration conf, int pingInterval) {
        conf.setInt("ipc.ping.interval", pingInterval);
    }

    public static final int getPingInterval(Configuration conf) {
        return conf.getInt("ipc.ping.interval", 60000);
    }

    public static final int getTimeout(Configuration conf) {
        if (!conf.getBoolean("ipc.client.ping", true)) {
            return Client.getPingInterval(conf);
        }
        return -1;
    }

    public static final void setConnectTimeout(Configuration conf, int timeout) {
        conf.setInt("ipc.client.connect.timeout", timeout);
    }

    synchronized void incCount() {
        ++this.refCount;
    }

    synchronized void decCount() {
        --this.refCount;
    }

    synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    void checkResponse(RpcHeaderProtos.RpcResponseHeaderProto header) throws IOException {
        byte[] id;
        if (header == null) {
            throw new IOException("Response is null.");
        }
        if (header.hasClientId() && !Arrays.equals(id = header.getClientId().toByteArray(), RpcConstants.DUMMY_CLIENT_ID) && !Arrays.equals(id, this.clientId)) {
            throw new IOException("Client IDs not matched: local ID=" + StringUtils.byteToHexString(this.clientId) + ", ID in response=" + StringUtils.byteToHexString(header.getClientId().toByteArray()));
        }
    }

    Call createCall(RPC.RpcKind rpcKind, Writable rpcRequest) {
        return new Call(rpcKind, rpcRequest);
    }

    public Client(Class<? extends Writable> valueClass, Configuration conf, SocketFactory factory) {
        this.valueClass = valueClass;
        this.conf = conf;
        this.socketFactory = factory;
        this.connectionTimeout = conf.getInt("ipc.client.connect.timeout", 20000);
        this.fallbackAllowed = conf.getBoolean("ipc.client.fallback-to-simple-auth-allowed", false);
        this.clientId = ClientId.getClientId();
        this.sendParamsExecutor = clientExcecutorFactory.refAndGetInstance();
    }

    public Client(Class<? extends Writable> valueClass, Configuration conf) {
        this(valueClass, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        Hashtable<ConnectionId, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        clientExcecutorFactory.unrefAndCleanup();
    }

    public Writable call(Writable param, InetSocketAddress address) throws IOException {
        return this.call(RPC.RpcKind.RPC_BUILTIN, param, address);
    }

    @Deprecated
    public Writable call(RPC.RpcKind rpcKind, Writable param, InetSocketAddress address) throws IOException {
        return this.call(rpcKind, param, address, null);
    }

    @Deprecated
    public Writable call(RPC.RpcKind rpcKind, Writable param, InetSocketAddress addr, UserGroupInformation ticket) throws IOException {
        ConnectionId remoteId = ConnectionId.getConnectionId(addr, null, ticket, 0, this.conf);
        return this.call(rpcKind, param, remoteId);
    }

    @Deprecated
    public Writable call(RPC.RpcKind rpcKind, Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout) throws IOException {
        ConnectionId remoteId = ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, this.conf);
        return this.call(rpcKind, param, remoteId);
    }

    public Writable call(Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, Configuration conf) throws IOException {
        ConnectionId remoteId = ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, conf);
        return this.call(RPC.RpcKind.RPC_BUILTIN, param, remoteId);
    }

    public Writable call(Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, int serviceClass, Configuration conf) throws IOException {
        ConnectionId remoteId = ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, conf);
        return this.call(RPC.RpcKind.RPC_BUILTIN, param, remoteId, serviceClass);
    }

    public Writable call(RPC.RpcKind rpcKind, Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, Configuration conf) throws IOException {
        ConnectionId remoteId = ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, conf);
        return this.call(rpcKind, param, remoteId);
    }

    public Writable call(Writable param, ConnectionId remoteId) throws IOException {
        return this.call(RPC.RpcKind.RPC_BUILTIN, param, remoteId);
    }

    public Writable call(RPC.RpcKind rpcKind, Writable rpcRequest, ConnectionId remoteId) throws IOException {
        return this.call(rpcKind, rpcRequest, remoteId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable call(RPC.RpcKind rpcKind, Writable rpcRequest, ConnectionId remoteId, int serviceClass) throws IOException {
        Call call = this.createCall(rpcKind, rpcRequest);
        Connection connection = this.getConnection(remoteId, call, serviceClass);
        try {
            connection.sendRpcRequest(call);
        }
        catch (RejectedExecutionException e) {
            throw new IOException("connection has been closed", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn((Object)"interrupted waiting to send rpc request to server", (Throwable)e);
            throw new IOException(e);
        }
        boolean interrupted = false;
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                try {
                    call.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (call.error != null) {
                if (call.error instanceof RemoteException) {
                    call.error.fillInStackTrace();
                    throw call.error;
                }
                InetSocketAddress address = connection.getRemoteAddress();
                throw NetUtils.wrapException(address.getHostName(), address.getPort(), NetUtils.getHostname(), 0, call.error);
            }
            return call.getRpcResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    Set<ConnectionId> getConnectionIds() {
        Hashtable<ConnectionId, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            return this.connections.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(ConnectionId remoteId, Call call, int serviceClass) throws IOException {
        Connection connection;
        if (!this.running.get()) {
            throw new IOException("The client is stopped");
        }
        do {
            Hashtable<ConnectionId, Connection> hashtable = this.connections;
            synchronized (hashtable) {
                connection = this.connections.get(remoteId);
                if (connection == null) {
                    connection = new Connection(remoteId, serviceClass);
                    this.connections.put(remoteId, connection);
                }
            }
        } while (!connection.addCall(call));
        connection.setupIOstreams();
        return connection;
    }

    public static int nextCallId() {
        return callIdCounter.getAndIncrement() & Integer.MAX_VALUE;
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    @InterfaceStability.Evolving
    public static class ConnectionId {
        InetSocketAddress address;
        UserGroupInformation ticket;
        final Class<?> protocol;
        private static final int PRIME = 16777619;
        private final int rpcTimeout;
        private final int maxIdleTime;
        private final RetryPolicy connectionRetryPolicy;
        private final int maxRetriesOnSasl;
        private final int maxRetriesOnSocketTimeouts;
        private final boolean tcpNoDelay;
        private final boolean doPing;
        private final int pingInterval;
        private String saslQop;
        private final Configuration conf;

        ConnectionId(InetSocketAddress address, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, RetryPolicy connectionRetryPolicy, Configuration conf) {
            this.protocol = protocol;
            this.address = address;
            this.ticket = ticket;
            this.rpcTimeout = rpcTimeout;
            this.connectionRetryPolicy = connectionRetryPolicy;
            this.maxIdleTime = conf.getInt("ipc.client.connection.maxidletime", 10000);
            this.maxRetriesOnSasl = conf.getInt("ipc.client.connect.max.retries.on.sasl", 5);
            this.maxRetriesOnSocketTimeouts = conf.getInt("ipc.client.connect.max.retries.on.timeouts", 45);
            this.tcpNoDelay = conf.getBoolean("ipc.client.tcpnodelay", false);
            this.doPing = conf.getBoolean("ipc.client.ping", true);
            this.pingInterval = this.doPing ? Client.getPingInterval(conf) : 0;
            this.conf = conf;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        Class<?> getProtocol() {
            return this.protocol;
        }

        UserGroupInformation getTicket() {
            return this.ticket;
        }

        private int getRpcTimeout() {
            return this.rpcTimeout;
        }

        int getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public int getMaxRetriesOnSasl() {
            return this.maxRetriesOnSasl;
        }

        public int getMaxRetriesOnSocketTimeouts() {
            return this.maxRetriesOnSocketTimeouts;
        }

        boolean getTcpNoDelay() {
            return this.tcpNoDelay;
        }

        boolean getDoPing() {
            return this.doPing;
        }

        int getPingInterval() {
            return this.pingInterval;
        }

        @VisibleForTesting
        String getSaslQop() {
            return this.saslQop;
        }

        static ConnectionId getConnectionId(InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, Configuration conf) throws IOException {
            return ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, null, conf);
        }

        static ConnectionId getConnectionId(InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, RetryPolicy connectionRetryPolicy, Configuration conf) throws IOException {
            if (connectionRetryPolicy == null) {
                int max = conf.getInt("ipc.client.connect.max.retries", 10);
                int retryInterval = conf.getInt("ipc.client.connect.retry.interval", 1000);
                connectionRetryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(max, retryInterval, TimeUnit.MILLISECONDS);
            }
            return new ConnectionId(addr, protocol, ticket, rpcTimeout, connectionRetryPolicy, conf);
        }

        static boolean isEqual(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ConnectionId) {
                ConnectionId that = (ConnectionId)obj;
                return ConnectionId.isEqual(this.address, that.address) && this.doPing == that.doPing && this.maxIdleTime == that.maxIdleTime && ConnectionId.isEqual(this.connectionRetryPolicy, that.connectionRetryPolicy) && this.pingInterval == that.pingInterval && ConnectionId.isEqual(this.protocol, that.protocol) && this.rpcTimeout == that.rpcTimeout && this.tcpNoDelay == that.tcpNoDelay && ConnectionId.isEqual(this.ticket, that.ticket);
            }
            return false;
        }

        public int hashCode() {
            int result = this.connectionRetryPolicy.hashCode();
            result = 16777619 * result + (this.address == null ? 0 : this.address.hashCode());
            result = 16777619 * result + (this.doPing ? 1231 : 1237);
            result = 16777619 * result + this.maxIdleTime;
            result = 16777619 * result + this.pingInterval;
            result = 16777619 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            result = 16777619 * result + this.rpcTimeout;
            result = 16777619 * result + (this.tcpNoDelay ? 1231 : 1237);
            result = 16777619 * result + (this.ticket == null ? 0 : this.ticket.hashCode());
            return result;
        }

        public String toString() {
            return this.address.toString();
        }
    }

    private class Connection
    extends Thread {
        private InetSocketAddress server;
        private final ConnectionId remoteId;
        private SaslRpcServer.AuthMethod authMethod;
        private Server.AuthProtocol authProtocol;
        private int serviceClass;
        private SaslRpcClient saslRpcClient;
        private Socket socket = null;
        private DataInputStream in;
        private DataOutputStream out;
        private int rpcTimeout;
        private int maxIdleTime;
        private final RetryPolicy connectionRetryPolicy;
        private final int maxRetriesOnSasl;
        private int maxRetriesOnSocketTimeouts;
        private boolean tcpNoDelay;
        private boolean doPing;
        private int pingInterval;
        private ByteArrayOutputStream pingRequest;
        private Hashtable<Integer, Call> calls = new Hashtable();
        private AtomicLong lastActivity = new AtomicLong();
        private AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        private IOException closeException;
        private final Object sendRpcRequestLock = new Object();

        public Connection(ConnectionId remoteId, int serviceClass) throws IOException {
            this.remoteId = remoteId;
            this.server = remoteId.getAddress();
            if (this.server.isUnresolved()) {
                throw NetUtils.wrapException(this.server.getHostName(), this.server.getPort(), null, 0, new UnknownHostException());
            }
            this.rpcTimeout = remoteId.getRpcTimeout();
            this.maxIdleTime = remoteId.getMaxIdleTime();
            this.connectionRetryPolicy = remoteId.connectionRetryPolicy;
            this.maxRetriesOnSasl = remoteId.getMaxRetriesOnSasl();
            this.maxRetriesOnSocketTimeouts = remoteId.getMaxRetriesOnSocketTimeouts();
            this.tcpNoDelay = remoteId.getTcpNoDelay();
            this.doPing = remoteId.getDoPing();
            if (this.doPing) {
                this.pingRequest = new ByteArrayOutputStream();
                RpcHeaderProtos.RpcRequestHeaderProto pingHeader = ProtoUtil.makeRpcRequestHeader(RPC.RpcKind.RPC_PROTOCOL_BUFFER, RpcHeaderProtos.RpcRequestHeaderProto.OperationProto.RPC_FINAL_PACKET, -4, -1, Client.this.clientId);
                pingHeader.writeDelimitedTo(this.pingRequest);
            }
            this.pingInterval = remoteId.getPingInterval();
            this.serviceClass = serviceClass;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The ping interval is " + this.pingInterval + " ms."));
            }
            UserGroupInformation ticket = remoteId.getTicket();
            boolean trySasl = UserGroupInformation.isSecurityEnabled() || ticket != null && !ticket.getTokens().isEmpty();
            this.authProtocol = trySasl ? Server.AuthProtocol.SASL : Server.AuthProtocol.NONE;
            this.setName("IPC Client (" + Client.this.socketFactory.hashCode() + ") connection to " + this.server.toString() + " from " + (ticket == null ? "an unknown user" : ticket.getUserName()));
            this.setDaemon(true);
        }

        private void touch() {
            this.lastActivity.set(Time.now());
        }

        private synchronized boolean addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            this.calls.put(call.id, call);
            this.notify();
            return true;
        }

        private synchronized void disposeSasl() {
            if (this.saslRpcClient != null) {
                try {
                    this.saslRpcClient.dispose();
                    this.saslRpcClient = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUser = currentUser.getRealUser();
            return this.authMethod == SaslRpcServer.AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals(currentUser) || loginUser.equals(realUser));
        }

        private synchronized SaslRpcServer.AuthMethod setupSaslConnection(InputStream in2, OutputStream out2) throws IOException {
            this.saslRpcClient = new SaslRpcClient(this.remoteId.getTicket(), this.remoteId.getProtocol(), this.remoteId.getAddress(), this.remoteId.conf);
            return this.saslRpcClient.saslConnect(in2, out2);
        }

        private synchronized boolean updateAddress() throws IOException {
            InetSocketAddress currentAddr = NetUtils.createSocketAddrForHost(this.server.getHostName(), this.server.getPort());
            if (!this.server.equals(currentAddr)) {
                LOG.warn((Object)("Address change detected. Old: " + this.server.toString() + " New: " + currentAddr.toString()));
                this.server = currentAddr;
                return true;
            }
            return false;
        }

        private synchronized void setupConnection() throws IOException {
            int ioFailures = 0;
            int timeoutFailures = 0;
            while (true) {
                try {
                    String host;
                    InetAddress localAddr;
                    KerberosInfo krbInfo;
                    this.socket = Client.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(this.tcpNoDelay);
                    this.socket.setKeepAlive(true);
                    UserGroupInformation ticket = this.remoteId.getTicket();
                    if (ticket != null && ticket.hasKerberosCredentials() && (krbInfo = this.remoteId.getProtocol().getAnnotation(KerberosInfo.class)) != null && krbInfo.clientPrincipal() != null && (localAddr = NetUtils.getLocalInetAddress(host = SecurityUtil.getHostFromPrincipal(this.remoteId.getTicket().getUserName()))) != null) {
                        this.socket.bind(new InetSocketAddress(localAddr, 0));
                    }
                    NetUtils.connect(this.socket, this.server, Client.this.connectionTimeout);
                    if (this.rpcTimeout > 0) {
                        this.pingInterval = this.rpcTimeout;
                    }
                    this.socket.setSoTimeout(this.pingInterval);
                    return;
                }
                catch (ConnectTimeoutException toe) {
                    if (this.updateAddress()) {
                        ioFailures = 0;
                        timeoutFailures = 0;
                    }
                    int n = timeoutFailures;
                    timeoutFailures = (short)(timeoutFailures + 1);
                    this.handleConnectionTimeout(n, this.maxRetriesOnSocketTimeouts, toe);
                    continue;
                }
                catch (IOException ie) {
                    if (this.updateAddress()) {
                        ioFailures = 0;
                        timeoutFailures = 0;
                    }
                    int n = ioFailures;
                    ioFailures = (short)(ioFailures + 1);
                    this.handleConnectionFailure(n, ie);
                    continue;
                }
                break;
            }
        }

        private synchronized void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, final Random rand, UserGroupInformation ugi) throws IOException, InterruptedException {
            ugi.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    int MAX_BACKOFF = 5000;
                    Connection.this.closeConnection();
                    Connection.this.disposeSasl();
                    if (Connection.this.shouldAuthenticateOverKrb()) {
                        if (currRetries < maxRetries) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                            }
                            if (UserGroupInformation.isLoginKeytabBased()) {
                                UserGroupInformation.getLoginUser().reloginFromKeytab();
                            } else if (UserGroupInformation.isLoginTicketBased()) {
                                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                            }
                            Thread.sleep(rand.nextInt(5000) + 1);
                            return null;
                        }
                        String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + Connection.this.remoteId;
                        LOG.warn((Object)msg);
                        throw (IOException)new IOException(msg).initCause(ex);
                    }
                    LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)ex;
                    }
                    throw new IOException(ex);
                }
            });
        }

        private synchronized void setupIOstreams() {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            try {
                OutputStream outStream;
                InputStream inStream;
                block16: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connecting to " + this.server));
                    }
                    int numRetries = 0;
                    Random rand = null;
                    while (true) {
                        this.setupConnection();
                        inStream = NetUtils.getInputStream(this.socket);
                        outStream = NetUtils.getOutputStream(this.socket);
                        this.writeConnectionHeader(outStream);
                        if (this.authProtocol != Server.AuthProtocol.SASL) break block16;
                        final SocketInputWrapper in2 = inStream;
                        final OutputStream out2 = outStream;
                        UserGroupInformation ticket = this.remoteId.getTicket();
                        if (ticket.getRealUser() != null) {
                            ticket = ticket.getRealUser();
                        }
                        try {
                            this.authMethod = ticket.doAs(new PrivilegedExceptionAction<SaslRpcServer.AuthMethod>(){

                                @Override
                                public SaslRpcServer.AuthMethod run() throws IOException, InterruptedException {
                                    return Connection.this.setupSaslConnection(in2, out2);
                                }
                            });
                        }
                        catch (Exception ex) {
                            this.authMethod = this.saslRpcClient.getAuthMethod();
                            if (rand == null) {
                                rand = new Random();
                            }
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, this.maxRetriesOnSasl, ex, rand, ticket);
                            continue;
                        }
                        break;
                    }
                    if (this.authMethod != SaslRpcServer.AuthMethod.SIMPLE) {
                        inStream = this.saslRpcClient.getInputStream(inStream);
                        outStream = this.saslRpcClient.getOutputStream(outStream);
                        this.remoteId.saslQop = (String)this.saslRpcClient.getNegotiatedProperty("javax.security.sasl.qop");
                        LOG.debug((Object)("Negotiated QOP is :" + this.remoteId.saslQop));
                    } else if (UserGroupInformation.isSecurityEnabled() && !Client.this.fallbackAllowed) {
                        throw new IOException("Server asks us to fall back to SIMPLE auth, but this client is configured to only allow secure connections.");
                    }
                }
                if (this.doPing) {
                    inStream = new PingInputStream(inStream);
                }
                this.in = new DataInputStream(new BufferedInputStream(inStream));
                if (!(outStream instanceof BufferedOutputStream)) {
                    outStream = new BufferedOutputStream(outStream);
                }
                this.out = new DataOutputStream(outStream);
                this.writeConnectionContext(this.remoteId, this.authMethod);
                this.touch();
                this.start();
                return;
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    this.markClosed((IOException)t);
                } else {
                    this.markClosed(new IOException("Couldn't set up IO streams", t));
                }
                this.close();
                return;
            }
        }

        private void closeConnection() {
            if (this.socket == null) {
                return;
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Not able to close a socket", (Throwable)e);
            }
            this.socket = null;
        }

        private void handleConnectionTimeout(int curRetries, int maxRetries, IOException ioe) throws IOException {
            this.closeConnection();
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            LOG.info((Object)("Retrying connect to server: " + this.server + ". Already tried " + curRetries + " time(s); maxRetries=" + maxRetries));
        }

        private void handleConnectionFailure(int curRetries, IOException ioe) throws IOException {
            RetryPolicy.RetryAction action;
            this.closeConnection();
            try {
                action = this.connectionRetryPolicy.shouldRetry(ioe, curRetries, 0, true);
            }
            catch (Exception e) {
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
            if (action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                if (action.reason != null) {
                    LOG.warn((Object)("Failed to connect to server: " + this.server + ": " + action.reason), (Throwable)ioe);
                }
                throw ioe;
            }
            try {
                Thread.sleep(action.delayMillis);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException("Interrupted: action=" + action + ", retry policy=" + this.connectionRetryPolicy).initCause(e);
            }
            LOG.info((Object)("Retrying connect to server: " + this.server + ". Already tried " + curRetries + " time(s); retry policy is " + this.connectionRetryPolicy));
        }

        private void writeConnectionHeader(OutputStream outStream) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(outStream));
            out.write(RpcConstants.HEADER.array());
            out.write(9);
            out.write(this.serviceClass);
            out.write(this.authProtocol.callId);
            out.flush();
        }

        private void writeConnectionContext(ConnectionId remoteId, SaslRpcServer.AuthMethod authMethod) throws IOException {
            IpcConnectionContextProtos.IpcConnectionContextProto message = ProtoUtil.makeIpcConnectionContext(RPC.getProtocolName(remoteId.getProtocol()), remoteId.getTicket(), authMethod);
            RpcHeaderProtos.RpcRequestHeaderProto connectionContextHeader = ProtoUtil.makeRpcRequestHeader(RPC.RpcKind.RPC_PROTOCOL_BUFFER, RpcHeaderProtos.RpcRequestHeaderProto.OperationProto.RPC_FINAL_PACKET, -3, -1, Client.this.clientId);
            ProtobufRpcEngine.RpcRequestMessageWrapper request = new ProtobufRpcEngine.RpcRequestMessageWrapper(connectionContextHeader, (Message)message);
            this.out.writeInt(request.getLength());
            request.write(this.out);
        }

        private synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get() && (timeout = (long)this.maxIdleTime - (Time.now() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sendPing() throws IOException {
            long curTime = Time.now();
            if (curTime - this.lastActivity.get() >= (long)this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(this.pingRequest.size());
                    this.pingRequest.writeTo(this.out);
                    this.out.flush();
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting, having connections " + Client.this.connections.size()));
            }
            try {
                while (this.waitForWork()) {
                    this.receiveRpcResponse();
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)("Unexpected error reading responses on connection " + this), t);
                this.markClosed(new IOException("Error reading responses", t));
            }
            this.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": stopped, remaining connections " + Client.this.connections.size()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendRpcRequest(final Call call) throws InterruptedException, IOException {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            final DataOutputBuffer d = new DataOutputBuffer();
            RpcHeaderProtos.RpcRequestHeaderProto header = ProtoUtil.makeRpcRequestHeader(call.rpcKind, RpcHeaderProtos.RpcRequestHeaderProto.OperationProto.RPC_FINAL_PACKET, call.id, call.retry, Client.this.clientId);
            header.writeDelimitedTo(d);
            call.rpcRequest.write(d);
            Object object = this.sendRpcRequestLock;
            synchronized (object) {
                Future<?> senderFuture = Client.this.sendParamsExecutor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            DataOutputStream dataOutputStream = Connection.this.out;
                            synchronized (dataOutputStream) {
                                block11: {
                                    if (!Connection.this.shouldCloseConnection.get()) break block11;
                                    return;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(Connection.this.getName() + " sending #" + call.id));
                                }
                                byte[] data = d.getData();
                                int totalLength = d.getLength();
                                Connection.this.out.writeInt(totalLength);
                                Connection.this.out.write(data, 0, totalLength);
                                Connection.this.out.flush();
                            }
                        }
                        catch (IOException e) {
                            Connection.this.markClosed(e);
                        }
                        finally {
                            IOUtils.closeStream(d);
                        }
                    }
                });
                try {
                    senderFuture.get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException("unexpected checked exception", cause);
                }
            }
        }

        private void receiveRpcResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            try {
                int totalLen = this.in.readInt();
                RpcHeaderProtos.RpcResponseHeaderProto header = RpcHeaderProtos.RpcResponseHeaderProto.parseDelimitedFrom(this.in);
                Client.this.checkResponse(header);
                int headerLen = header.getSerializedSize();
                headerLen += CodedOutputStream.computeRawVarint32Size((int)headerLen);
                int callId = header.getCallId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + " got value #" + callId));
                }
                Call call = this.calls.get(callId);
                RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto status = header.getStatus();
                if (status == RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.SUCCESS) {
                    ProtobufRpcEngine.RpcWrapper resWrapper;
                    Writable value = (Writable)ReflectionUtils.newInstance(Client.this.valueClass, Client.this.conf);
                    value.readFields(this.in);
                    this.calls.remove(callId);
                    call.setRpcResponse(value);
                    if (call.getRpcResponse() instanceof ProtobufRpcEngine.RpcWrapper && totalLen != headerLen + (resWrapper = (ProtobufRpcEngine.RpcWrapper)call.getRpcResponse()).getLength()) {
                        throw new RpcClientException("RPC response length mismatch on rpc success");
                    }
                } else {
                    RemoteException re;
                    RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto erCode;
                    if (totalLen != headerLen) {
                        throw new RpcClientException("RPC response length mismatch on rpc error");
                    }
                    String exceptionClassName = header.hasExceptionClassName() ? header.getExceptionClassName() : "ServerDidNotSetExceptionClassName";
                    String errorMsg = header.hasErrorMsg() ? header.getErrorMsg() : "ServerDidNotSetErrorMsg";
                    RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto rpcErrorCodeProto = erCode = header.hasErrorDetail() ? header.getErrorDetail() : null;
                    if (erCode == null) {
                        LOG.warn((Object)"Detailed error code not set by server on rpc error");
                    }
                    RemoteException remoteException = re = erCode == null ? new RemoteException(exceptionClassName, errorMsg) : new RemoteException(exceptionClassName, errorMsg, erCode);
                    if (status == RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR) {
                        this.calls.remove(callId);
                        call.setException(re);
                    } else if (status == RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.FATAL) {
                        this.markClosed(re);
                    }
                }
            }
            catch (IOException e) {
                this.markClosed(e);
            }
        }

        private synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)"The connection is not in the closed state");
                return;
            }
            Hashtable hashtable = Client.this.connections;
            synchronized (hashtable) {
                if (Client.this.connections.get(this.remoteId) == this) {
                    Client.this.connections.remove(this.remoteId);
                }
            }
            IOUtils.closeStream(this.out);
            IOUtils.closeStream(this.in);
            this.disposeSasl();
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn((Object)"A connection is closed for no cause and calls are not empty");
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing ipc connection to " + this.server + ": " + this.closeException.getMessage()), (Throwable)this.closeException);
                }
                this.cleanupCalls();
            }
            this.closeConnection();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closed"));
            }
        }

        private void cleanupCalls() {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                itor.remove();
                c.setException(this.closeException);
            }
        }

        private class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !Client.this.running.get() || Connection.this.rpcTimeout > 0) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    static class Call {
        final int id;
        final int retry;
        final Writable rpcRequest;
        Writable rpcResponse;
        IOException error;
        final RPC.RpcKind rpcKind;
        boolean done;

        private Call(RPC.RpcKind rpcKind, Writable param) {
            this.rpcKind = rpcKind;
            this.rpcRequest = param;
            Integer id = (Integer)callId.get();
            if (id == null) {
                this.id = Client.nextCallId();
            } else {
                callId.set(null);
                this.id = id;
            }
            Integer rc = (Integer)retryCount.get();
            this.retry = rc == null ? 0 : rc;
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public synchronized void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public synchronized void setRpcResponse(Writable rpcResponse) {
            this.rpcResponse = rpcResponse;
            this.callComplete();
        }

        public synchronized Writable getRpcResponse() {
            return this.rpcResponse;
        }
    }

    private static class ClientExecutorServiceFactory {
        private int executorRefCount = 0;
        private ExecutorService clientExecutor = null;

        private ClientExecutorServiceFactory() {
        }

        synchronized ExecutorService refAndGetInstance() {
            if (this.executorRefCount == 0) {
                this.clientExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("IPC Parameter Sending Thread #%d").build());
            }
            ++this.executorRefCount;
            return this.clientExecutor;
        }

        synchronized ExecutorService unrefAndCleanup() {
            --this.executorRefCount;
            assert (this.executorRefCount >= 0);
            if (this.executorRefCount == 0) {
                this.clientExecutor.shutdown();
                try {
                    if (!this.clientExecutor.awaitTermination(1L, TimeUnit.MINUTES)) {
                        this.clientExecutor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"Interrupted while waiting for clientExecutorto stop", (Throwable)e);
                    this.clientExecutor.shutdownNow();
                }
                this.clientExecutor = null;
            }
            return this.clientExecutor;
        }
    }
}

