/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.hadoop.util.PureJavaCrc32;
import org.junit.Assert;
import org.junit.Test;

public class TestPureJavaCrc32 {
    private final CRC32 theirs = new CRC32();
    private final PureJavaCrc32 ours = new PureJavaCrc32();

    @Test
    public void testCorrectness() throws Exception {
        this.checkSame();
        this.theirs.update(104);
        this.ours.update(104);
        this.checkSame();
        this.checkOnBytes(new byte[]{40, 60, 97, -70}, false);
        this.checkOnBytes("hello world!".getBytes("UTF-8"), false);
        for (int i = 0; i < 10000; ++i) {
            byte[] randomBytes = new byte[new Random().nextInt(2048)];
            new Random().nextBytes(randomBytes);
            this.checkOnBytes(randomBytes, false);
        }
    }

    private void checkOnBytes(byte[] bytes, boolean print) {
        this.theirs.reset();
        this.ours.reset();
        this.checkSame();
        for (int i = 0; i < bytes.length; ++i) {
            this.ours.update((int)bytes[i]);
            this.theirs.update(bytes[i]);
            this.checkSame();
        }
        if (print) {
            System.out.println("theirs:\t" + Long.toHexString(this.theirs.getValue()) + "\nours:\t" + Long.toHexString(this.ours.getValue()));
        }
        this.theirs.reset();
        this.ours.reset();
        this.ours.update(bytes, 0, bytes.length);
        this.theirs.update(bytes, 0, bytes.length);
        if (print) {
            System.out.println("theirs:\t" + Long.toHexString(this.theirs.getValue()) + "\nours:\t" + Long.toHexString(this.ours.getValue()));
        }
        this.checkSame();
        if (bytes.length >= 10) {
            this.ours.update(bytes, 5, 5);
            this.theirs.update(bytes, 5, 5);
            this.checkSame();
        }
    }

    private void checkSame() {
        Assert.assertEquals((long)this.theirs.getValue(), (long)this.ours.getValue());
    }

    public static class PerformanceTest {
        public static final int MAX_LEN = 0x2000000;
        public static final int BYTES_PER_SIZE = 0x8000000;
        static final Checksum zip = new CRC32();
        static final Checksum[] CRCS = new Checksum[]{new PureJavaCrc32()};

        public static void main(String[] args) {
            PerformanceTest.printSystemProperties(System.out);
            PerformanceTest.doBench(CRCS, System.out);
        }

        private static void printCell(String s, int width, PrintStream out) {
            int w = s.length() > width ? s.length() : width;
            out.printf(" %" + w + "s |", s);
        }

        private static void doBench(Checksum[] crcs, PrintStream out) {
            ArrayList<Checksum> a = new ArrayList<Checksum>();
            a.add(zip);
            for (Checksum c : crcs) {
                if (c.getClass() == zip.getClass()) continue;
                a.add(c);
            }
            PerformanceTest.doBench(a, out);
        }

        private static void doBench(List<Checksum> crcs, PrintStream out) {
            byte[] bytes = new byte[0x2000000];
            new Random().nextBytes(bytes);
            out.printf("\nPerformance Table (The unit is MB/sec)\n||", new Object[0]);
            String title = "Num Bytes";
            PerformanceTest.printCell("Num Bytes", 0, out);
            for (Checksum c : crcs) {
                out.printf("|", new Object[0]);
                PerformanceTest.printCell(c.getClass().getSimpleName(), 8, out);
            }
            out.printf("|\n", new Object[0]);
            for (Checksum c : crcs) {
                PerformanceTest.doBench(c, bytes, 2, null);
                PerformanceTest.doBench(c, bytes, 2101, null);
            }
            for (int size = 1; size < 0x2000000; size *= 2) {
                out.printf("|", new Object[0]);
                PerformanceTest.printCell(String.valueOf(size), "Num Bytes".length() + 1, out);
                Long expected = null;
                for (Checksum c : crcs) {
                    System.gc();
                    long result = PerformanceTest.doBench(c, bytes, size, out);
                    if (c.getClass() == zip.getClass()) {
                        expected = result;
                        continue;
                    }
                    if (result == expected) continue;
                    throw new RuntimeException(c.getClass() + " has bugs!");
                }
                out.printf("\n", new Object[0]);
            }
        }

        private static long doBench(Checksum crc, byte[] bytes, int size, PrintStream out) {
            String name = crc.getClass().getSimpleName();
            int trials = 0x8000000 / size;
            long st = System.nanoTime();
            crc.reset();
            for (int i = 0; i < trials; ++i) {
                crc.update(bytes, 0, size);
            }
            long result = crc.getValue();
            long et = System.nanoTime();
            double mbProcessed = (double)(trials * size) / 1024.0 / 1024.0;
            double secsElapsed = (double)(et - st) / 1.0E9;
            if (out != null) {
                String s = String.format("%9.3f", mbProcessed / secsElapsed);
                PerformanceTest.printCell(s, name.length() + 1, out);
            }
            return result;
        }

        private static void printSystemProperties(PrintStream out) {
            String[] names = new String[]{"java.version", "java.runtime.name", "java.runtime.version", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.vm.specification.version", "java.specification.version", "os.arch", "os.name", "os.version"};
            Properties p = System.getProperties();
            for (String n : names) {
                out.println(n + " = " + p.getProperty(n));
            }
        }
    }

    public static class Table {
        private final int[][] tables;

        private Table(int nBits, int nTables, long polynomial) {
            this.tables = new int[nTables][];
            int size = 1 << nBits;
            for (int i = 0; i < this.tables.length; ++i) {
                this.tables[i] = new int[size];
            }
            int[] first = this.tables[0];
            for (int i = 0; i < first.length; ++i) {
                int crc = i;
                for (int j = 0; j < nBits; ++j) {
                    if ((crc & 1) == 1) {
                        crc >>>= 1;
                        crc = (int)((long)crc ^ polynomial);
                        continue;
                    }
                    crc >>>= 1;
                }
                first[i] = crc;
            }
            int mask = first.length - 1;
            for (int j = 1; j < this.tables.length; ++j) {
                int[] previous = this.tables[j - 1];
                int[] current = this.tables[j];
                for (int i = 0; i < current.length; ++i) {
                    current[i] = previous[i] >>> nBits ^ first[previous[i] & mask];
                }
            }
        }

        String[] toStrings(String nameformat) {
            String[] s = new String[this.tables.length];
            for (int j = 0; j < this.tables.length; ++j) {
                int[] t = this.tables[j];
                StringBuilder b = new StringBuilder();
                b.append(String.format("    /* " + nameformat + " */", j));
                int i = 0;
                while (i < t.length) {
                    b.append("\n    ");
                    for (int k = 0; k < 4; ++k) {
                        b.append(String.format("0x%08X, ", t[i++]));
                    }
                }
                s[j] = b.toString();
            }
            return s;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            String tableFormat = String.format("T%d_", Integer.numberOfTrailingZeros(this.tables[0].length)) + "%d";
            String startFormat = "  private static final int " + tableFormat + "_start = %d*256;";
            for (int j = 0; j < this.tables.length; ++j) {
                b.append(String.format(startFormat, j, j));
                b.append("\n");
            }
            b.append("  private static final int[] T = new int[] {");
            for (String s : this.toStrings(tableFormat)) {
                b.append("\n");
                b.append(s);
            }
            b.setCharAt(b.length() - 2, '\n');
            b.append(" };\n");
            return b.toString();
        }

        public static void main(String[] args) throws FileNotFoundException {
            if (args.length != 1) {
                System.err.println("Usage: " + Table.class.getName() + " <polynomial>");
                System.exit(1);
            }
            long polynomial = Long.parseLong(args[0], 16);
            int i = 8;
            PrintStream out = new PrintStream(new FileOutputStream("table" + i + ".txt"), true);
            Table t = new Table(i, 16, polynomial);
            String s = t.toString();
            System.out.println(s);
            out.println(s);
        }
    }
}

