/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;

public class BreakableService
extends AbstractService {
    private boolean failOnInit;
    private boolean failOnStart;
    private boolean failOnStop;
    private int[] counts = new int[4];

    public BreakableService() {
        this(false, false, false);
    }

    public BreakableService(boolean failOnInit, boolean failOnStart, boolean failOnStop) {
        super("BreakableService");
        this.failOnInit = failOnInit;
        this.failOnStart = failOnStart;
        this.failOnStop = failOnStop;
        this.inc(Service.STATE.NOTINITED);
    }

    private int convert(Service.STATE state) {
        return state.getValue();
    }

    private void inc(Service.STATE state) {
        int index;
        int n = index = this.convert(state);
        this.counts[n] = this.counts[n] + 1;
    }

    public int getCount(Service.STATE state) {
        return this.counts[this.convert(state)];
    }

    private void maybeFail(boolean fail, String action) {
        if (fail) {
            throw new BrokenLifecycleEvent((Service)this, action);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.inc(Service.STATE.INITED);
        this.maybeFail(this.failOnInit, "init");
        super.serviceInit(conf);
    }

    protected void serviceStart() {
        this.inc(Service.STATE.STARTED);
        this.maybeFail(this.failOnStart, "start");
    }

    protected void serviceStop() {
        this.inc(Service.STATE.STOPPED);
        this.maybeFail(this.failOnStop, "stop");
    }

    public void setFailOnInit(boolean failOnInit) {
        this.failOnInit = failOnInit;
    }

    public void setFailOnStart(boolean failOnStart) {
        this.failOnStart = failOnStart;
    }

    public void setFailOnStop(boolean failOnStop) {
        this.failOnStop = failOnStop;
    }

    public static class BrokenLifecycleEvent
    extends RuntimeException {
        final Service.STATE state;

        public BrokenLifecycleEvent(Service service, String action) {
            super("Lifecycle Failure during " + action + " state is " + service.getServiceState());
            this.state = service.getServiceState();
        }
    }
}

