/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestBytesWritable {
    @Test
    public void testSizeChange() throws Exception {
        byte[] hadoop = "hadoop".getBytes();
        BytesWritable buf = new BytesWritable(hadoop);
        int size = buf.getLength();
        int orig_capacity = buf.getCapacity();
        buf.setSize(size * 2);
        int new_capacity = buf.getCapacity();
        System.arraycopy(buf.getBytes(), 0, buf.getBytes(), size, size);
        Assert.assertTrue((new_capacity >= size * 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)(size * 2), (long)buf.getLength());
        Assert.assertTrue((new_capacity != orig_capacity ? 1 : 0) != 0);
        buf.setSize(size * 4);
        Assert.assertTrue((new_capacity != buf.getCapacity() ? 1 : 0) != 0);
        for (int i = 0; i < size * 2; ++i) {
            Assert.assertEquals((long)hadoop[i % size], (long)buf.getBytes()[i]);
        }
        Assert.assertEquals((long)(size * 4), (long)buf.copyBytes().length);
        buf.setCapacity(1);
        Assert.assertEquals((long)1L, (long)buf.getLength());
        Assert.assertEquals((long)hadoop[0], (long)buf.getBytes()[0]);
    }

    @Test
    public void testHash() throws Exception {
        byte[] owen = "owen".getBytes();
        BytesWritable buf = new BytesWritable(owen);
        Assert.assertEquals((long)4347922L, (long)buf.hashCode());
        buf.setCapacity(10000);
        Assert.assertEquals((long)4347922L, (long)buf.hashCode());
        buf.setSize(0);
        Assert.assertEquals((long)1L, (long)buf.hashCode());
    }

    @Test
    public void testCompare() throws Exception {
        int i;
        byte[][] values = new byte[][]{"abc".getBytes(), "ad".getBytes(), "abcd".getBytes(), "".getBytes(), "b".getBytes()};
        BytesWritable[] buf = new BytesWritable[values.length];
        for (i = 0; i < values.length; ++i) {
            buf[i] = new BytesWritable(values[i]);
        }
        for (i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                Assert.assertTrue((buf[i].compareTo((BinaryComparable)buf[j]) == -buf[j].compareTo((BinaryComparable)buf[i]) ? 1 : 0) != 0);
                Assert.assertTrue((i == j == (buf[i].compareTo((BinaryComparable)buf[j]) == 0) ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((buf[0].compareTo((BinaryComparable)buf[1]) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((buf[1].compareTo((BinaryComparable)buf[2]) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((buf[2].compareTo((BinaryComparable)buf[3]) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((buf[3].compareTo((BinaryComparable)buf[4]) < 0 ? 1 : 0) != 0);
    }

    private void checkToString(byte[] input, String expected) {
        String actual = new BytesWritable(input).toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToString() {
        this.checkToString(new byte[]{0, 1, 2, 16}, "00 01 02 10");
        this.checkToString(new byte[]{-128, -127, -1, -2, 1, 0}, "80 81 ff fe 01 00");
    }

    @Test
    public void testZeroCopy() {
        byte[] bytes = "brock".getBytes();
        BytesWritable zeroBuf = new BytesWritable(bytes, bytes.length);
        BytesWritable copyBuf = new BytesWritable(bytes);
        Assert.assertTrue((String)"copy took place, backing array != array passed to constructor", (bytes == zeroBuf.getBytes() ? 1 : 0) != 0);
        Assert.assertTrue((String)"length of BW should backing byte array", (zeroBuf.getLength() == bytes.length ? 1 : 0) != 0);
        Assert.assertEquals((String)"objects with same backing array should be equal", (Object)zeroBuf, (Object)copyBuf);
        Assert.assertEquals((String)"string repr of objects with same backing array should be equal", (Object)zeroBuf.toString(), (Object)copyBuf.toString());
        Assert.assertTrue((String)"compare order objects with same backing array should be equal", (zeroBuf.compareTo((BinaryComparable)copyBuf) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"hash of objects with same backing array should be equal", (zeroBuf.hashCode() == copyBuf.hashCode() ? 1 : 0) != 0);
        byte[] buffer = new byte[bytes.length * 5];
        zeroBuf.set(buffer, 0, buffer.length);
        zeroBuf.set(bytes, 0, bytes.length);
        Assert.assertEquals((String)"buffer created with (array, len) has bad contents", (Object)zeroBuf, (Object)copyBuf);
        Assert.assertTrue((String)"buffer created with (array, len) has bad length", (zeroBuf.getLength() == copyBuf.getLength() ? 1 : 0) != 0);
    }
}

