/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.junit.Assert;
import org.junit.Test;

public class TestPathExceptions {
    protected String path = "some/file";
    protected String error = "KABOOM";

    @Test
    public void testWithDefaultString() throws Exception {
        PathIOException pe = new PathIOException(this.path);
        Assert.assertEquals((Object)new Path(this.path), (Object)pe.getPath());
        Assert.assertEquals((Object)("`" + this.path + "': Input/output error"), (Object)pe.getMessage());
    }

    @Test
    public void testWithThrowable() throws Exception {
        IOException ioe = new IOException("KABOOM");
        PathIOException pe = new PathIOException(this.path, (Throwable)ioe);
        Assert.assertEquals((Object)new Path(this.path), (Object)pe.getPath());
        Assert.assertEquals((Object)("`" + this.path + "': Input/output error: " + this.error), (Object)pe.getMessage());
    }

    @Test
    public void testWithCustomString() throws Exception {
        PathIOException pe = new PathIOException(this.path, this.error);
        Assert.assertEquals((Object)new Path(this.path), (Object)pe.getPath());
        Assert.assertEquals((Object)("`" + this.path + "': " + this.error), (Object)pe.getMessage());
    }
}

