/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InvalidNameException;
import javax.net.ssl.SSLContext;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.SearchCursor;
import org.apache.directory.ldap.client.api.exception.InvalidConnectionException;
import org.apache.directory.ldap.client.api.exception.LdapException;
import org.apache.directory.ldap.client.api.future.AddFuture;
import org.apache.directory.ldap.client.api.future.BindFuture;
import org.apache.directory.ldap.client.api.future.CompareFuture;
import org.apache.directory.ldap.client.api.future.DeleteFuture;
import org.apache.directory.ldap.client.api.future.ExtendedFuture;
import org.apache.directory.ldap.client.api.future.ModifyDnFuture;
import org.apache.directory.ldap.client.api.future.ModifyFuture;
import org.apache.directory.ldap.client.api.future.ResponseFuture;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.apache.directory.ldap.client.api.listener.DeleteListener;
import org.apache.directory.ldap.client.api.message.AbandonRequest;
import org.apache.directory.ldap.client.api.message.AbstractMessage;
import org.apache.directory.ldap.client.api.message.AddRequest;
import org.apache.directory.ldap.client.api.message.AddResponse;
import org.apache.directory.ldap.client.api.message.BindRequest;
import org.apache.directory.ldap.client.api.message.BindResponse;
import org.apache.directory.ldap.client.api.message.CompareRequest;
import org.apache.directory.ldap.client.api.message.CompareResponse;
import org.apache.directory.ldap.client.api.message.DeleteRequest;
import org.apache.directory.ldap.client.api.message.DeleteResponse;
import org.apache.directory.ldap.client.api.message.ExtendedIntermediateResponse;
import org.apache.directory.ldap.client.api.message.ExtendedRequest;
import org.apache.directory.ldap.client.api.message.ExtendedResponse;
import org.apache.directory.ldap.client.api.message.LdapResult;
import org.apache.directory.ldap.client.api.message.ModifyDnRequest;
import org.apache.directory.ldap.client.api.message.ModifyDnResponse;
import org.apache.directory.ldap.client.api.message.ModifyRequest;
import org.apache.directory.ldap.client.api.message.ModifyResponse;
import org.apache.directory.ldap.client.api.message.Referral;
import org.apache.directory.ldap.client.api.message.Response;
import org.apache.directory.ldap.client.api.message.SearchIntermediateResponse;
import org.apache.directory.ldap.client.api.message.SearchRequest;
import org.apache.directory.ldap.client.api.message.SearchResponse;
import org.apache.directory.ldap.client.api.message.SearchResultDone;
import org.apache.directory.ldap.client.api.message.SearchResultEntry;
import org.apache.directory.ldap.client.api.message.SearchResultReference;
import org.apache.directory.ldap.client.api.protocol.LdapProtocolCodecFactory;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.LdapTransformer;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.apache.directory.shared.ldap.codec.bind.SaslCredentials;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseCodec;
import org.apache.directory.shared.ldap.codec.controls.ControlImpl;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.del.DelResponseCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.intermediate.IntermediateResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseCodec;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequestCodec;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.loader.ldif.JarLdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConnection
extends IoHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(LdapConnection.class);
    private static final String LDAP_RESPONSE = "LdapReponse";
    private long timeOut = 30000L;
    private LdapConnectionConfig config = new LdapConnectionConfig();
    private IoConnector connector;
    private boolean localConnector;
    private IoFilter ldapProtocolFilter = new ProtocolCodecFilter((ProtocolCodecFactory)new LdapProtocolCodecFactory());
    private IoSession ldapSession;
    private AtomicInteger messageId;
    private Map<Integer, ResponseFuture<? extends Response>> futureMap = new ConcurrentHashMap<Integer, ResponseFuture<? extends Response>>();
    private List<String> supportedControls;
    private Entry rootDSE;
    private AtomicBoolean authenticated = new AtomicBoolean(false);
    private AtomicBoolean connected = new AtomicBoolean(false);
    private SchemaManager schemaManager;
    private static final String OPERATION_CANCELLED = "Operation would have been cancelled";
    static final String TIME_OUT_ERROR = "TimeOut occured";
    static final String NO_RESPONSE_ERROR = "The response queue has been emptied, no response was found.";
    private static final String COMPARE_FAILED = "Failed to perform compare operation";

    public boolean isConnected() {
        return this.ldapSession != null && this.connected.get();
    }

    public boolean isAuthenticated() {
        return this.isConnected() && this.authenticated.get();
    }

    private void checkSession() throws InvalidConnectionException {
        if (this.ldapSession == null) {
            throw new InvalidConnectionException("Cannot connect on the server, the connection is null");
        }
        if (!this.connected.get()) {
            throw new InvalidConnectionException("Cannot connect on the server, the connection is invalid");
        }
    }

    private void addToFutureMap(int messageId, ResponseFuture<? extends Response> future) {
        LOG.debug("Adding <" + messageId + ", " + future.getClass().getName() + ">");
        this.futureMap.put(messageId, future);
    }

    private ResponseFuture<? extends Response> getFromFutureMap(int messageId) {
        ResponseFuture<? extends Response> future = this.futureMap.remove(messageId);
        if (future != null) {
            LOG.debug("Removing <" + messageId + ", " + future.getClass().getName() + ">");
        }
        return future;
    }

    private ResponseFuture<? extends Response> peekFromFutureMap(int messageId) {
        ResponseFuture<? extends Response> future = this.futureMap.get(messageId);
        if (future != null) {
            LOG.debug("Getting <" + messageId + ", " + future.getClass().getName() + ">");
        }
        return future;
    }

    public LdapMessageCodec getResponse() {
        return (LdapMessageCodec)this.ldapSession.getAttribute((Object)LDAP_RESPONSE);
    }

    private void setControls(Map<String, Control> controls, LdapMessageCodec message) {
        if (controls != null) {
            for (Control control : controls.values()) {
                ControlImpl ctrl = new ControlImpl(control.getOid());
                ctrl.setValue(control.getValue());
                message.addControl((Control)ctrl);
            }
        }
    }

    private long getTimeout(long clientTimeOut) {
        if (clientTimeOut <= 0L) {
            return this.timeOut <= 0L ? Long.MAX_VALUE : this.timeOut;
        }
        if (this.timeOut <= 0L) {
            return clientTimeOut;
        }
        return this.timeOut < clientTimeOut ? this.timeOut : clientTimeOut;
    }

    private BindResponse convert(BindResponseCodec bindResponseCodec) {
        BindResponse bindResponse = new BindResponse();
        bindResponse.setMessageId(bindResponseCodec.getMessageId());
        bindResponse.setServerSaslCreds(bindResponseCodec.getServerSaslCreds());
        bindResponse.setLdapResult(this.convert(bindResponseCodec.getLdapResult()));
        return bindResponse;
    }

    private void setIResponse(IntermediateResponseCodec intermediateResponseCodec, ResponseFuture responseFuture) throws Exception {
        AbstractMessage intermediateResponse = null;
        if (responseFuture instanceof SearchFuture) {
            intermediateResponse = new SearchIntermediateResponse();
        } else if (responseFuture instanceof ExtendedFuture) {
            intermediateResponse = new ExtendedIntermediateResponse();
        } else {
            throw new UnsupportedOperationException("Unknown ResponseFuture type " + responseFuture.getClass().getName());
        }
        intermediateResponse.setResponseName(intermediateResponseCodec.getResponseName());
        intermediateResponse.setResponseValue(intermediateResponseCodec.getResponseValue());
        responseFuture.set(intermediateResponse);
    }

    private LdapResult convert(LdapResultCodec ldapResultCodec) {
        LdapResult ldapResult = new LdapResult();
        ldapResult.setErrorMessage(ldapResultCodec.getErrorMessage());
        ldapResult.setMatchedDn(ldapResultCodec.getMatchedDN());
        Referral referral = new Referral();
        if (ldapResultCodec.getReferrals() != null) {
            for (LdapURL url : ldapResultCodec.getReferrals()) {
                referral.addLdapUrls(url);
            }
        }
        ldapResult.setReferral(referral);
        ldapResult.setResultCode(ldapResultCodec.getResultCode());
        return ldapResult;
    }

    private SearchResultEntry convert(SearchResultEntryCodec searchEntryResultCodec) {
        SearchResultEntry searchResultEntry = new SearchResultEntry();
        searchResultEntry.setMessageId(searchEntryResultCodec.getMessageId());
        searchResultEntry.setEntry(searchEntryResultCodec.getEntry());
        this.addControls((LdapMessageCodec)searchEntryResultCodec, searchResultEntry);
        return searchResultEntry;
    }

    private SearchResultDone convert(SearchResultDoneCodec searchResultDoneCodec) {
        SearchResultDone searchResultDone = new SearchResultDone();
        searchResultDone.setMessageId(searchResultDoneCodec.getMessageId());
        searchResultDone.setLdapResult(this.convert(searchResultDoneCodec.getLdapResult()));
        this.addControls((LdapMessageCodec)searchResultDoneCodec, searchResultDone);
        return searchResultDone;
    }

    private SearchResultReference convert(SearchResultReferenceCodec searchEntryReferenceCodec) {
        SearchResultReference searchResultReference = new SearchResultReference();
        searchResultReference.setMessageId(searchEntryReferenceCodec.getMessageId());
        Referral referral = new Referral();
        if (searchEntryReferenceCodec.getSearchResultReferences() != null) {
            for (LdapURL url : searchEntryReferenceCodec.getSearchResultReferences()) {
                referral.addLdapUrls(url);
            }
        }
        searchResultReference.setReferral(referral);
        this.addControls((LdapMessageCodec)searchEntryReferenceCodec, searchResultReference);
        return searchResultReference;
    }

    public LdapConnection() {
        this.config.setUseSsl(false);
        this.config.setLdapPort(this.config.getDefaultLdapPort());
        this.config.setLdapHost(this.config.getDefaultLdapHost());
        this.messageId = new AtomicInteger(0);
    }

    public LdapConnection(LdapConnectionConfig config) {
        this.config = config;
        this.messageId = new AtomicInteger(0);
    }

    public LdapConnection(boolean useSsl) {
        this.config.setUseSsl(useSsl);
        this.config.setLdapPort(useSsl ? this.config.getDefaultLdapsPort() : this.config.getDefaultLdapPort());
        this.config.setLdapHost(this.config.getDefaultLdapHost());
        this.messageId = new AtomicInteger(0);
    }

    public LdapConnection(String server) {
        this.config.setUseSsl(false);
        this.config.setLdapPort(this.config.getDefaultLdapPort());
        this.config.setLdapHost(server);
        this.messageId = new AtomicInteger(0);
    }

    public LdapConnection(String server, boolean useSsl) {
        this.config.setUseSsl(useSsl);
        this.config.setLdapPort(useSsl ? this.config.getDefaultLdapsPort() : this.config.getDefaultLdapPort());
        this.config.setLdapHost(server);
        this.messageId = new AtomicInteger(0);
    }

    public LdapConnection(String server, int port) {
        this(server, port, false);
    }

    public LdapConnection(String server, int port, boolean useSsl) {
        this.config.setUseSsl(useSsl);
        this.config.setLdapPort(port);
        this.config.setLdapHost(server);
        this.messageId = new AtomicInteger();
    }

    public boolean connect() throws LdapException, IOException {
        if (this.ldapSession != null && this.connected.get()) {
            return true;
        }
        if (this.connector == null) {
            this.connector = new NioSocketConnector();
            this.localConnector = true;
            this.connector.getFilterChain().addLast("ldapCodec", this.ldapProtocolFilter);
            if (this.config.isUseSsl()) {
                try {
                    SSLContext sslContext = SSLContext.getInstance(this.config.getSslProtocol());
                    sslContext.init(this.config.getKeyManagers(), this.config.getTrustManagers(), this.config.getSecureRandom());
                    SslFilter sslFilter = new SslFilter(sslContext);
                    sslFilter.setUseClientMode(true);
                    this.connector.getFilterChain().addFirst("sslFilter", (IoFilter)sslFilter);
                }
                catch (Exception e) {
                    String msg = "Failed to initialize the SSL context";
                    LOG.error(msg, (Throwable)e);
                    throw new LdapException(msg, e);
                }
            }
            this.connector.setHandler((IoHandler)this);
        }
        InetSocketAddress address = new InetSocketAddress(this.config.getLdapHost(), this.config.getLdapPort());
        ConnectFuture connectionFuture = this.connector.connect((SocketAddress)address);
        connectionFuture.awaitUninterruptibly();
        if (!connectionFuture.isConnected()) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return false;
        }
        this.ldapSession = connectionFuture.getSession();
        this.connected.set(true);
        LdapMessageContainer ldapMessageContainer = new LdapMessageContainer();
        this.ldapSession.setAttribute((Object)"LDAP-Container", (Object)ldapMessageContainer);
        this.messageId.set(0);
        return true;
    }

    public boolean close() throws IOException {
        if (this.ldapSession != null && this.connected.get()) {
            this.ldapSession.close(true);
            this.connected.set(false);
        }
        if (this.localConnector) {
            this.connector.dispose();
            this.connector = null;
        }
        this.messageId.set(0);
        return true;
    }

    public AddResponse add(Entry entry) throws LdapException {
        if (entry == null) {
            String msg = "Cannot add empty entry";
            LOG.debug(msg);
            throw new NullPointerException(msg);
        }
        return this.add(new AddRequest(entry));
    }

    public AddFuture addAsync(Entry entry) throws LdapException {
        if (entry == null) {
            String msg = "Cannot add null entry";
            LOG.debug(msg);
            throw new NullPointerException(msg);
        }
        return this.addAsync(new AddRequest(entry));
    }

    public AddResponse add(AddRequest addRequest) throws LdapException {
        AddFuture addFuture = this.addAsync(addRequest);
        try {
            long timeout = this.getTimeout(addRequest.getTimeout());
            AddResponse addResponse = addFuture.get(timeout, TimeUnit.MILLISECONDS);
            if (addResponse == null) {
                LOG.error("Add failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (addResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Add successful : {}", (Object)addResponse);
            } else {
                LOG.debug("Add failed : {}", (Object)addResponse);
            }
            return addResponse;
        }
        catch (TimeoutException te) {
            if (!addFuture.isCancelled()) {
                this.abandon(addRequest.getMessageId());
            }
            LOG.error("Add failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!addFuture.isCancelled()) {
                this.abandon(addRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    public AddFuture addAsync(AddRequest addRequest) throws LdapException {
        this.checkSession();
        AddRequestCodec addReqCodec = new AddRequestCodec();
        int newId = this.messageId.incrementAndGet();
        addRequest.setMessageId(newId);
        addReqCodec.setMessageId(newId);
        addReqCodec.setEntry(addRequest.getEntry());
        addReqCodec.setEntryDn(addRequest.getEntry().getDn());
        this.setControls(addRequest.getControls(), (LdapMessageCodec)addReqCodec);
        AddFuture addFuture = new AddFuture(this, newId);
        this.addToFutureMap(newId, addFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)addReqCodec);
        if (!writeFuture.awaitUninterruptibly(this.getTimeout(0L))) {
            LOG.error("Add failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return addFuture;
    }

    private AddResponse convert(AddResponseCodec addRespCodec) {
        AddResponse addResponse = new AddResponse();
        addResponse.setMessageId(addRespCodec.getMessageId());
        addResponse.setLdapResult(this.convert(addRespCodec.getLdapResult()));
        return addResponse;
    }

    public void abandon(int messageId) {
        AbandonRequest abandonRequest = new AbandonRequest();
        abandonRequest.setAbandonedMessageId(messageId);
        this.abandonInternal(abandonRequest);
    }

    public void abandon(AbandonRequest abandonRequest) {
        this.abandonInternal(abandonRequest);
    }

    private void abandonInternal(AbandonRequest abandonRequest) {
        AbandonRequestCodec request = new AbandonRequestCodec();
        int newId = this.messageId.incrementAndGet();
        abandonRequest.setMessageId(newId);
        request.setMessageId(newId);
        request.setAbandonedMessageId(abandonRequest.getAbandonedMessageId());
        this.setControls(abandonRequest.getControls(), (LdapMessageCodec)request);
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending request \n{}", (Object)request);
        this.ldapSession.write((Object)request);
        int abandonId = abandonRequest.getAbandonedMessageId();
        ResponseFuture<? extends Response> rf = this.getFromFutureMap(abandonId);
        if (rf != null) {
            LOG.debug("sending cancel signal to future");
            rf.cancel(true);
        } else {
            LOG.error("There is no future asscoiated with operation message ID {}, perhaps the operation would have been completed", (Object)abandonId);
        }
    }

    public BindResponse bind() throws LdapException, IOException {
        LOG.debug("Anonymous Bind request");
        BindRequest bindRequest = new BindRequest();
        bindRequest.setName("");
        bindRequest.setCredentials(StringTools.EMPTY_BYTES);
        return this.bind(bindRequest);
    }

    public BindFuture bindAsync() throws LdapException, IOException {
        LOG.debug("Anonymous Bind request");
        BindRequest bindRequest = new BindRequest();
        bindRequest.setName("");
        bindRequest.setCredentials(StringTools.EMPTY_BYTES);
        return this.bindAsync(bindRequest);
    }

    public BindResponse bind(String name, String credentials) throws LdapException, IOException {
        LOG.debug("Bind request : {}", (Object)name);
        BindRequest bindRequest = new BindRequest();
        bindRequest.setName(name);
        bindRequest.setCredentials(StringTools.getBytesUtf8((String)credentials));
        return this.bind(bindRequest);
    }

    public BindFuture bindAsync(String name, String credentials) throws LdapException, IOException {
        LOG.debug("Bind request : {}", (Object)name);
        BindRequest bindRequest = new BindRequest();
        bindRequest.setName(name);
        bindRequest.setCredentials(StringTools.getBytesUtf8((String)credentials));
        return this.bindAsync(bindRequest);
    }

    public BindResponse bind(DN name, String credentials) throws LdapException, IOException {
        LOG.debug("Bind request : {}", (Object)name);
        BindRequest bindRequest = new BindRequest();
        bindRequest.setCredentials(StringTools.getBytesUtf8((String)credentials));
        if (name == null) {
            bindRequest.setName("");
        } else {
            bindRequest.setName(name.getName());
        }
        return this.bind(bindRequest);
    }

    public BindFuture bindAsync(DN name, String credentials) throws LdapException, IOException {
        LOG.debug("Bind request : {}", (Object)name);
        BindRequest bindRequest = new BindRequest();
        bindRequest.setCredentials(StringTools.getBytesUtf8((String)credentials));
        if (name == null) {
            bindRequest.setName("");
        } else {
            bindRequest.setName(name.getName());
        }
        return this.bindAsync(bindRequest);
    }

    public BindResponse bind(BindRequest bindRequest) throws LdapException, IOException {
        BindFuture bindFuture = this.bindAsync(bindRequest);
        try {
            long timeout = this.getTimeout(bindRequest.getTimeout());
            BindResponse bindResponse = bindFuture.get(timeout, TimeUnit.MILLISECONDS);
            if (bindResponse == null) {
                LOG.error("Bind failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                this.authenticated.set(true);
                LOG.debug("Bind successful : {}", (Object)bindResponse);
            } else {
                LOG.debug("Bind failed : {}", (Object)bindResponse);
            }
            return bindResponse;
        }
        catch (TimeoutException te) {
            if (!bindFuture.isCancelled()) {
                this.abandon(bindRequest.getMessageId());
            }
            LOG.error("Bind failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!bindFuture.isCancelled()) {
                this.abandon(bindRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    private SearchRequestCodec createSearchMessage(SearchRequest searchRequest) throws LdapException {
        SearchRequestCodec request = new SearchRequestCodec();
        int newId = this.messageId.incrementAndGet();
        searchRequest.setMessageId(newId);
        request.setMessageId(newId);
        try {
            DN dn = new DN(searchRequest.getBaseDn());
            request.setBaseObject(dn);
        }
        catch (InvalidNameException ine) {
            String msg = "The given dn '" + searchRequest.getBaseDn() + "' is not valid";
            LOG.error(msg);
            LdapException ldapException = new LdapException(msg);
            ldapException.initCause(ine);
            throw ldapException;
        }
        request.setScope(searchRequest.getScope());
        request.setDerefAliases(searchRequest.getDerefAliases().getValue());
        request.setTimeLimit(searchRequest.getTimeLimit());
        request.setSizeLimit(searchRequest.getSizeLimit());
        request.setTypesOnly(searchRequest.getTypesOnly());
        Filter filter = null;
        try {
            ExprNode filterNode = FilterParser.parse((String)searchRequest.getFilter());
            filter = LdapTransformer.transformFilter((ExprNode)filterNode);
        }
        catch (ParseException pe) {
            String msg = "The given filter '" + searchRequest.getFilter() + "' is not valid";
            LOG.error(msg);
            LdapException ldapException = new LdapException(msg);
            ldapException.initCause(pe);
            throw ldapException;
        }
        request.setFilter(filter);
        Set<String> attributes = searchRequest.getAttributes();
        if (attributes != null) {
            for (String attribute : attributes) {
                request.addAttribute(attribute);
            }
        }
        this.setControls(searchRequest.getControls(), (LdapMessageCodec)request);
        return request;
    }

    private BindRequestCodec createBindMessage(BindRequest bindRequest) throws LdapException {
        BindRequestCodec bindRequestCodec = new BindRequestCodec();
        int newId = this.messageId.incrementAndGet();
        bindRequest.setMessageId(newId);
        bindRequestCodec.setMessageId(newId);
        bindRequestCodec.setVersion(LdapConnectionConfig.LDAP_V3);
        try {
            DN dn = new DN(bindRequest.getName());
            bindRequestCodec.setName(dn);
        }
        catch (InvalidNameException ine) {
            String msg = "The given dn '" + bindRequest.getName() + "' is not valid";
            LOG.error(msg);
            LdapException ldapException = new LdapException(msg);
            ldapException.initCause(ine);
            throw ldapException;
        }
        SimpleAuthentication authentication = null;
        if (bindRequest.isSimple()) {
            authentication = new SimpleAuthentication();
            authentication.setSimple(bindRequest.getCredentials());
        } else {
            authentication = new SaslCredentials();
            ((SaslCredentials)authentication).setCredentials(bindRequest.getCredentials());
            ((SaslCredentials)authentication).setMechanism(bindRequest.getSaslMechanism());
        }
        bindRequestCodec.setAuthentication((LdapAuthentication)authentication);
        this.setControls(bindRequest.getControls(), (LdapMessageCodec)bindRequestCodec);
        return bindRequestCodec;
    }

    public BindFuture bindAsync(BindRequest bindRequest) throws LdapException, IOException {
        this.authenticated.set(false);
        this.connect();
        this.checkSession();
        BindRequestCodec bindMessage = this.createBindMessage(bindRequest);
        int newId = bindMessage.getMessageId();
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending request \n{}", (Object)bindMessage);
        BindFuture bindFuture = new BindFuture(this, newId);
        this.addToFutureMap(newId, bindFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)bindMessage);
        if (!writeFuture.awaitUninterruptibly(this.getTimeout(0L))) {
            LOG.error("Bind failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return bindFuture;
    }

    public Cursor<SearchResponse> search(String baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setBaseDn(baseDn);
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.addAttributes(attributes);
        searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
        return this.search(searchRequest);
    }

    public SearchFuture searchAsync(String baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setBaseDn(baseDn);
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.addAttributes(attributes);
        searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
        return this.searchAsync(searchRequest);
    }

    public SearchFuture searchAsync(SearchRequest searchRequest) throws LdapException {
        this.checkSession();
        SearchRequestCodec request = this.createSearchMessage(searchRequest);
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending request \n{}", (Object)request);
        SearchFuture searchFuture = new SearchFuture(this, request.getMessageId());
        this.addToFutureMap(request.getMessageId(), searchFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)request);
        if (!writeFuture.awaitUninterruptibly(this.getTimeout(0L))) {
            LOG.error("Search failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return searchFuture;
    }

    public Cursor<SearchResponse> search(SearchRequest searchRequest) throws LdapException {
        SearchFuture searchFuture = this.searchAsync(searchRequest);
        long timeout = this.getTimeout(searchRequest.getTimeout());
        return new SearchCursor(searchFuture, timeout, TimeUnit.MILLISECONDS);
    }

    public void unBind() throws Exception {
        this.checkSession();
        UnBindRequestCodec unbindRequest = new UnBindRequestCodec();
        int newId = this.messageId.incrementAndGet();
        unbindRequest.setMessageId(newId);
        LOG.debug("-----------------------------------------------------------------");
        LOG.debug("Sending Unbind request \n{}", (Object)unbindRequest);
        WriteFuture unbindFuture = this.ldapSession.write((Object)unbindRequest);
        this.authenticated.set(false);
        this.clearMaps();
        if (this.ldapSession != null && this.connected.get()) {
            CloseFuture closeFuture = this.ldapSession.close(true);
            LOG.debug("waiting for closeFuture");
            closeFuture.awaitUninterruptibly();
            LOG.debug("closeFuture done");
            this.connected.set(false);
        }
        this.messageId.set(0);
        LOG.debug("Unbind successful");
    }

    public void setConnector(IoConnector connector) {
        this.connector = connector;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        LdapMessageCodec response = (LdapMessageCodec)message;
        LOG.debug("-------> {} Message received <-------", (Object)response);
        ResponseFuture<? extends Response> responseFuture = this.peekFromFutureMap(response.getMessageId());
        if (responseFuture == null) {
            LOG.info("There is no future associated with the messageId {}, ignoring the message", (Object)response.getMessageId());
            return;
        }
        int messageId = response.getMessageId();
        switch (response.getMessageType()) {
            case ADD_RESPONSE: {
                AddResponseCodec addRespCodec = (AddResponseCodec)response;
                addRespCodec.addControl(response.getCurrentControl());
                addRespCodec.setMessageId(messageId);
                AddResponse addResponse = this.convert(addRespCodec);
                AddFuture addFuture = (AddFuture)responseFuture;
                if (addFuture == null) {
                    LOG.error("AddFuture is null");
                    throw new LdapException("AddFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    if (addResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Add successful : {}", (Object)addResponse);
                    } else {
                        LOG.debug("Add failed : {}", (Object)addResponse);
                    }
                }
                addFuture.set(addResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case BIND_RESPONSE: {
                BindResponseCodec bindResponseCodec = (BindResponseCodec)response;
                bindResponseCodec.setMessageId(messageId);
                bindResponseCodec.addControl(response.getCurrentControl());
                BindResponse bindResponse = this.convert(bindResponseCodec);
                BindFuture bindFuture = (BindFuture)responseFuture;
                if (bindFuture == null) {
                    LOG.error("BindFuture is null");
                    throw new LdapException("BindFuture is null");
                }
                if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                    this.authenticated.set(true);
                    LOG.debug("Bind successful : {}", (Object)bindResponse);
                } else {
                    LOG.debug("Bind failed : {}", (Object)bindResponse);
                }
                bindFuture.set(bindResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case COMPARE_RESPONSE: {
                CompareResponseCodec compResCodec = (CompareResponseCodec)response;
                compResCodec.setMessageId(messageId);
                compResCodec.addControl(response.getCurrentControl());
                CompareResponse compareResponse = this.convert(compResCodec);
                CompareFuture compareFuture = (CompareFuture)responseFuture;
                if (compareFuture == null) {
                    LOG.error("CompareFuture is null");
                    throw new LdapException("CompareFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    if (compareResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Compare successful : {}", (Object)compareResponse);
                    } else {
                        LOG.debug("Compare failed : {}", (Object)compareResponse);
                    }
                }
                compareFuture.set(compareResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case DEL_RESPONSE: {
                DelResponseCodec delRespCodec = (DelResponseCodec)response;
                delRespCodec.addControl(response.getCurrentControl());
                delRespCodec.setMessageId(messageId);
                DeleteResponse deleteResponse = this.convert(delRespCodec);
                DeleteFuture deleteFuture = (DeleteFuture)responseFuture;
                if (deleteFuture == null) {
                    LOG.error("DeleteFuture is null");
                    throw new LdapException("DeleteFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    if (deleteResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Delete successful : {}", (Object)deleteResponse);
                    } else {
                        LOG.debug("Delete failed : {}", (Object)deleteResponse);
                    }
                }
                deleteFuture.set(deleteResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case EXTENDED_RESPONSE: {
                ExtendedResponseCodec extResCodec = (ExtendedResponseCodec)response;
                extResCodec.setMessageId(messageId);
                extResCodec.addControl(response.getCurrentControl());
                ExtendedResponse extendedResponse = this.convert(extResCodec);
                ExtendedFuture extendedFuture = (ExtendedFuture)responseFuture;
                if (extendedFuture == null) {
                    LOG.error("ExtendedFuture is null");
                    throw new LdapException("extendedFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    if (extendedResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Extended successful : {}", (Object)extendedResponse);
                    } else {
                        LOG.debug("Extended failed : {}", (Object)extendedResponse);
                    }
                }
                extendedFuture.set(extendedResponse);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case INTERMEDIATE_RESPONSE: {
                IntermediateResponseCodec intermediateResponseCodec = (IntermediateResponseCodec)response;
                intermediateResponseCodec.setMessageId(messageId);
                intermediateResponseCodec.addControl(response.getCurrentControl());
                this.setIResponse(intermediateResponseCodec, responseFuture);
                break;
            }
            case MODIFY_RESPONSE: {
                ModifyResponseCodec modRespCodec = (ModifyResponseCodec)response;
                modRespCodec.setMessageId(messageId);
                modRespCodec.addControl(response.getCurrentControl());
                ModifyResponse modifyResp = this.convert(modRespCodec);
                ModifyFuture modifyFuture = (ModifyFuture)responseFuture;
                if (modifyFuture == null) {
                    LOG.error("ModifyFuture is null");
                    throw new LdapException("ModifyFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    if (modifyResp.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("ModifyFuture successful : {}", (Object)modifyResp);
                    } else {
                        LOG.debug("ModifyFuture failed : {}", (Object)modifyResp);
                    }
                }
                modifyFuture.set(modifyResp);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case MODIFYDN_RESPONSE: {
                ModifyDNResponseCodec modDnRespCodec = (ModifyDNResponseCodec)response;
                modDnRespCodec.setMessageId(messageId);
                modDnRespCodec.addControl(response.getCurrentControl());
                ModifyDnResponse modifyDnResp = this.convert(modDnRespCodec);
                ModifyDnFuture modifyDnFuture = (ModifyDnFuture)responseFuture;
                if (modifyDnFuture == null) {
                    LOG.error("ModifyDNFuture is null");
                    throw new LdapException("ModifyDNFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    if (modifyDnResp.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("ModifyDN successful : {}", (Object)modifyDnResp);
                    } else {
                        LOG.debug("ModifyDN failed : {}", (Object)modifyDnResp);
                    }
                }
                modifyDnFuture.set(modifyDnResp);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case SEARCH_RESULT_DONE: {
                SearchResultDoneCodec searchResultDoneCodec = (SearchResultDoneCodec)response;
                searchResultDoneCodec.setMessageId(messageId);
                searchResultDoneCodec.addControl(response.getCurrentControl());
                SearchResultDone searchResultDone = this.convert(searchResultDoneCodec);
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (searchFuture == null) {
                    LOG.error("SearchFuture is null");
                    throw new LdapException("SearchFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    if (searchResultDone.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                        LOG.debug("Search successful : {}", (Object)searchResultDone);
                    } else {
                        LOG.debug("Search failed : {}", (Object)searchResultDone);
                    }
                }
                searchFuture.set(searchResultDone);
                this.removeFromFutureMaps(messageId);
                break;
            }
            case SEARCH_RESULT_ENTRY: {
                SearchResultEntryCodec searchResultEntryCodec = (SearchResultEntryCodec)response;
                searchResultEntryCodec.setMessageId(messageId);
                searchResultEntryCodec.addControl(response.getCurrentControl());
                SearchResultEntry srchEntry = this.convert(searchResultEntryCodec);
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (searchFuture == null) {
                    LOG.error("SearchFuture is null");
                    throw new LdapException("SearchFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Search entry found : {}", (Object)srchEntry);
                }
                searchFuture.set(srchEntry);
                break;
            }
            case SEARCH_RESULT_REFERENCE: {
                SearchResultReferenceCodec searchResultReferenceCodec = (SearchResultReferenceCodec)response;
                searchResultReferenceCodec.setMessageId(messageId);
                searchResultReferenceCodec.addControl(response.getCurrentControl());
                SearchResultReference searchResultReference = this.convert(searchResultReferenceCodec);
                SearchFuture searchFuture = (SearchFuture)responseFuture;
                if (searchFuture == null) {
                    LOG.error("SearchFuture is null");
                    throw new LdapException("SearchFuture is null");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Search reference found : {}", (Object)searchResultReference);
                }
                searchFuture.set(searchResultReference);
                break;
            }
            default: {
                LOG.error("~~~~~~~~~~~~~~~~~~~~~ Unknown message type {} ~~~~~~~~~~~~~~~~~~~~~", (Object)response.getMessageTypeName());
            }
        }
    }

    public ModifyResponse modify(Entry entry, ModificationOperation modOp) throws LdapException {
        if (entry == null) {
            LOG.debug("received a null entry for modification");
            throw new NullPointerException("Entry to be modified cannot be null");
        }
        ModifyRequest modReq = new ModifyRequest(entry.getDn());
        Iterator itr = entry.iterator();
        while (itr.hasNext()) {
            modReq.addModification((EntryAttribute)itr.next(), modOp);
        }
        return this.modify(modReq);
    }

    public ModifyResponse modify(ModifyRequest modRequest) throws LdapException {
        ModifyFuture modifyFuture = this.modifyAsync(modRequest);
        try {
            long timeout = this.getTimeout(modRequest.getTimeout());
            ModifyResponse modifyResponse = modifyFuture.get(timeout, TimeUnit.MILLISECONDS);
            if (modifyResponse == null) {
                LOG.error("Modify failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (modifyResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Modify successful : {}", (Object)modifyResponse);
            } else {
                LOG.debug("Modify failed : {}", (Object)modifyResponse);
            }
            return modifyResponse;
        }
        catch (TimeoutException te) {
            if (!modifyFuture.isCancelled()) {
                this.abandon(modRequest.getMessageId());
            }
            LOG.error("Modify failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!modifyFuture.isCancelled()) {
                this.abandon(modRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    public ModifyFuture modifyAsync(ModifyRequest modRequest) throws LdapException {
        this.checkSession();
        ModifyRequestCodec modReqCodec = new ModifyRequestCodec();
        int newId = this.messageId.incrementAndGet();
        modRequest.setMessageId(newId);
        modReqCodec.setMessageId(newId);
        modReqCodec.setModifications(modRequest.getMods());
        modReqCodec.setObject(modRequest.getDn());
        this.setControls(modRequest.getControls(), (LdapMessageCodec)modReqCodec);
        ModifyFuture modifyFuture = new ModifyFuture(this, newId);
        this.addToFutureMap(newId, modifyFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)modReqCodec);
        if (!writeFuture.awaitUninterruptibly(this.getTimeout(0L))) {
            LOG.error("Modify failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return modifyFuture;
    }

    private ModifyResponse convert(ModifyResponseCodec modRespCodec) {
        ModifyResponse modResponse = new ModifyResponse();
        modResponse.setMessageId(modRespCodec.getMessageId());
        modResponse.setLdapResult(this.convert(modRespCodec.getLdapResult()));
        return modResponse;
    }

    public ModifyDnResponse rename(String entryDn, String newRdn) throws LdapException {
        return this.rename(entryDn, newRdn, true);
    }

    public ModifyDnResponse rename(DN entryDn, RDN newRdn) throws LdapException {
        return this.rename(entryDn, newRdn, true);
    }

    public ModifyDnResponse rename(String entryDn, String newRdn, boolean deleteOldRdn) throws LdapException {
        try {
            return this.rename(new DN(entryDn), new RDN(newRdn), deleteOldRdn);
        }
        catch (InvalidNameException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    public ModifyDnResponse rename(DN entryDn, RDN newRdn, boolean deleteOldRdn) throws LdapException {
        ModifyDnRequest modDnRequest = new ModifyDnRequest();
        modDnRequest.setEntryDn(entryDn);
        modDnRequest.setNewRdn(newRdn);
        modDnRequest.setDeleteOldRdn(deleteOldRdn);
        return this.modifyDn(modDnRequest);
    }

    public ModifyDnResponse move(String entryDn, String newSuperiorDn) throws LdapException {
        try {
            return this.move(new DN(entryDn), new DN(newSuperiorDn));
        }
        catch (InvalidNameException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    public ModifyDnResponse move(DN entryDn, DN newSuperiorDn) throws LdapException {
        ModifyDnRequest modDnRequest = new ModifyDnRequest();
        modDnRequest.setEntryDn(entryDn);
        modDnRequest.setNewSuperior(newSuperiorDn);
        modDnRequest.setNewRdn(entryDn.getRdn());
        return this.modifyDn(modDnRequest);
    }

    public ModifyDnResponse modifyDn(ModifyDnRequest modDnRequest) throws LdapException {
        ModifyDnFuture modifyDnFuture = this.modifyDnAsync(modDnRequest);
        try {
            long timeout = this.getTimeout(modDnRequest.getTimeout());
            ModifyDnResponse modifyDnResponse = modifyDnFuture.get(timeout, TimeUnit.MILLISECONDS);
            if (modifyDnResponse == null) {
                LOG.error("ModifyDN failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (modifyDnResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("ModifyDN successful : {}", (Object)modifyDnResponse);
            } else {
                LOG.debug("Modify failed : {}", (Object)modifyDnResponse);
            }
            return modifyDnResponse;
        }
        catch (TimeoutException te) {
            if (!modifyDnFuture.isCancelled()) {
                this.abandon(modDnRequest.getMessageId());
            }
            LOG.error("Modify failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!modifyDnFuture.isCancelled()) {
                this.abandon(modDnRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    public ModifyDnFuture modifyDnAsync(ModifyDnRequest modDnRequest) throws LdapException {
        this.checkSession();
        ModifyDNRequestCodec modDnCodec = new ModifyDNRequestCodec();
        int newId = this.messageId.incrementAndGet();
        modDnRequest.setMessageId(newId);
        modDnCodec.setMessageId(newId);
        modDnCodec.setEntry(modDnRequest.getEntryDn());
        modDnCodec.setNewRDN(modDnRequest.getNewRdn());
        modDnCodec.setDeleteOldRDN(modDnRequest.isDeleteOldRdn());
        modDnCodec.setNewSuperior(modDnRequest.getNewSuperior());
        this.setControls(modDnRequest.getControls(), (LdapMessageCodec)modDnCodec);
        ModifyDnFuture modifyDnFuture = new ModifyDnFuture(this, newId);
        this.addToFutureMap(newId, modifyDnFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)modDnCodec);
        if (!writeFuture.awaitUninterruptibly(this.getTimeout(0L))) {
            LOG.error("Modify failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return modifyDnFuture;
    }

    private ModifyDnResponse convert(ModifyDNResponseCodec modDnRespCodec) {
        ModifyDnResponse modDnResponse = new ModifyDnResponse();
        modDnResponse.setMessageId(modDnRespCodec.getMessageId());
        modDnResponse.setLdapResult(this.convert(modDnRespCodec.getLdapResult()));
        return modDnResponse;
    }

    public DeleteResponse delete(String dn) throws LdapException {
        try {
            DeleteRequest deleteRequest = new DeleteRequest(new DN(dn));
            return this.delete(deleteRequest);
        }
        catch (InvalidNameException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    public DeleteResponse delete(DN dn) throws LdapException {
        DeleteRequest deleteRequest = new DeleteRequest(dn);
        return this.delete(deleteRequest);
    }

    public DeleteResponse deleteTree(DN dn) throws LdapException {
        String treeDeleteOid = "1.2.840.113556.1.4.805";
        if (this.isControlSupported(treeDeleteOid)) {
            DeleteRequest delRequest = new DeleteRequest(dn);
            delRequest.add(new Control[]{new ControlImpl(treeDeleteOid)});
            return this.delete(delRequest);
        }
        String msg = "The subtreeDelete control (1.2.840.113556.1.4.805) is not supported by the server\n The deletion has been aborted";
        LOG.error(msg);
        throw new LdapException(msg);
    }

    public DeleteResponse deleteTree(String dn) throws LdapException {
        try {
            String treeDeleteOid = "1.2.840.113556.1.4.805";
            DN newDn = new DN(dn);
            if (this.isControlSupported(treeDeleteOid)) {
                DeleteRequest delRequest = new DeleteRequest(newDn);
                delRequest.add(new Control[]{new ControlImpl(treeDeleteOid)});
                return this.delete(delRequest);
            }
            String msg = "The subtreeDelete control (1.2.840.113556.1.4.805) is not supported by the server\n The deletion has been aborted";
            LOG.error(msg);
            throw new LdapException(msg);
        }
        catch (InvalidNameException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    private DeleteResponse deleteRecursive(DN dn, Map<DN, Cursor<SearchResponse>> cursorMap, DeleteListener listener) throws LdapException {
        LOG.debug("searching for {}", (Object)dn.getName());
        DeleteResponse delResponse = null;
        Cursor<SearchResponse> cursor = null;
        try {
            if (cursorMap == null) {
                cursorMap = new HashMap<DN, Cursor<SearchResponse>>();
            }
            if ((cursor = cursorMap.get(dn)) == null) {
                cursor = this.search(dn.getName(), "(objectClass=*)", SearchScope.ONELEVEL, null);
                LOG.debug("putting cursor for {}", (Object)dn.getName());
                cursorMap.put(dn, cursor);
            }
            if (!cursor.next()) {
                LOG.debug("deleting {}", (Object)dn.getName());
                cursorMap.remove(dn);
                cursor.close();
                delResponse = this.delete(new DeleteRequest(dn));
            } else {
                do {
                    SearchResponse searchResp;
                    if (!((searchResp = (SearchResponse)cursor.get()) instanceof SearchResultEntry)) continue;
                    SearchResultEntry searchResult = (SearchResultEntry)searchResp;
                    this.deleteRecursive(searchResult.getEntry().getDn(), cursorMap, listener);
                } while (cursor.next());
                cursorMap.remove(dn);
                cursor.close();
                LOG.debug("deleting {}", (Object)dn.getName());
                delResponse = this.delete(new DeleteRequest(dn));
            }
        }
        catch (Exception e) {
            String msg = "Failed to delete child entries under the DN " + dn.getName();
            LOG.error(msg, (Throwable)e);
            throw new LdapException(msg, e);
        }
        return delResponse;
    }

    public DeleteResponse delete(DeleteRequest deleteRequest) throws LdapException {
        DeleteFuture deleteFuture = this.deleteAsync(deleteRequest);
        try {
            long timeout = this.getTimeout(deleteRequest.getTimeout());
            DeleteResponse delResponse = deleteFuture.get(timeout, TimeUnit.MILLISECONDS);
            if (delResponse == null) {
                LOG.error("Delete failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (delResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Delete successful : {}", (Object)delResponse);
            } else {
                LOG.debug("Delete failed : {}", (Object)delResponse);
            }
            return delResponse;
        }
        catch (TimeoutException te) {
            if (!deleteFuture.isCancelled()) {
                this.abandon(deleteRequest.getMessageId());
            }
            LOG.error("Del failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!deleteFuture.isCancelled()) {
                this.abandon(deleteRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    public DeleteFuture deleteAsync(DeleteRequest delRequest) throws LdapException {
        this.checkSession();
        DelRequestCodec delReqCodec = new DelRequestCodec();
        int newId = this.messageId.incrementAndGet();
        delRequest.setMessageId(newId);
        delReqCodec.setMessageId(newId);
        delReqCodec.setEntry(delRequest.getTargetDn());
        this.setControls(delRequest.getControls(), (LdapMessageCodec)delReqCodec);
        DeleteFuture deleteFuture = new DeleteFuture(this, newId);
        this.addToFutureMap(newId, deleteFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)delReqCodec);
        if (!writeFuture.awaitUninterruptibly(this.getTimeout(0L))) {
            LOG.error("Delete failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return deleteFuture;
    }

    public CompareResponse compare(String dn, String attributeName, String value) throws LdapException {
        try {
            CompareRequest compareRequest = new CompareRequest();
            compareRequest.setEntryDn(new DN(dn));
            compareRequest.setAttrName(attributeName);
            compareRequest.setValue(value);
            return this.compare(compareRequest);
        }
        catch (Exception e) {
            LOG.error(COMPARE_FAILED, (Throwable)e);
            throw new LdapException(COMPARE_FAILED, e);
        }
    }

    public CompareResponse compare(String dn, String attributeName, byte[] value) throws LdapException {
        try {
            CompareRequest compareRequest = new CompareRequest();
            compareRequest.setEntryDn(new DN(dn));
            compareRequest.setAttrName(attributeName);
            compareRequest.setValue(value);
            return this.compare(compareRequest);
        }
        catch (Exception e) {
            LOG.error(COMPARE_FAILED, (Throwable)e);
            throw new LdapException(COMPARE_FAILED, e);
        }
    }

    public CompareResponse compare(String dn, String attributeName, Value<?> value) throws LdapException {
        try {
            CompareRequest compareRequest = new CompareRequest();
            compareRequest.setEntryDn(new DN(dn));
            compareRequest.setAttrName(attributeName);
            compareRequest.setValue(value);
            return this.compare(compareRequest);
        }
        catch (Exception e) {
            LOG.error(COMPARE_FAILED, (Throwable)e);
            throw new LdapException(COMPARE_FAILED, e);
        }
    }

    public CompareResponse compare(DN dn, String attributeName, String value) throws LdapException {
        CompareRequest compareRequest = new CompareRequest();
        compareRequest.setEntryDn(dn);
        compareRequest.setAttrName(attributeName);
        compareRequest.setValue(value);
        return this.compare(compareRequest);
    }

    public CompareResponse compare(DN dn, String attributeName, byte[] value) throws LdapException {
        CompareRequest compareRequest = new CompareRequest();
        compareRequest.setEntryDn(dn);
        compareRequest.setAttrName(attributeName);
        compareRequest.setValue(value);
        return this.compare(compareRequest);
    }

    public CompareResponse compare(DN dn, String attributeName, Value<?> value) throws LdapException {
        CompareRequest compareRequest = new CompareRequest();
        compareRequest.setEntryDn(dn);
        compareRequest.setAttrName(attributeName);
        compareRequest.setValue(value.get());
        return this.compare(compareRequest);
    }

    public CompareResponse compare(CompareRequest compareRequest) throws LdapException {
        CompareFuture compareFuture = this.compareAsync(compareRequest);
        try {
            long timeout = this.getTimeout(compareRequest.getTimeout());
            CompareResponse compareResponse = compareFuture.get(timeout, TimeUnit.MILLISECONDS);
            if (compareResponse == null) {
                LOG.error("Compare failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (compareResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Compare successful : {}", (Object)compareResponse);
            } else {
                LOG.debug("Compare failed : {}", (Object)compareResponse);
            }
            return compareResponse;
        }
        catch (TimeoutException te) {
            if (!compareFuture.isCancelled()) {
                this.abandon(compareRequest.getMessageId());
            }
            LOG.error("Compare failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!compareFuture.isCancelled()) {
                this.abandon(compareRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    public CompareFuture compareAsync(CompareRequest compareRequest) throws LdapException {
        this.checkSession();
        CompareRequestCodec compareReqCodec = new CompareRequestCodec();
        int newId = this.messageId.incrementAndGet();
        compareRequest.setMessageId(newId);
        compareReqCodec.setMessageId(newId);
        compareReqCodec.setEntry(compareRequest.getEntryDn());
        compareReqCodec.setAttributeDesc(compareRequest.getAttrName());
        compareReqCodec.setAssertionValue(compareRequest.getValue());
        this.setControls(compareRequest.getControls(), (LdapMessageCodec)compareReqCodec);
        CompareFuture compareFuture = new CompareFuture(this, newId);
        this.addToFutureMap(newId, compareFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)compareReqCodec);
        if (!writeFuture.awaitUninterruptibly(this.getTimeout(0L))) {
            LOG.error("Compare failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return compareFuture;
    }

    private CompareResponse convert(CompareResponseCodec compareRespCodec) {
        CompareResponse compareResponse = new CompareResponse();
        compareResponse.setMessageId(compareRespCodec.getMessageId());
        compareResponse.setLdapResult(this.convert(compareRespCodec.getLdapResult()));
        return compareResponse;
    }

    private DeleteResponse convert(DelResponseCodec delRespCodec) {
        DeleteResponse response = new DeleteResponse();
        response.setMessageId(delRespCodec.getMessageId());
        response.setLdapResult(this.convert(delRespCodec.getLdapResult()));
        return response;
    }

    public ExtendedResponse extended(String oid) throws LdapException {
        return this.extended(oid, null);
    }

    public ExtendedResponse extended(String oid, byte[] value) throws LdapException {
        try {
            return this.extended(new OID(oid), value);
        }
        catch (DecoderException e) {
            String msg = "Failed to decode the OID " + oid;
            LOG.error(msg);
            throw new LdapException(msg, e);
        }
    }

    public ExtendedResponse extended(OID oid) throws LdapException {
        return this.extended(oid, null);
    }

    public ExtendedResponse extended(OID oid, byte[] value) throws LdapException {
        ExtendedRequest extRequest = new ExtendedRequest(oid);
        extRequest.setValue(value);
        return this.extended(extRequest);
    }

    public ExtendedResponse extended(ExtendedRequest extendedRequest) throws LdapException {
        ExtendedFuture extendedFuture = this.extendedAsync(extendedRequest);
        try {
            long timeout = this.getTimeout(extendedRequest.getTimeout());
            ExtendedResponse extendedResponse = extendedFuture.get(timeout, TimeUnit.MILLISECONDS);
            if (extendedResponse == null) {
                LOG.error("Extended failed : timeout occured");
                throw new LdapException(TIME_OUT_ERROR);
            }
            if (extendedResponse.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
                LOG.debug("Extended successful : {}", (Object)extendedResponse);
            } else {
                LOG.debug("Extended failed : {}", (Object)extendedResponse);
            }
            return extendedResponse;
        }
        catch (TimeoutException te) {
            if (!extendedFuture.isCancelled()) {
                this.abandon(extendedRequest.getMessageId());
            }
            LOG.error("Extended failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        catch (Exception ie) {
            LOG.error(NO_RESPONSE_ERROR, (Throwable)ie);
            LdapException ldapException = new LdapException(NO_RESPONSE_ERROR);
            ldapException.initCause(ie);
            if (!extendedFuture.isCancelled()) {
                this.abandon(extendedRequest.getMessageId());
            }
            throw ldapException;
        }
    }

    public ExtendedFuture extendedAsync(ExtendedRequest extendedRequest) throws LdapException {
        this.checkSession();
        ExtendedRequestCodec extReqCodec = new ExtendedRequestCodec();
        int newId = this.messageId.incrementAndGet();
        extReqCodec.setMessageId(newId);
        extReqCodec.setMessageId(newId);
        extReqCodec.setRequestName(extendedRequest.getOid());
        extReqCodec.setRequestValue(extendedRequest.getValue());
        this.setControls(extendedRequest.getControls(), (LdapMessageCodec)extReqCodec);
        ExtendedFuture extendedFuture = new ExtendedFuture(this, newId);
        this.addToFutureMap(newId, extendedFuture);
        WriteFuture writeFuture = this.ldapSession.write((Object)extReqCodec);
        if (!writeFuture.awaitUninterruptibly(this.getTimeout(0L))) {
            LOG.error("Extended failed : timeout occured");
            throw new LdapException(TIME_OUT_ERROR);
        }
        return extendedFuture;
    }

    public SearchResponse lookup(String dn) throws LdapException {
        return this.lookup(dn, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
    }

    public SearchResponse lookup(String dn, String ... attributes) throws LdapException {
        SearchResponse resp = null;
        try {
            Cursor<SearchResponse> cursor = this.search(dn, "(objectClass=*)", SearchScope.OBJECT, attributes);
            if (cursor.next()) {
                resp = (SearchResponse)cursor.get();
            }
            cursor.close();
        }
        catch (Exception e) {
            throw new LdapException(e);
        }
        return resp;
    }

    private ExtendedResponse convert(ExtendedResponseCodec extRespCodec) {
        ExtendedResponse extResponse = new ExtendedResponse();
        OID oid = null;
        try {
            if (extRespCodec.getResponseName() != null) {
                oid = new OID(extRespCodec.getResponseName());
            }
        }
        catch (DecoderException e) {
            // empty catch block
        }
        extResponse.setOid(oid);
        extResponse.setValue(extRespCodec.getResponse());
        extResponse.setMessageId(extRespCodec.getMessageId());
        extResponse.setLdapResult(this.convert(extRespCodec.getLdapResult()));
        return extResponse;
    }

    public boolean isControlSupported(String controlOID) throws LdapException {
        return this.getSupportedControls().contains(controlOID);
    }

    public List<String> getSupportedControls() throws LdapException {
        if (this.supportedControls != null) {
            return this.supportedControls;
        }
        if (this.rootDSE == null) {
            this.fetchRootDSE();
        }
        this.supportedControls = new ArrayList<String>();
        EntryAttribute attr = this.rootDSE.get("supportedControl");
        for (Value value : attr) {
            this.supportedControls.add(value.getString());
        }
        return this.supportedControls;
    }

    public void loadSchema() throws LdapException {
        try {
            JarLdifSchemaLoader jarSchemaLoader = new JarLdifSchemaLoader();
            this.schemaManager = new DefaultSchemaManager((SchemaLoader)jarSchemaLoader);
            this.schemaManager.loadAllEnabled();
            if (!this.schemaManager.getErrors().isEmpty()) {
                String msg = "there are errors while loading the schema";
                LOG.error(msg + " {}", (Object)this.schemaManager.getErrors());
                throw new LdapException(msg);
            }
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            LOG.error("failed to load the schema", (Throwable)e);
            throw new LdapException(e);
        }
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    private void fetchRootDSE() throws LdapException {
        Cursor<SearchResponse> cursor = null;
        try {
            cursor = this.search("", "(objectClass=*)", SearchScope.OBJECT, "*", "+");
            cursor.next();
            SearchResultEntry searchRes = (SearchResultEntry)cursor.get();
            this.rootDSE = searchRes.getEntry();
        }
        catch (Exception e) {
            String msg = "Failed to fetch the RootDSE";
            LOG.error(msg);
            throw new LdapException(msg, e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close open cursor", (Throwable)e);
                }
            }
        }
    }

    public LdapConnectionConfig getConfig() {
        return this.config;
    }

    private void addControls(LdapMessageCodec codec, AbstractMessage message) {
        List ccList = codec.getControls();
        if (ccList != null) {
            for (Control cc : ccList) {
                if (cc == null) continue;
                ControlImpl control = new ControlImpl(cc.getOid());
                control.setValue(cc.getValue());
                control.setCritical(cc.isCritical());
                message.add(new Control[]{control});
            }
        }
    }

    private void removeFromFutureMaps(int msgId) {
        this.getFromFutureMap(msgId);
    }

    private void clearMaps() {
        this.futureMap.clear();
    }

    public boolean doesFutureExistFor(Integer messageId) {
        return this.futureMap.get(messageId) != null;
    }
}

