/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.utils.BloomCalculations;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.Filter;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.obs.OpenBitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilter
extends Filter {
    private static final Logger logger = LoggerFactory.getLogger(BloomFilter.class);
    private static final int EXCESS = 20;
    static ICompactSerializer2<BloomFilter> serializer_ = new BloomFilterSerializer();
    public OpenBitSet bitset;

    BloomFilter(int hashes, OpenBitSet bs) {
        this.hashCount = hashes;
        this.bitset = bs;
    }

    public static BloomFilter emptyFilter() {
        return new BloomFilter(0, BloomFilter.bucketsFor(0L, 0));
    }

    public static ICompactSerializer2<BloomFilter> serializer() {
        return serializer_;
    }

    private static OpenBitSet bucketsFor(long numElements, int bucketsPer) {
        return new OpenBitSet(numElements * (long)bucketsPer + 20L);
    }

    public static BloomFilter getFilter(long numElements, int targetBucketsPerElem) {
        int maxBucketsPerElement = Math.max(1, BloomCalculations.maxBucketsPerElement(numElements));
        int bucketsPerElement = Math.min(targetBucketsPerElem, maxBucketsPerElement);
        if (bucketsPerElement < targetBucketsPerElem) {
            logger.warn(String.format("Cannot provide an optimal BloomFilter for %d elements (%d/%d buckets per element).", numElements, bucketsPerElement, targetBucketsPerElem));
        }
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement);
        if (logger.isTraceEnabled()) {
            logger.trace("Creating bloom filter for {} elements and spec {}", (Object)numElements, (Object)spec);
        }
        return new BloomFilter(spec.K, BloomFilter.bucketsFor(numElements, spec.bucketsPerElement));
    }

    public static BloomFilter getFilter(long numElements, double maxFalsePosProbability) {
        assert (maxFalsePosProbability <= 1.0) : "Invalid probability";
        int bucketsPerElement = BloomCalculations.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement, maxFalsePosProbability);
        return new BloomFilter(spec.K, BloomFilter.bucketsFor(numElements, spec.bucketsPerElement));
    }

    private long buckets() {
        return this.bitset.size();
    }

    private long[] getHashBuckets(ByteBuffer key) {
        return BloomFilter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    static long[] getHashBuckets(ByteBuffer b, int hashCount, long max) {
        long[] result = new long[hashCount];
        long hash1 = MurmurHash.hash64(b, b.position(), b.remaining(), 0L);
        long hash2 = MurmurHash.hash64(b, b.position(), b.remaining(), hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + (long)i * hash2) % max);
        }
        return result;
    }

    @Override
    public void add(ByteBuffer key) {
        for (long bucketIndex : this.getHashBuckets(key)) {
            this.bitset.set(bucketIndex);
        }
    }

    @Override
    public boolean isPresent(ByteBuffer key) {
        for (long bucketIndex : this.getHashBuckets(key)) {
            if (this.bitset.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.bitset.clear(0L, this.bitset.size());
    }

    public int serializedSize() {
        return BloomFilterSerializer.serializedSize(this);
    }
}

