/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.StatusLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCInspector {
    private static final Logger logger = LoggerFactory.getLogger(GCInspector.class);
    static final long INTERVAL_IN_MS = 1000L;
    static final long MIN_DURATION = 200L;
    static final long MIN_DURATION_TPSTATS = 1000L;
    public static final GCInspector instance = new GCInspector();
    private HashMap<String, Long> gctimes = new HashMap();
    private HashMap<String, Long> gccounts = new HashMap();
    List<GarbageCollectorMXBean> beans = new ArrayList<GarbageCollectorMXBean>();
    MemoryMXBean membean = ManagementFactory.getMemoryMXBean();
    private volatile boolean cacheSizesReduced;

    public GCInspector() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
            for (ObjectName name : server.queryNames(gcName, null)) {
                GarbageCollectorMXBean gc = ManagementFactory.newPlatformMXBeanProxy(server, name.getCanonicalName(), GarbageCollectorMXBean.class);
                this.beans.add(gc);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        if (this.beans.size() == 0) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                GCInspector.this.logGCResults();
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(t, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void logGCResults() {
        for (GarbageCollectorMXBean gc : this.beans) {
            Long previousTotal = this.gctimes.get(gc.getName());
            Long total = gc.getCollectionTime();
            if (previousTotal == null) {
                previousTotal = 0L;
            }
            if (previousTotal.equals(total)) continue;
            this.gctimes.put(gc.getName(), total);
            Long duration = total - previousTotal;
            assert (duration > 0L);
            Long previousCount = this.gccounts.get(gc.getName());
            Long count = gc.getCollectionCount();
            if (previousCount == null) {
                previousCount = 0L;
            }
            if (count.equals(previousCount)) continue;
            this.gccounts.put(gc.getName(), count);
            MemoryUsage mu = this.membean.getHeapMemoryUsage();
            long memoryUsed = mu.getUsed();
            long memoryMax = mu.getMax();
            String st = String.format("GC for %s: %s ms for %s collections, %s used; max is %s", gc.getName(), duration, count - previousCount, memoryUsed, memoryMax);
            long durationPerCollection = duration / (count - previousCount);
            if (durationPerCollection > 200L) {
                logger.info(st);
            } else if (logger.isDebugEnabled()) {
                logger.debug(st);
            }
            if (durationPerCollection > 1000L) {
                StatusLogger.log();
            }
            if (!gc.getName().equals("ConcurrentMarkSweep")) continue;
            SSTableDeletingTask.rescheduleFailedTasks();
            double usage = (double)memoryUsed / (double)memoryMax;
            if ((double)memoryUsed > DatabaseDescriptor.getReduceCacheSizesAt() * (double)memoryMax && !this.cacheSizesReduced) {
                this.cacheSizesReduced = true;
                logger.warn("Heap is " + usage + " full.  You may need to reduce memtable and/or cache sizes.  Cassandra is now reducing cache sizes to free up memory.  Adjust reduce_cache_sizes_at threshold in cassandra.yaml if you don't want Cassandra to do this automatically");
                StorageService.instance.reduceCacheSizes();
            }
            if (!((double)memoryUsed > DatabaseDescriptor.getFlushLargestMemtablesAt() * (double)memoryMax)) continue;
            logger.warn("Heap is " + usage + " full.  You may need to reduce memtable and/or cache sizes.  Cassandra will now flush up to the two largest memtables to free up memory.  Adjust flush_largest_memtables_at threshold in cassandra.yaml if you don't want Cassandra to do this automatically");
            StorageService.instance.flushLargestMemtables();
        }
    }
}

