/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;

public class DatacenterSyncWriteResponseHandler
extends AbstractWriteResponseHandler {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private static final String localdc = snitch.getDatacenter(FBUtilities.getBroadcastAddress());
    private final NetworkTopologyStrategy strategy;
    private HashMap<String, AtomicInteger> responses = new HashMap();

    protected DatacenterSyncWriteResponseHandler(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, String table) {
        super(writeEndpoints, consistencyLevel);
        assert (consistencyLevel == ConsistencyLevel.EACH_QUORUM);
        this.strategy = (NetworkTopologyStrategy)Table.open(table).getReplicationStrategy();
        for (String dc : this.strategy.getDatacenters()) {
            int rf = this.strategy.getReplicationFactor(dc);
            this.responses.put(dc, new AtomicInteger(rf / 2 + 1));
        }
    }

    public static IWriteResponseHandler create(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, String table) {
        return new DatacenterSyncWriteResponseHandler(writeEndpoints, consistencyLevel, table);
    }

    @Override
    public void response(Message message) {
        String dataCenter = message == null ? localdc : snitch.getDatacenter(message.getFrom());
        this.responses.get(dataCenter).getAndDecrement();
        for (AtomicInteger i : this.responses.values()) {
            if (0 >= i.get()) continue;
            return;
        }
        this.condition.signal();
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        HashMap<String, AtomicInteger> dcEndpoints = new HashMap<String, AtomicInteger>();
        for (String dc : this.strategy.getDatacenters()) {
            dcEndpoints.put(dc, new AtomicInteger());
        }
        for (InetAddress destination : this.writeEndpoints) {
            if (!FailureDetector.instance.isAlive(destination)) continue;
            String destinationDC = snitch.getDatacenter(destination);
            ((AtomicInteger)dcEndpoints.get(destinationDC)).incrementAndGet();
        }
        for (String dc : this.strategy.getDatacenters()) {
            if (((AtomicInteger)dcEndpoints.get(dc)).get() >= this.responses.get(dc).get()) continue;
            throw new UnavailableException();
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

