/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.IOException;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.cassandra.io.compress.ICompressor;

public class DeflateCompressor
implements ICompressor {
    public static final DeflateCompressor instance = new DeflateCompressor();
    private final ThreadLocal<Deflater> deflater = new ThreadLocal<Deflater>(){

        @Override
        protected Deflater initialValue() {
            return new Deflater();
        }
    };
    private final ThreadLocal<Inflater> inflater = new ThreadLocal<Inflater>(){

        @Override
        protected Inflater initialValue() {
            return new Inflater();
        }
    };

    public static DeflateCompressor create(Map<String, String> compressionOptions) {
        return instance;
    }

    private DeflateCompressor() {
    }

    @Override
    public int initialCompressedBufferLength(int chunkLength) {
        return chunkLength;
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, ICompressor.WrappedArray output, int outputOffset) throws IOException {
        Deflater def = this.deflater.get();
        def.reset();
        def.setInput(input, inputOffset, inputLength);
        def.finish();
        if (def.needsInput()) {
            return 0;
        }
        int offs = outputOffset;
        while (true) {
            offs += def.deflate(output.buffer, offs, output.buffer.length - offs);
            if (def.needsInput()) {
                return offs - outputOffset;
            }
            byte[] newBuffer = new byte[output.buffer.length * 4 / 3 + 1];
            System.arraycopy(output.buffer, 0, newBuffer, 0, offs);
            output.buffer = newBuffer;
        }
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        Inflater inf = this.inflater.get();
        inf.reset();
        inf.setInput(input, inputOffset, inputLength);
        if (inf.needsInput()) {
            return 0;
        }
        try {
            return inf.inflate(output, outputOffset, output.length - outputOffset);
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
    }
}

