/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class UpdateKeyspace
extends Migration {
    private KSMetaData newKsm;
    private KSMetaData oldKsm;

    protected UpdateKeyspace() {
    }

    public UpdateKeyspace(KSMetaData ksm) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getBroadcastAddress()), Schema.instance.getVersion());
        assert (ksm != null);
        assert (ksm.cfMetaData() != null);
        if (ksm.cfMetaData().size() > 0) {
            throw new ConfigurationException("Updated keyspace must not contain any column families");
        }
        this.oldKsm = this.schema.getKSMetaData(ksm.name);
        if (this.oldKsm == null) {
            throw new ConfigurationException(ksm.name + " cannot be updated because it doesn't exist.");
        }
        this.newKsm = new KSMetaData(ksm.name, ksm.strategyClass, ksm.strategyOptions, ksm.isDurableWrites(), this.oldKsm.cfMetaData().values().toArray(new CFMetaData[0]));
        this.rm = this.makeDefinitionMutation(this.newKsm, this.oldKsm, this.newVersion);
    }

    @Override
    void applyModels() throws IOException {
        this.schema.clearTableDefinition(this.oldKsm, this.newVersion);
        this.schema.setTableDefinition(this.newKsm, this.newVersion);
        Table table = Table.open(this.newKsm.name, this.schema);
        try {
            table.createReplicationStrategy(this.newKsm);
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        logger.info("Keyspace updated. Please perform any manual operations.");
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.UpdateKeyspace uks = new org.apache.cassandra.db.migration.avro.UpdateKeyspace();
        uks.newKs = this.newKsm.toAvro();
        uks.oldKs = this.oldKsm.toAvro();
        mi.migration = uks;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.UpdateKeyspace uks = (org.apache.cassandra.db.migration.avro.UpdateKeyspace)((Object)mi.migration);
        this.newKsm = KSMetaData.fromAvro(uks.newKs);
        this.oldKsm = KSMetaData.fromAvro(uks.oldKs);
    }

    public String toString() {
        return String.format("Update keyspace %s to %s", this.oldKsm.toString(), this.newKsm.toString());
    }
}

