/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery.http;

import java.net.URI;
import javax.servlet.Servlet;
import org.apache.activemq.Service;
import org.apache.activemq.transport.discovery.http.DiscoveryRegistryServlet;
import org.apache.activemq.transport.discovery.http.HTTPDiscoveryAgent;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class EmbeddedJettyServer
implements Service {
    private HTTPDiscoveryAgent agent;
    private Server server;
    private SelectChannelConnector connector;
    private DiscoveryRegistryServlet camelServlet = new DiscoveryRegistryServlet();

    public void start() throws Exception {
        URI uri = new URI(this.agent.getRegistryURL());
        this.server = new Server();
        Context context = new Context(0);
        context.setContextPath("/");
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)this.camelServlet);
        context.addServlet(holder, "/*");
        this.server.setHandler((Handler)context);
        this.server.start();
        int port = 80;
        if (uri.getPort() >= 0) {
            port = uri.getPort();
        }
        this.connector = new SelectChannelConnector();
        this.connector.setPort(port);
        this.server.addConnector((Connector)this.connector);
        this.connector.start();
    }

    public void stop() throws Exception {
        if (this.connector != null) {
            this.connector.stop();
            this.connector = null;
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    public HTTPDiscoveryAgent getAgent() {
        return this.agent;
    }

    public void setAgent(HTTPDiscoveryAgent agent) {
        this.agent = agent;
    }
}

