/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp.hibernate;

import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.ClassUtils;
import org.andromda.maven.plugin.andromdapp.SchemaManagement;
import org.andromda.maven.plugin.andromdapp.SchemaManagementException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class HibernateSchemaManagement
implements SchemaManagement {
    protected static Logger logger = Logger.getLogger(HibernateSchemaManagement.class);
    protected static final String HIBERNATE_2_PACKAGE = "net.sf.hibernate.tool.hbm2ddl";
    protected static final String HIBERNATE_3_PACKAGE = "org.hibernate.tool.hbm2ddl";
    private String version;
    private String outputPath;

    public void setVersion(String version) {
        this.version = version;
    }

    protected Class getExecutionClass() {
        Class hibernateClass = null;
        String hibernate2ClassName = null;
        String hibernate3ClassName = null;
        try {
            hibernate3ClassName = "org.hibernate.tool.hbm2ddl." + this.getExecutionClassName();
            hibernateClass = ClassUtils.loadClass((String)hibernate3ClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hibernate2ClassName = "net.sf.hibernate.tool.hbm2ddl." + this.getExecutionClassName();
            hibernateClass = ClassUtils.loadClass((String)hibernate2ClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hibernateClass == null) {
            throw new RuntimeException("There appear to be no Hibernate 2 or 3 jars are your classpath, because neither '" + hibernate2ClassName + "', nor '" + hibernate3ClassName + "' could be found");
        }
        return hibernateClass;
    }

    protected String getVersion() {
        return this.version;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    protected String getProperty(Map properties, String name) {
        String value = ObjectUtils.toString(properties.get(name));
        return value;
    }

    protected String getRequiredProperty(Map properties, String name) {
        String value = ObjectUtils.toString(properties.get(name));
        if (StringUtils.isBlank((String)value)) {
            throw new SchemaManagementException("The '" + name + "' must be specified");
        }
        return value;
    }

    protected String getOutputPath() {
        return this.outputPath;
    }

    protected abstract String getExecutionClassName();

    @Override
    public String execute(Connection connection, Map options) throws Exception {
        String hibernateDialect = "hibernate.dialect";
        System.setProperty("hibernate.dialect", this.getRequiredProperty(options, "hibernate.dialect"));
        List<String> argumentList = this.getArguments(options);
        String[] arguments = argumentList.toArray(new String[argumentList.size()]);
        Class executionClass = this.getExecutionClass();
        Method method = executionClass.getMethod("main", String[].class);
        method.invoke((Object)executionClass, new Object[]{arguments});
        return this.getExecutionOuputPath(options);
    }

    protected abstract String getExecutionOuputPath(Map var1);

    private List<String> getArguments(Map options) throws Exception {
        List<String> mappingFiles = this.getMappingFilesList(this.getRequiredProperty(options, "mappingFileExtension"), this.getRequiredProperty(options, "mappingsLocation"));
        String[] args = new String[]{"--delimiter=;", "--format"};
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.addAll(mappingFiles);
        this.addArguments(options, arguments);
        return arguments;
    }

    protected abstract void addArguments(Map var1, List<String> var2) throws Exception;

    protected List<String> getMappingFilesList(String extension, String baseDirectory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDirectory);
        scanner.setIncludes(new String[]{"**/*." + extension});
        scanner.setExcludes(null);
        scanner.scan();
        ArrayList<String> files = new ArrayList<String>();
        for (String path : Arrays.asList(scanner.getIncludedFiles())) {
            files.add(new File(baseDirectory, path).toString());
        }
        return files;
    }
}

