/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.andromda.cartridges.spring.SpringHibernateUtils;
import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.metafacades.SpringEntity;
import org.andromda.cartridges.spring.metafacades.SpringEntityLogic;
import org.andromda.cartridges.spring.metafacades.SpringMetafacadeUtils;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.EntityQueryOperation;
import org.andromda.metafacades.uml.EnumerationFacade;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ValueObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SpringEntityLogicImpl
extends SpringEntityLogic {
    private static final long serialVersionUID = 34L;
    private static final String INHERITANCE_STRATEGY_CLASS = "class";
    private static final String INHERITANCE_STRATEGY_SUBCLASS = "subclass";
    private static final String INHERITANCE_STRATEGY_CONCRETE = "concrete";
    private static final String INHERITANCE_STRATEGY_INTERFACE = "interface";
    private static final Collection<String> INHERITANCE_STRATEGIES = new ArrayList<String>();
    private static final String NO_TRANSFORMATION_CONSTANT_SUFFIX = "NONE";
    private static final String INHERITANCE_STRATEGY = "hibernateInheritanceStrategy";

    public SpringEntityLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetDaoName() {
        return this.getDaoNamePattern().replaceAll("\\{0\\}", this.getName());
    }

    private String getDaoNamePattern() {
        return String.valueOf(this.getConfiguredProperty("daoNamePattern"));
    }

    @Override
    protected String handleGetFullyQualifiedDaoName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getDaoName());
    }

    @Override
    protected String handleGetDaoImplementationName() {
        return this.getDaoImplementationNamePattern().replaceAll("\\{0\\}", this.getName());
    }

    private String getDaoImplementationNamePattern() {
        return String.valueOf(this.getConfiguredProperty("daoImplementationNamePattern"));
    }

    @Override
    protected String handleGetFullyQualifiedDaoImplementationName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getDaoImplementationName());
    }

    @Override
    protected String handleGetDaoBaseName() {
        return this.getDaoBaseNamePattern().replaceAll("\\{0\\}", this.getName());
    }

    private String getDaoBaseNamePattern() {
        return String.valueOf(this.getConfiguredProperty("daoBaseNamePattern"));
    }

    @Override
    protected String handleGetFullyQualifiedDaoBaseName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getDaoBaseName());
    }

    @Override
    protected String handleGetEntityImplementationName() {
        return this.getEntityName() + "Impl";
    }

    @Override
    protected String handleGetFullyQualifiedEntityImplementationName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getEntityName(), "Impl");
    }

    @Override
    protected String handleGetBeanName(boolean targetSuffix) {
        String beanName = StringUtils.uncapitalize((String)StringUtils.trimToEmpty((String)this.getName()));
        StringBuilder beanNameBuffer = new StringBuilder(String.valueOf(this.getConfiguredProperty("beanNamePrefix")));
        beanNameBuffer.append(this.getDaoNamePattern().replaceAll("\\{0\\}", beanName));
        if (targetSuffix) {
            beanNameBuffer.append("Target");
        }
        return beanNameBuffer.toString();
    }

    @Override
    protected String handleGetEntityName() {
        String entityNamePattern = (String)this.getConfiguredProperty("entityNamePattern");
        return MessageFormat.format(entityNamePattern, StringUtils.trimToEmpty((String)this.getName()));
    }

    @Override
    protected String handleGetFullyQualifiedEntityName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getEntityName(), null);
    }

    @Override
    protected Object handleGetRoot() {
        SpringEntityLogicImpl generalization = this;
        while (generalization.getGeneralization() != null && generalization instanceof SpringEntity) {
            generalization = generalization.getGeneralization();
        }
        return generalization;
    }

    @Override
    protected boolean handleIsDaoBusinessOperationsPresent() {
        return this.getDaoBusinessOperations() != null && !this.getDaoBusinessOperations().isEmpty();
    }

    @Override
    protected Collection<OperationFacade> handleGetDaoBusinessOperations() {
        Collection<EntityQueryOperation> finders = this.getQueryOperations();
        List<OperationFacade> operations = this.getOperations();
        Collection nonFinders = CollectionUtils.subtract(operations, finders);
        return new FilteredCollection(nonFinders){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return ((OperationFacade)object).isStatic();
            }
        };
    }

    @Override
    protected Collection<DependencyFacade> handleGetValueObjectReferences() {
        return this.getValueObjectReferences(false);
    }

    protected Collection<DependencyFacade> getValueObjectReferences(boolean follow) {
        ArrayList<DependencyFacade> sourceDependencies = new ArrayList<DependencyFacade>(this.getSourceDependencies());
        if (follow) {
            for (GeneralizableElementFacade entity = this.getGeneralization(); entity != null; entity = entity.getGeneralization()) {
                sourceDependencies.addAll(entity.getSourceDependencies());
            }
        }
        return new FilteredCollection(sourceDependencies){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                boolean valid = false;
                ModelElementFacade targetElement = ((DependencyFacade)object).getTargetElement();
                if (targetElement instanceof ClassifierFacade) {
                    ClassifierFacade element = (ClassifierFacade)targetElement;
                    valid = element.isDataType() || element instanceof ValueObject || element instanceof EnumerationFacade;
                }
                return valid;
            }
        };
    }

    @Override
    protected Collection<DependencyFacade> handleGetAllValueObjectReferences() {
        return this.getValueObjectReferences(true);
    }

    @Override
    protected boolean handleIsDaoImplementationRequired() {
        return !this.getValueObjectReferences().isEmpty() || !this.getDaoBusinessOperations().isEmpty() || !this.getQueryOperations(true).isEmpty();
    }

    @Override
    protected String handleGetDaoNoTransformationConstantName() {
        return "TRANSFORM_NONE";
    }

    protected boolean checkHibInheritance(String inheritance) {
        return inheritance.equals(this.getHibernateInheritanceStrategy());
    }

    @Override
    protected boolean handleIsHibernateInheritanceClass() {
        return this.checkHibInheritance(INHERITANCE_STRATEGY_CLASS);
    }

    @Override
    protected boolean handleIsHibernateInheritanceInterface() {
        return this.checkHibInheritance(INHERITANCE_STRATEGY_INTERFACE);
    }

    @Override
    protected boolean handleIsHibernateInheritanceSubclass() {
        return this.checkHibInheritance(INHERITANCE_STRATEGY_SUBCLASS);
    }

    @Override
    protected boolean handleIsHibernateInheritanceConcrete() {
        return this.checkHibInheritance(INHERITANCE_STRATEGY_CONCRETE);
    }

    @Override
    protected String handleGetHibernateInheritanceStrategy() {
        String inheritance = this.getInheritance(this);
        SpringEntity superEntity = this.getSpringSuperEntity();
        while (superEntity != null && StringUtils.isBlank((String)inheritance)) {
            inheritance = superEntity.getHibernateInheritanceStrategy();
        }
        String string = inheritance = inheritance != null ? inheritance.toLowerCase() : null;
        if (StringUtils.isBlank((String)inheritance) || !INHERITANCE_STRATEGIES.contains(inheritance)) {
            inheritance = this.getDefaultInheritanceStrategy();
        }
        return inheritance;
    }

    private String getDefaultInheritanceStrategy() {
        return String.valueOf(this.getConfiguredProperty(INHERITANCE_STRATEGY));
    }

    private String getInheritance(SpringEntity entity) {
        Object value;
        String inheritance = null;
        if (entity != null && (value = entity.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_INHERITANCE)) != null) {
            inheritance = String.valueOf(value);
        }
        return inheritance;
    }

    @Override
    protected boolean handleIsRequiresHibernateMapping() {
        SpringEntity superEntity = this.getSpringSuperEntity();
        return SpringHibernateUtils.mapSubclassesInSeparateFile((String)this.getConfiguredProperty("hibernateMappingStrategy")) || this.isRoot() && (!this.isHibernateInheritanceInterface() || this.getSpecializations().isEmpty() || superEntity != null && superEntity.isHibernateInheritanceInterface());
    }

    private boolean isRoot() {
        SpringEntity superEntity = this.getSpringSuperEntity();
        boolean abstractConcreteEntity = (this.isHibernateInheritanceConcrete() || this.isHibernateInheritanceInterface()) && this.isAbstract();
        return (this.getSpringSuperEntity() == null || superEntity.isHibernateInheritanceInterface() || superEntity.isHibernateInheritanceConcrete()) && !abstractConcreteEntity;
    }

    private SpringEntity getSpringSuperEntity() {
        SpringEntity superEntity = null;
        if (this.getGeneralization() != null && this.getGeneralization() instanceof SpringEntity) {
            superEntity = (SpringEntity)this.getGeneralization();
        }
        return superEntity;
    }

    @Override
    protected String handleGetAttributeEmbeddedValueList() {
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = this.getEmbeddedValues().iterator();
        while (iterator.hasNext()) {
            AttributeFacade attribute = (AttributeFacade)iterator.next();
            String name = attribute.getName();
            if (!StringUtils.isNotBlank((String)name)) continue;
            buffer.append('\"').append(name).append('\"');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    @Override
    protected boolean handleIsRichClient() {
        String richClient = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("richClient")));
        return "true".equalsIgnoreCase(richClient);
    }

    static {
        INHERITANCE_STRATEGIES.add(INHERITANCE_STRATEGY_CLASS);
        INHERITANCE_STRATEGIES.add(INHERITANCE_STRATEGY_SUBCLASS);
        INHERITANCE_STRATEGIES.add(INHERITANCE_STRATEGY_CONCRETE);
        INHERITANCE_STRATEGIES.add(INHERITANCE_STRATEGY_INTERFACE);
    }
}

