/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class QIcon
implements Icon {
    public static final int NORTH = 1;
    public static final int NORTH_EAST = 2;
    public static final int NORTH_WEST = 8;
    public static final int WEST = 7;
    public static final int EAST = 3;
    public static final int CENTER = 0;
    public static final int SOUTH = 5;
    public static final int SOUTH_EAST = 4;
    public static final int SOUTH_WEST = 6;
    private Icon baseIcon = null;
    private List<Object[]> overlays = null;

    public QIcon(Icon baseIcon) {
        this(baseIcon, null, -1);
    }

    public QIcon(Icon baseIcon, Icon overlay, int position) {
        this.baseIcon = baseIcon;
        this.overlays = new ArrayList<Object[]>();
        if (overlay != null) {
            this.addOverlayIcon(overlay, position);
        }
    }

    public void addOverlayIcon(Icon icon, int pos) {
        Point position = this.getPosition(icon, pos);
        this.addOverlayIcon(icon, position);
    }

    public void addOverlayIcon(Icon icon, int xpos, int ypos) {
        Point position = new Point(xpos, ypos);
        this.addOverlayIcon(icon, position);
    }

    public void addOverlayIcon(Icon icon, Point position) {
        Object[] objects = new Object[]{icon, position};
        this.overlays.add(objects);
    }

    private Point getPosition(Icon overlayIcon, int position) {
        int x = 0;
        int y = 0;
        switch (position) {
            case 2: {
                x = this.baseIcon.getIconWidth() - overlayIcon.getIconWidth();
                y = 0;
                break;
            }
            case 1: {
                x = (this.baseIcon.getIconWidth() - overlayIcon.getIconWidth()) / 2;
                y = 0;
                break;
            }
            case 8: {
                x = 0;
                y = 0;
                break;
            }
            case 7: {
                x = 0;
                y = (this.baseIcon.getIconHeight() - overlayIcon.getIconHeight()) / 2;
                break;
            }
            case 0: {
                x = (this.baseIcon.getIconWidth() - overlayIcon.getIconWidth()) / 2;
                y = (this.baseIcon.getIconHeight() - overlayIcon.getIconHeight()) / 2;
                break;
            }
            case 3: {
                x = this.baseIcon.getIconWidth() - overlayIcon.getIconWidth();
                y = (this.baseIcon.getIconHeight() - overlayIcon.getIconHeight()) / 2;
                break;
            }
            case 4: {
                x = this.baseIcon.getIconWidth() - overlayIcon.getIconWidth();
                y = this.baseIcon.getIconHeight() - overlayIcon.getIconHeight();
                break;
            }
            case 5: {
                x = (this.baseIcon.getIconWidth() - overlayIcon.getIconWidth()) / 2;
                y = this.baseIcon.getIconHeight() - overlayIcon.getIconHeight();
                break;
            }
            case 6: {
                x = 0;
                y = this.baseIcon.getIconHeight() - overlayIcon.getIconHeight();
                break;
            }
            default: {
                x = (this.baseIcon.getIconWidth() - overlayIcon.getIconWidth()) / 2;
                y = (this.baseIcon.getIconHeight() - overlayIcon.getIconHeight()) / 2;
            }
        }
        return new Point(x, y);
    }

    public int getIconHeight() {
        return this.baseIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.baseIcon.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.baseIcon.paintIcon(c, g, x, y);
        for (int i = 0; i < this.overlays.size(); ++i) {
            Object[] objects = this.overlays.get(i);
            Icon overlayIcon = (Icon)objects[0];
            Point position = (Point)objects[1];
            overlayIcon.paintIcon(c, g, x + (int)position.getX(), y + (int)position.getY());
        }
    }
}

