/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.security;

import net.timewalker.ffmq4.security.Privilege;
import net.timewalker.ffmq4.security.User;
import net.timewalker.ffmq4.security.XMLSecurityDescriptor;
import net.timewalker.ffmq4.utils.descriptor.AbstractDescriptor;
import net.timewalker.ffmq4.utils.xml.AbstractXMLDescriptorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class XMLSecurityDescriptorHandler
extends AbstractXMLDescriptorHandler {
    private XMLSecurityDescriptor descriptor = new XMLSecurityDescriptor();
    private User currentUser;
    private Privilege currentPrivilege;

    public AbstractDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void before(String name, String currentPath, Attributes attributes) throws SAXException {
        if (currentPath.equals("security/users/user")) {
            this.currentUser = new User();
            this.currentUser.setName(this.getRequired(attributes, "name"));
            this.currentUser.setPassword(this.getRequired(attributes, "password"));
        }
        if (currentPath.equals("security/users/user/privilege")) {
            this.currentPrivilege = new Privilege();
            this.currentPrivilege.setResourcePattern(this.getRequired(attributes, "resource"));
            this.currentPrivilege.setActions(this.getRequired(attributes, "actions"));
        }
    }

    protected void onNode(String name, String currentPath) throws SAXException {
        if (!currentPath.equals("security") && !currentPath.equals("security/users")) {
            if (currentPath.equals("security/users/user")) {
                this.descriptor.addUser(this.currentUser);
                this.currentUser = null;
            } else if (currentPath.equals("security/users/user/privilege")) {
                this.currentUser.addPrivilege(this.currentPrivilege);
                this.currentPrivilege = null;
            } else {
                throw new SAXException("Unexpected node : " + name + " (" + currentPath + ")");
            }
        }
    }
}

