/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.jmx;

import java.lang.management.ManagementFactory;
import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.jmx.JMXAgent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJMXAgent
implements JMXAgent {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    public AbstractJMXAgent() {
        this.init();
    }

    protected abstract String getType();

    private void init() {
        this.log.info((Object)("Starting JMX agent (" + this.getType() + ")"));
    }

    @Override
    public void stop() {
        this.log.info((Object)"Stopping JMX agent");
    }

    @Override
    public final void register(ObjectName name, Object mBean) throws JMSException {
        this.log.debug((Object)("Registering object " + name));
        try {
            this.mBeanServer.registerMBean(mBean, name);
        }
        catch (Exception e) {
            throw new FFMQException("Cannot register MBean", "JMX_ERROR", (Throwable)e);
        }
    }

    @Override
    public final void unregister(ObjectName name) throws JMSException {
        this.log.debug((Object)("Unregistering object " + name));
        try {
            this.mBeanServer.unregisterMBean(name);
        }
        catch (Exception e) {
            throw new FFMQException("Cannot unregister MBean", "JMX_ERROR", (Throwable)e);
        }
    }
}

