/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.tcp;

import java.net.SocketAddress;
import net.timewalker.ffmq4.transport.AbstractPacketTransport;
import net.timewalker.ffmq4.utils.Settings;

public abstract class AbstractTcpPacketTransport
extends AbstractPacketTransport {
    protected int streamSendBufferSize;
    protected int streamRecvBufferSize;
    protected int initialPacketBufferSize;
    protected int socketSendBufferSize;
    protected int socketRecvBufferSize;
    protected int sendQueueMaxSize;
    public int pingInterval;

    public AbstractTcpPacketTransport(String id, boolean client, Settings settings) {
        super(id, client);
        this.streamSendBufferSize = settings.getIntProperty("transport.tcp.stream.sendBufferSize", 8192);
        this.streamRecvBufferSize = settings.getIntProperty("transport.tcp.stream.recvBufferSize", 8192);
        this.initialPacketBufferSize = settings.getIntProperty("transport.tcp.initialPacketBufferSize", 4096);
        this.socketSendBufferSize = settings.getIntProperty("transport.tcp.socket.sendBufferSize", 65536);
        this.socketRecvBufferSize = settings.getIntProperty("transport.tcp.socket.recvBufferSize", 65536);
        this.sendQueueMaxSize = settings.getIntProperty("transport.tcp.sendQueueMaxSize", 100);
        this.pingInterval = settings.getIntProperty("transport.tcp.pingInterval", 30);
    }

    @Override
    public final String getRemotePeerID() {
        SocketAddress peerAddress = this.getRemotePeer();
        return peerAddress != null ? peerAddress.toString() : "not connected";
    }

    public abstract SocketAddress getRemotePeer();
}

