/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.remote.session;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.client.ClientEnvironment;
import net.timewalker.ffmq4.common.destination.DestinationTools;
import net.timewalker.ffmq4.common.destination.TemporaryQueueRef;
import net.timewalker.ffmq4.common.destination.TemporaryTopicRef;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageTools;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.remote.connection.RemoteConnection;
import net.timewalker.ffmq4.remote.session.RemoteDurableTopicSubscriber;
import net.timewalker.ffmq4.remote.session.RemoteMessageConsumer;
import net.timewalker.ffmq4.remote.session.RemoteMessageProducer;
import net.timewalker.ffmq4.remote.session.RemoteQueueBrowser;
import net.timewalker.ffmq4.storage.data.DataStoreFullException;
import net.timewalker.ffmq4.transport.PacketTransportEndpoint;
import net.timewalker.ffmq4.transport.packet.AbstractQueryPacket;
import net.timewalker.ffmq4.transport.packet.query.AcknowledgeQuery;
import net.timewalker.ffmq4.transport.packet.query.CloseSessionQuery;
import net.timewalker.ffmq4.transport.packet.query.CommitQuery;
import net.timewalker.ffmq4.transport.packet.query.CreateSessionQuery;
import net.timewalker.ffmq4.transport.packet.query.CreateTemporaryQueueQuery;
import net.timewalker.ffmq4.transport.packet.query.CreateTemporaryTopicQuery;
import net.timewalker.ffmq4.transport.packet.query.PutQuery;
import net.timewalker.ffmq4.transport.packet.query.RecoverQuery;
import net.timewalker.ffmq4.transport.packet.query.RollbackQuery;
import net.timewalker.ffmq4.transport.packet.query.UnsubscribeQuery;
import net.timewalker.ffmq4.transport.packet.response.CreateTemporaryQueueResponse;
import net.timewalker.ffmq4.transport.packet.response.CreateTemporaryTopicResponse;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.id.IntegerID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteSession
extends AbstractSession {
    private static final Log log = LogFactory.getLog(RemoteSession.class);
    protected final PacketTransportEndpoint transportEndpoint;
    private boolean sendAcksAsync;
    private boolean retryOnQueueFull;
    private long retryTimeout;
    private List<String> deliveredMessageIDs = new Vector<String>();
    private Object retryLock = new Object();
    private boolean debugEnabled = log.isDebugEnabled();
    private boolean synchronousAckRequired;

    public RemoteSession(IntegerID sessionId, RemoteConnection connection, PacketTransportEndpoint transportEndpoint, boolean transacted, int acknowledgeMode) {
        super(sessionId, connection, transacted, acknowledgeMode);
        this.transportEndpoint = transportEndpoint;
        this.sendAcksAsync = ClientEnvironment.getSettings().getBooleanProperty("consumer.sendAcksAsync", true);
        this.retryOnQueueFull = ClientEnvironment.getSettings().getBooleanProperty("producer.retryOnQueueFull", true);
        this.retryTimeout = ClientEnvironment.getSettings().getLongProperty("producer.retryTimeout", 30000L);
        log.debug((Object)("New remote session ID is " + sessionId));
    }

    public void remoteInit() throws JMSException {
        CreateSessionQuery query = new CreateSessionQuery();
        query.setSessionId(this.id);
        query.setTransacted(this.transacted);
        query.setAcknowledgeMode(this.acknowledgeMode);
        this.transportEndpoint.blockingRequest(query);
    }

    public final PacketTransportEndpoint getTransportEndpoint() {
        return this.transportEndpoint;
    }

    protected final void dispatch(Message message) throws JMSException {
        if (this.debugEnabled) {
            log.debug((Object)("#" + this.id + " Sending message " + message.getJMSMessageID()));
        }
        boolean asyncDispatch = this.transacted || message.getJMSDeliveryMode() == 1;
        PutQuery query = new PutQuery();
        query.setSessionId(this.id);
        if (asyncDispatch) {
            AbstractMessage msgCopy = MessageTools.makeInternalCopy(message);
            query.setMessage(msgCopy);
        } else {
            query.setMessage((AbstractMessage)message);
        }
        if (asyncDispatch) {
            this.transportEndpoint.nonBlockingRequest(query);
        } else if (this.retryOnQueueFull) {
            this.retriableBlockingQuery(query, this.retryTimeout);
        } else {
            this.transportEndpoint.blockingRequest(query);
        }
    }

    public final void notifyDeliveredMessage(String deliveredMessageID) {
        this.externalAccessLock.readLock().lock();
        try {
            if (this.closed) {
                return;
            }
            if (this.debugEnabled) {
                log.debug((Object)(this + " Adding delivered message ID : " + deliveredMessageID));
            }
            this.deliveredMessageIDs.add(deliveredMessageID);
            if (!this.transacted && this.acknowledgeMode != 3) {
                this.synchronousAckRequired = true;
            }
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RemoteQueueBrowser browser = new RemoteQueueBrowser(this.idProvider.createID(), this, queue, messageSelector);
            this.registerBrowser(browser);
            browser.remoteInit();
            RemoteQueueBrowser remoteQueueBrowser = browser;
            return remoteQueueBrowser;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RemoteMessageConsumer consumer = new RemoteMessageConsumer(this.idProvider.createID(), this, DestinationTools.asRef(destination), messageSelector, noLocal);
            this.registerConsumer(consumer);
            consumer.remoteInit();
            RemoteMessageConsumer remoteMessageConsumer = consumer;
            return remoteMessageConsumer;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RemoteDurableTopicSubscriber subscriber = new RemoteDurableTopicSubscriber(this.idProvider.createID(), this, topic, messageSelector, noLocal, name);
            this.registerConsumer(subscriber);
            subscriber.remoteInit();
            RemoteDurableTopicSubscriber remoteDurableTopicSubscriber = subscriber;
            return remoteDurableTopicSubscriber;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageProducer createProducer(Destination destination) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RemoteMessageProducer producer = new RemoteMessageProducer(this, (Destination)DestinationTools.asRef(destination), this.idProvider.createID());
            this.registerProducer(producer);
            RemoteMessageProducer remoteMessageProducer = producer;
            return remoteMessageProducer;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            CreateTemporaryQueueQuery query = new CreateTemporaryQueueQuery();
            query.setSessionId(this.id);
            CreateTemporaryQueueResponse response = (CreateTemporaryQueueResponse)this.transportEndpoint.blockingRequest(query);
            TemporaryQueueRef temporaryQueueRef = new TemporaryQueueRef(this.connection, response.getQueueName());
            return temporaryQueueRef;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            CreateTemporaryTopicQuery query = new CreateTemporaryTopicQuery();
            query.setSessionId(this.id);
            CreateTemporaryTopicResponse response = (CreateTemporaryTopicResponse)this.transportEndpoint.blockingRequest(query);
            TemporaryTopicRef temporaryTopicRef = new TemporaryTopicRef(this.connection, response.getTopicName());
            return temporaryTopicRef;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void recover() throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Session is transacted");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RecoverQuery query = new RecoverQuery();
            query.setSessionId(this.id);
            query.setDeliveredMessageIDs(this.deliveredMessageIDs);
            this.transportEndpoint.blockingRequest(query);
            this.deliveredMessageIDs.clear();
            this.synchronousAckRequired = false;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public void unsubscribe(String subscriptionName) throws JMSException {
        if (StringTools.isEmpty(subscriptionName)) {
            throw new FFMQException("Empty subscription name", "INVALID_SUBSCRIPTION_NAME");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            UnsubscribeQuery query = new UnsubscribeQuery();
            query.setSessionId(this.id);
            query.setSubscriptionName(subscriptionName);
            this.transportEndpoint.blockingRequest(query);
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void commit() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        log.debug((Object)("#" + this.id + " commit()"));
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            CommitQuery query = new CommitQuery();
            query.setSessionId(this.id);
            query.setDeliveredMessageIDs(this.deliveredMessageIDs);
            if (this.retryOnQueueFull) {
                this.retriableBlockingQuery(query, this.retryTimeout);
            } else {
                this.transportEndpoint.blockingRequest(query);
            }
            this.deliveredMessageIDs.clear();
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retriableBlockingQuery(AbstractQueryPacket query, long retryTimeout) throws JMSException {
        long retryWait = 50L;
        long totalWait = 0L;
        while (true) {
            try {
                this.transportEndpoint.blockingRequest(query);
            }
            catch (DataStoreFullException e) {
                if (retryTimeout <= 0L || totalWait < retryTimeout) {
                    this.externalAccessLock.readLock().unlock();
                    try {
                        Object object = this.retryLock;
                        synchronized (object) {
                            this.retryLock.wait(retryWait);
                        }
                    }
                    catch (InterruptedException ex) {
                        throw e;
                    }
                    finally {
                        this.externalAccessLock.readLock().lock();
                    }
                    if (this.closed) {
                        throw new IllegalStateException("Session is closed");
                    }
                    if ((totalWait += retryWait) >= retryTimeout) continue;
                    if ((retryWait *= 2L) > 2000L) {
                        retryWait = 2000L;
                    }
                    if (retryWait <= retryTimeout - totalWait) continue;
                    retryWait = retryTimeout - totalWait;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public final void rollback() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        log.debug((Object)("#" + this.id + " rollback()"));
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RollbackQuery query = new RollbackQuery();
            query.setSessionId(this.id);
            query.setDeliveredMessageIDs(this.deliveredMessageIDs);
            this.transportEndpoint.blockingRequest(query);
            this.deliveredMessageIDs.clear();
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSessionClose() {
        super.onSessionClose();
        if (this.retryOnQueueFull) {
            Object object = this.retryLock;
            synchronized (object) {
                this.retryLock.notifyAll();
            }
        }
        try {
            CloseSessionQuery query = new CloseSessionQuery();
            query.setSessionId(this.id);
            this.transportEndpoint.blockingRequest(query);
        }
        catch (JMSException e) {
            ErrorTools.log(e, log);
        }
    }

    @Override
    protected void onSessionClosed() {
        super.onSessionClosed();
        this.transportEndpoint.close();
    }

    @Override
    public final void acknowledge() throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Session is transacted");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            if (this.deliveredMessageIDs.isEmpty()) {
                throw new FFMQException("No received message to acknowledge", "INTERNAL_ERROR");
            }
            if (this.sendAcksAsync && !this.synchronousAckRequired) {
                ArrayList<String> messageIDs = new ArrayList<String>(this.deliveredMessageIDs.size());
                for (int n = 0; n < this.deliveredMessageIDs.size(); ++n) {
                    messageIDs.add(this.deliveredMessageIDs.get(n));
                }
                this.deliveredMessageIDs.clear();
                AcknowledgeQuery query = new AcknowledgeQuery();
                query.setSessionId(this.id);
                query.setDeliveredMessageIDs(messageIDs);
                this.transportEndpoint.nonBlockingRequest(query);
            } else {
                AcknowledgeQuery query = new AcknowledgeQuery();
                query.setSessionId(this.id);
                query.setDeliveredMessageIDs(this.deliveredMessageIDs);
                this.transportEndpoint.blockingRequest(query);
                this.deliveredMessageIDs.clear();
            }
            this.synchronousAckRequired = false;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }
}

