/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.SerializationTools;

public final class ObjectMessageImpl
extends AbstractMessage
implements ObjectMessage {
    private byte[] body;

    public ObjectMessageImpl() {
    }

    public ObjectMessageImpl(Serializable object) throws JMSException {
        this.setObject(object);
    }

    @Override
    protected byte getType() {
        return 4;
    }

    @Override
    protected void unserializeBodyFrom(RawDataBuffer in) {
        this.body = in.readNullableByteArray();
    }

    @Override
    protected final void serializeBodyTo(RawDataBuffer out) {
        out.writeNullableByteArray(this.body);
    }

    public void clearBody() {
        this.assertDeserializationLevel(3);
        this.body = null;
        this.bodyIsReadOnly = false;
    }

    public Serializable getObject() throws JMSException {
        if (this.body == null) {
            return null;
        }
        try {
            return SerializationTools.fromByteArray(this.body);
        }
        catch (Exception e) {
            throw new FFMQException("Cannot deserialize object message body", "MESSAGE_ERROR", e);
        }
    }

    public void setObject(Serializable object) throws JMSException {
        if (this.bodyIsReadOnly) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
        this.assertDeserializationLevel(3);
        if (object == null) {
            this.body = null;
            return;
        }
        try {
            this.body = SerializationTools.toByteArray(object);
        }
        catch (Exception e) {
            throw new FFMQException("Cannot serialize object message body", "MESSAGE_ERROR", e);
        }
    }

    @Override
    public AbstractMessage copy() {
        ObjectMessageImpl clone = new ObjectMessageImpl();
        this.copyCommonFields(clone);
        clone.body = this.body;
        return clone;
    }

    @Override
    public String toString() {
        return super.toString() + " bodySize=" + this.body.length;
    }
}

