/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.remote.session;

import java.util.NoSuchElementException;
import javax.jms.JMSException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.session.AbstractQueueBrowserEnumeration;
import net.timewalker.ffmq4.remote.session.RemoteQueueBrowser;
import net.timewalker.ffmq4.remote.session.RemoteSession;
import net.timewalker.ffmq4.transport.PacketTransportEndpoint;
import net.timewalker.ffmq4.transport.packet.query.CloseBrowserEnumerationQuery;
import net.timewalker.ffmq4.transport.packet.query.QueueBrowserFetchElementQuery;
import net.timewalker.ffmq4.transport.packet.query.QueueBrowserGetEnumerationQuery;
import net.timewalker.ffmq4.transport.packet.response.QueueBrowserFetchElementResponse;
import net.timewalker.ffmq4.transport.packet.response.QueueBrowserGetEnumerationResponse;
import net.timewalker.ffmq4.utils.ErrorTools;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RemoteQueueBrowserEnumeration
extends AbstractQueueBrowserEnumeration {
    private static final Log log = LogFactory.getLog(RemoteQueueBrowserEnumeration.class);
    private PacketTransportEndpoint transportEndpoint;
    private RemoteSession session;
    private AbstractMessage nextMessage;
    private boolean endOfQueueReached;

    public RemoteQueueBrowserEnumeration(RemoteSession session, RemoteQueueBrowser browser) {
        super(browser, null);
        this.transportEndpoint = session.getTransportEndpoint();
        this.session = session;
    }

    protected void remoteInit() throws JMSException {
        QueueBrowserGetEnumerationQuery query = new QueueBrowserGetEnumerationQuery();
        query.setSessionId(this.session.getId());
        query.setBrowserId(this.browser.getId());
        QueueBrowserGetEnumerationResponse response = (QueueBrowserGetEnumerationResponse)this.transportEndpoint.blockingRequest(query);
        this.id = response.getEnumId();
        log.debug((Object)("Remote queue browser enumeration ID is " + this.id));
    }

    private AbstractMessage fetchNext() throws JMSException {
        if (this.nextMessage != null) {
            return this.nextMessage;
        }
        QueueBrowserFetchElementQuery query = new QueueBrowserFetchElementQuery();
        query.setSessionId(this.session.getId());
        query.setBrowserId(this.browser.getId());
        query.setEnumId(this.id);
        QueueBrowserFetchElementResponse response = (QueueBrowserFetchElementResponse)this.transportEndpoint.blockingRequest(query);
        this.nextMessage = response.getMessage();
        if (this.nextMessage == null) {
            this.endOfQueueReached = true;
            this.close();
        }
        return this.nextMessage;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.endOfQueueReached) {
            return false;
        }
        try {
            this.checkNotClosed();
            AbstractMessage msg = this.fetchNext();
            return msg != null;
        }
        catch (JMSException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    @Override
    public AbstractMessage nextElement() {
        if (this.endOfQueueReached) {
            throw new NoSuchElementException();
        }
        try {
            this.checkNotClosed();
            AbstractMessage msg = this.fetchNext();
            if (msg != null) {
                this.nextMessage = null;
                msg.ensureDeserializationLevel(3);
                msg.markAsReadOnly();
                return msg;
            }
            throw new NoSuchElementException();
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (JMSException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    @Override
    protected void onQueueBrowserEnumerationClose() {
        try {
            CloseBrowserEnumerationQuery query = new CloseBrowserEnumerationQuery();
            query.setSessionId(this.session.getId());
            query.setBrowserId(this.browser.getId());
            query.setEnumId(this.id);
            this.transportEndpoint.blockingRequest(query);
        }
        catch (JMSException e) {
            ErrorTools.log(e, log);
        }
    }
}

