/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.remote.session;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import net.timewalker.ffmq4.common.destination.DestinationTools;
import net.timewalker.ffmq4.remote.connection.RemoteConnection;
import net.timewalker.ffmq4.remote.session.RemoteQueueReceiver;
import net.timewalker.ffmq4.remote.session.RemoteQueueSender;
import net.timewalker.ffmq4.remote.session.RemoteSession;
import net.timewalker.ffmq4.transport.PacketTransportEndpoint;
import net.timewalker.ffmq4.utils.id.IntegerID;

public final class RemoteQueueSession
extends RemoteSession
implements QueueSession {
    public RemoteQueueSession(IntegerID sessionId, RemoteConnection connection, PacketTransportEndpoint transportEndpoint, boolean transacted, int acknowledgeMode) {
        super(sessionId, connection, transportEndpoint, transacted, acknowledgeMode);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RemoteQueueReceiver receiver = new RemoteQueueReceiver(this.idProvider.createID(), this, DestinationTools.asRef(queue), messageSelector);
            this.registerConsumer(receiver);
            receiver.remoteInit();
            RemoteQueueReceiver remoteQueueReceiver = receiver;
            return remoteQueueReceiver;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            RemoteQueueSender sender = new RemoteQueueSender((RemoteSession)this, DestinationTools.asRef(queue), this.idProvider.createID());
            this.registerProducer(sender);
            RemoteQueueSender remoteQueueSender = sender;
            return remoteQueueSender;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }

    @Override
    public void unsubscribe(String subscriptionName) throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }
}

