/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression;

import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.selector.expression.AtomicOperand;
import net.timewalker.ffmq4.common.message.selector.expression.utils.ArithmeticUtils;

public abstract class SelectorNode {
    public abstract Object evaluate(Message var1) throws JMSException;

    protected final Object negate(Object value) {
        if (value == null) {
            return null;
        }
        return (Boolean)value != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public final Boolean evaluateBoolean(Message message) throws JMSException {
        Object value = this.evaluate(message);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new FFMQException("Expected a boolean but got : " + value.toString(), "INVALID_SELECTOR_EXPRESSION");
    }

    public final Number evaluateNumeric(Message message) throws JMSException {
        Object value = this.evaluate(message);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ArithmeticUtils.normalize((Number)value);
        }
        throw new FFMQException("Expected a numeric but got : " + value.toString(), "INVALID_SELECTOR_EXPRESSION");
    }

    public final String evaluateString(Message message) throws JMSException {
        Object value = this.evaluate(message);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new FFMQException("Expected a string but got : " + value.toString(), "INVALID_SELECTOR_EXPRESSION");
    }

    protected final int getNodeType(Object value) {
        if (value instanceof String) {
            return 1;
        }
        if (value instanceof Boolean) {
            return 3;
        }
        return 2;
    }

    protected final String parenthesize(SelectorNode node) {
        if (node instanceof AtomicOperand) {
            return node.toString();
        }
        return "(" + node + ")";
    }
}

