/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.thucydides.core.IgnoredStepException;
import net.thucydides.core.PendingStepException;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.steps.AnnotatedStepDescription;
import net.thucydides.core.steps.DefaultValue;
import net.thucydides.core.steps.ErrorConvertor;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepArgumentWriter;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import org.apache.commons.lang3.StringUtils;
import org.junit.internal.AssumptionViolatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> testStepClass;
    private Throwable error = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepInterceptor.class);
    private boolean throwExceptionImmediately = false;
    private final List<String> OBJECT_METHODS = Arrays.asList("toString", "equals", "hashcode", "clone", "notify", "notifyAll", "wait", "finalize", "getMetaClass");

    public StepInterceptor(Class<?> testStepClass) {
        this.testStepClass = testStepClass;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = this.baseClassMethod(method, obj.getClass()) ? this.runBaseObjectMethod(obj, method, args, proxy) : this.testStepResult(obj, method, args, proxy);
        return result;
    }

    private boolean baseClassMethod(Method method, Class callingClass) {
        boolean methodDoesNotComeFromThisClassOrARelatedParentClass;
        boolean isACoreLanguageMethod = this.OBJECT_METHODS.contains(method.getName());
        boolean bl = methodDoesNotComeFromThisClassOrARelatedParentClass = !this.declaredInSameDomain(method, callingClass);
        return isACoreLanguageMethod || methodDoesNotComeFromThisClassOrARelatedParentClass;
    }

    private boolean declaredInSameDomain(Method method, Class callingClass) {
        return this.domainPackageOf(this.getRoot(method)).equals(this.domainPackageOf(callingClass));
    }

    private String domainPackageOf(Class callingClass) {
        Package classPackage = callingClass.getPackage();
        String classPackageName = classPackage != null ? classPackage.getName() : "";
        return this.packageDomainName(classPackageName);
    }

    private String packageDomainName(String methodPackage) {
        String[] packages = StringUtils.split((String)methodPackage, (String)".");
        if (packages.length == 0) {
            return "";
        }
        if (packages.length == 1) {
            return packages[0];
        }
        return String.valueOf(packages[0]) + "." + packages[1];
    }

    private String domainPackageOf(Method method) {
        Package methodPackage = method.getDeclaringClass().getPackage();
        String methodPackageName = methodPackage != null ? methodPackage.getName() : "";
        return this.packageDomainName(methodPackageName);
    }

    private Method getRoot(Method method) {
        try {
            method.getClass().getDeclaredField("root").setAccessible(true);
            return (Method)method.getClass().getDeclaredField("root").get(method);
        }
        catch (IllegalAccessException illegalAccessException) {
            return method;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return method;
        }
    }

    private Object testStepResult(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (!this.isATestStep(method)) {
            return this.runNormalMethod(obj, method, args, proxy);
        }
        if (this.shouldSkip(method)) {
            this.notifySkippedStepStarted(method, args);
            return this.skipTestStep(obj, method, args, proxy);
        }
        this.notifyStepStarted(method, args);
        return this.runTestStep(obj, method, args, proxy);
    }

    private Object skipTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Exception {
        Object skippedReturnObject = this.runSkippedMethod(obj, method, args, proxy);
        this.notifyStepSkippedFor(method, args);
        LOGGER.info("SKIPPED STEP: {}", (Object)method.getName());
        return this.appropriateReturnObject(skippedReturnObject, obj, method);
    }

    private Object runSkippedMethod(Object obj, Method method, Object[] args, MethodProxy proxy) {
        LOGGER.trace("Running test step " + this.getTestNameFrom(method, args, false));
        Object result = null;
        StepEventBus.getEventBus().temporarilySuspendWebdriverCalls();
        result = this.runIfNestedMethodsShouldBeRun(obj, method, args, proxy);
        StepEventBus.getEventBus().reenableWebdriverCalls();
        return result;
    }

    private Object runIfNestedMethodsShouldBeRun(Object obj, Method method, Object[] args, MethodProxy proxy) {
        Object result = null;
        try {
            if (!TestAnnotations.shouldSkipNested(method)) {
                result = this.invokeMethod(obj, args, proxy);
            }
        }
        catch (Throwable anyException) {
            LOGGER.trace("Ignoring exception thrown during a skipped test", anyException);
        }
        return result;
    }

    Object appropriateReturnObject(Object returnedValue, Object obj, Method method) {
        if (returnedValue != null) {
            return returnedValue;
        }
        return this.appropriateReturnObject(obj, method);
    }

    Object appropriateReturnObject(Object obj, Method method) {
        if (method.getReturnType().isAssignableFrom(obj.getClass())) {
            return obj;
        }
        return null;
    }

    private boolean shouldNotSkipMethod(Method methodOrStep, Class callingClass) {
        return !this.shouldSkipMethod(methodOrStep, callingClass);
    }

    private boolean shouldSkipMethod(Method methodOrStep, Class callingClass) {
        return (this.aPreviousStepHasFailed() || this.testIsPending()) && this.declaredInSameDomain(methodOrStep, callingClass);
    }

    private boolean shouldSkip(Method methodOrStep) {
        return this.aPreviousStepHasFailed() || this.testIsPending() || this.isPending(methodOrStep) || this.isIgnored(methodOrStep);
    }

    private boolean testIsPending() {
        return StepEventBus.getEventBus().currentTestIsSuspended();
    }

    private boolean aPreviousStepHasFailed() {
        boolean aPreviousStepHasFailed = false;
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            aPreviousStepHasFailed = true;
        }
        return aPreviousStepHasFailed;
    }

    private Object runBaseObjectMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invokeMethod(obj, args, proxy);
    }

    private Object runNormalMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = this.defaultReturnValueFor(method);
        if (this.shouldNotSkipMethod(method, obj.getClass())) {
            result = this.invokeMethodAndNotifyFailures(obj, method, args, proxy, result);
        }
        return result;
    }

    private Object invokeMethodAndNotifyFailures(Object obj, Method method, Object[] args, MethodProxy proxy, Object result) throws Throwable {
        try {
            result = this.invokeMethod(obj, args, proxy);
        }
        catch (Throwable generalException) {
            this.error = generalException;
            Throwable assertionError = ErrorConvertor.forError(this.error).convertToAssertion();
            this.notifyStepStarted(method, args);
            this.notifyOfStepFailure(method, args, assertionError);
        }
        return result;
    }

    private Object defaultReturnValueFor(Method method) {
        if (method.getReturnType() == method.getDeclaringClass()) {
            return this;
        }
        return DefaultValue.forClass(method.getReturnType());
    }

    private boolean isAnnotatedWithAValidStepAnnotation(Method method) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = method.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (this.isAThucydidesStep(annotation) || AnnotatedStepDescription.isACompatibleStep(annotation)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isAThucydidesStep(Annotation annotation) {
        return annotation instanceof Step || annotation instanceof StepGroup;
    }

    private boolean isATestStep(Method method) {
        return this.isAnnotatedWithAValidStepAnnotation(method);
    }

    private boolean isIgnored(Method method) {
        return TestAnnotations.isIgnored(method);
    }

    private Object runTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        LOGGER.info("STARTING STEP: {}", (Object)method.getName());
        Object result = null;
        try {
            result = this.executeTestStepMethod(obj, method, args, proxy, result);
            LOGGER.info("STEP DONE: {}", (Object)method.getName());
        }
        catch (AssertionError failedAssertion) {
            this.error = failedAssertion;
            this.logStepFailure(method, args, (Throwable)((Object)failedAssertion));
            return this.appropriateReturnObject(obj, method);
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            return this.appropriateReturnObject(obj, method);
        }
        catch (Throwable testErrorException) {
            this.error = testErrorException;
            this.logStepFailure(method, args, ErrorConvertor.forError(this.error).convertToAssertion());
            return this.appropriateReturnObject(obj, method);
        }
        return result;
    }

    private void logStepFailure(Method method, Object[] args, Throwable assertionError) throws Throwable {
        this.notifyOfStepFailure(method, args, assertionError);
        LOGGER.info("STEP FAILED: {} - {}", (Object)method.getName(), (Object)assertionError.getMessage());
    }

    private Object executeTestStepMethod(Object obj, Method method, Object[] args, MethodProxy proxy, Object result) throws Throwable {
        try {
            result = this.invokeMethod(obj, args, proxy);
            this.notifyStepFinishedFor(method, args);
        }
        catch (PendingStepException pendingStep) {
            this.notifyStepPending(pendingStep.getMessage());
        }
        catch (IgnoredStepException ignoredStep) {
            this.notifyStepIgnored(ignoredStep.getMessage());
        }
        catch (AssumptionViolatedException assumptionViolated) {
            this.notifyAssumptionViolated(assumptionViolated.getMessage());
        }
        Preconditions.checkArgument((boolean)true);
        return result;
    }

    private Object invokeMethod(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private boolean isPending(Method method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private void notifyStepFinishedFor(Method method, Object[] args) {
        StepEventBus.getEventBus().stepFinished();
    }

    private void notifyStepPending(String message) {
        StepEventBus.getEventBus().stepPending(message);
    }

    private void notifyAssumptionViolated(String message) {
        StepEventBus.getEventBus().assumptionViolated(message);
    }

    private void notifyStepIgnored(String message) {
        StepEventBus.getEventBus().stepIgnored();
    }

    private String getTestNameFrom(Method method, Object[] args) {
        return this.getTestNameFrom(method, args, true);
    }

    private String getTestNameFrom(Method method, Object[] args, boolean addMarkup) {
        if (args == null || args.length == 0) {
            return method.getName();
        }
        return this.testNameWithArguments(method, args, addMarkup);
    }

    private String testNameWithArguments(Method method, Object[] args, boolean addMarkup) {
        StringBuilder testName = new StringBuilder(method.getName());
        testName.append(": ");
        if (addMarkup) {
            testName.append("<span class='step-parameter'>");
        }
        boolean isFirst = true;
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (!isFirst) {
                testName.append(", ");
            }
            testName.append(StepArgumentWriter.readableFormOf(arg));
            isFirst = false;
            ++n2;
        }
        if (addMarkup) {
            testName.append("</span>");
        }
        return testName.toString();
    }

    private void notifyStepSkippedFor(Method method, Object[] args) throws Exception {
        if (this.isPending(method)) {
            StepEventBus.getEventBus().stepPending();
        } else {
            StepEventBus.getEventBus().stepIgnored();
        }
    }

    private void notifyOfStepFailure(Method method, Object[] args, Throwable cause) throws Throwable {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        StepFailure failure = new StepFailure(description, cause);
        StepEventBus.getEventBus().stepFailed(failure);
        if (this.shouldThrowExceptionImmediately()) {
            throw cause;
        }
    }

    private boolean shouldThrowExceptionImmediately() {
        return this.throwExceptionImmediately;
    }

    private void notifyStepStarted(Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        StepEventBus.getEventBus().stepStarted(description);
    }

    private void notifySkippedStepStarted(Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        StepEventBus.getEventBus().skippedStepStarted(description);
    }

    public void setThowsExceptionImmediately(boolean throwExceptionImmediately) {
        this.throwExceptionImmediately = throwExceptionImmediately;
    }
}

