/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.thucydides.core.ThucydidesSystemProperties;
import net.thucydides.core.ThucydidesSystemProperty;
import org.apache.commons.lang3.StringUtils;

public class FileResources {
    private static final int BUFFER_SIZE = 4096;
    private static final int DEFAULT_FILE_IO_RETRY_TIMEOUT = 60;
    private String resourceDirectoryRoot;

    public static FileResources from(String resourceDirectoryRoot) {
        return new FileResources(resourceDirectoryRoot);
    }

    protected FileResources(String resourceDirectoryRoot) {
        this.resourceDirectoryRoot = resourceDirectoryRoot;
    }

    public final String findTargetSubdirectoryFrom(String sourceResource) {
        int directoryRootStartsAt = StringUtils.lastIndexOf((CharSequence)sourceResource, (CharSequence)this.resourceDirectoryRoot);
        int relativePathStartsAt = directoryRootStartsAt + this.resourceDirectoryRoot.length() + 1;
        String relativePath = sourceResource.substring(relativePathStartsAt);
        relativePath = this.stripLeadingSeparatorFrom(relativePath);
        return this.directoryIn(relativePath);
    }

    public final String stripLeadingSeparatorFrom(String path) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            return path.substring(1);
        }
        return path;
    }

    public final String findTargetFileFrom(String sourceResource) {
        int directoryRootStartsAt = StringUtils.lastIndexOf((CharSequence)sourceResource, (CharSequence)this.resourceDirectoryRoot);
        int relativePathStartsAt = directoryRootStartsAt + this.resourceDirectoryRoot.length() + 1;
        String relativePath = sourceResource.substring(relativePathStartsAt);
        return this.filenameIn(relativePath);
    }

    public final void copyResourceTo(String sourceResource, File targetDirectory) throws IOException {
        String targetFile = this.findTargetFileFrom(sourceResource);
        String targetRelativeDirectory = this.findTargetSubdirectoryFrom(sourceResource);
        File destinationDirectory = targetDirectory;
        if (targetRelativeDirectory.length() > 0) {
            destinationDirectory = new File(targetDirectory, targetRelativeDirectory);
        }
        if (new File(sourceResource).isDirectory()) {
            File fullTargetDirectory = new File(destinationDirectory, targetFile);
            fullTargetDirectory.mkdirs();
        } else {
            this.copyFileFromClasspathToTargetDirectory(sourceResource, destinationDirectory);
        }
    }

    private void copyFileFromClasspathToTargetDirectory(String resourcePath, File targetDirectory) throws IOException {
        File destinationFile;
        InputStream in;
        FileOutputStream out;
        block4: {
            out = null;
            in = null;
            try {
                File resourceOnClasspath = new File(resourcePath);
                in = resourceOnClasspath.exists() ? new FileInputStream(resourceOnClasspath) : this.getClass().getClassLoader().getResourceAsStream(resourcePath);
                destinationFile = new File(targetDirectory, resourceOnClasspath.getName());
                if (!destinationFile.exists()) break block4;
            }
            catch (Throwable throwable) {
                this.closeSafely(out, in);
                throw throwable;
            }
            this.closeSafely(out, in);
            return;
        }
        if (destinationFile.getParent() != null) {
            new File(destinationFile.getParent()).mkdirs();
        }
        out = this.getOutputStreamForDestination(destinationFile);
        this.copyData(in, out);
        this.closeSafely(out, in);
    }

    private FileOutputStream getOutputStreamForDestination(File destinationFile) throws FileNotFoundException {
        FileOutputStream outStream = null;
        long start = new Date().getTime();
        long timeout = this.getRetryTimeOut();
        long timeElapsed = 0L;
        boolean FILE_NOT_FOUND = true;
        while (FILE_NOT_FOUND) {
            try {
                timeElapsed = new Date().getTime() - start;
                outStream = this.createOutputStream(destinationFile);
                FILE_NOT_FOUND = false;
            }
            catch (FileNotFoundException fnfe) {
                if (timeElapsed <= timeout) continue;
                throw fnfe;
            }
        }
        return outStream;
    }

    private long getRetryTimeOut() {
        ThucydidesSystemProperties systemProperties = ThucydidesSystemProperties.getProperties();
        int timeout = systemProperties.getIntegerValue(ThucydidesSystemProperty.THUCYDIDES_FILE_IO_RETRY_TIMEOUT, 60);
        return timeout * 1000;
    }

    public static long getDefaultRetryTimeout() {
        return 60000L;
    }

    protected FileOutputStream createOutputStream(File destinationFile) throws FileNotFoundException {
        return new FileOutputStream(destinationFile);
    }

    private void copyData(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private void closeSafely(OutputStream out, InputStream in) throws IOException {
        if (in != null) {
            in.close();
        }
        if (out != null) {
            out.close();
        }
    }

    private String directoryIn(String path) {
        if (path.contains("/")) {
            int filenameStartsAt = StringUtils.lastIndexOf((CharSequence)path, (CharSequence)"/");
            return path.substring(0, filenameStartsAt);
        }
        if (path.contains("\\")) {
            int filenameStartsAt = StringUtils.lastIndexOf((CharSequence)path, (CharSequence)"\\");
            return path.substring(0, filenameStartsAt);
        }
        return "";
    }

    private String filenameIn(String path) {
        if (path.contains("/")) {
            int filenameStartsAt = StringUtils.lastIndexOf((CharSequence)path, (CharSequence)"/");
            return path.substring(filenameStartsAt + 1);
        }
        if (path.contains("\\")) {
            int filenameStartsAt = StringUtils.lastIndexOf((CharSequence)path, (CharSequence)"\\");
            return path.substring(filenameStartsAt + 1);
        }
        return path;
    }
}

